/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.kafkarest.entities.AutoValue_ConsumerGroup;
import io.confluent.kafkarest.entities.Broker;
import io.confluent.kafkarest.entities.Consumer;
import io.confluent.kafkarest.entities.Partition;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;

@AutoValue
public abstract class ConsumerGroup {
    ConsumerGroup() {
    }

    public abstract String getClusterId();

    public abstract String getConsumerGroupId();

    public abstract boolean isSimple();

    public abstract String getPartitionAssignor();

    public abstract State getState();

    public abstract Type getType();

    public abstract boolean isMixedConsumerGroup();

    public abstract Broker getCoordinator();

    public abstract ImmutableList<Consumer> getConsumers();

    public final ImmutableMap<Partition, Consumer> getPartitionAssignment() {
        ImmutableMap.Builder partitionAssignment = ImmutableMap.builder();
        for (Consumer consumer : this.getConsumers()) {
            for (Partition partition : consumer.getAssignedPartitions()) {
                partitionAssignment.put((Object)partition, (Object)consumer);
            }
        }
        return partitionAssignment.build();
    }

    public static Builder builder() {
        return new AutoValue_ConsumerGroup.Builder();
    }

    public static ConsumerGroup fromConsumerGroupDescription(String clusterId, ConsumerGroupDescription description) {
        return ConsumerGroup.builder().setClusterId(clusterId).setConsumerGroupId(description.groupId()).setSimple(description.isSimpleConsumerGroup()).setPartitionAssignor(description.partitionAssignor()).setState(new State(description.groupState())).setType(new Type(description.type())).setMixedConsumerGroup(ConsumerGroup.hasNonUpgradedMember(description.type(), description.members())).setCoordinator(Broker.fromNode(clusterId, description.coordinator())).setConsumers(description.members().stream().map(consumer -> Consumer.fromMemberDescription(clusterId, description.groupId(), consumer)).collect(Collectors.toList())).build();
    }

    private static boolean hasNonUpgradedMember(GroupType groupType, Collection<MemberDescription> memberDescriptions) {
        if (groupType == GroupType.CONSUMER) {
            for (MemberDescription memberDescription : memberDescriptions) {
                if ((!memberDescription.upgraded().isPresent() || ((Boolean)memberDescription.upgraded().get()).booleanValue()) && !memberDescription.upgraded().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setConsumerGroupId(String var1);

        public abstract Builder setSimple(boolean var1);

        public abstract Builder setPartitionAssignor(String var1);

        public abstract Builder setState(State var1);

        public abstract Builder setType(Type var1);

        public abstract Builder setMixedConsumerGroup(boolean var1);

        public abstract Builder setCoordinator(Broker var1);

        public abstract Builder setConsumers(List<Consumer> var1);

        public abstract ConsumerGroup build();
    }

    public static class State {
        public static final State UNKNOWN = new State(GroupState.UNKNOWN);
        public static final State PREPARING_REBALANCE = new State(GroupState.PREPARING_REBALANCE);
        public static final State COMPLETING_REBALANCE = new State(GroupState.COMPLETING_REBALANCE);
        public static final State ASSIGNING = new State(GroupState.ASSIGNING);
        public static final State RECONCILING = new State(GroupState.RECONCILING);
        public static final State STABLE = new State(GroupState.STABLE);
        public static final State DEAD = new State(GroupState.DEAD);
        public static final State EMPTY = new State(GroupState.EMPTY);
        private static final Map<String, GroupState> NAME_TO_ENUM = Arrays.stream(GroupState.values()).collect(Collectors.toMap(state -> state.name().toUpperCase(Locale.ROOT), Function.identity()));
        private final GroupState state;

        State(GroupState state) {
            this.state = Objects.requireNonNull(state);
        }

        public GroupState toGroupState() {
            return this.state;
        }

        @JsonValue
        public String toString() {
            return this.state.name().toUpperCase(Locale.ROOT);
        }

        @JsonCreator
        public static State fromString(String state) {
            return new State(NAME_TO_ENUM.getOrDefault(state.toUpperCase(Locale.ROOT), GroupState.UNKNOWN));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            State that = (State)obj;
            return this.state == that.state;
        }

        public int hashCode() {
            return this.state.hashCode();
        }
    }

    public static class Type {
        public static final Type UNKNOWN = new Type(GroupType.UNKNOWN);
        public static final Type CLASSIC = new Type(GroupType.CLASSIC);
        public static final Type CONSUMER = new Type(GroupType.CONSUMER);
        public static final Type SHARE = new Type(GroupType.SHARE);
        private static final Map<String, GroupType> NAME_TO_ENUM = Arrays.stream(GroupType.values()).collect(Collectors.toMap(type -> type.name().toUpperCase(Locale.ROOT), Function.identity()));
        private final GroupType type;

        Type(GroupType type) {
            this.type = Objects.requireNonNull(type);
        }

        public GroupType toGroupType() {
            return this.type;
        }

        @JsonValue
        public String toString() {
            return this.type.name().toUpperCase(Locale.ROOT);
        }

        @JsonCreator
        public static Type fromString(String type) {
            return new Type(NAME_TO_ENUM.getOrDefault(type.toUpperCase(Locale.ROOT), GroupType.UNKNOWN));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Type that = (Type)obj;
            return this.type == that.type;
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }
}

