/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v2.ConsumerSeekRequest;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Optional;

final class AutoValue_ConsumerSeekRequest_PartitionTimestamp
extends ConsumerSeekRequest.PartitionTimestamp {
    private final String topic;
    private final int partition;
    private final Instant timestamp;
    private final Optional<String> metadata;

    private AutoValue_ConsumerSeekRequest_PartitionTimestamp(String topic, int partition, Instant timestamp, Optional<String> metadata) {
        this.topic = topic;
        this.partition = partition;
        this.timestamp = timestamp;
        this.metadata = metadata;
    }

    @Override
    @JsonProperty(value="topic")
    public String getTopic() {
        return this.topic;
    }

    @Override
    @JsonProperty(value="partition")
    public int getPartition() {
        return this.partition;
    }

    @Override
    @JsonProperty(value="timestamp")
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty(value="metadata")
    public Optional<String> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "PartitionTimestamp{topic=" + this.topic + ", partition=" + this.partition + ", timestamp=" + String.valueOf(this.timestamp) + ", metadata=" + String.valueOf(this.metadata) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConsumerSeekRequest.PartitionTimestamp) {
            ConsumerSeekRequest.PartitionTimestamp that = (ConsumerSeekRequest.PartitionTimestamp)o;
            return this.topic.equals(that.getTopic()) && this.partition == that.getPartition() && this.timestamp.equals(that.getTimestamp()) && this.metadata.equals(that.getMetadata());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.partition;
        h$ *= 1000003;
        h$ ^= this.timestamp.hashCode();
        h$ *= 1000003;
        return h$ ^= this.metadata.hashCode();
    }

    static final class Builder
    extends ConsumerSeekRequest.PartitionTimestamp.Builder {
        private String topic;
        private Integer partition;
        private Instant timestamp;
        private Optional<String> metadata = Optional.empty();

        Builder() {
        }

        @Override
        public ConsumerSeekRequest.PartitionTimestamp.Builder setTopic(String topic) {
            if (topic == null) {
                throw new NullPointerException("Null topic");
            }
            this.topic = topic;
            return this;
        }

        @Override
        public ConsumerSeekRequest.PartitionTimestamp.Builder setPartition(int partition) {
            this.partition = partition;
            return this;
        }

        @Override
        public ConsumerSeekRequest.PartitionTimestamp.Builder setTimestamp(Instant timestamp) {
            if (timestamp == null) {
                throw new NullPointerException("Null timestamp");
            }
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ConsumerSeekRequest.PartitionTimestamp.Builder setMetadata(@Nullable String metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        public ConsumerSeekRequest.PartitionTimestamp build() {
            Object missing = "";
            if (this.topic == null) {
                missing = (String)missing + " topic";
            }
            if (this.partition == null) {
                missing = (String)missing + " partition";
            }
            if (this.timestamp == null) {
                missing = (String)missing + " timestamp";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_ConsumerSeekRequest_PartitionTimestamp(this.topic, this.partition, this.timestamp, this.metadata);
        }
    }
}

