/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.EntityUtils;
import io.confluent.kafkarest.entities.ProduceRecord;
import io.confluent.kafkarest.entities.ProduceRequest;
import io.confluent.rest.validation.ConstraintViolations;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotEmpty;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public final class BinaryPartitionProduceRequest {
    @NotEmpty
    @Nullable
    private final List<BinaryPartitionProduceRecord> records;

    @JsonCreator
    private BinaryPartitionProduceRequest(@JsonProperty(value="records") @Nullable @NotEmpty List<BinaryPartitionProduceRecord> records, @JsonProperty(value="key_schema") @Nullable String keySchema, @JsonProperty(value="key_schema_id") @Nullable Integer keySchemaId, @JsonProperty(value="value_schema") @Nullable String valueSchema, @JsonProperty(value="value_schema_id") @Nullable Integer valueSchemaId) {
        this.records = records;
    }

    @JsonProperty(value="records")
    @Nullable
    public List<BinaryPartitionProduceRecord> getRecords() {
        return this.records;
    }

    public static BinaryPartitionProduceRequest create(List<BinaryPartitionProduceRecord> records) {
        if (records.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return new BinaryPartitionProduceRequest(records, null, null, null, null);
    }

    public ProduceRequest<byte[], byte[]> toProduceRequest() {
        if (this.records == null || this.records.isEmpty()) {
            throw new IllegalStateException();
        }
        return ProduceRequest.create(this.records.stream().map(record -> ProduceRecord.create(record.key, record.value, null)).collect(Collectors.toList()), null, null, null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryPartitionProduceRequest that = (BinaryPartitionProduceRequest)o;
        return Objects.equals(this.records, that.records);
    }

    public int hashCode() {
        return Objects.hash(this.records);
    }

    public String toString() {
        return new StringJoiner(", ", BinaryPartitionProduceRequest.class.getSimpleName() + "[", "]").add("records=" + String.valueOf(this.records)).toString();
    }

    public static final class BinaryPartitionProduceRecord {
        @Nullable
        private final byte[] key;
        @Nullable
        private final byte[] value;

        @JsonCreator
        public BinaryPartitionProduceRecord(@JsonProperty(value="key") @Nullable String key, @JsonProperty(value="value") @Nullable String value) {
            try {
                this.key = key != null ? EntityUtils.parseBase64Binary(key) : null;
            }
            catch (IllegalArgumentException e) {
                throw ConstraintViolations.simpleException((String)"Record key contains invalid base64 encoding");
            }
            try {
                this.value = value != null ? EntityUtils.parseBase64Binary(value) : null;
            }
            catch (IllegalArgumentException e) {
                throw ConstraintViolations.simpleException((String)"Record value contains invalid base64 encoding");
            }
        }

        @JsonProperty(value="key")
        @Nullable
        public String getKey() {
            return this.key == null ? null : EntityUtils.encodeBase64Binary(this.key);
        }

        @JsonProperty(value="value")
        @Nullable
        public String getValue() {
            return this.value == null ? null : EntityUtils.encodeBase64Binary(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BinaryPartitionProduceRecord that = (BinaryPartitionProduceRecord)o;
            return Arrays.equals(this.key, that.key) && Arrays.equals(this.value, that.value);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.key);
            result = 31 * result + Arrays.hashCode(this.value);
            return result;
        }

        public String toString() {
            return new StringJoiner(", ", BinaryPartitionProduceRecord.class.getSimpleName() + "[", "]").add("key=" + Arrays.toString(this.key)).add("value=" + Arrays.toString(this.value)).toString();
        }
    }
}

