/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.Topic;
import io.confluent.kafkarest.entities.TopicConfig;
import io.confluent.kafkarest.entities.v2.GetPartitionResponse;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public final class GetTopicResponse {
    @NotEmpty
    @Nullable
    private final String name;
    @NotNull
    @Nullable
    private final Map<String, String> configs;
    @NotEmpty
    @Nullable
    private final List<GetPartitionResponse> partitions;

    @JsonCreator
    private GetTopicResponse(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="configs") @Nullable Map<String, String> configs, @JsonProperty(value="partitions") @Nullable List<GetPartitionResponse> partitions) {
        this.name = name;
        this.configs = configs;
        this.partitions = partitions;
    }

    @JsonProperty
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty
    @Nullable
    public Map<String, String> getConfigs() {
        return this.configs;
    }

    @JsonProperty
    @Nullable
    public List<GetPartitionResponse> getPartitions() {
        return this.partitions;
    }

    public static GetTopicResponse fromTopic(Topic topic, List<TopicConfig> configs) {
        HashMap<String, String> configsMap = new HashMap<String, String>();
        for (TopicConfig config : configs) {
            configsMap.put(config.getName(), config.getValue());
        }
        return new GetTopicResponse(topic.getName(), configsMap, topic.getPartitions().stream().map(GetPartitionResponse::fromPartition).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTopicResponse that = (GetTopicResponse)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.configs, that.configs) && Objects.equals(this.partitions, that.partitions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.configs, this.partitions);
    }

    public String toString() {
        return new StringJoiner(", ", GetTopicResponse.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("configs=" + String.valueOf(this.configs)).add("partitions=" + String.valueOf(this.partitions)).toString();
    }
}

