/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.ProduceRecord;
import io.confluent.kafkarest.entities.ProduceRequest;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public final class JsonTopicProduceRequest {
    @NotEmpty
    @Nullable
    private final List<JsonTopicProduceRecord> records;

    @JsonCreator
    private JsonTopicProduceRequest(@JsonProperty(value="records") @Nullable List<JsonTopicProduceRecord> records, @JsonProperty(value="key_schema") @Nullable String keySchema, @JsonProperty(value="key_schema_id") @Nullable Integer keySchemaId, @JsonProperty(value="value_schema") @Nullable String valueSchema, @JsonProperty(value="value_schema_id") @Nullable Integer valueSchemaId) {
        this.records = records;
    }

    @JsonProperty(value="records")
    @Nullable
    public List<JsonTopicProduceRecord> getRecords() {
        return this.records;
    }

    public static JsonTopicProduceRequest create(List<JsonTopicProduceRecord> records) {
        if (records.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return new JsonTopicProduceRequest(records, null, null, null, null);
    }

    public ProduceRequest<Object, Object> toProduceRequest() {
        if (this.records == null || this.records.isEmpty()) {
            throw new IllegalStateException();
        }
        return ProduceRequest.create(this.records.stream().map(record -> ProduceRecord.create(record.key, record.value, record.partition)).collect(Collectors.toList()), null, null, null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonTopicProduceRequest that = (JsonTopicProduceRequest)o;
        return Objects.equals(this.records, that.records);
    }

    public int hashCode() {
        return Objects.hash(this.records);
    }

    public String toString() {
        return new StringJoiner(", ", JsonTopicProduceRequest.class.getSimpleName() + "[", "]").add("records=" + String.valueOf(this.records)).toString();
    }

    public static final class JsonTopicProduceRecord {
        @Nullable
        private final Object key;
        @Nullable
        private final Object value;
        @PositiveOrZero
        @Nullable
        private final Integer partition;

        @JsonCreator
        public JsonTopicProduceRecord(@JsonProperty(value="key") @Nullable Object key, @JsonProperty(value="value") @Nullable Object value, @JsonProperty(value="partition") @Nullable Integer partition) {
            this.key = key;
            this.value = value;
            this.partition = partition;
        }

        @JsonProperty(value="key")
        @Nullable
        public Object getKey() {
            return this.key;
        }

        @JsonProperty(value="value")
        @Nullable
        public Object getValue() {
            return this.value;
        }

        @JsonProperty(value="partition")
        @Nullable
        public Integer getPartition() {
            return this.partition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonTopicProduceRecord that = (JsonTopicProduceRecord)o;
            return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.partition, that.partition);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value, this.partition);
        }

        public String toString() {
            return new StringJoiner(", ", JsonTopicProduceRecord.class.getSimpleName() + "[", "]").add("key=" + String.valueOf(this.key)).add("value=" + String.valueOf(this.value)).add("partition=" + this.partition).toString();
        }
    }
}

