/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v2.AutoValue_ProduceRequest;
import io.confluent.kafkarest.entities.v2.AutoValue_ProduceRequest_ProduceRecord;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Optional;

@AutoValue
public abstract class ProduceRequest {
    @NotEmpty
    @JsonProperty(value="records")
    public abstract ImmutableList<ProduceRecord> getRecords();

    @JsonProperty(value="key_schema_id")
    public abstract Optional<Integer> getKeySchemaId();

    @JsonProperty(value="key_schema")
    public abstract Optional<String> getKeySchema();

    @JsonProperty(value="value_schema_id")
    public abstract Optional<Integer> getValueSchemaId();

    @JsonProperty(value="value_schema")
    public abstract Optional<String> getValueSchema();

    public static ProduceRequest create(List<ProduceRecord> records) {
        return ProduceRequest.create(records, null, null, null, null);
    }

    public static ProduceRequest create(List<ProduceRecord> records, @Nullable Integer keySchemaId, @Nullable String keySchema, @Nullable Integer valueSchemaId, @Nullable String valueSchema) {
        return new AutoValue_ProduceRequest((ImmutableList<ProduceRecord>)ImmutableList.copyOf(records), Optional.ofNullable(keySchemaId), Optional.ofNullable(keySchema), Optional.ofNullable(valueSchemaId), Optional.ofNullable(valueSchema));
    }

    @JsonCreator
    static ProduceRequest fromJson(@JsonProperty(value="records") @Nullable List<ProduceRecord> records, @JsonProperty(value="key_schema_id") @Nullable Integer keySchemaId, @JsonProperty(value="key_schema") @Nullable String keySchema, @JsonProperty(value="value_schema_id") @Nullable Integer valueSchemaId, @JsonProperty(value="value_schema") @Nullable String valueSchema) {
        return ProduceRequest.create((List<ProduceRecord>)(records != null ? records : ImmutableList.of()), keySchemaId, keySchema, valueSchemaId, valueSchema);
    }

    @AutoValue
    public static abstract class ProduceRecord {
        @JsonProperty(value="partition")
        public abstract Optional<Integer> getPartition();

        @JsonProperty(value="key")
        public abstract Optional<JsonNode> getKey();

        @JsonProperty(value="value")
        public abstract Optional<JsonNode> getValue();

        public static ProduceRecord create(@Nullable JsonNode key, @Nullable JsonNode value) {
            return ProduceRecord.create(null, key, value);
        }

        public static ProduceRecord create(@Nullable Integer partition, @Nullable JsonNode key, @Nullable JsonNode value) {
            return new AutoValue_ProduceRequest_ProduceRecord(Optional.ofNullable(partition), Optional.ofNullable(key), Optional.ofNullable(value));
        }

        @JsonCreator
        static ProduceRecord fromJson(@JsonProperty(value="partition") @Nullable Integer partition, @JsonProperty(value="key") @Nullable JsonNode key, @JsonProperty(value="value") @Nullable JsonNode value) {
            return ProduceRecord.create(partition, key, value);
        }
    }
}

