/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.Objects;
import java.util.StringJoiner;

public final class TopicPartition {
    @NotEmpty
    @Nullable
    private final String topic;
    @PositiveOrZero
    @Nullable
    private final Integer partition;

    public TopicPartition(@JsonProperty(value="topic") @Nullable String topic, @JsonProperty(value="partition") @Nullable Integer partition) {
        this.topic = topic;
        this.partition = partition;
    }

    @JsonProperty
    @Nullable
    public String getTopic() {
        return this.topic;
    }

    @JsonProperty
    @Nullable
    public Integer getPartition() {
        return this.partition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPartition that = (TopicPartition)o;
        return Objects.equals(this.topic, that.topic) && Objects.equals(this.partition, that.partition);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.partition);
    }

    public String toString() {
        return new StringJoiner(", ", TopicPartition.class.getSimpleName() + "[", "]").add("topic='" + this.topic + "'").add("partition=" + this.partition).toString();
    }
}

