/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.Broker;
import io.confluent.kafkarest.entities.v3.AutoValue_BrokerData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.util.Optional;

@AutoValue
public abstract class BrokerData
extends Resource {
    BrokerData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="broker_id")
    public abstract int getBrokerId();

    @JsonProperty(value="host")
    public abstract Optional<String> getHost();

    @JsonProperty(value="port")
    public abstract Optional<Integer> getPort();

    @JsonProperty(value="rack")
    public abstract Optional<String> getRack();

    @JsonProperty(value="configs")
    public abstract Resource.Relationship getConfigs();

    @JsonProperty(value="partition_replicas")
    public abstract Resource.Relationship getPartitionReplicas();

    public static Builder builder() {
        return new AutoValue_BrokerData.Builder().setKind("KafkaBroker");
    }

    public static Builder fromBroker(Broker broker) {
        return BrokerData.builder().setClusterId(broker.getClusterId()).setBrokerId(broker.getBrokerId()).setHost(broker.getHost()).setPort(broker.getPort()).setRack(broker.getRack());
    }

    @JsonCreator
    static BrokerData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="broker_id") int brokerId, @JsonProperty(value="host") @Nullable String host, @JsonProperty(value="port") @Nullable Integer port, @JsonProperty(value="rack") @Nullable String rack, @JsonProperty(value="configs") Resource.Relationship configs, @JsonProperty(value="partition_replicas") Resource.Relationship partitionReplicas) {
        return ((Builder)((Builder)BrokerData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setBrokerId(brokerId).setHost(host).setPort(port).setRack(rack).setConfigs(configs).setPartitionReplicas(partitionReplicas).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setBrokerId(int var1);

        public abstract Builder setHost(@Nullable String var1);

        public abstract Builder setPort(@Nullable Integer var1);

        public abstract Builder setRack(@Nullable String var1);

        public abstract Builder setConfigs(Resource.Relationship var1);

        public abstract Builder setPartitionReplicas(Resource.Relationship var1);

        public abstract BrokerData build();
    }
}

