/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.Consumer;
import io.confluent.kafkarest.entities.v3.AutoValue_ConsumerData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.util.Optional;

@AutoValue
public abstract class ConsumerData
extends Resource {
    ConsumerData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="consumer_group_id")
    public abstract String getConsumerGroupId();

    @JsonProperty(value="consumer_id")
    public abstract String getConsumerId();

    @JsonProperty(value="instance_id")
    public abstract Optional<String> getInstanceId();

    @JsonProperty(value="client_id")
    public abstract String getClientId();

    @JsonProperty(value="assignments")
    public abstract Resource.Relationship getAssignments();

    public static Builder builder() {
        return new AutoValue_ConsumerData.Builder().setKind("KafkaConsumer");
    }

    public static Builder fromConsumer(Consumer consumer) {
        return ConsumerData.builder().setClusterId(consumer.getClusterId()).setConsumerGroupId(consumer.getConsumerGroupId()).setConsumerId(consumer.getConsumerId()).setInstanceId(consumer.getInstanceId().orElse(null)).setClientId(consumer.getClientId());
    }

    @JsonCreator
    static ConsumerData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="consumer_group_id") String consumerGroupId, @JsonProperty(value="consumer_id") String consumerId, @JsonProperty(value="instance_id") @Nullable String instanceId, @JsonProperty(value="client_id") String clientId, @JsonProperty(value="assignments") Resource.Relationship assignments) {
        return ((Builder)((Builder)ConsumerData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setConsumerGroupId(consumerGroupId).setConsumerId(consumerId).setInstanceId(instanceId).setClientId(clientId).setAssignments(assignments).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setConsumerGroupId(String var1);

        public abstract Builder setConsumerId(String var1);

        public abstract Builder setInstanceId(@Nullable String var1);

        public abstract Builder setClientId(String var1);

        public abstract Builder setAssignments(Resource.Relationship var1);

        public abstract ConsumerData build();
    }
}

