/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.ConsumerGroupLagSummary;
import io.confluent.kafkarest.entities.v3.AutoValue_ConsumerGroupLagSummaryData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.util.Optional;

@AutoValue
public abstract class ConsumerGroupLagSummaryData
extends Resource {
    ConsumerGroupLagSummaryData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="consumer_group_id")
    public abstract String getConsumerGroupId();

    @JsonProperty(value="max_lag")
    public abstract Long getMaxLag();

    @JsonProperty(value="total_lag")
    public abstract Long getTotalLag();

    @JsonProperty(value="max_lag_consumer_id")
    public abstract String getMaxLagConsumerId();

    @JsonProperty(value="max_lag_consumer")
    public abstract Resource.Relationship getMaxLagConsumer();

    @JsonProperty(value="max_lag_client_id")
    public abstract String getMaxLagClientId();

    @JsonProperty(value="max_lag_instance_id")
    public abstract Optional<String> getMaxLagInstanceId();

    @JsonProperty(value="max_lag_topic_name")
    public abstract String getMaxLagTopicName();

    @JsonProperty(value="max_lag_partition_id")
    public abstract Integer getMaxLagPartitionId();

    @JsonProperty(value="max_lag_partition")
    public abstract Resource.Relationship getMaxLagPartition();

    public static Builder builder() {
        return new AutoValue_ConsumerGroupLagSummaryData.Builder().setKind("KafkaConsumerGroupLagSummary");
    }

    public static Builder fromConsumerGroupLagSummary(ConsumerGroupLagSummary consumerGroupLagSummary) {
        return ConsumerGroupLagSummaryData.builder().setClusterId(consumerGroupLagSummary.getClusterId()).setConsumerGroupId(consumerGroupLagSummary.getConsumerGroupId()).setMaxLag(consumerGroupLagSummary.getMaxLag()).setTotalLag(consumerGroupLagSummary.getTotalLag()).setMaxLagConsumerId(consumerGroupLagSummary.getMaxLagConsumerId()).setMaxLagClientId(consumerGroupLagSummary.getMaxLagClientId()).setMaxLagInstanceId(consumerGroupLagSummary.getMaxLagInstanceId().orElse(null)).setMaxLagTopicName(consumerGroupLagSummary.getMaxLagTopicName()).setMaxLagPartitionId(consumerGroupLagSummary.getMaxLagPartitionId());
    }

    @JsonCreator
    static ConsumerGroupLagSummaryData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="consumer_group_id") String consumerGroupId, @JsonProperty(value="max_lag") Long maxLag, @JsonProperty(value="total_lag") Long totalLag, @JsonProperty(value="max_lag_consumer_id") String maxLagConsumerId, @JsonProperty(value="max_lag_consumer") Resource.Relationship maxLagConsumer, @JsonProperty(value="max_lag_client_id") String maxLagClientId, @JsonProperty(value="max_lag_instance_id") @Nullable String maxLagInstanceId, @JsonProperty(value="max_lag_topic_name") String maxLagTopicName, @JsonProperty(value="max_lag_partition_id") Integer maxLagPartitionId, @JsonProperty(value="max_lag_partition") Resource.Relationship maxLagPartition) {
        return ((Builder)((Builder)ConsumerGroupLagSummaryData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setConsumerGroupId(consumerGroupId).setMaxLag(maxLag).setTotalLag(totalLag).setMaxLagConsumerId(maxLagConsumerId).setMaxLagConsumer(maxLagConsumer).setMaxLagClientId(maxLagClientId).setMaxLagInstanceId(maxLagInstanceId).setMaxLagTopicName(maxLagTopicName).setMaxLagPartitionId(maxLagPartitionId).setMaxLagPartition(maxLagPartition).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setConsumerGroupId(String var1);

        public abstract Builder setMaxLag(Long var1);

        public abstract Builder setTotalLag(Long var1);

        public abstract Builder setMaxLagConsumerId(String var1);

        public abstract Builder setMaxLagConsumer(Resource.Relationship var1);

        public abstract Builder setMaxLagClientId(String var1);

        public abstract Builder setMaxLagInstanceId(@Nullable String var1);

        public abstract Builder setMaxLagTopicName(String var1);

        public abstract Builder setMaxLagPartitionId(Integer var1);

        public abstract Builder setMaxLagPartition(Resource.Relationship var1);

        public abstract ConsumerGroupLagSummaryData build();
    }
}

