/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.ConsumerLag;
import io.confluent.kafkarest.entities.v3.AutoValue_ConsumerLagData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.util.Optional;

@AutoValue
public abstract class ConsumerLagData
extends Resource {
    ConsumerLagData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="consumer_group_id")
    public abstract String getConsumerGroupId();

    @JsonProperty(value="topic_name")
    public abstract String getTopicName();

    @JsonProperty(value="partition_id")
    public abstract int getPartitionId();

    @JsonProperty(value="consumer_id")
    public abstract String getConsumerId();

    @JsonProperty(value="instance_id")
    public abstract Optional<String> getInstanceId();

    @JsonProperty(value="client_id")
    public abstract String getClientId();

    @JsonProperty(value="current_offset")
    public abstract Long getCurrentOffset();

    @JsonProperty(value="log_end_offset")
    public abstract Long getLogEndOffset();

    @JsonProperty(value="lag")
    public abstract Long getLag();

    public static Builder builder() {
        return new AutoValue_ConsumerLagData.Builder().setKind("KafkaConsumerLag");
    }

    public static Builder fromConsumerLag(ConsumerLag consumerLag) {
        return ConsumerLagData.builder().setClusterId(consumerLag.getClusterId()).setConsumerGroupId(consumerLag.getConsumerGroupId()).setTopicName(consumerLag.getTopicName()).setPartitionId(consumerLag.getPartitionId()).setConsumerId(consumerLag.getConsumerId()).setInstanceId(consumerLag.getInstanceId().orElse(null)).setClientId(consumerLag.getClientId()).setCurrentOffset(consumerLag.getCurrentOffset()).setLogEndOffset(consumerLag.getLogEndOffset()).setLag(consumerLag.getLag());
    }

    @JsonCreator
    static ConsumerLagData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="consumer_group_id") String consumerGroupId, @JsonProperty(value="topic_name") String topicName, @JsonProperty(value="partition_id") int partitionId, @JsonProperty(value="consumer_id") String consumerId, @JsonProperty(value="instance_id") @Nullable String instanceId, @JsonProperty(value="client_id") String clientId, @JsonProperty(value="current_offset") Long currentOffset, @JsonProperty(value="log_end_offset") Long logEndOffset, @JsonProperty(value="lag") Long lag) {
        return ((Builder)((Builder)ConsumerLagData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setConsumerGroupId(consumerGroupId).setTopicName(topicName).setPartitionId(partitionId).setConsumerId(consumerId).setInstanceId(instanceId).setClientId(clientId).setCurrentOffset(currentOffset).setLogEndOffset(logEndOffset).setLag(lag).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setConsumerGroupId(String var1);

        public abstract Builder setTopicName(String var1);

        public abstract Builder setPartitionId(int var1);

        public abstract Builder setConsumerId(String var1);

        public abstract Builder setInstanceId(@Nullable String var1);

        public abstract Builder setClientId(String var1);

        public abstract Builder setCurrentOffset(Long var1);

        public abstract Builder setLogEndOffset(Long var1);

        public abstract Builder setLag(Long var1);

        public abstract ConsumerLagData build();
    }
}

