/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.AutoValue_CreateTopicRequest;
import io.confluent.kafkarest.entities.v3.AutoValue_CreateTopicRequest_ConfigEntry;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@AutoValue
public abstract class CreateTopicRequest {
    CreateTopicRequest() {
    }

    @JsonProperty(value="topic_name")
    public abstract String getTopicName();

    @JsonProperty(value="partitions_count")
    public abstract Optional<Integer> getPartitionsCount();

    @JsonProperty(value="replication_factor")
    public abstract Optional<Short> getReplicationFactor();

    @JsonProperty(value="replicas_assignments")
    public abstract Map<Integer, List<Integer>> getReplicasAssignments();

    @JsonProperty(value="configs")
    public abstract ImmutableList<ConfigEntry> getConfigs();

    @JsonProperty(value="validate_only")
    public abstract Optional<Boolean> getValidateOnly();

    public static Builder builder() {
        return new AutoValue_CreateTopicRequest.Builder().setReplicasAssignments(Collections.emptyMap());
    }

    @JsonCreator
    static CreateTopicRequest fromJson(@JsonProperty(value="topic_name") String topicName, @JsonProperty(value="partitions_count") @Nullable Integer partitionsCount, @JsonProperty(value="replication_factor") @Nullable Short replicationFactor, @JsonProperty(value="replicas_assignments") @Nullable Map<Integer, List<Integer>> replicasAssignments, @JsonProperty(value="configs") @Nullable List<ConfigEntry> configs, @JsonProperty(value="validate_only") @Nullable Boolean validateOnly) {
        return CreateTopicRequest.builder().setTopicName(topicName).setPartitionsCount(partitionsCount).setReplicationFactor(replicationFactor).setReplicasAssignments(replicasAssignments != null ? replicasAssignments : Collections.emptyMap()).setConfigs((List<ConfigEntry>)(configs != null ? configs : ImmutableList.of())).setValidateOnly(validateOnly).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setTopicName(String var1);

        public abstract Builder setPartitionsCount(@Nullable Integer var1);

        public abstract Builder setReplicationFactor(@Nullable Short var1);

        public abstract Builder setReplicasAssignments(Map<Integer, List<Integer>> var1);

        public abstract Builder setConfigs(List<ConfigEntry> var1);

        public abstract Builder setValidateOnly(@Nullable Boolean var1);

        public abstract CreateTopicRequest build();
    }

    @AutoValue
    public static abstract class ConfigEntry {
        ConfigEntry() {
        }

        @JsonProperty(value="name")
        public abstract String getName();

        @JsonProperty(value="value")
        public abstract Optional<String> getValue();

        public static ConfigEntry create(String name, @Nullable String value) {
            return new AutoValue_CreateTopicRequest_ConfigEntry(name, Optional.ofNullable(value));
        }

        @JsonCreator
        static ConfigEntry fromJson(@JsonProperty(value="name") String name, @JsonProperty(value="value") @Nullable String value) {
            return ConfigEntry.create(name, value);
        }
    }
}

