/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.entities.v3.AutoValue_ProduceBatchRequestEntry;
import io.confluent.kafkarest.entities.v3.ProduceRequest;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(using=Deserializer.class)
@AutoValue
public abstract class ProduceBatchRequestEntry {
    ProduceBatchRequestEntry() {
    }

    @JsonProperty(value="id")
    public abstract JsonNode getId();

    @JsonProperty(value="partition_id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<Integer> getPartitionId();

    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract ImmutableList<ProduceRequest.ProduceRequestHeader> getHeaders();

    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<ProduceRequest.ProduceRequestData> getKey();

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<ProduceRequest.ProduceRequestData> getValue();

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<Instant> getTimestamp();

    @JsonIgnore
    public abstract long getOriginalSize();

    public static Builder builder() {
        return new AutoValue_ProduceBatchRequestEntry.Builder().setHeaders(Collections.emptyList());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        static Builder fromJson(@JsonProperty(value="id") JsonNode id, @JsonProperty(value="partition_id") @Nullable Integer partitionId, @JsonProperty(value="headers") @Nullable List<ProduceRequest.ProduceRequestHeader> headers, @JsonProperty(value="key") @Nullable ProduceRequest.ProduceRequestData key, @JsonProperty(value="value") @Nullable ProduceRequest.ProduceRequestData value, @JsonProperty(value="timestamp") @Nullable Instant timestamp) {
            return ProduceBatchRequestEntry.builder().setId(id).setPartitionId(partitionId).setHeaders((List<ProduceRequest.ProduceRequestHeader>)(headers != null ? headers : ImmutableList.of())).setKey(key).setValue(value).setTimestamp(timestamp);
        }

        public abstract Builder setId(JsonNode var1);

        public abstract Builder setPartitionId(@Nullable Integer var1);

        public abstract Builder setHeaders(List<ProduceRequest.ProduceRequestHeader> var1);

        public abstract Builder setKey(@Nullable ProduceRequest.ProduceRequestData var1);

        public abstract Builder setValue(@Nullable ProduceRequest.ProduceRequestData var1);

        public abstract Builder setTimestamp(@Nullable Instant var1);

        public abstract Builder setOriginalSize(long var1);

        abstract ProduceBatchRequestEntry autoBuild();

        public final ProduceBatchRequestEntry build() {
            ProduceBatchRequestEntry entry = this.autoBuild();
            JsonNode idNode = entry.getId();
            if (idNode.getNodeType() != JsonNodeType.STRING) {
                throw Errors.produceBatchException("Batch entry identifier is not a valid string.");
            }
            String idString = idNode.asText();
            if (idString.length() < 1 || idString.length() > 80) {
                throw Errors.produceBatchException("Batch entry identifier is not a valid string.");
            }
            if (!idString.matches("[0-9a-zA-Z-_]+")) {
                throw Errors.produceBatchException("Batch entry identifier is not a valid string.");
            }
            return entry;
        }
    }

    static final class Deserializer
    extends JsonDeserializer<ProduceBatchRequestEntry> {
        Deserializer() {
        }

        public ProduceBatchRequestEntry deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            long start = parser.getCurrentLocation().getByteOffset() == -1L ? parser.getCurrentLocation().getCharOffset() : parser.getCurrentLocation().getByteOffset();
            Builder builder = (Builder)parser.readValueAs(Builder.class);
            long end = parser.getCurrentLocation().getByteOffset() == -1L ? parser.getCurrentLocation().getCharOffset() : parser.getCurrentLocation().getByteOffset();
            long size = start == -1L || end == -1L ? 0L : end - start + 1L;
            builder.setOriginalSize(size);
            return builder.build();
        }
    }
}

