/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.requestlog;

import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLog
extends AbstractLifeCycle
implements RequestLog {
    private static final Logger log = LoggerFactory.getLogger(CustomLog.class);
    private final CustomRequestLog delegateJettyLog;
    private final String[] requestAttributesToLog;
    public static final String PRODUCE_ERROR_CODE_LOG_PREFIX = "Codes=";

    public CustomLog(RequestLog.Writer writer, String formatString, String[] requestAttributesToLog) {
        for (String attr : requestAttributesToLog) {
            formatString = (String)formatString + " %{" + attr + "}attr";
        }
        this.requestAttributesToLog = requestAttributesToLog;
        this.delegateJettyLog = new CustomRequestLog(writer, (String)formatString);
    }

    protected synchronized void doStart() throws Exception {
        if (this.delegateJettyLog != null) {
            this.delegateJettyLog.start();
        }
    }

    protected void doStop() throws Exception {
        if (this.delegateJettyLog != null) {
            this.delegateJettyLog.stop();
        }
    }

    public void log(Request request, Response response) {
        try {
            this.delegateJettyLog.log(request, response);
        }
        catch (Exception e) {
            log.debug("Logging with Jetty's CustomRequestLogFailed with exception {}, stack is \n{}", (Object)e, (Object)e.getStackTrace());
        }
    }

    public static class ProduceRecordErrorCounter {
        private final Map<Integer, Integer> produceErrorCodeCountMap = new TreeMap<Integer, Integer>();

        public synchronized void incrementErrorCount(int httpErrorCode) {
            this.produceErrorCodeCountMap.merge(httpErrorCode, 1, Integer::sum);
        }

        public synchronized String toString() {
            return CustomLog.PRODUCE_ERROR_CODE_LOG_PREFIX + this.produceErrorCodeCountMap.entrySet().stream().map(entry -> String.valueOf(entry.getKey()) + ":" + String.valueOf(entry.getValue())).collect(Collectors.joining(","));
        }
    }
}

