/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.protobuf.ByteString;
import io.confluent.kafkarest.common.CompletableFutures;
import io.confluent.kafkarest.controllers.ProduceController;
import io.confluent.kafkarest.controllers.RecordSerializer;
import io.confluent.kafkarest.controllers.SchemaManager;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.kafkarest.entities.ProduceResult;
import io.confluent.kafkarest.entities.RegisteredSchema;
import io.confluent.kafkarest.entities.v2.PartitionOffset;
import io.confluent.kafkarest.entities.v2.ProduceRequest;
import io.confluent.kafkarest.entities.v2.ProduceResponse;
import io.confluent.kafkarest.resources.v2.AutoValue_AbstractProduceAction_SerializedKeyAndValue;
import io.confluent.rest.exceptions.RestServerErrorException;
import jakarta.inject.Provider;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.RetriableException;

abstract class AbstractProduceAction {
    public static final String UNEXPECTED_PRODUCER_EXCEPTION = "Unexpected non-Kafka exception returned by Kafka";
    private final Provider<SchemaManager> schemaManager;
    private final Provider<RecordSerializer> recordSerializer;
    private final Provider<ProduceController> produceController;

    AbstractProduceAction(Provider<SchemaManager> schemaManager, Provider<RecordSerializer> recordSerializer, Provider<ProduceController> produceController) {
        this.schemaManager = Objects.requireNonNull(schemaManager);
        this.recordSerializer = Objects.requireNonNull(recordSerializer);
        this.produceController = Objects.requireNonNull(produceController);
    }

    final CompletableFuture<ProduceResponse> produceWithoutSchema(EmbeddedFormat format, String topicName, Optional<Integer> partition, ProduceRequest request) {
        List<SerializedKeyAndValue> serialized = this.serialize(format, topicName, partition, Optional.empty(), Optional.empty(), (List<ProduceRequest.ProduceRecord>)request.getRecords());
        List<CompletableFuture<ProduceResult>> resultFutures = this.doProduce(topicName, serialized);
        return AbstractProduceAction.produceResultsToResponse(Optional.empty(), Optional.empty(), resultFutures);
    }

    final CompletableFuture<ProduceResponse> produceWithSchema(EmbeddedFormat format, String topicName, Optional<Integer> partition, ProduceRequest request) {
        Optional<RegisteredSchema> keySchema = this.getSchema(format, topicName, request.getKeySchemaId(), request.getKeySchema(), true);
        Optional<RegisteredSchema> valueSchema = this.getSchema(format, topicName, request.getValueSchemaId(), request.getValueSchema(), false);
        List<SerializedKeyAndValue> serialized = this.serialize(format, topicName, partition, keySchema, valueSchema, (List<ProduceRequest.ProduceRecord>)request.getRecords());
        List<CompletableFuture<ProduceResult>> resultFutures = this.doProduce(topicName, serialized);
        return AbstractProduceAction.produceResultsToResponse(keySchema, valueSchema, resultFutures);
    }

    private Optional<RegisteredSchema> getSchema(EmbeddedFormat format, String topicName, Optional<Integer> schemaId, Optional<String> schema, boolean isKey) {
        if (format.requiresSchema() && (schemaId.isPresent() || schema.isPresent())) {
            return Optional.of(((SchemaManager)this.schemaManager.get()).getSchema(topicName, schema.map(unused -> format), Optional.empty(), Optional.empty(), schemaId, Optional.empty(), schema, isKey));
        }
        return Optional.empty();
    }

    private List<SerializedKeyAndValue> serialize(EmbeddedFormat format, String topicName, Optional<Integer> partition, Optional<RegisteredSchema> keySchema, Optional<RegisteredSchema> valueSchema, List<ProduceRequest.ProduceRecord> records) {
        return records.stream().map(record -> SerializedKeyAndValue.create(record.getPartition().map(Optional::of).orElse(partition), ((RecordSerializer)this.recordSerializer.get()).serialize(format, topicName, keySchema, record.getKey().orElse((JsonNode)NullNode.getInstance()), true), ((RecordSerializer)this.recordSerializer.get()).serialize(format, topicName, valueSchema, record.getValue().orElse((JsonNode)NullNode.getInstance()), false))).collect(Collectors.toList());
    }

    private List<CompletableFuture<ProduceResult>> doProduce(String topicName, List<SerializedKeyAndValue> serialized) {
        return serialized.stream().map(record -> ((ProduceController)this.produceController.get()).produce("", topicName, record.getPartitionId(), (Multimap<String, Optional<ByteString>>)ImmutableMultimap.of(), record.getKey(), record.getValue(), Instant.now())).collect(Collectors.toList());
    }

    private static CompletableFuture<ProduceResponse> produceResultsToResponse(Optional<RegisteredSchema> keySchema, Optional<RegisteredSchema> valueSchema, List<CompletableFuture<ProduceResult>> resultFutures) {
        CompletableFuture offsetsFuture = CompletableFutures.allAsList(resultFutures.stream().map(future -> future.thenApply(result -> new PartitionOffset(result.getPartitionId(), result.getOffset(), null, null))).map(future -> future.exceptionally(throwable -> new PartitionOffset(null, null, AbstractProduceAction.errorCodeFromProducerException(throwable.getCause()), throwable.getCause().getMessage()))).collect(Collectors.toList()));
        return offsetsFuture.thenApply(offsets -> new ProduceResponse((List<PartitionOffset>)offsets, keySchema.map(RegisteredSchema::getSchemaId).orElse(null), valueSchema.map(RegisteredSchema::getSchemaId).orElse(null)));
    }

    private static int errorCodeFromProducerException(Throwable e) {
        if (e instanceof AuthenticationException) {
            return 40101;
        }
        if (e instanceof AuthorizationException) {
            return 40301;
        }
        if (e instanceof RetriableException) {
            return 50003;
        }
        if (e instanceof KafkaException) {
            return 50002;
        }
        throw new RestServerErrorException(UNEXPECTED_PRODUCER_EXCEPTION, RestServerErrorException.DEFAULT_ERROR_CODE, e);
    }

    @AutoValue
    static abstract class SerializedKeyAndValue {
        SerializedKeyAndValue() {
        }

        abstract Optional<Integer> getPartitionId();

        abstract Optional<ByteString> getKey();

        abstract Optional<ByteString> getValue();

        private static SerializedKeyAndValue create(Optional<Integer> partitionId, Optional<ByteString> key, Optional<ByteString> value) {
            return new AutoValue_AbstractProduceAction_SerializedKeyAndValue(partitionId, key, value);
        }
    }
}

