/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ConsumerManager;
import io.confluent.kafkarest.entities.Consumer;
import io.confluent.kafkarest.entities.v3.ConsumerData;
import io.confluent.kafkarest.entities.v3.ConsumerDataList;
import io.confluent.kafkarest.entities.v3.GetConsumerResponse;
import io.confluent.kafkarest.entities.v3.ListConsumersResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

@Path(value="/v3/clusters/{clusterId}/consumer-groups/{consumerGroupId}/consumers")
@ResourceAccesslistFeature.ResourceName(value="api.v3.consumers.*")
public final class ConsumersResource {
    private final Provider<ConsumerManager> consumerManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public ConsumersResource(Provider<ConsumerManager> consumerManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.consumerManager = Objects.requireNonNull(consumerManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.consumers.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.consumers.list")
    public void listConsumers(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="consumerGroupId") String consumerGroupId) {
        CompletionStage response = ((ConsumerManager)this.consumerManager.get()).listConsumers(clusterId, consumerGroupId).thenApply(consumers -> ListConsumersResponse.create((ConsumerDataList)((ConsumerDataList.Builder)((ConsumerDataList.Builder)ConsumerDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "consumer-groups", consumerGroupId, "consumers")).build())).setData(consumers.stream().map(this::toConsumerData).sorted(Comparator.comparing(ConsumerData::getConsumerId)).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{consumerId}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.consumers.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.consumers.get")
    public void getConsumer(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="consumerGroupId") String consumerGroupId, @PathParam(value="consumerId") String consumerId) {
        CompletionStage response = ((CompletableFuture)((ConsumerManager)this.consumerManager.get()).getConsumer(clusterId, consumerGroupId, consumerId).thenApply(consumer -> (Consumer)consumer.orElseThrow(NotFoundException::new))).thenApply(consumer -> GetConsumerResponse.create(this.toConsumerData((Consumer)consumer)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    private ConsumerData toConsumerData(Consumer consumer) {
        return ((ConsumerData.Builder)ConsumerData.fromConsumer(consumer).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", consumer.getClusterId(), "consumer-groups", consumer.getConsumerGroupId(), "consumers", consumer.getConsumerId())).setResourceName(this.crnFactory.create("kafka", consumer.getClusterId(), "consumer-group", consumer.getConsumerGroupId(), "consumer", consumer.getConsumerId())).build())).setAssignments(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", consumer.getClusterId(), "consumer-groups", consumer.getConsumerGroupId(), "consumers", consumer.getConsumerId(), "assignments"))).build();
    }
}

