/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.BrokerConfigManager;
import io.confluent.kafkarest.controllers.BrokerManager;
import io.confluent.kafkarest.entities.Broker;
import io.confluent.kafkarest.entities.BrokerConfig;
import io.confluent.kafkarest.entities.v3.BrokerConfigDataList;
import io.confluent.kafkarest.entities.v3.ListBrokerConfigsResponse;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.resources.v3.BrokerConfigsResource;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

@Path(value="/v3/clusters/{clusterId}/brokers/-/configs")
@ResourceAccesslistFeature.ResourceName(value="api.v3.brokers-configs.*")
public final class ListAllBrokersConfigsAction {
    private final Provider<BrokerManager> brokerManager;
    private final Provider<BrokerConfigManager> brokerConfigManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public ListAllBrokersConfigsAction(Provider<BrokerManager> brokerManager, Provider<BrokerConfigManager> brokerConfigManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.brokerManager = brokerManager;
        this.brokerConfigManager = Objects.requireNonNull(brokerConfigManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.brokers.configs.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.brokers-configs.list")
    public void listBrokersConfigs(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId) {
        BrokerConfigManager resolvedBrokerConfigManager = (BrokerConfigManager)this.brokerConfigManager.get();
        CompletionStage response = ((BrokerManager)this.brokerManager.get()).listBrokers(clusterId).thenCompose(brokers -> resolvedBrokerConfigManager.listAllBrokerConfigs(clusterId, brokers.stream().map(Broker::getBrokerId).collect(Collectors.toList())).thenApply(configs -> ListBrokerConfigsResponse.create((BrokerConfigDataList)((BrokerConfigDataList.Builder)((BrokerConfigDataList.Builder)BrokerConfigDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "brokers", "-", "configs")).build())).setData(configs.values().stream().flatMap(brokerConfigs -> brokerConfigs.stream().sorted(Comparator.comparing(BrokerConfig::getBrokerId))).map(brokerConfig -> BrokerConfigsResource.toBrokerConfigData(brokerConfig, this.crnFactory, this.urlFactory)).collect(Collectors.toList()))).build())));
        AsyncResponses.asyncResume(asyncResponse, response);
    }
}

