/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ReplicaManager;
import io.confluent.kafkarest.entities.PartitionReplica;
import io.confluent.kafkarest.entities.v3.GetReplicaResponse;
import io.confluent.kafkarest.entities.v3.ListReplicasResponse;
import io.confluent.kafkarest.entities.v3.ReplicaData;
import io.confluent.kafkarest.entities.v3.ReplicaDataList;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

@Path(value="/v3/clusters/{clusterId}/topics/{topicName}/partitions/{partitionId}/replicas")
@ResourceAccesslistFeature.ResourceName(value="api.v3.replicas.*")
public final class ReplicasResource {
    private final Provider<ReplicaManager> replicaManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public ReplicasResource(Provider<ReplicaManager> replicaManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.replicaManager = Objects.requireNonNull(replicaManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.replicas.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.replicas.list")
    public void listReplicas(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @PathParam(value="partitionId") Integer partitionId) {
        CompletionStage response = ((ReplicaManager)this.replicaManager.get()).listReplicas(clusterId, topicName, partitionId).thenApply(replicas -> ListReplicasResponse.create((ReplicaDataList)((ReplicaDataList.Builder)((ReplicaDataList.Builder)ReplicaDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "topics", topicName, "partitions", Integer.toString(partitionId), "replicas")).build())).setData(replicas.stream().map(this::toReplicaData).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{brokerId}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.replicas.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.replicas.get")
    public void getReplica(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @PathParam(value="partitionId") Integer partitionId, @PathParam(value="brokerId") Integer brokerId) {
        CompletionStage response = ((CompletableFuture)((ReplicaManager)this.replicaManager.get()).getReplica(clusterId, topicName, partitionId, brokerId).thenApply(replica -> (PartitionReplica)replica.orElseThrow(NotFoundException::new))).thenApply(replica -> GetReplicaResponse.create(this.toReplicaData((PartitionReplica)replica)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    private ReplicaData toReplicaData(PartitionReplica replica) {
        return ((ReplicaData.Builder)ReplicaData.fromPartitionReplica(replica).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", replica.getClusterId(), "topics", replica.getTopicName(), "partitions", Integer.toString(replica.getPartitionId()), "replicas", Integer.toString(replica.getBrokerId()))).setResourceName(this.crnFactory.create("kafka", replica.getClusterId(), "topic", replica.getTopicName(), "partition", Integer.toString(replica.getPartitionId()), "replica", Integer.toString(replica.getBrokerId()))).build())).setBroker(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", replica.getClusterId(), "brokers", Integer.toString(replica.getBrokerId())))).build();
    }
}

