/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.resources.v3.ProduceRateLimiters;
import io.confluent.kafkarest.resources.v3.ProducerMetrics;
import io.confluent.kafkarest.response.ChunkedOutputFactory;
import io.confluent.kafkarest.response.StreamingResponseFactory;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Clock;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.glassfish.hk2.api.AnnotationLiteral;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public final class V3ResourcesModule
extends AbstractBinder {
    protected void configure() {
        this.bindAsContract(ProduceRateLimiters.class).in(Singleton.class);
        this.bindAsContract(ChunkedOutputFactory.class);
        this.bindAsContract(StreamingResponseFactory.class);
        this.bind(Clock.systemUTC()).to(Clock.class);
        this.bindFactory(ProduceResponseExecutorServiceFactory.class).qualifiedBy((Annotation)new ProduceResponseThreadPoolImpl()).to(ExecutorService.class).in(Singleton.class);
        this.bindFactory(ProducerMetricsFactory.class).to(ProducerMetrics.class).in(Singleton.class);
    }

    private static final class ProduceResponseExecutorServiceFactory
    implements Factory<ExecutorService> {
        private final int produceResponseThreadPoolSize;

        @Inject
        ProduceResponseExecutorServiceFactory(@ConfigModule.ProduceResponseThreadPoolSizeConfig Integer produceExecutorThreadPoolSize) {
            this.produceResponseThreadPoolSize = produceExecutorThreadPoolSize;
        }

        public ExecutorService provide() {
            ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Produce-response-thread-%d").build();
            return Executors.newFixedThreadPool(this.produceResponseThreadPoolSize, namedThreadFactory);
        }

        public void dispose(ExecutorService executorService) {
            executorService.shutdown();
            try {
                if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                executorService.shutdownNow();
            }
        }
    }

    private static final class ProduceResponseThreadPoolImpl
    extends AnnotationLiteral<ProduceResponseThreadPool>
    implements ProduceResponseThreadPool {
        private ProduceResponseThreadPoolImpl() {
        }
    }

    private static final class ProducerMetricsFactory
    implements Factory<ProducerMetrics> {
        private final Provider<KafkaRestConfig> config;

        @Inject
        ProducerMetricsFactory(Provider<KafkaRestConfig> config) {
            this.config = Objects.requireNonNull(config);
        }

        public ProducerMetrics provide() {
            return new ProducerMetrics((KafkaRestConfig)((Object)this.config.get()), Collections.emptyMap());
        }

        public void dispose(ProducerMetrics producerMetrics) {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ProduceResponseThreadPool {
    }
}

