/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.v2;

import io.confluent.kafkarest.ConsumerReadCallback;
import io.confluent.kafkarest.ConsumerRecordAndSize;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.entities.ConsumerRecord;
import io.confluent.kafkarest.v2.KafkaConsumerState;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaConsumerReadTask<KafkaKeyT, KafkaValueT, ClientKeyT, ClientValueT> {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumerReadTask.class);
    private final KafkaConsumerState<KafkaKeyT, KafkaValueT, ClientKeyT, ClientValueT> parent;
    private final Duration requestTimeout;
    private final int responseMinBytes;
    private final long maxResponseBytes;
    private final ConsumerReadCallback<ClientKeyT, ClientValueT> callback;
    private boolean finished;
    private List<ConsumerRecord<ClientKeyT, ClientValueT>> messages;
    private long bytesConsumed = 0L;
    private boolean exceededMinResponseBytes = false;
    private boolean exceededMaxResponseBytes = false;
    private final Instant started;
    private final Clock clock = Clock.systemUTC();

    public KafkaConsumerReadTask(KafkaConsumerState<KafkaKeyT, KafkaValueT, ClientKeyT, ClientValueT> parent, Duration timeout, long maxBytes, ConsumerReadCallback<ClientKeyT, ClientValueT> callback, KafkaRestConfig config) {
        this.parent = parent;
        this.maxResponseBytes = Math.min(maxBytes, config.getLong("consumer.request.max.bytes"));
        Duration defaultRequestTimeout = parent.getConsumerInstanceConfig().getRequestWaitMs() != null ? Duration.ofMillis(parent.getConsumerInstanceConfig().getRequestWaitMs().intValue()) : Duration.ofMillis(config.getInt("consumer.request.timeout.ms").intValue());
        this.requestTimeout = timeout.isNegative() || timeout.isZero() ? defaultRequestTimeout : Collections.min(Arrays.asList(timeout, defaultRequestTimeout));
        int responseMinBytes = parent.getConsumerInstanceConfig().getResponseMinBytes() != null ? parent.getConsumerInstanceConfig().getResponseMinBytes() : config.getInt("fetch.min.bytes");
        this.responseMinBytes = responseMinBytes < 0 ? Integer.MAX_VALUE : responseMinBytes;
        this.callback = callback;
        this.finished = false;
        this.started = this.clock.instant();
    }

    public void doPartialRead() {
        try {
            boolean requestTimedOut;
            if (this.messages == null) {
                this.messages = new Vector<ConsumerRecord<ClientKeyT, ClientValueT>>();
            }
            this.addRecords();
            log.trace("KafkaConsumerReadTask exiting read with id={} messages={} bytes={}, backing off if not complete", new Object[]{this, this.messages.size(), this.bytesConsumed});
            Instant now = this.clock.instant();
            Duration elapsed = Duration.between(this.started, now);
            boolean bl = requestTimedOut = elapsed.compareTo(this.requestTimeout) >= 0;
            if (requestTimedOut || this.exceededMaxResponseBytes || this.exceededMinResponseBytes) {
                log.trace("Finishing KafkaConsumerReadTask id={} requestTimedOut={} exceededMaxResponseBytes={} exceededMinResponseBytes={}", new Object[]{this, requestTimedOut, this.exceededMaxResponseBytes, this.exceededMinResponseBytes});
                this.finish();
            }
        }
        catch (Exception e) {
            this.finish(e);
            log.error("Unexpected exception in consumer read task id={} ", (Object)this, (Object)e);
        }
    }

    public boolean isDone() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecords() {
        KafkaConsumerState<KafkaKeyT, KafkaValueT, ClientKeyT, ClientValueT> kafkaConsumerState;
        while (!this.exceededMinResponseBytes && !this.exceededMaxResponseBytes && this.parent.hasNext()) {
            kafkaConsumerState = this.parent;
            synchronized (kafkaConsumerState) {
                if (this.parent.hasNext()) {
                    this.maybeAddRecord();
                }
            }
        }
        while (!this.exceededMaxResponseBytes && this.parent.hasNextCached()) {
            kafkaConsumerState = this.parent;
            synchronized (kafkaConsumerState) {
                if (this.parent.hasNextCached()) {
                    this.maybeAddRecord();
                }
            }
        }
    }

    private void maybeAddRecord() {
        ConsumerRecordAndSize<ClientKeyT, ClientValueT> recordAndSize = this.parent.createConsumerRecord(this.parent.peek());
        long roughMsgSize = recordAndSize.getSize();
        if (this.bytesConsumed + roughMsgSize >= this.maxResponseBytes) {
            this.exceededMaxResponseBytes = true;
            return;
        }
        this.messages.add(recordAndSize.getRecord());
        this.parent.next();
        this.bytesConsumed += roughMsgSize;
        if (!this.exceededMinResponseBytes && this.bytesConsumed > (long)this.responseMinBytes) {
            this.exceededMinResponseBytes = true;
        }
    }

    void finish() {
        this.finish(null);
    }

    private void finish(Exception e) {
        log.trace("Finishing KafkaConsumerReadTask id={}", (Object)this, (Object)e);
        try {
            this.callback.onCompletion(e == null ? this.messages : null, e);
        }
        catch (Throwable t) {
            log.error("Consumer read callback threw an unhandled exception id={} exception={}", (Object)this, (Object)e);
        }
        this.finished = true;
    }
}

