/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.TableflowV1CatalogIntegration;
import io.confluent.flink.apiserver.client.model.TableflowV1CatalogIntegrationList;
import io.confluent.flink.apiserver.client.model.TableflowV1TableflowTopic;
import io.confluent.flink.apiserver.client.model.TableflowV1TableflowTopicList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class TableflowV1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TableflowV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public TableflowV1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createTableflowV1CatalogIntegrationCall(String environment, String org, TableflowV1CatalogIntegration tableflowV1CatalogIntegration, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TableflowV1CatalogIntegration localVarPostBody = tableflowV1CatalogIntegration;
        String localVarPath = "/apis/tableflow/v1/orgs/{org}/environments/{environment}/catalogintegrations".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTableflowV1CatalogIntegrationValidateBeforeCall(String environment, String org, TableflowV1CatalogIntegration tableflowV1CatalogIntegration, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createTableflowV1CatalogIntegration(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createTableflowV1CatalogIntegration(Async)");
        }
        if (tableflowV1CatalogIntegration == null) {
            throw new ApiException("Missing the required parameter 'tableflowV1CatalogIntegration' when calling createTableflowV1CatalogIntegration(Async)");
        }
        return this.createTableflowV1CatalogIntegrationCall(environment, org, tableflowV1CatalogIntegration, _callback);
    }

    public TableflowV1CatalogIntegration createTableflowV1CatalogIntegration(String environment, String org, TableflowV1CatalogIntegration tableflowV1CatalogIntegration) throws ApiException {
        ApiResponse<TableflowV1CatalogIntegration> localVarResp = this.createTableflowV1CatalogIntegrationWithHttpInfo(environment, org, tableflowV1CatalogIntegration);
        return localVarResp.getData();
    }

    public ApiResponse<TableflowV1CatalogIntegration> createTableflowV1CatalogIntegrationWithHttpInfo(String environment, String org, TableflowV1CatalogIntegration tableflowV1CatalogIntegration) throws ApiException {
        Call localVarCall = this.createTableflowV1CatalogIntegrationValidateBeforeCall(environment, org, tableflowV1CatalogIntegration, null);
        Type localVarReturnType = new TypeToken<TableflowV1CatalogIntegration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTableflowV1CatalogIntegrationAsync(String environment, String org, TableflowV1CatalogIntegration tableflowV1CatalogIntegration, ApiCallback<TableflowV1CatalogIntegration> _callback) throws ApiException {
        Call localVarCall = this.createTableflowV1CatalogIntegrationValidateBeforeCall(environment, org, tableflowV1CatalogIntegration, _callback);
        Type localVarReturnType = new TypeToken<TableflowV1CatalogIntegration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createTableflowV1TableflowTopicCall(String environment, String org, TableflowV1TableflowTopic tableflowV1TableflowTopic, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TableflowV1TableflowTopic localVarPostBody = tableflowV1TableflowTopic;
        String localVarPath = "/apis/tableflow/v1/orgs/{org}/environments/{environment}/tableflowtopics".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTableflowV1TableflowTopicValidateBeforeCall(String environment, String org, TableflowV1TableflowTopic tableflowV1TableflowTopic, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createTableflowV1TableflowTopic(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createTableflowV1TableflowTopic(Async)");
        }
        if (tableflowV1TableflowTopic == null) {
            throw new ApiException("Missing the required parameter 'tableflowV1TableflowTopic' when calling createTableflowV1TableflowTopic(Async)");
        }
        return this.createTableflowV1TableflowTopicCall(environment, org, tableflowV1TableflowTopic, _callback);
    }

    public TableflowV1TableflowTopic createTableflowV1TableflowTopic(String environment, String org, TableflowV1TableflowTopic tableflowV1TableflowTopic) throws ApiException {
        ApiResponse<TableflowV1TableflowTopic> localVarResp = this.createTableflowV1TableflowTopicWithHttpInfo(environment, org, tableflowV1TableflowTopic);
        return localVarResp.getData();
    }

    public ApiResponse<TableflowV1TableflowTopic> createTableflowV1TableflowTopicWithHttpInfo(String environment, String org, TableflowV1TableflowTopic tableflowV1TableflowTopic) throws ApiException {
        Call localVarCall = this.createTableflowV1TableflowTopicValidateBeforeCall(environment, org, tableflowV1TableflowTopic, null);
        Type localVarReturnType = new TypeToken<TableflowV1TableflowTopic>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTableflowV1TableflowTopicAsync(String environment, String org, TableflowV1TableflowTopic tableflowV1TableflowTopic, ApiCallback<TableflowV1TableflowTopic> _callback) throws ApiException {
        Call localVarCall = this.createTableflowV1TableflowTopicValidateBeforeCall(environment, org, tableflowV1TableflowTopic, _callback);
        Type localVarReturnType = new TypeToken<TableflowV1TableflowTopic>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteTableflowV1CatalogIntegrationCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/tableflow/v1/orgs/{org}/environments/{environment}/catalogintegrations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTableflowV1CatalogIntegrationValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteTableflowV1CatalogIntegration(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteTableflowV1CatalogIntegration(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteTableflowV1CatalogIntegration(Async)");
        }
        return this.deleteTableflowV1CatalogIntegrationCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public TableflowV1CatalogIntegration deleteTableflowV1CatalogIntegration(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<TableflowV1CatalogIntegration> localVarResp = this.deleteTableflowV1CatalogIntegrationWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<TableflowV1CatalogIntegration> deleteTableflowV1CatalogIntegrationWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteTableflowV1CatalogIntegrationValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<TableflowV1CatalogIntegration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteTableflowV1CatalogIntegrationAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<TableflowV1CatalogIntegration> _callback) throws ApiException {
        Call localVarCall = this.deleteTableflowV1CatalogIntegrationValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<TableflowV1CatalogIntegration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteTableflowV1TableflowTopicCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/tableflow/v1/orgs/{org}/environments/{environment}/tableflowtopics/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTableflowV1TableflowTopicValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteTableflowV1TableflowTopic(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteTableflowV1TableflowTopic(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteTableflowV1TableflowTopic(Async)");
        }
        return this.deleteTableflowV1TableflowTopicCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public TableflowV1TableflowTopic deleteTableflowV1TableflowTopic(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<TableflowV1TableflowTopic> localVarResp = this.deleteTableflowV1TableflowTopicWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<TableflowV1TableflowTopic> deleteTableflowV1TableflowTopicWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteTableflowV1TableflowTopicValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<TableflowV1TableflowTopic>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteTableflowV1TableflowTopicAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<TableflowV1TableflowTopic> _callback) throws ApiException {
        Call localVarCall = this.deleteTableflowV1TableflowTopicValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<TableflowV1TableflowTopic>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listTableflowV1CatalogIntegrationsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/tableflow/v1/orgs/{org}/environments/{environment}/catalogintegrations".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTableflowV1CatalogIntegrationsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listTableflowV1CatalogIntegrations(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listTableflowV1CatalogIntegrations(Async)");
        }
        return this.listTableflowV1CatalogIntegrationsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public TableflowV1CatalogIntegrationList listTableflowV1CatalogIntegrations(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<TableflowV1CatalogIntegrationList> localVarResp = this.listTableflowV1CatalogIntegrationsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<TableflowV1CatalogIntegrationList> listTableflowV1CatalogIntegrationsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listTableflowV1CatalogIntegrationsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<TableflowV1CatalogIntegrationList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTableflowV1CatalogIntegrationsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<TableflowV1CatalogIntegrationList> _callback) throws ApiException {
        Call localVarCall = this.listTableflowV1CatalogIntegrationsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<TableflowV1CatalogIntegrationList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listTableflowV1CatalogIntegrationsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/tableflow/v1/orgs/{org}/catalogintegrations".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTableflowV1CatalogIntegrationsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listTableflowV1CatalogIntegrationsForAllEnvironments(Async)");
        }
        return this.listTableflowV1CatalogIntegrationsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public TableflowV1CatalogIntegrationList listTableflowV1CatalogIntegrationsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<TableflowV1CatalogIntegrationList> localVarResp = this.listTableflowV1CatalogIntegrationsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<TableflowV1CatalogIntegrationList> listTableflowV1CatalogIntegrationsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listTableflowV1CatalogIntegrationsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<TableflowV1CatalogIntegrationList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTableflowV1CatalogIntegrationsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<TableflowV1CatalogIntegrationList> _callback) throws ApiException {
        Call localVarCall = this.listTableflowV1CatalogIntegrationsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<TableflowV1CatalogIntegrationList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listTableflowV1TableflowTopicsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/tableflow/v1/orgs/{org}/environments/{environment}/tableflowtopics".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTableflowV1TableflowTopicsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listTableflowV1TableflowTopics(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listTableflowV1TableflowTopics(Async)");
        }
        return this.listTableflowV1TableflowTopicsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public TableflowV1TableflowTopicList listTableflowV1TableflowTopics(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<TableflowV1TableflowTopicList> localVarResp = this.listTableflowV1TableflowTopicsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<TableflowV1TableflowTopicList> listTableflowV1TableflowTopicsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listTableflowV1TableflowTopicsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<TableflowV1TableflowTopicList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTableflowV1TableflowTopicsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<TableflowV1TableflowTopicList> _callback) throws ApiException {
        Call localVarCall = this.listTableflowV1TableflowTopicsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<TableflowV1TableflowTopicList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listTableflowV1TableflowTopicsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/tableflow/v1/orgs/{org}/tableflowtopics".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTableflowV1TableflowTopicsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listTableflowV1TableflowTopicsForAllEnvironments(Async)");
        }
        return this.listTableflowV1TableflowTopicsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public TableflowV1TableflowTopicList listTableflowV1TableflowTopicsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<TableflowV1TableflowTopicList> localVarResp = this.listTableflowV1TableflowTopicsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<TableflowV1TableflowTopicList> listTableflowV1TableflowTopicsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listTableflowV1TableflowTopicsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<TableflowV1TableflowTopicList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTableflowV1TableflowTopicsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<TableflowV1TableflowTopicList> _callback) throws ApiException {
        Call localVarCall = this.listTableflowV1TableflowTopicsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<TableflowV1TableflowTopicList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchTableflowV1CatalogIntegrationCall(String environment, String name, String org, TableflowV1CatalogIntegration tableflowV1CatalogIntegration, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TableflowV1CatalogIntegration localVarPostBody = tableflowV1CatalogIntegration;
        String localVarPath = "/apis/tableflow/v1/orgs/{org}/environments/{environment}/catalogintegrations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchTableflowV1CatalogIntegrationValidateBeforeCall(String environment, String name, String org, TableflowV1CatalogIntegration tableflowV1CatalogIntegration, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchTableflowV1CatalogIntegration(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchTableflowV1CatalogIntegration(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchTableflowV1CatalogIntegration(Async)");
        }
        if (tableflowV1CatalogIntegration == null) {
            throw new ApiException("Missing the required parameter 'tableflowV1CatalogIntegration' when calling patchTableflowV1CatalogIntegration(Async)");
        }
        return this.patchTableflowV1CatalogIntegrationCall(environment, name, org, tableflowV1CatalogIntegration, _callback);
    }

    public TableflowV1CatalogIntegration patchTableflowV1CatalogIntegration(String environment, String name, String org, TableflowV1CatalogIntegration tableflowV1CatalogIntegration) throws ApiException {
        ApiResponse<TableflowV1CatalogIntegration> localVarResp = this.patchTableflowV1CatalogIntegrationWithHttpInfo(environment, name, org, tableflowV1CatalogIntegration);
        return localVarResp.getData();
    }

    public ApiResponse<TableflowV1CatalogIntegration> patchTableflowV1CatalogIntegrationWithHttpInfo(String environment, String name, String org, TableflowV1CatalogIntegration tableflowV1CatalogIntegration) throws ApiException {
        Call localVarCall = this.patchTableflowV1CatalogIntegrationValidateBeforeCall(environment, name, org, tableflowV1CatalogIntegration, null);
        Type localVarReturnType = new TypeToken<TableflowV1CatalogIntegration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchTableflowV1CatalogIntegrationAsync(String environment, String name, String org, TableflowV1CatalogIntegration tableflowV1CatalogIntegration, ApiCallback<TableflowV1CatalogIntegration> _callback) throws ApiException {
        Call localVarCall = this.patchTableflowV1CatalogIntegrationValidateBeforeCall(environment, name, org, tableflowV1CatalogIntegration, _callback);
        Type localVarReturnType = new TypeToken<TableflowV1CatalogIntegration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchTableflowV1TableflowTopicCall(String environment, String name, String org, TableflowV1TableflowTopic tableflowV1TableflowTopic, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TableflowV1TableflowTopic localVarPostBody = tableflowV1TableflowTopic;
        String localVarPath = "/apis/tableflow/v1/orgs/{org}/environments/{environment}/tableflowtopics/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchTableflowV1TableflowTopicValidateBeforeCall(String environment, String name, String org, TableflowV1TableflowTopic tableflowV1TableflowTopic, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchTableflowV1TableflowTopic(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchTableflowV1TableflowTopic(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchTableflowV1TableflowTopic(Async)");
        }
        if (tableflowV1TableflowTopic == null) {
            throw new ApiException("Missing the required parameter 'tableflowV1TableflowTopic' when calling patchTableflowV1TableflowTopic(Async)");
        }
        return this.patchTableflowV1TableflowTopicCall(environment, name, org, tableflowV1TableflowTopic, _callback);
    }

    public TableflowV1TableflowTopic patchTableflowV1TableflowTopic(String environment, String name, String org, TableflowV1TableflowTopic tableflowV1TableflowTopic) throws ApiException {
        ApiResponse<TableflowV1TableflowTopic> localVarResp = this.patchTableflowV1TableflowTopicWithHttpInfo(environment, name, org, tableflowV1TableflowTopic);
        return localVarResp.getData();
    }

    public ApiResponse<TableflowV1TableflowTopic> patchTableflowV1TableflowTopicWithHttpInfo(String environment, String name, String org, TableflowV1TableflowTopic tableflowV1TableflowTopic) throws ApiException {
        Call localVarCall = this.patchTableflowV1TableflowTopicValidateBeforeCall(environment, name, org, tableflowV1TableflowTopic, null);
        Type localVarReturnType = new TypeToken<TableflowV1TableflowTopic>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchTableflowV1TableflowTopicAsync(String environment, String name, String org, TableflowV1TableflowTopic tableflowV1TableflowTopic, ApiCallback<TableflowV1TableflowTopic> _callback) throws ApiException {
        Call localVarCall = this.patchTableflowV1TableflowTopicValidateBeforeCall(environment, name, org, tableflowV1TableflowTopic, _callback);
        Type localVarReturnType = new TypeToken<TableflowV1TableflowTopic>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readTableflowV1CatalogIntegrationCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/tableflow/v1/orgs/{org}/environments/{environment}/catalogintegrations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readTableflowV1CatalogIntegrationValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readTableflowV1CatalogIntegration(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readTableflowV1CatalogIntegration(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readTableflowV1CatalogIntegration(Async)");
        }
        return this.readTableflowV1CatalogIntegrationCall(environment, name, org, resourceVersion, _callback);
    }

    public TableflowV1CatalogIntegration readTableflowV1CatalogIntegration(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<TableflowV1CatalogIntegration> localVarResp = this.readTableflowV1CatalogIntegrationWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<TableflowV1CatalogIntegration> readTableflowV1CatalogIntegrationWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readTableflowV1CatalogIntegrationValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<TableflowV1CatalogIntegration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readTableflowV1CatalogIntegrationAsync(String environment, String name, String org, String resourceVersion, ApiCallback<TableflowV1CatalogIntegration> _callback) throws ApiException {
        Call localVarCall = this.readTableflowV1CatalogIntegrationValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<TableflowV1CatalogIntegration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readTableflowV1TableflowTopicCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/tableflow/v1/orgs/{org}/environments/{environment}/tableflowtopics/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readTableflowV1TableflowTopicValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readTableflowV1TableflowTopic(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readTableflowV1TableflowTopic(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readTableflowV1TableflowTopic(Async)");
        }
        return this.readTableflowV1TableflowTopicCall(environment, name, org, resourceVersion, _callback);
    }

    public TableflowV1TableflowTopic readTableflowV1TableflowTopic(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<TableflowV1TableflowTopic> localVarResp = this.readTableflowV1TableflowTopicWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<TableflowV1TableflowTopic> readTableflowV1TableflowTopicWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readTableflowV1TableflowTopicValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<TableflowV1TableflowTopic>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readTableflowV1TableflowTopicAsync(String environment, String name, String org, String resourceVersion, ApiCallback<TableflowV1TableflowTopic> _callback) throws ApiException {
        Call localVarCall = this.readTableflowV1TableflowTopicValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<TableflowV1TableflowTopic>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateTableflowV1CatalogIntegrationCall(String environment, String name, String org, TableflowV1CatalogIntegration tableflowV1CatalogIntegration, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TableflowV1CatalogIntegration localVarPostBody = tableflowV1CatalogIntegration;
        String localVarPath = "/apis/tableflow/v1/orgs/{org}/environments/{environment}/catalogintegrations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateTableflowV1CatalogIntegrationValidateBeforeCall(String environment, String name, String org, TableflowV1CatalogIntegration tableflowV1CatalogIntegration, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateTableflowV1CatalogIntegration(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateTableflowV1CatalogIntegration(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateTableflowV1CatalogIntegration(Async)");
        }
        if (tableflowV1CatalogIntegration == null) {
            throw new ApiException("Missing the required parameter 'tableflowV1CatalogIntegration' when calling updateTableflowV1CatalogIntegration(Async)");
        }
        return this.updateTableflowV1CatalogIntegrationCall(environment, name, org, tableflowV1CatalogIntegration, _callback);
    }

    public TableflowV1CatalogIntegration updateTableflowV1CatalogIntegration(String environment, String name, String org, TableflowV1CatalogIntegration tableflowV1CatalogIntegration) throws ApiException {
        ApiResponse<TableflowV1CatalogIntegration> localVarResp = this.updateTableflowV1CatalogIntegrationWithHttpInfo(environment, name, org, tableflowV1CatalogIntegration);
        return localVarResp.getData();
    }

    public ApiResponse<TableflowV1CatalogIntegration> updateTableflowV1CatalogIntegrationWithHttpInfo(String environment, String name, String org, TableflowV1CatalogIntegration tableflowV1CatalogIntegration) throws ApiException {
        Call localVarCall = this.updateTableflowV1CatalogIntegrationValidateBeforeCall(environment, name, org, tableflowV1CatalogIntegration, null);
        Type localVarReturnType = new TypeToken<TableflowV1CatalogIntegration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateTableflowV1CatalogIntegrationAsync(String environment, String name, String org, TableflowV1CatalogIntegration tableflowV1CatalogIntegration, ApiCallback<TableflowV1CatalogIntegration> _callback) throws ApiException {
        Call localVarCall = this.updateTableflowV1CatalogIntegrationValidateBeforeCall(environment, name, org, tableflowV1CatalogIntegration, _callback);
        Type localVarReturnType = new TypeToken<TableflowV1CatalogIntegration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateTableflowV1TableflowTopicCall(String environment, String name, String org, TableflowV1TableflowTopic tableflowV1TableflowTopic, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TableflowV1TableflowTopic localVarPostBody = tableflowV1TableflowTopic;
        String localVarPath = "/apis/tableflow/v1/orgs/{org}/environments/{environment}/tableflowtopics/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateTableflowV1TableflowTopicValidateBeforeCall(String environment, String name, String org, TableflowV1TableflowTopic tableflowV1TableflowTopic, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateTableflowV1TableflowTopic(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateTableflowV1TableflowTopic(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateTableflowV1TableflowTopic(Async)");
        }
        if (tableflowV1TableflowTopic == null) {
            throw new ApiException("Missing the required parameter 'tableflowV1TableflowTopic' when calling updateTableflowV1TableflowTopic(Async)");
        }
        return this.updateTableflowV1TableflowTopicCall(environment, name, org, tableflowV1TableflowTopic, _callback);
    }

    public TableflowV1TableflowTopic updateTableflowV1TableflowTopic(String environment, String name, String org, TableflowV1TableflowTopic tableflowV1TableflowTopic) throws ApiException {
        ApiResponse<TableflowV1TableflowTopic> localVarResp = this.updateTableflowV1TableflowTopicWithHttpInfo(environment, name, org, tableflowV1TableflowTopic);
        return localVarResp.getData();
    }

    public ApiResponse<TableflowV1TableflowTopic> updateTableflowV1TableflowTopicWithHttpInfo(String environment, String name, String org, TableflowV1TableflowTopic tableflowV1TableflowTopic) throws ApiException {
        Call localVarCall = this.updateTableflowV1TableflowTopicValidateBeforeCall(environment, name, org, tableflowV1TableflowTopic, null);
        Type localVarReturnType = new TypeToken<TableflowV1TableflowTopic>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateTableflowV1TableflowTopicAsync(String environment, String name, String org, TableflowV1TableflowTopic tableflowV1TableflowTopic, ApiCallback<TableflowV1TableflowTopic> _callback) throws ApiException {
        Call localVarCall = this.updateTableflowV1TableflowTopicValidateBeforeCall(environment, name, org, tableflowV1TableflowTopic, _callback);
        Type localVarReturnType = new TypeToken<TableflowV1TableflowTopic>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

