/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.confluent.flink.apiserver.client.JSON;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FlinkV1SavepointStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_FLINK_VERSION = "flinkVersion";
    @SerializedName(value="flinkVersion")
    private String flinkVersion;
    public static final String SERIALIZED_NAME_FORMAT = "format";
    @SerializedName(value="format")
    private FormatEnum format;
    public static final String SERIALIZED_NAME_PHASE = "phase";
    @SerializedName(value="phase")
    private PhaseEnum phase = PhaseEnum.PENDING;
    public static final String SERIALIZED_NAME_URI = "uri";
    @SerializedName(value="uri")
    private String uri;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FlinkV1SavepointStatus flinkVersion(String flinkVersion) {
        this.flinkVersion = flinkVersion;
        return this;
    }

    @Nullable
    public String getFlinkVersion() {
        return this.flinkVersion;
    }

    public void setFlinkVersion(String flinkVersion) {
        this.flinkVersion = flinkVersion;
    }

    public FlinkV1SavepointStatus format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @Nullable
    public FormatEnum getFormat() {
        return this.format;
    }

    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public FlinkV1SavepointStatus phase(PhaseEnum phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    public PhaseEnum getPhase() {
        return this.phase;
    }

    public void setPhase(PhaseEnum phase) {
        this.phase = phase;
    }

    public FlinkV1SavepointStatus uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Nullable
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public FlinkV1SavepointStatus putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlinkV1SavepointStatus flinkV1SavepointStatus = (FlinkV1SavepointStatus)o;
        return Objects.equals(this.flinkVersion, flinkV1SavepointStatus.flinkVersion) && Objects.equals((Object)this.format, (Object)flinkV1SavepointStatus.format) && Objects.equals((Object)this.phase, (Object)flinkV1SavepointStatus.phase) && Objects.equals(this.uri, flinkV1SavepointStatus.uri) && Objects.equals(this.additionalProperties, flinkV1SavepointStatus.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.flinkVersion, this.format, this.phase, this.uri, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlinkV1SavepointStatus {\n");
        sb.append("    flinkVersion: ").append(this.toIndentedString(this.flinkVersion)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString((Object)this.phase)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in FlinkV1SavepointStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_FLINK_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_FLINK_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FLINK_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `flinkVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FLINK_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FORMAT) != null && !jsonObj.get(SERIALIZED_NAME_FORMAT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FORMAT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `format` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FORMAT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FORMAT) != null && !jsonObj.get(SERIALIZED_NAME_FORMAT).isJsonNull()) {
            FormatEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_FORMAT));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHASE) != null && !jsonObj.get(SERIALIZED_NAME_PHASE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PHASE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `phase` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHASE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHASE) != null && !jsonObj.get(SERIALIZED_NAME_PHASE).isJsonNull()) {
            PhaseEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PHASE));
        }
        if (jsonObj.get(SERIALIZED_NAME_URI) != null && !jsonObj.get(SERIALIZED_NAME_URI).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URI).toString()));
        }
    }

    public static FlinkV1SavepointStatus fromJson(String jsonString) throws IOException {
        return (FlinkV1SavepointStatus)JSON.getGson().fromJson(jsonString, FlinkV1SavepointStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FLINK_VERSION);
        openapiFields.add(SERIALIZED_NAME_FORMAT);
        openapiFields.add(SERIALIZED_NAME_PHASE);
        openapiFields.add(SERIALIZED_NAME_URI);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FlinkV1SavepointStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FlinkV1SavepointStatus.class));
            return new TypeAdapter<FlinkV1SavepointStatus>(){

                public void write(JsonWriter out, FlinkV1SavepointStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public FlinkV1SavepointStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    FlinkV1SavepointStatus.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    FlinkV1SavepointStatus instance = (FlinkV1SavepointStatus)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PhaseEnum {
        COMPLETED("Completed"),
        DELETING("Deleting"),
        FAILED("Failed"),
        IN_PROGRESS("InProgress"),
        PENDING("Pending");

        private String value;

        private PhaseEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PhaseEnum fromValue(String value) {
            for (PhaseEnum b : PhaseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            PhaseEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<PhaseEnum> {
            public void write(JsonWriter jsonWriter, PhaseEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PhaseEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PhaseEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FormatEnum {
        ALIGNED_CHECKPOINT("AlignedCheckpoint"),
        NATIVE_SAVEPOINT("NativeSavepoint"),
        UNALIGNED_CHECKPOINT("UnalignedCheckpoint");

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            FormatEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<FormatEnum> {
            public void write(JsonWriter jsonWriter, FormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FormatEnum.fromValue(value);
            }
        }
    }
}

