/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.confluent.flink.apiserver.client.JSON;
import io.confluent.flink.apiserver.client.model.SqlV3SensitivePayload;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SqlV3ConnectionSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_AUTH_DATA = "authData";
    @SerializedName(value="authData")
    private SqlV3SensitivePayload authData;
    public static final String SERIALIZED_NAME_CONNECTION_TYPE = "connectionType";
    @SerializedName(value="connectionType")
    private String connectionType = "";
    public static final String SERIALIZED_NAME_ENDPOINT = "endpoint";
    @SerializedName(value="endpoint")
    private String endpoint = "";
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SqlV3ConnectionSpec authData(SqlV3SensitivePayload authData) {
        this.authData = authData;
        return this;
    }

    @Nonnull
    public SqlV3SensitivePayload getAuthData() {
        return this.authData;
    }

    public void setAuthData(SqlV3SensitivePayload authData) {
        this.authData = authData;
    }

    public SqlV3ConnectionSpec connectionType(String connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    @Nonnull
    public String getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public SqlV3ConnectionSpec endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Nonnull
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public SqlV3ConnectionSpec putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlV3ConnectionSpec sqlV3ConnectionSpec = (SqlV3ConnectionSpec)o;
        return Objects.equals(this.authData, sqlV3ConnectionSpec.authData) && Objects.equals(this.connectionType, sqlV3ConnectionSpec.connectionType) && Objects.equals(this.endpoint, sqlV3ConnectionSpec.endpoint) && Objects.equals(this.additionalProperties, sqlV3ConnectionSpec.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.authData, this.connectionType, this.endpoint, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SqlV3ConnectionSpec {\n");
        sb.append("    authData: ").append(this.toIndentedString(this.authData)).append("\n");
        sb.append("    connectionType: ").append(this.toIndentedString(this.connectionType)).append("\n");
        sb.append("    endpoint: ").append(this.toIndentedString(this.endpoint)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SqlV3ConnectionSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_CONNECTION_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `connectionType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONNECTION_TYPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ENDPOINT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `endpoint` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENDPOINT).toString()));
        }
    }

    public static SqlV3ConnectionSpec fromJson(String jsonString) throws IOException {
        return (SqlV3ConnectionSpec)JSON.getGson().fromJson(jsonString, SqlV3ConnectionSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUTH_DATA);
        openapiFields.add(SERIALIZED_NAME_CONNECTION_TYPE);
        openapiFields.add(SERIALIZED_NAME_ENDPOINT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AUTH_DATA);
        openapiRequiredFields.add(SERIALIZED_NAME_CONNECTION_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_ENDPOINT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!SqlV3ConnectionSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SqlV3ConnectionSpec.class));
            return new TypeAdapter<SqlV3ConnectionSpec>(){

                public void write(JsonWriter out, SqlV3ConnectionSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public SqlV3ConnectionSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    SqlV3ConnectionSpec.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    SqlV3ConnectionSpec instance = (SqlV3ConnectionSpec)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

