/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;

public enum SerializerEncoding {
    JSON,
    XML,
    TEXT;

    private static final ClientLogger LOGGER;

    public static SerializerEncoding fromHeaders(HttpHeaders headers) {
        String mimeContentType = headers.getValue(HttpHeaderName.CONTENT_TYPE);
        if (CoreUtils.isNullOrEmpty(mimeContentType)) {
            LOGGER.verbose("'Content-Type' not found. Returning default encoding: JSON");
            return JSON;
        }
        int contentTypeEnd = mimeContentType.indexOf(59);
        String contentType = contentTypeEnd == -1 ? mimeContentType : mimeContentType.substring(0, contentTypeEnd);
        SerializerEncoding encoding = SerializerEncoding.checkForKnownEncoding(contentType);
        if (encoding != null) {
            return encoding;
        }
        int contentTypeTypeSplit = contentType.indexOf(47);
        if (contentTypeTypeSplit == -1) {
            LOGGER.log(LogLevel.VERBOSE, () -> "Content-Type '" + contentType + "' does not match mime-type formatting 'type'/'subtype'. Returning default: JSON");
            return JSON;
        }
        String subtype = contentType.substring(contentTypeTypeSplit + 1);
        int lastIndex = subtype.lastIndexOf(43);
        if (lastIndex == -1) {
            return JSON;
        }
        String mimeTypeSuffix = subtype.substring(lastIndex + 1);
        if ("xml".equalsIgnoreCase(mimeTypeSuffix)) {
            return XML;
        }
        if ("json".equalsIgnoreCase(mimeTypeSuffix)) {
            return JSON;
        }
        LOGGER.log(LogLevel.VERBOSE, () -> "Content-Type '" + mimeTypeSuffix + "' does not match any supported one. Returning default: JSON");
        return JSON;
    }

    private static SerializerEncoding checkForKnownEncoding(String contentType) {
        int length = contentType.length();
        if (length != 8 && length != 9 && length != 10 && length != 15 && length != 16) {
            return null;
        }
        if ("text/".regionMatches(true, 0, contentType, 0, 5)) {
            if (length == 8) {
                if ("xml".regionMatches(true, 0, contentType, 5, 3)) {
                    return XML;
                }
                if ("csv".regionMatches(true, 0, contentType, 5, 3)) {
                    return TEXT;
                }
                if ("css".regionMatches(true, 0, contentType, 5, 3)) {
                    return TEXT;
                }
            } else {
                if (length == 9 && "html".regionMatches(true, 0, contentType, 5, 4)) {
                    return TEXT;
                }
                if (length == 10 && "plain".regionMatches(true, 0, contentType, 5, 5)) {
                    return TEXT;
                }
                if (length == 15 && "javascript".regionMatches(true, 0, contentType, 5, 10)) {
                    return TEXT;
                }
            }
        } else if ("application/".regionMatches(true, 0, contentType, 0, 12)) {
            if (length == 16 && "json".regionMatches(true, 0, contentType, 12, 4)) {
                return JSON;
            }
            if (length == 15 && "xml".regionMatches(true, 0, contentType, 12, 3)) {
                return XML;
            }
        }
        return null;
    }

    static {
        LOGGER = new ClientLogger(SerializerEncoding.class);
    }
}

