/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.LibCryptoRng;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.NativeEvpCipherCtx;
import com.amazon.corretto.crypto.provider.RuntimeCryptoException;
import com.amazon.corretto.crypto.provider.ShimByteBuffer;
import com.amazon.corretto.crypto.provider.Utils;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

class AesCbcSpi
extends CipherSpi {
    public static final int NO_PADDING = 0;
    public static final int PKCS7_PADDING = 1;
    public static final int ISO10126_PADDING = 2;
    public static final Set<String> AES_CBC_NO_PADDING_NAMES;
    public static final Set<String> AES_CBC_PKCS7_PADDING_NAMES;
    public static final Set<String> AES_CBC_ISO10126_PADDING_NAMES;
    private static final byte[] EMPTY_ARRAY;
    private static final int BLOCK_SIZE_IN_BYTES = 16;
    private static final int MODE_NOT_SET = -1;
    private static final int ENC_MODE = 1;
    private static final int DEC_MODE = 0;
    private CipherState cipherState;
    private Padding paddingScheme;
    private int unprocessedInput;
    private int opMode;
    private byte[] key;
    private byte[] iv;
    private NativeEvpCipherCtx nativeCtx;
    private final boolean saveContext;
    private byte[] lastBlock;
    private boolean inputIsEmpty;

    AesCbcSpi(Padding padding, boolean bl) {
        this.paddingScheme = padding;
        this.cipherState = CipherState.NEEDS_INITIALIZATION;
        this.unprocessedInput = 0;
        this.opMode = -1;
        this.key = null;
        this.iv = null;
        this.nativeCtx = null;
        this.saveContext = bl;
        this.lastBlock = null;
        this.inputIsEmpty = true;
    }

    private boolean noPadding() {
        return this.paddingScheme.equals((Object)Padding.NONE);
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!"CBC".equalsIgnoreCase(string)) {
            throw new NoSuchAlgorithmException("Only CBC mode is supported.");
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (string == null) {
            throw new NoSuchPaddingException("Padding cannot be null.");
        }
        if (!this.inputIsEmpty) {
            throw new NoSuchPaddingException("Padding cannot be set during an operation.");
        }
        Predicate<String> predicate = string2 -> string2.split("/")[2].equalsIgnoreCase(string);
        if (AES_CBC_ISO10126_PADDING_NAMES.stream().anyMatch(predicate)) {
            this.paddingScheme = Padding.ISO10126;
        } else if (AES_CBC_PKCS7_PADDING_NAMES.stream().anyMatch(predicate)) {
            this.paddingScheme = Padding.PKCS7;
        } else if (AES_CBC_NO_PADDING_NAMES.stream().anyMatch(predicate)) {
            this.paddingScheme = Padding.NONE;
        } else {
            throw new NoSuchPaddingException(String.format("%s is not a supported padding.", string));
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        long l = n + this.unprocessedInput;
        long l2 = l % 16L;
        if (this.noPadding()) {
            return (int)l;
        }
        if (this.opMode == 1) {
            return (int)(l + 16L - l2);
        }
        return (int)l;
    }

    @Override
    protected byte[] engineGetIV() {
        return this.iv == null ? null : (byte[])this.iv.clone();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("AES");
            byte[] byArray = this.iv;
            if (byArray == null) {
                byArray = new byte[16];
                new LibCryptoRng().nextBytes(byArray);
            }
            algorithmParameters.init(new IvParameterSpec(byArray));
            return algorithmParameters;
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException generalSecurityException) {
            throw new Error("Unexpected error", generalSecurityException);
        }
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (n != 1 && n != 3) {
            throw new InvalidKeyException("IV required for decrypt");
        }
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        try {
            this.engineInit(n, key, new IvParameterSpec(byArray), null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeCryptoException(invalidAlgorithmParameterException);
        }
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            this.engineInit(n, key, algorithmParameters.getParameterSpec(IvParameterSpec.class), null);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException);
        }
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int n2 = AesCbcSpi.checkOperation(n);
        byte[] byArray = AesCbcSpi.checkAesCbcIv(algorithmParameterSpec);
        byte[] byArray2 = Utils.checkAesKey(key);
        this.cipherState = CipherState.INITIALIZED;
        this.opMode = n2;
        this.iv = byArray;
        this.key = byArray2;
        this.unprocessedInput = 0;
        this.inputIsEmpty = true;
        this.initLastBlock();
    }

    private void initLastBlock() {
        if (!this.paddingScheme.equals((Object)Padding.ISO10126) || this.opMode != 0) {
            return;
        }
        if (this.lastBlock == null) {
            this.lastBlock = new byte[17];
        } else {
            Arrays.fill(this.lastBlock, (byte)0);
        }
    }

    private static int checkOperation(int n) throws InvalidParameterException {
        return n == 1 || n == 3 ? 1 : 0;
    }

    private static byte[] checkAesCbcIv(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec cannot be null.");
            }
            throw new InvalidAlgorithmParameterException("Unknown AlgorithmParameterSpec: " + algorithmParameterSpec.getClass());
        }
        IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
        byte[] byArray = ivParameterSpec.getIV();
        if (byArray.length != 16) {
            throw new InvalidAlgorithmParameterException("Invalid IV for AES/CBC");
        }
        return byArray;
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        Utils.checkArrayLimits(byArray, n, n2);
        this.finalOrUpdateStateCheck();
        byte[] byArray2 = new byte[this.getOutputSizeUpdate(n2)];
        int n3 = this.update(null, byArray, n, n2, null, byArray2, 0);
        return byArray2.length == n3 ? byArray2 : Arrays.copyOf(byArray2, n3);
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        Utils.checkArrayLimits(byArray, n, n2);
        Utils.checkArrayLimits(byArray2, n3, byArray2.length - n3);
        this.updateChecks(n2, byArray2.length - n3);
        return this.update(null, byArray, n, n2, null, byArray2, n3);
    }

    @Override
    protected int engineUpdate(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        this.updateChecks(byteBuffer.remaining(), byteBuffer2.remaining());
        ShimByteBuffer shimByteBuffer = new ShimByteBuffer(byteBuffer, true);
        ShimByteBuffer shimByteBuffer2 = new ShimByteBuffer(byteBuffer2, false);
        int n = this.update(shimByteBuffer.directByteBuffer, shimByteBuffer.array, shimByteBuffer.offset, byteBuffer.remaining(), shimByteBuffer2.directByteBuffer, shimByteBuffer2.array, shimByteBuffer2.offset);
        shimByteBuffer2.writeBack(n);
        byteBuffer.position(byteBuffer.limit());
        byteBuffer2.position(byteBuffer2.position() + n);
        return n;
    }

    private void finalOrUpdateStateCheck() {
        if (this.cipherState == CipherState.NEEDS_INITIALIZATION) {
            throw new IllegalStateException("Cipher needs initialization.");
        }
    }

    private void updateChecks(int n, int n2) throws ShortBufferException {
        this.finalOrUpdateStateCheck();
        if (n2 < this.getOutputSizeUpdate(n)) {
            throw new ShortBufferException();
        }
    }

    private int getOutputSizeUpdate(int n) {
        long l = (long)n + (long)this.unprocessedInput;
        if (l == 0L) {
            return 0;
        }
        long l2 = l % 16L;
        if (this.noPadding() || this.opMode == 1 || l2 != 0L) {
            return (int)(l - l2);
        }
        return (int)l;
    }

    private int update(ByteBuffer byteBuffer, byte[] byArray, int n, int n2, ByteBuffer byteBuffer2, byte[] byArray2, int n3) {
        if (n2 > 0) {
            this.inputIsEmpty = false;
        }
        long[] lArray = new long[]{0L};
        try {
            int n4;
            int n5 = this.paddingScheme.getValue();
            if (this.cipherState == CipherState.INITIALIZED) {
                if (this.nativeCtx != null) {
                    n4 = this.nativeCtx.use(l -> AesCbcSpi.nInitUpdate(this.opMode, n5, this.key, this.key.length, this.iv, null, l, this.lastBlock, byteBuffer, byArray, n, n2, byteBuffer2, byArray2, n3));
                } else {
                    n4 = AesCbcSpi.nInitUpdate(this.opMode, n5, this.key, this.key.length, this.iv, lArray, 0L, this.lastBlock, byteBuffer, byArray, n, n2, byteBuffer2, byArray2, n3);
                    this.nativeCtx = new NativeEvpCipherCtx(lArray[0]);
                }
                this.cipherState = CipherState.UPDATED;
            } else {
                n4 = this.nativeCtx.use(l -> AesCbcSpi.nUpdate(this.opMode, n5, l, this.lastBlock, byteBuffer, byArray, n, n2, this.unprocessedInput, byteBuffer2, byArray2, n3));
            }
            long l2 = n2 + this.unprocessedInput;
            this.unprocessedInput = (int)(l2 - (long)n4);
            return n4;
        }
        catch (Exception exception) {
            this.cipherState = CipherState.NEEDS_INITIALIZATION;
            this.cleanUpNativeContextIfNeeded(lArray[0]);
            throw exception;
        }
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = AesCbcSpi.emptyIfNull(byArray);
        Utils.checkArrayLimits(byArray2, n, n2);
        this.finalOrUpdateStateCheck();
        byte[] byArray3 = new byte[this.getOutputSizeFinal(n2)];
        int n3 = this.doFinal(null, byArray2, n, n2, null, byArray3, 0);
        return n3 == byArray3.length ? byArray3 : Arrays.copyOf(byArray3, n3);
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3 = AesCbcSpi.emptyIfNull(byArray);
        Utils.checkArrayLimits(byArray3, n, n2);
        Utils.checkArrayLimits(byArray2, n3, byArray2.length - n3);
        this.finalChecks(n2, byArray2.length - n3);
        return this.doFinal(null, byArray3, n, n2, null, byArray2, n3);
    }

    @Override
    protected int engineDoFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.finalChecks(byteBuffer.remaining(), byteBuffer2.remaining());
        ShimByteBuffer shimByteBuffer = new ShimByteBuffer(byteBuffer, true);
        ShimByteBuffer shimByteBuffer2 = new ShimByteBuffer(byteBuffer2, false);
        int n = this.doFinal(shimByteBuffer.directByteBuffer, shimByteBuffer.array, shimByteBuffer.offset, byteBuffer.remaining(), shimByteBuffer2.directByteBuffer, shimByteBuffer2.array, shimByteBuffer2.offset);
        shimByteBuffer2.writeBack(n);
        byteBuffer.position(byteBuffer.limit());
        byteBuffer2.position(byteBuffer2.position() + n);
        return n;
    }

    private void finalChecks(int n, int n2) throws IllegalBlockSizeException, ShortBufferException {
        this.finalOrUpdateStateCheck();
        if (n2 < this.getOutputSizeFinal(n)) {
            throw new ShortBufferException(n2 + "<" + this.getOutputSizeFinal(n));
        }
    }

    private int getOutputSizeFinal(int n) throws IllegalBlockSizeException {
        long l = (long)n + (long)this.unprocessedInput;
        long l2 = l % 16L;
        if ((this.opMode == 0 || this.noPadding()) && l2 != 0L) {
            throw new IllegalBlockSizeException("Input length not multiple of 16 bytes");
        }
        if (this.noPadding()) {
            return (int)l;
        }
        if (this.opMode == 1) {
            return (int)(l + 16L - l2);
        }
        return (int)l;
    }

    private int doFinal(ByteBuffer byteBuffer, byte[] byArray, int n, int n2, ByteBuffer byteBuffer2, byte[] byArray2, int n3) {
        if (n2 > 0) {
            this.inputIsEmpty = false;
        }
        if (this.inputIsEmpty && this.opMode == 0 && !this.noPadding()) {
            return 0;
        }
        long[] lArray = new long[]{0L};
        try {
            int n4;
            int n5 = this.paddingScheme.getValue();
            if (this.saveContext) {
                if (this.cipherState == CipherState.INITIALIZED) {
                    if (this.nativeCtx != null) {
                        n4 = this.nativeCtx.use(l -> AesCbcSpi.nInitUpdateFinal(this.opMode, n5, this.key, this.key.length, this.iv, null, l, true, this.lastBlock, byteBuffer, byArray, n, n2, byteBuffer2, byArray2, n3));
                    } else {
                        n4 = AesCbcSpi.nInitUpdateFinal(this.opMode, n5, this.key, this.key.length, this.iv, lArray, 0L, true, this.lastBlock, byteBuffer, byArray, n, n2, byteBuffer2, byArray2, n3);
                        this.nativeCtx = new NativeEvpCipherCtx(lArray[0]);
                    }
                } else {
                    n4 = this.nativeCtx.use(l -> AesCbcSpi.nUpdateFinal(this.opMode, n5, l, true, this.lastBlock, byteBuffer, byArray, n, n2, this.unprocessedInput, byteBuffer2, byArray2, n3));
                }
            } else {
                long l2 = this.nativeCtx == null ? 0L : this.nativeCtx.take();
                this.nativeCtx = null;
                n4 = this.cipherState == CipherState.INITIALIZED ? AesCbcSpi.nInitUpdateFinal(this.opMode, n5, this.key, this.key.length, this.iv, null, l2, false, this.lastBlock, byteBuffer, byArray, n, n2, byteBuffer2, byArray2, n3) : AesCbcSpi.nUpdateFinal(this.opMode, n5, l2, false, this.lastBlock, byteBuffer, byArray, n, n2, this.unprocessedInput, byteBuffer2, byArray2, n3);
            }
            this.cipherState = CipherState.INITIALIZED;
            this.unprocessedInput = 0;
            this.inputIsEmpty = true;
            if (this.lastBlock != null) {
                Arrays.fill(this.lastBlock, (byte)0);
            }
            return n4;
        }
        catch (Exception exception) {
            this.cipherState = CipherState.NEEDS_INITIALIZATION;
            this.cleanUpNativeContextIfNeeded(lArray[0]);
            throw exception;
        }
    }

    private void cleanUpNativeContextIfNeeded(long l) {
        if (this.nativeCtx == null && l != 0L) {
            Utils.releaseEvpCipherCtx(l);
        }
    }

    private static native int nInitUpdateFinal(int var0, int var1, byte[] var2, int var3, byte[] var4, long[] var5, long var6, boolean var8, byte[] var9, ByteBuffer var10, byte[] var11, int var12, int var13, ByteBuffer var14, byte[] var15, int var16);

    private static native int nInitUpdate(int var0, int var1, byte[] var2, int var3, byte[] var4, long[] var5, long var6, byte[] var8, ByteBuffer var9, byte[] var10, int var11, int var12, ByteBuffer var13, byte[] var14, int var15);

    private static native int nUpdate(int var0, int var1, long var2, byte[] var4, ByteBuffer var5, byte[] var6, int var7, int var8, int var9, ByteBuffer var10, byte[] var11, int var12);

    private static native int nUpdateFinal(int var0, int var1, long var2, boolean var4, byte[] var5, ByteBuffer var6, byte[] var7, int var8, int var9, int var10, ByteBuffer var11, byte[] var12, int var13);

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        try {
            byte[] byArray = Utils.encodeForWrapping(key);
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("Wrapping failed", badPaddingException);
        }
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            byte[] byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
            return Utils.buildUnwrappedKey(byArray2, string, n);
        }
        catch (InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new InvalidKeyException("Unwrapping failed", generalSecurityException);
        }
    }

    private static byte[] emptyIfNull(byte[] byArray) {
        return byArray == null ? EMPTY_ARRAY : byArray;
    }

    static {
        Loader.load();
        AES_CBC_NO_PADDING_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("AES/CBC/NoPadding".toLowerCase(), "AES_128/CBC/NoPadding".toLowerCase(), "AES_192/CBC/NoPadding".toLowerCase(), "AES_256/CBC/NoPadding".toLowerCase())));
        AES_CBC_PKCS7_PADDING_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("AES/CBC/PKCS7Padding".toLowerCase(), "AES_128/CBC/PKCS7Padding".toLowerCase(), "AES_192/CBC/PKCS7Padding".toLowerCase(), "AES_256/CBC/PKCS7Padding".toLowerCase(), "AES/CBC/PKCS5Padding".toLowerCase(), "AES_128/CBC/PKCS5Padding".toLowerCase(), "AES_192/CBC/PKCS5Padding".toLowerCase(), "AES_256/CBC/PKCS5Padding".toLowerCase())));
        AES_CBC_ISO10126_PADDING_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("AES/CBC/ISO10126Padding".toLowerCase(), "AES_128/CBC/ISO10126Padding".toLowerCase(), "AES_192/CBC/ISO10126Padding".toLowerCase(), "AES_256/CBC/ISO10126Padding".toLowerCase())));
        EMPTY_ARRAY = new byte[0];
    }

    private static enum CipherState {
        NEEDS_INITIALIZATION,
        INITIALIZED,
        UPDATED;

    }

    static enum Padding {
        NONE(0),
        PKCS7(1),
        ISO10126(2);

        private final int value;

        private Padding(int n2) {
            this.value = n2;
        }

        int getValue() {
            return this.value;
        }
    }
}

