/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.Utils;
import java.security.spec.KeySpec;
import java.util.Objects;

public class ConcatenationKdfSpec
implements KeySpec {
    private final byte[] secret;
    private final int outputLen;
    private final String algorithmName;
    private final byte[] info;
    private final byte[] salt;

    public ConcatenationKdfSpec(byte[] byArray, int n, String string, byte[] byArray2, byte[] byArray3) {
        this.secret = Objects.requireNonNull(byArray);
        if (this.secret.length == 0) {
            throw new IllegalArgumentException("Secret must be byte array with non-zero length.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Output size must be greater than zero.");
        }
        this.outputLen = n;
        this.algorithmName = Objects.requireNonNull(string);
        this.info = Objects.requireNonNull(byArray2);
        this.salt = Objects.requireNonNull(byArray3);
    }

    public ConcatenationKdfSpec(byte[] byArray, int n, String string) {
        this(byArray, n, string, Utils.EMPTY_ARRAY, Utils.EMPTY_ARRAY);
    }

    public ConcatenationKdfSpec(byte[] byArray, int n, String string, byte[] byArray2) {
        this(byArray, n, string, byArray2, Utils.EMPTY_ARRAY);
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public byte[] getInfo() {
        return this.info;
    }

    public int getOutputLen() {
        return this.outputLen;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }
}

