/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.EvpKey;
import com.amazon.corretto.crypto.provider.EvpRsaKey;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;

class EvpRsaPrivateKey
extends EvpRsaKey
implements RSAPrivateKey {
    private static final long serialVersionUID = 1L;
    protected volatile BigInteger privateExponent;

    private static native byte[] encodeRsaPrivateKey(long var0);

    protected static native byte[] getPrivateExponent(long var0);

    EvpRsaPrivateKey(long l) {
        this(new EvpKey.InternalKey(l));
    }

    EvpRsaPrivateKey(EvpKey.InternalKey internalKey) {
        super(internalKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigInteger getPrivateExponent() {
        BigInteger bigInteger = this.privateExponent;
        if (bigInteger == null) {
            EvpRsaPrivateKey evpRsaPrivateKey = this;
            synchronized (evpRsaPrivateKey) {
                bigInteger = this.privateExponent;
                if (bigInteger == null) {
                    this.privateExponent = bigInteger = this.nativeBN(EvpRsaPrivateKey::getPrivateExponent);
                }
            }
        }
        return bigInteger;
    }

    @Override
    protected synchronized void destroyJavaState() {
        super.destroyJavaState();
        this.privateExponent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] internalGetEncoded() {
        this.assertNotDestroyed();
        byte[] byArray = this.encoded;
        if (byArray == null) {
            EvpRsaPrivateKey evpRsaPrivateKey = this;
            synchronized (evpRsaPrivateKey) {
                byArray = this.encoded;
                if (byArray == null) {
                    this.encoded = byArray = this.use(EvpRsaPrivateKey::encodeRsaPrivateKey);
                }
            }
        }
        return byArray;
    }
}

