/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.utils;

import java.security.PrivateKey;
import java.security.PublicKey;

public final class MlDsaUtils {
    private MlDsaUtils() {
    }

    private static native byte[] computeMuInternal(byte[] var0, byte[] var1);

    private static native byte[] expandPrivateKeyInternal(byte[] var0);

    public static byte[] computeMu(PublicKey publicKey, byte[] byArray) {
        if (publicKey == null || !publicKey.getAlgorithm().startsWith("ML-DSA") || byArray == null) {
            throw new IllegalArgumentException();
        }
        return MlDsaUtils.computeMuInternal(publicKey.getEncoded(), byArray);
    }

    public static byte[] expandPrivateKey(PrivateKey privateKey) {
        if (privateKey == null || !privateKey.getAlgorithm().startsWith("ML-DSA")) {
            throw new IllegalArgumentException();
        }
        return MlDsaUtils.expandPrivateKeyInternal(privateKey.getEncoded());
    }
}

