/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.image.publisher.TenantMetricsPublisher;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinator$;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntityAndConsumptions;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaSnapshot;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.ReportQuotaResult;
import kafka.server.BrokerReconfigurable;
import kafka.server.FlexFanoutQuotaManager;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ClusterLevelQuotaCallback;
import org.apache.kafka.server.quota.ElasticCkuDefinitionUtils;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.util.Scheduler;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r\u0015s!B\u001d;\u0011\u0003\te!B\";\u0011\u0003!\u0005\"B&\u0002\t\u0003a\u0005bB'\u0002\u0005\u0004%\tA\u0014\u0005\u0007A\u0006\u0001\u000b\u0011B(\t\u000b\u0005\fA\u0011\u00012\t\u000f\r}\u0012\u0001\"\u0003\u0004B\u0019!1I\u000f\u0001e\u0011!\txA!b\u0001\n\u0003\u0011\b\u0002\u0003<\b\u0005\u0003\u0005\u000b\u0011B:\t\u0011]<!Q1A\u0005\u0002aD\u0001\u0002`\u0004\u0003\u0002\u0003\u0006I!\u001f\u0005\t{\u001e\u0011)\u0019!C\u0001}\"I\u0011QA\u0004\u0003\u0002\u0003\u0006Ia \u0005\u000b\u0003\u000f9!Q1A\u0005\u0002\u0005%\u0001BCA\u0012\u000f\t\u0005\t\u0015!\u0003\u0002\f!Q\u0011QE\u0004\u0003\u0006\u0004%\t!a\n\t\u0015\u0005\u0005sA!A!\u0002\u0013\tI\u0003\u0003\u0006\u0002D\u001d\u0011)\u0019!C\u0001\u0003\u000bB!\"!\u0015\b\u0005\u0003\u0005\u000b\u0011BA$\u0011)\t\u0019f\u0002BC\u0002\u0013\u0005\u0011Q\u000b\u0005\u000b\u0003;:!\u0011!Q\u0001\n\u0005]\u0003BCA0\u000f\t\u0015\r\u0011\"\u0001\u0002b!Q\u0011\u0011O\u0004\u0003\u0002\u0003\u0006I!a\u0019\t\r-;A\u0011AA:\u0011%\t)i\u0002b\u0001\n\u0003\t9\t\u0003\u0005\u0002\u001a\u001e\u0001\u000b\u0011BAE\u0011%\tYj\u0002a\u0001\n\u0013\ti\nC\u0005\u0002&\u001e\u0001\r\u0011\"\u0003\u0002(\"A\u00111W\u0004!B\u0013\ty\nC\u0005\u0002>\u001e\u0001\r\u0011\"\u0003\u0002\u001e\"I\u0011qX\u0004A\u0002\u0013%\u0011\u0011\u0019\u0005\t\u0003\u000b<\u0001\u0015)\u0003\u0002 \"I\u0011\u0011Z\u0004A\u0002\u0013%\u0011Q\u0014\u0005\n\u0003\u0017<\u0001\u0019!C\u0005\u0003\u001bD\u0001\"!5\bA\u0003&\u0011q\u0014\u0005\n\u0003+<\u0001\u0019!C\u0005\u0003;C\u0011\"a6\b\u0001\u0004%I!!7\t\u0011\u0005uw\u0001)Q\u0005\u0003?Cq!!9\b\t\u0003\t\u0019\u000fC\u0004\u0002p\u001e!I!!=\t\u000f\t=q\u0001\"\u0003\u0003\u0012!9!1D\u0004\u0005\n\tu\u0001b\u0002B\u0012\u000f\u0011\u0005!Q\u0005\u0005\b\u0005+:A\u0011\u0001B,\u0011\u001d\u0011\u0019g\u0002C\u0001\u0005KBqA!!\b\t\u0003\u0011\u0019\tC\u0004\u0003\f\u001e!\tA!$\t\u000f\tEu\u0001\"\u0001\u0003\u0014\"9!QT\u0004\u0005\u0002\t}\u0005b\u0002BU\u000f\u0011\u0005!1\u0016\u0005\b\u0005g;A\u0011\u0001B[\u0011\u001d\u0011\tm\u0002C\u0001\u0005\u0007DaA!2\b\t\u0003r\u0005b\u0002Bd\u000f\u0011\u0005#\u0011\u001a\u0005\b\u0005+<A\u0011\u0001Bl\u0011\u001d\u0011yn\u0002C\u0005\u0005C\f\u0001#U;pi\u0006\u001cun\u001c:eS:\fGo\u001c:\u000b\u0005mb\u0014!B9v_R\f'BA\u001f?\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003}\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002C\u00035\t!H\u0001\tRk>$\u0018mQ8pe\u0012Lg.\u0019;peN\u0011\u0011!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0002\u0011\u0006)1oY1mC&\u0011!j\u0012\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\t\u0015!\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0002\u001fB\u0019\u0001kU+\u000e\u0003ES!AU$\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002U#\n\u00191+\u001a;\u0011\u0005YkfBA,\\!\tAv)D\u0001Z\u0015\tQ\u0006)\u0001\u0004=e>|GOP\u0005\u00039\u001e\u000ba\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011AlR\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tA\u0005)\u0011\r\u001d9msR)2Ma:\u0003l\n58QBB\u0010\u0007S\u0019Yc!\f\u00040\ru\u0002C\u0001\"\b'\u00119Q)Z6\u0011\u0005\u0019LW\"A4\u000b\u0005!t\u0014!B;uS2\u001c\u0018B\u00016h\u0005\u001daunZ4j]\u001e\u0004\"\u0001\\8\u000e\u00035T!A\u001c \u0002\rM,'O^3s\u0013\t\u0001XN\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z\u0001\tEJ|7.\u001a:JIV\t1\u000f\u0005\u0002Gi&\u0011Qo\u0012\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003-\tXo\u001c;b\u0007>tg-[4\u0016\u0003e\u0004\"A\u0011>\n\u0005mT$AF)v_R\f7i\\8sI&t\u0017\r^8s\u0007>tg-[4\u0002\u0019E,x\u000e^1D_:4\u0017n\u001a\u0011\u0002#E,x\u000e^1Ti\u0006$X-T1oC\u001e,'/F\u0001\u0000!\r\u0011\u0015\u0011A\u0005\u0004\u0003\u0007Q$!E)v_R\f7\u000b^1uK6\u000bg.Y4fe\u0006\u0011\u0012/^8uCN#\u0018\r^3NC:\fw-\u001a:!\u0003%\u00198\r[3ek2,'/\u0006\u0002\u0002\fA!\u0011QBA\u0010\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011\u0001B;uS2T1A\\A\u000b\u0015\ry\u0014q\u0003\u0006\u0005\u00033\tY\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003;\t1a\u001c:h\u0013\u0011\t\t#a\u0004\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005)\u0012N\u001c;fe:\fG.\u00113nS:\u001cV\u000f\u001d9mS\u0016\u0014XCAA\u0015!\u0019\tY#a\u000e\u0002<5\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0005gk:\u001cG/[8o\u0015\u0011\t\t\"a\r\u000b\u0005\u0005U\u0012\u0001\u00026bm\u0006LA!!\u000f\u0002.\tA1+\u001e9qY&,'\u000fE\u0002m\u0003{I1!a\u0010n\u00055Ie\u000e^3s]\u0006d\u0017\tZ7j]\u00061\u0012N\u001c;fe:\fG.\u00113nS:\u001cV\u000f\u001d9mS\u0016\u0014\b%A\rdYV\u001cH/\u001a:MKZ,G.U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\WCAA$!\u0011\tI%!\u0014\u000e\u0005\u0005-#bA\u001e\u0002\u0014%!\u0011qJA&\u0005e\u0019E.^:uKJdUM^3m#V|G/Y\"bY2\u0014\u0017mY6\u00025\rdWo\u001d;fe2+g/\u001a7Rk>$\u0018mQ1mY\n\f7m\u001b\u0011\u0002#\u0019dW\r\u001f$b]>,H/T1oC\u001e,'/\u0006\u0002\u0002XA\u0019A.!\u0017\n\u0007\u0005mSN\u0001\fGY\u0016Dh)\u00198pkR\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003I1G.\u001a=GC:|W\u000f^'b]\u0006<WM\u001d\u0011\u0002\tQLW.Z\u000b\u0003\u0003G\u0002B!!\u001a\u0002n5\u0011\u0011q\r\u0006\u0004Q\u0006%$\u0002BA6\u0003+\taaY8n[>t\u0017\u0002BA8\u0003O\u0012A\u0001V5nK\u0006)A/[7fAQ\t2-!\u001e\u0002x\u0005e\u00141PA?\u0003\u007f\n\t)a!\t\u000bED\u0002\u0019A:\t\u000b]D\u0002\u0019A=\t\u000buD\u0002\u0019A@\t\u000f\u0005\u001d\u0001\u00041\u0001\u0002\f!9\u0011Q\u0005\rA\u0002\u0005%\u0002bBA\"1\u0001\u0007\u0011q\t\u0005\b\u0003'B\u0002\u0019AA,\u0011\u001d\ty\u0006\u0007a\u0001\u0003G\n\u0001\"[:BGRLg/Z\u000b\u0003\u0003\u0013\u0003B!a#\u0002\u00166\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t*\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003'\u000b\t$\u0001\u0006d_:\u001cWO\u001d:f]RLA!a&\u0002\u000e\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\f\u0011\"[:BGRLg/\u001a\u0011\u0002=\t\u0014xn[3s)\u0016t\u0017M\u001c;MS6LG\u000f\u0015:pIV\u001cWM])v_R\fWCAAP!\r1\u0015\u0011U\u0005\u0004\u0003G;%\u0001\u0002'p]\u001e\f!E\u0019:pW\u0016\u0014H+\u001a8b]Rd\u0015.\\5u!J|G-^2feF+x\u000e^1`I\u0015\fH\u0003BAU\u0003_\u00032ARAV\u0013\r\tik\u0012\u0002\u0005+:LG\u000fC\u0005\u00022r\t\t\u00111\u0001\u0002 \u0006\u0019\u0001\u0010J\u0019\u0002?\t\u0014xn[3s)\u0016t\u0017M\u001c;MS6LG\u000f\u0015:pIV\u001cWM])v_R\f\u0007\u0005K\u0002\u001e\u0003o\u00032ARA]\u0013\r\tYl\u0012\u0002\tm>d\u0017\r^5mK\u0006q\"M]8lKJ$VM\\1oi2KW.\u001b;D_:\u001cX/\\3s#V|G/Y\u0001#EJ|7.\u001a:UK:\fg\u000e\u001e'j[&$8i\u001c8tk6,'/U;pi\u0006|F%Z9\u0015\t\u0005%\u00161\u0019\u0005\n\u0003c{\u0012\u0011!a\u0001\u0003?\u000bqD\u0019:pW\u0016\u0014H+\u001a8b]Rd\u0015.\\5u\u0007>t7/^7feF+x\u000e^1!Q\r\u0001\u0013qW\u0001'EJ|7.\u001a:J]R,'O\\1m)\u0016t\u0017M\u001c;MS6LG\u000f\u0015:pIV\u001cWM])v_R\f\u0017A\u000b2s_.,'/\u00138uKJt\u0017\r\u001c+f]\u0006tG\u000fT5nSR\u0004&o\u001c3vG\u0016\u0014\u0018+^8uC~#S-\u001d\u000b\u0005\u0003S\u000by\rC\u0005\u00022\n\n\t\u00111\u0001\u0002 \u00069#M]8lKJLe\u000e^3s]\u0006dG+\u001a8b]Rd\u0015.\\5u!J|G-^2feF+x\u000e^1!Q\r\u0019\u0013qW\u0001'EJ|7.\u001a:J]R,'O\\1m)\u0016t\u0017M\u001c;MS6LGoQ8ogVlWM])v_R\f\u0017A\u000b2s_.,'/\u00138uKJt\u0017\r\u001c+f]\u0006tG\u000fT5nSR\u001cuN\\:v[\u0016\u0014\u0018+^8uC~#S-\u001d\u000b\u0005\u0003S\u000bY\u000eC\u0005\u00022\u0016\n\t\u00111\u0001\u0002 \u00069#M]8lKJLe\u000e^3s]\u0006dG+\u001a8b]Rd\u0015.\\5u\u0007>t7/^7feF+x\u000e^1!Q\r1\u0013qW\u0001\ng\u0016$\u0018i\u0019;jm\u0016$B!!+\u0002f\"9\u0011q]\u0014A\u0002\u0005%\u0018AB1di&4X\rE\u0002G\u0003WL1!!<H\u0005\u001d\u0011un\u001c7fC:\f1cZ3u\u0005J|7.\u001a:Rk>$\u0018\rT5nSR$b!a=\u0002z\n\r\u0001c\u0001$\u0002v&\u0019\u0011q_$\u0003\r\u0011{WO\u00197f\u0011\u001d\tY\u0010\u000ba\u0001\u0003{\f\u0011\"];pi\u0006$\u0016\u0010]3\u0011\t\u0005%\u0013q`\u0005\u0005\u0005\u0003\tYEA\bDY&,g\u000e^)v_R\fG+\u001f9f\u0011\u001d\u0011)\u0001\u000ba\u0001\u0005\u000f\t!\"\u001a8uSRLH+\u001f9f!\u0019\u0011IAa\u0003V+6\u0011\u0011\u0011G\u0005\u0005\u0005\u001b\t\tDA\u0002NCB\fA$\u001e9eCR,'I]8lKJ$VM\\1oiF+x\u000e^1MS6LG\u000f\u0006\u0004\u0002*\nM!q\u0003\u0005\b\u0005+I\u0003\u0019AAP\u00035\u0001(o\u001c3vG\u0016\u0014\u0018+^8uC\"9!\u0011D\u0015A\u0002\u0005}\u0015!D2p]N,X.\u001a:Rk>$\u0018-\u0001\u0013va\u0012\fG/\u001a\"s_.,'/\u00138uKJt\u0017\r\u001c+f]\u0006tG/U;pi\u0006d\u0015.\\5u)\u0019\tIKa\b\u0003\"!9!Q\u0003\u0016A\u0002\u0005}\u0005b\u0002B\rU\u0001\u0007\u0011qT\u0001\u000eG>l\u0007/\u001e;f#V|G/Y:\u0015\u0011\u0005%&q\u0005B\u0015\u0005\u000bBQ!]\u0016A\u0002MDqAa\u000b,\u0001\u0004\u0011i#\u0001\u0007rk>$\u0018-\u00128ue&,7\u000f\u0005\u0004\u00030\te\"q\b\b\u0005\u0005c\u0011)DD\u0002Y\u0005gI\u0011\u0001S\u0005\u0004\u0005o9\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005w\u0011iD\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u00119d\u0012\t\u0004\u0005\n\u0005\u0013b\u0001B\"u\tQ\u0012+^8uC\u0016sG/\u001b;z\u0003:$7i\u001c8tk6\u0004H/[8og\"9!qI\u0016A\u0002\t%\u0013\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u001d1%1\nB(\u0003SK1A!\u0014H\u0005%1UO\\2uS>t\u0017\u0007E\u0002C\u0005#J1Aa\u0015;\u0005E\u0011V\r]8siF+x\u000e^1SKN,H\u000e^\u0001#SN$\u0015P\\1nS\u000e\fVo\u001c;b\u0007>l\u0007/\u001e;fI\nKh\t\\3y\r\u0006tw.\u001e;\u0015\t\u0005%(\u0011\f\u0005\b\u00057b\u0003\u0019\u0001B/\u0003-\tXo\u001c;b\u000b:$\u0018\u000e^=\u0011\u0007\t\u0013y&C\u0002\u0003bi\u00121\"U;pi\u0006,e\u000e^5us\u0006iA-Z:de&\u0014W-U;pi\u0006$BAa\u001a\u0003\u0000A9aI!\u001b\u0003n\te\u0014b\u0001B6\u000f\n1A+\u001e9mKJ\u0002BAa\u001c\u0003v5\u0011!\u0011\u000f\u0006\u0005\u0005g\nI'\u0001\u0005qe>$xnY8m\u0013\u0011\u00119H!\u001d\u0003\r\u0015\u0013(o\u001c:t!\r\u0011%1P\u0005\u0004\u0005{R$\u0001E)v_R\fG)Z:de&\u0004H/[8o\u0011\u001d\u0011Y&\fa\u0001\u0005;\n!#];pi\u0006\u001cHk\u001c9jG\u000e{gNZ5hgV\u0011!Q\u0011\t\u0005\u0005\u0013\u00119)\u0003\u0003\u0003\n\u0006E\"A\u0003)s_B,'\u000f^5fg\u0006a\u0001/\u0019:uSRLwN\u001c$peR\u00191Oa$\t\u000f\tms\u00061\u0001\u0003^\u0005\u0019b/\u00197jI\u0006$X-U;pi\u0006,e\u000e^5usR!!Q\u0013BN!\u00151%q\u0013B7\u0013\r\u0011Ij\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\tm\u0003\u00071\u0001\u0003^\u0005QqN\\#mK\u000e$\u0018n\u001c8\u0015\r\u0005%&\u0011\u0015BS\u0011\u0019\u0011\u0019+\ra\u0001g\u0006)\u0012/^8uCR{\u0007/[2QCJ$\u0018\u000e^5p]&#\u0007B\u0002BTc\u0001\u00071/\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006iqN\u001c*fg&<g.\u0019;j_:$b!!+\u0003.\n=\u0006B\u0002BRe\u0001\u00071\u000fC\u0004\u0003(J\u0002\rA!-\u0011\t\u0019\u00139j]\u0001\bgR\f'\u000f^;q)\u0011\tIKa.\t\u000f\te6\u00071\u0001\u0003<\u0006\u0001#/\u001a;sS\u00164X-U;pi\u0006$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u!\u00111%QX:\n\u0007\t}vIA\u0005Gk:\u001cG/[8oa\u0005A1\u000f[;uI><h\u000e\u0006\u0002\u0002*\u0006)\"/Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\u0018a\u0006<bY&$\u0017\r^3SK\u000e|gNZ5hkJ\fG/[8o)\u0011\tIKa3\t\u000f\t5g\u00071\u0001\u0003P\u0006Ia.Z<D_:4\u0017n\u001a\t\u0004Y\nE\u0017b\u0001Bj[\nY1*\u00194lC\u000e{gNZ5h\u0003-\u0011XmY8oM&<WO]3\u0015\r\u0005%&\u0011\u001cBo\u0011\u001d\u0011Yn\u000ea\u0001\u0005\u001f\f\u0011b\u001c7e\u0007>tg-[4\t\u000f\t5w\u00071\u0001\u0003P\u00061\u0012n]\"mS\u0016tG/U;pi\u0006$\u0016\u0010]3WC2LG\r\u0006\u0003\u0002j\n\r\bB\u0002Bsq\u0001\u0007Q+A\u0001t\u0011\u001d\u0011I/\u0002a\u0001\u0005\u001f\faaY8oM&<\u0007bBA\u0004\u000b\u0001\u0007\u00111\u0002\u0005\b\u0005_,\u0001\u0019\u0001By\u0003Y!XM\\1oi6+GO]5dgB+(\r\\5tQ\u0016\u0014\b#\u0002$\u0003\u0018\nM\b\u0003\u0002B{\u0007\u0013i!Aa>\u000b\t\te(1`\u0001\naV\u0014G.[:iKJTAA!@\u0003\u0000\u0006)\u0011.\\1hK*\u0019qh!\u0001\u000b\t\r\r1QA\u0001\nG>tg\r\\;f]RT!aa\u0002\u0002\u0005%|\u0017\u0002BB\u0006\u0005o\u0014a\u0003V3oC:$X*\u001a;sS\u000e\u001c\b+\u001e2mSNDWM\u001d\u0005\b\u0007\u001f)\u0001\u0019AB\t\u0003MiW\u000f\u001c;j)\u0016t\u0017M\u001c;NKR\fG-\u0019;b!\u00151%qSB\n!\u0011\u0019)ba\u0007\u000e\u0005\r]!\u0002BB\r\u0003'\t1\"\\;mi&$XM\\1oi&!1QDB\f\u0005MiU\u000f\u001c;j)\u0016t\u0017M\u001c;NKR\fG-\u0019;b\u0011\u001d\u0019\t#\u0002a\u0001\u0007G\taB]3qY&\u001c\u0017-T1oC\u001e,'\u000fE\u0002m\u0007KI1aa\nn\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDq!!\n\u0006\u0001\u0004\tI\u0003C\u0004\u0002D\u0015\u0001\r!a\u0012\t\u000f\u0005MS\u00011\u0001\u0002X!91\u0011G\u0003A\u0002\rM\u0012aB7fiJL7m\u001d\t\u0005\u0007k\u0019I$\u0004\u0002\u00048)!1\u0011GA5\u0013\u0011\u0019Yda\u000e\u0003\u000f5+GO]5dg\"9\u0011qL\u0003A\u0002\u0005\r\u0014AF9v_R\f7i\\8sI&t\u0017\r^8s\u0007>tg-[4\u0015\u0007e\u001c\u0019\u0005C\u0004\u0003j\u001a\u0001\rAa4")
public class QuotaCoordinator
implements Logging,
BrokerReconfigurable {
    private final int brokerId;
    private final QuotaCoordinatorConfig quotaConfig;
    private final QuotaStateManager quotaStateManager;
    private final Scheduler scheduler;
    private final Supplier<InternalAdmin> internalAdminSupplier;
    private final ClusterLevelQuotaCallback clusterLevelQuotaCallback;
    private final FlexFanoutQuotaManager flexFanoutManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private volatile long brokerTenantLimitProducerQuota;
    private volatile long brokerTenantLimitConsumerQuota;
    private volatile long brokerInternalTenantLimitProducerQuota;
    private volatile long brokerInternalTenantLimitConsumerQuota;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static QuotaCoordinator apply(KafkaConfig config, Scheduler scheduler, Option<TenantMetricsPublisher> tenantMetricsPublisher, Option<MultiTenantMetadata> multiTenantMetadata, ReplicaManager replicaManager, Supplier<InternalAdmin> internalAdminSupplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, FlexFanoutQuotaManager flexFanoutManager, Metrics metrics, Time time) {
        return QuotaCoordinator$.MODULE$.apply(config, scheduler, tenantMetricsPublisher, multiTenantMetadata, replicaManager, internalAdminSupplier, clusterLevelQuotaCallback, flexFanoutManager, metrics, time);
    }

    public static Set<String> ReconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        QuotaCoordinator quotaCoordinator = this;
        synchronized (quotaCoordinator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public QuotaCoordinatorConfig quotaConfig() {
        return this.quotaConfig;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    public ClusterLevelQuotaCallback clusterLevelQuotaCallback() {
        return this.clusterLevelQuotaCallback;
    }

    public FlexFanoutQuotaManager flexFanoutManager() {
        return this.flexFanoutManager;
    }

    public Time time() {
        return this.time;
    }

    public AtomicBoolean isActive() {
        return this.isActive;
    }

    private long brokerTenantLimitProducerQuota() {
        return this.brokerTenantLimitProducerQuota;
    }

    private void brokerTenantLimitProducerQuota_$eq(long x$1) {
        this.brokerTenantLimitProducerQuota = x$1;
    }

    private long brokerTenantLimitConsumerQuota() {
        return this.brokerTenantLimitConsumerQuota;
    }

    private void brokerTenantLimitConsumerQuota_$eq(long x$1) {
        this.brokerTenantLimitConsumerQuota = x$1;
    }

    private long brokerInternalTenantLimitProducerQuota() {
        return this.brokerInternalTenantLimitProducerQuota;
    }

    private void brokerInternalTenantLimitProducerQuota_$eq(long x$1) {
        this.brokerInternalTenantLimitProducerQuota = x$1;
    }

    private long brokerInternalTenantLimitConsumerQuota() {
        return this.brokerInternalTenantLimitConsumerQuota;
    }

    private void brokerInternalTenantLimitConsumerQuota_$eq(long x$1) {
        this.brokerInternalTenantLimitConsumerQuota = x$1;
    }

    public void setActive(boolean active) {
        this.isActive().set(active);
    }

    private double getBrokerQuotaLimit(ClientQuotaType quotaType, java.util.Map<String, String> entityType) {
        String tenant;
        String string = tenant = entityType.get("tenant");
        String string2 = "lkc-internal-tenant";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            ClientQuotaType clientQuotaType = quotaType;
            if (((Object)((Object)ClientQuotaType.FETCH)).equals((Object)clientQuotaType)) {
                return this.brokerInternalTenantLimitConsumerQuota();
            }
            if (((Object)((Object)ClientQuotaType.PRODUCE)).equals((Object)clientQuotaType)) {
                return this.brokerInternalTenantLimitProducerQuota();
            }
            throw new IllegalArgumentException("Not a client quota type: " + quotaType);
        }
        ClientQuotaType clientQuotaType = quotaType;
        if (((Object)((Object)ClientQuotaType.FETCH)).equals((Object)clientQuotaType)) {
            return this.brokerTenantLimitConsumerQuota();
        }
        if (((Object)((Object)ClientQuotaType.PRODUCE)).equals((Object)clientQuotaType)) {
            return this.brokerTenantLimitProducerQuota();
        }
        throw new IllegalArgumentException("Not a client quota type: " + quotaType);
    }

    private void updateBrokerTenantQuotaLimit(long producerQuota, long consumerQuota) {
        this.brokerTenantLimitProducerQuota_$eq(producerQuota);
        this.brokerTenantLimitConsumerQuota_$eq(consumerQuota);
    }

    private void updateBrokerInternalTenantQuotaLimit(long producerQuota, long consumerQuota) {
        this.brokerInternalTenantLimitProducerQuota_$eq(producerQuota);
        this.brokerInternalTenantLimitConsumerQuota_$eq(consumerQuota);
    }

    public void computeQuotas(int brokerId, Iterable<QuotaEntityAndConsumptions> quotaEntries, Function1<ReportQuotaResult, BoxedUnit> responseCallback) {
        if (!this.isActive().get()) {
            responseCallback.apply(new ReportQuotaResult(((IterableOnceOps)quotaEntries.map((Function1<QuotaEntityAndConsumptions, Tuple2> & Serializable)quotaEntityAndConsumptions -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(quotaEntityAndConsumptions.entity()), Errors.COORDINATOR_NOT_AVAILABLE))).toMap($less$colon$less$.MODULE$.refl())));
            return;
        }
        scala.collection.mutable.Map invalidQuotaEntries = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        Buffer validQuotaEntries = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        quotaEntries.foreach((Function1<QuotaEntityAndConsumptions, Object> & Serializable)quotaEntityAndConsumptions -> {
            this.processQuotaEntry$1(quotaEntityAndConsumptions, invalidQuotaEntries, brokerId, validQuotaEntries);
            return BoxedUnit.UNIT;
        });
        if (invalidQuotaEntries.nonEmpty()) {
            this.debug((Function0<String> & Serializable)() -> "Skipping quota computation for " + invalidQuotaEntries.size() + " quota entries because they failed validation");
        }
        scala.collection.immutable.Map<TopicPartition, Iterable<QuotaEntry>> quotaEntriesPerPartition = validQuotaEntries.groupBy((Function1<QuotaEntry, TopicPartition> & Serializable)quotaEntry -> new TopicPartition("_confluent-quotas", this.partitionFor(quotaEntry.quotaEntity())));
        this.quotaStateManager().storeQuotas(quotaEntriesPerPartition, (Function1<Map<Object, Errors>, BoxedUnit>)(Function1<Map, Object> & Serializable)responseStatus -> {
            this.storeQuotaCallback$1(responseStatus, quotaEntries, responseCallback, invalidQuotaEntries);
            return BoxedUnit.UNIT;
        }, this.quotaStateManager().storeQuotas$default$3());
    }

    public boolean isDynamicQuotaComputedByFlexFanout(QuotaEntity quotaEntity) {
        return this.flexFanoutManager().isDynamicQuotaComputedByFlexFanout(quotaEntity);
    }

    public Tuple2<Errors, QuotaDescription> describeQuota(QuotaEntity quotaEntity) {
        if (!this.isActive().get()) {
            return new Tuple2<Errors, QuotaDescription>(Errors.COORDINATOR_NOT_AVAILABLE, new QuotaDescription((Map)scala.collection.Map$.MODULE$.empty()));
        }
        Option<Errors> option = this.validateQuotaEntity(quotaEntity);
        if (option instanceof Some) {
            Some some = (Some)option;
            Errors error = (Errors)((Object)some.value());
            return new Tuple2<Errors, QuotaDescription>(error, new QuotaDescription((Map)scala.collection.Map$.MODULE$.empty()));
        }
        if (None$.MODULE$.equals(option)) {
            Option<QuotaEntry> option2 = this.quotaStateManager().getQuota(quotaEntity);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                QuotaEntry quotaEntry = (QuotaEntry)some.value();
                scala.collection.immutable.Map brokerQuotaEntries = (scala.collection.immutable.Map)((IterableOnceOps)((IterableOps)quotaEntry.computedQuotas().filter((Function1<Tuple2, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(QuotaCoordinator.$anonfun$describeQuota$1(x$1)))).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        int brokerId = tuple2._1$mcI$sp();
                        scala.collection.mutable.Map perBrokerQuotas = (scala.collection.mutable.Map)tuple2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(brokerId)), ((MapOps)perBrokerQuotas.filter((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToBoolean(QuotaCoordinator.$anonfun$describeQuota$3(this, x0$2)))).map((Function1<Tuple2, Tuple2> & Serializable)x0$3 -> {
                            Tuple2 tuple2 = x0$3;
                            if (tuple2 != null) {
                                String quotaType = (String)tuple2._1();
                                QuotaValue quotaValue = (QuotaValue)tuple2._2();
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(quotaType), BoxesRunTime.boxToDouble(quotaValue.quota()));
                            }
                            throw new MatchError(tuple2);
                        }).toMap($less$colon$less$.MODULE$.refl()));
                    }
                    throw new MatchError(tuple2);
                })).toMap($less$colon$less$.MODULE$.refl()).filter((Function1<Tuple2, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(QuotaCoordinator.$anonfun$describeQuota$5(x$2)));
                if (!brokerQuotaEntries.exists((Function1<Tuple2, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(QuotaCoordinator.$anonfun$describeQuota$6(x$3)))) {
                    return new Tuple2<Errors, QuotaDescription>(Errors.QUOTA_ENTITY_NOT_FOUND, new QuotaDescription((Map)scala.collection.Map$.MODULE$.empty()));
                }
                return new Tuple2<Errors, QuotaDescription>(Errors.NONE, new QuotaDescription(brokerQuotaEntries));
            }
            if (None$.MODULE$.equals(option2)) {
                return new Tuple2<Errors, QuotaDescription>(Errors.QUOTA_ENTITY_NOT_FOUND, new QuotaDescription((Map)scala.collection.Map$.MODULE$.empty()));
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public Properties quotasTopicConfigs() {
        Properties props = new Properties();
        props.put("cleanup.policy", "compact");
        props.put("segment.bytes", Integer.toString(this.quotaConfig().quotasTopicSegmentBytes()));
        props.put("compression.type", BrokerCompressionType.PRODUCER.name);
        props.put("confluent.placement.constraints", this.quotaConfig().quotasTopicPlacementConstraints());
        return props;
    }

    public int partitionFor(QuotaEntity quotaEntity) {
        return this.quotaStateManager().partitionFor(quotaEntity);
    }

    public Option<Errors> validateQuotaEntity(QuotaEntity quotaEntity) {
        if (this.quotaStateManager().isLoadingQuotaEntity(quotaEntity)) {
            return new Some<Errors>(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        if (!this.quotaStateManager().ownsQuotaEntity(quotaEntity)) {
            return new Some<Errors>(Errors.NOT_COORDINATOR);
        }
        return None$.MODULE$;
    }

    public void onElection(int quotaTopicPartitionId, int coordinatorEpoch) {
        this.info((Function0<String> & Serializable)() -> "Elected as the quota coordinator for partition " + quotaTopicPartitionId + " at epoch " + coordinatorEpoch);
        this.quotaStateManager().loadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void onResignation(int quotaTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String> & Serializable)() -> "Resigned as the quota coordinator for partition " + quotaTopicPartitionId + " at epoch " + coordinatorEpoch);
        this.quotaStateManager().unloadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void startup(Function0<Object> retrieveQuotaTopicPartitionCount) {
        this.info((Function0<String> & Serializable)() -> "Starting up.");
        this.scheduler().startup();
        this.quotaStateManager().startup(retrieveQuotaTopicPartitionCount, () -> this.maybeCreateQuotaTopic$1());
        this.info((Function0<String> & Serializable)() -> "Startup complete.");
    }

    public void shutdown() {
        this.info((Function0<String> & Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.quotaStateManager().shutdown();
        this.scheduler().shutdown();
        this.info((Function0<String> & Serializable)() -> "Shutdown complete.");
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantProducerByteRate()) < 0L) {
            throw new ConfigException("Updating client bandwidth throttle config require 'confluent.quota.tenant.broker.max.producer.rate' to be positive");
        }
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantConsumerByteRate()) < 0L) {
            throw new ConfigException("Updating client bandwidth throttle config require 'confluent.quota.tenant.broker.max.consumer.rate'  to be positive");
        }
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerInternalTenantProducerByteRate()) < 0L) {
            throw new ConfigException("Updating client internal bandwidth throttle config require 'confluent.quota.tenant.internal.broker.max.producer.rate' to be positive");
        }
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerInternalTenantConsumerByteRate()) < 0L) {
            throw new ConfigException("Updating client internal bandwidth throttle config require 'confluent.quota.tenant.internal.broker.max.consumer.rate'  to be positive");
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        block10: {
            block9: {
                block8: {
                    block7: {
                        Integer n = newConfig.confluentConfig().quotasExpirationTimeMs();
                        Integer n2 = oldConfig.confluentConfig().quotasExpirationTimeMs();
                        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
                            this.quotaStateManager().reconfigure(QuotaCoordinator$.MODULE$.kafka$coordinator$quota$QuotaCoordinator$$quotaCoordinatorConfig(newConfig));
                        }
                        Long l = newConfig.confluentConfig().maxBrokerTenantConsumerByteRate();
                        Long l2 = oldConfig.confluentConfig().maxBrokerTenantConsumerByteRate();
                        if (l != null ? !((Object)l).equals(l2) : l2 != null) break block7;
                        Long l3 = newConfig.confluentConfig().maxBrokerTenantProducerByteRate();
                        Long l4 = oldConfig.confluentConfig().maxBrokerTenantProducerByteRate();
                        if (!(l3 == null ? l4 != null : !((Object)l3).equals(l4))) break block8;
                    }
                    this.updateBrokerTenantQuotaLimit(Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantProducerByteRate()), Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantConsumerByteRate()));
                }
                Long l = newConfig.confluentConfig().maxBrokerInternalTenantConsumerByteRate();
                Long l5 = oldConfig.confluentConfig().maxBrokerInternalTenantConsumerByteRate();
                if (l != null ? !((Object)l).equals(l5) : l5 != null) break block9;
                Long l6 = newConfig.confluentConfig().maxBrokerInternalTenantProducerByteRate();
                Long l7 = oldConfig.confluentConfig().maxBrokerInternalTenantProducerByteRate();
                if (!(l6 == null ? l7 != null : !((Object)l6).equals(l7))) break block10;
            }
            this.updateBrokerInternalTenantQuotaLimit(Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerInternalTenantProducerByteRate()), Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerInternalTenantConsumerByteRate()));
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isClientQuotaTypeValid(String s) {
        String string = s;
        String string2 = ClientQuotaType.PRODUCE.toString();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = s;
        String string4 = ClientQuotaType.FETCH.toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ long $anonfun$computeQuotas$4(java.util.Map elasticCkuDef) {
        return elasticCkuDef.getOrDefault((Object)ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.TOTAL_THROUGHPUT, Predef$.MODULE$.int2Integer(0)).longValue();
    }

    public static final /* synthetic */ void $anonfun$computeQuotas$3(QuotaCoordinator $this, QuotaEntry quotaEntry$1, int brokerId$1, QuotaConsumption quotaConsumption) {
        boolean isValidQuotaType = $this.isClientQuotaTypeValid(quotaConsumption.quotaType());
        if (isValidQuotaType) {
            java.util.Map<String, String> entityType = CollectionConverters$.MODULE$.MapHasAsJava(quotaEntry$1.quotaEntity().entityTypes()).asJava();
            long totalPerECKUThroughputLimit = BoxesRunTime.unboxToLong(Option$.MODULE$.apply($this.clusterLevelQuotaCallback().elasticCkuDefinition(entityType)).map((Function1<java.util.Map, Object> & Serializable)elasticCkuDef -> BoxesRunTime.boxToLong(QuotaCoordinator.$anonfun$computeQuotas$4(elasticCkuDef))).getOrElse(() -> 0L));
            Double produceClusterQuotaLimit = $this.clusterLevelQuotaCallback().clusterQuotaLimit(ClientQuotaType.PRODUCE, entityType);
            Double fetchClusterQuotaLimit = $this.clusterLevelQuotaCallback().clusterQuotaLimit(ClientQuotaType.FETCH, entityType);
            double totalThroughputLimit = totalPerECKUThroughputLimit > 0L ? Predef$.MODULE$.Double2double(produceClusterQuotaLimit) + Predef$.MODULE$.Double2double(fetchClusterQuotaLimit) : 0.0;
            QuotaSnapshot produceQuotaSnapshot = new QuotaSnapshot(ClientQuotaType.PRODUCE.toString(), Predef$.MODULE$.Double2double(produceClusterQuotaLimit), $this.getBrokerQuotaLimit(ClientQuotaType.PRODUCE, entityType));
            QuotaSnapshot fetchQuotaSnapshot = new QuotaSnapshot(ClientQuotaType.FETCH.toString(), Predef$.MODULE$.Double2double(fetchClusterQuotaLimit), $this.getBrokerQuotaLimit(ClientQuotaType.FETCH, entityType));
            quotaEntry$1.updateConsumptionAndRecomputeQuotas($this.quotaConfig(), brokerId$1, quotaConsumption, produceQuotaSnapshot, fetchQuotaSnapshot, totalThroughputLimit, $this.flexFanoutManager(), $this.time().milliseconds());
            return;
        }
        quotaEntry$1.updateConsumption(brokerId$1, quotaConsumption, $this.time().milliseconds());
    }

    private final void processQuotaEntry$1(QuotaEntityAndConsumptions quotaEntityAndConsumptions, scala.collection.mutable.Map invalidQuotaEntries$1, int brokerId$1, Buffer validQuotaEntries$1) {
        Option<Errors> option = this.validateQuotaEntity(quotaEntityAndConsumptions.entity());
        if (option instanceof Some) {
            Some some = (Some)option;
            Errors error = (Errors)((Object)some.value());
            invalidQuotaEntries$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(quotaEntityAndConsumptions.entity()), error));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            QuotaEntry quotaEntry = this.quotaStateManager().getAndMaybePutQuota(quotaEntityAndConsumptions.entity());
            quotaEntry.inLock(() -> quotaEntityAndConsumptions.consumptions().foreach((Function1<QuotaConsumption, Object> & Serializable)quotaConsumption -> {
                QuotaCoordinator.$anonfun$computeQuotas$3(this, quotaEntry, brokerId$1, quotaConsumption);
                return BoxedUnit.UNIT;
            }));
            validQuotaEntries$1.$plus$eq(quotaEntry);
            return;
        }
        throw new MatchError(option);
    }

    private final void storeQuotaCallback$1(Map responseStatus, Iterable quotaEntries$1, Function1 responseCallback$1, scala.collection.mutable.Map invalidQuotaEntries$1) {
        scala.collection.immutable.Map entityResults = ((IterableOnceOps)quotaEntries$1.map((Function1<QuotaEntityAndConsumptions, Tuple2> & Serializable)quotaEntry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(quotaEntry.entity()), responseStatus.getOrElse(BoxesRunTime.boxToInteger(this.partitionFor(quotaEntry.entity())), (Function0<Errors> & Serializable)() -> Errors.UNKNOWN_SERVER_ERROR)))).toMap($less$colon$less$.MODULE$.refl());
        responseCallback$1.apply(new ReportQuotaResult((Map)entityResults.$plus$plus(invalidQuotaEntries$1)));
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$1(Tuple2 x$1) {
        return ((IterableOnceOps)x$1._2()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$3(QuotaCoordinator $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String quotaType = (String)tuple2._1();
            return $this.isClientQuotaTypeValid(quotaType);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$5(Tuple2 x$2) {
        return ((IterableOnceOps)x$2._2()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$6(Tuple2 x$3) {
        return ((IterableOnceOps)x$3._2()).nonEmpty();
    }

    private final void maybeCreateQuotaTopic$1() {
        boolean topicCreated = false;
        while (!topicCreated) {
            try {
                this.internalAdminSupplier().get().ensureTopic("_confluent-quotas", this.quotaConfig().quotasTopicPartitions(), this.quotaConfig().quotasTopicReplicationFactor(), this.quotasTopicConfigs());
                topicCreated = true;
                this.isActive().set(true);
            }
            catch (Throwable t) {
                this.warn((Function0<String> & Serializable)() -> "Failed to create topic _confluent-quotas with error " + t + ", retrying after 5 seconds");
                Thread.sleep(5000L);
            }
        }
    }

    public QuotaCoordinator(int brokerId, QuotaCoordinatorConfig quotaConfig, QuotaStateManager quotaStateManager, Scheduler scheduler, Supplier<InternalAdmin> internalAdminSupplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, FlexFanoutQuotaManager flexFanoutManager, Time time) {
        this.brokerId = brokerId;
        this.quotaConfig = quotaConfig;
        this.quotaStateManager = quotaStateManager;
        this.scheduler = scheduler;
        this.internalAdminSupplier = internalAdminSupplier;
        this.clusterLevelQuotaCallback = clusterLevelQuotaCallback;
        this.flexFanoutManager = flexFanoutManager;
        this.time = time;
        Logging.$init$(this);
        this.isActive = new AtomicBoolean(false);
        this.logIdent_$eq("[QuotaCoordinator brokerId=" + brokerId + "]: ");
        this.brokerTenantLimitProducerQuota = quotaConfig.quotasBrokerLimitProducer();
        this.brokerTenantLimitConsumerQuota = quotaConfig.quotasBrokerLimitConsumer();
        this.brokerInternalTenantLimitProducerQuota = quotaConfig.quotasBrokerInternalLimitProducer();
        this.brokerInternalTenantLimitConsumerQuota = quotaConfig.quotasBrokerInternalLimitConsumer();
    }
}

