/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaSnapshot;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.QuotaValue$;
import kafka.server.FlexFanoutQuotaManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.server.config.FlexFanoutMode;
import org.apache.kafka.server.quota.ClientQuotaType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcDD$sp;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001\u0002\f\u0018\u0001yA\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tc\u0001\u0011\t\u0011)A\u0005[!A!\u0007\u0001BA\u0002\u0013\u00051\u0007\u0003\u00058\u0001\t\u0005\r\u0011\"\u00019\u0011!q\u0004A!A!B\u0013!\u0004\"B\"\u0001\t\u0003!U\u0001\u0002%\u0001\t%Cqa\u0018\u0001C\u0002\u0013%\u0001\r\u0003\u0004n\u0001\u0001\u0006I!\u0019\u0005\b]\u0002\u0011\r\u0011\"\u0001p\u0011\u0019A\b\u0001)A\u0005a\"9\u0011\u0010\u0001b\u0001\n\u0013Q\bBB@\u0001A\u0003%1\u0010C\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!9\u0011q\u0007\u0001\u0005\n\u0005e\u0002bBA#\u0001\u0011\u0005\u0011q\t\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\t)\n\u0001C\u0005\u0003/Cq!a*\u0001\t\u0003\tI\u000bC\u0004\u0002,\u0002!\t%!+\u0003\u0015E+x\u000e^1F]R\u0014\u0018P\u0003\u0002\u00193\u0005)\u0011/^8uC*\u0011!dG\u0001\fG>|'\u000fZ5oCR|'OC\u0001\u001d\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011a%K\u0007\u0002O)\u0011\u0001fG\u0001\u0006kRLGn]\u0005\u0003U\u001d\u0012q\u0001T8hO&tw-A\u0006rk>$\u0018-\u00128uSRLX#A\u0017\u0011\u00059zS\"A\f\n\u0005A:\"aC)v_R\fWI\u001c;jif\fA\"];pi\u0006,e\u000e^5us\u0002\nA\u0003\\1tiV\u0003H-\u0019;fIRKW.Z:uC6\u0004X#\u0001\u001b\u0011\u0005\u0001*\u0014B\u0001\u001c\"\u0005\u0011auN\\4\u000211\f7\u000f^+qI\u0006$X\r\u001a+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000f\u0006\u0002:yA\u0011\u0001EO\u0005\u0003w\u0005\u0012A!\u00168ji\"9Q\bBA\u0001\u0002\u0004!\u0014a\u0001=%c\u0005)B.Y:u+B$\u0017\r^3e)&lWm\u001d;b[B\u0004\u0003FA\u0003A!\t\u0001\u0013)\u0003\u0002CC\tAao\u001c7bi&dW-\u0001\u0004=S:LGO\u0010\u000b\u0004\u000b\u001a;\u0005C\u0001\u0018\u0001\u0011\u0015Yc\u00011\u0001.\u0011\u0015\u0011d\u00011\u00015\u0005=\u0001VM\u001d\"s_.,'/U;pi\u0006\u001c\b\u0003\u0002&P#rk\u0011a\u0013\u0006\u0003\u00196\u000bq!\\;uC\ndWM\u0003\u0002OC\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005A[%aA'baB\u0011!+\u0017\b\u0003'^\u0003\"\u0001V\u0011\u000e\u0003US!AV\u000f\u0002\rq\u0012xn\u001c;?\u0013\tA\u0016%\u0001\u0004Qe\u0016$WMZ\u0005\u00035n\u0013aa\u0015;sS:<'B\u0001-\"!\tqS,\u0003\u0002_/\tQ\u0011+^8uCZ\u000bG.^3\u0002\t1|7m[\u000b\u0002CB\u0011!m[\u0007\u0002G*\u0011A-Z\u0001\u0006Y>\u001c7n\u001d\u0006\u0003M\u001e\f!bY8oGV\u0014(/\u001a8u\u0015\tA\u0017.\u0001\u0003vi&d'\"\u00016\u0002\t)\fg/Y\u0005\u0003Y\u000e\u0014QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0017!\u00027pG.\u0004\u0013AD2p[B,H/\u001a3Rk>$\u0018m]\u000b\u0002aB!a%]:w\u0013\t\u0011xE\u0001\u0003Q_>d\u0007C\u0001\u0011u\u0013\t)\u0018EA\u0002J]R\u0004\"a^\u0004\u000e\u0003\u0001\tqbY8naV$X\rZ)v_R\f7\u000fI\u0001\u0015Y\u0006\u001cHOU3d_6\u0004X\u000f^3e)&lW-T:\u0016\u0003m\u0004B\u0001`?Ri5\tQ-\u0003\u0002\u007fK\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0002+1\f7\u000f\u001e*fG>l\u0007/\u001e;fIRKW.Z'tA\u00051\u0011N\u001c'pG.,B!!\u0002\u0002\fQ!\u0011qAA\u000f!\u0011\tI!a\u0003\r\u0001\u00119\u0011Q\u0002\bC\u0002\u0005=!!\u0001+\u0012\t\u0005E\u0011q\u0003\t\u0004A\u0005M\u0011bAA\u000bC\t9aj\u001c;iS:<\u0007c\u0001\u0011\u0002\u001a%\u0019\u00111D\u0011\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002 9!\t\u0019AA\u0011\u0003\r1WO\u001c\t\u0006A\u0005\r\u0012qA\u0005\u0004\u0003K\t#\u0001\u0003\u001fcs:\fW.\u001a \u0002\u001bA,H/U;pi\u00064\u0016\r\\;f)\u001dI\u00141FA\u0018\u0003gAa!!\f\u0010\u0001\u0004\u0019\u0018\u0001\u00032s_.,'/\u00133\t\r\u0005Er\u00021\u0001R\u0003%\tXo\u001c;b)f\u0004X\r\u0003\u0004\u00026=\u0001\r\u0001X\u0001\u000bcV|G/\u0019,bYV,\u0017!D4fiF+x\u000e^1WC2,X\r\u0006\u0004\u0002<\u0005\u0005\u00131\t\t\u0005A\u0005uB,C\u0002\u0002@\u0005\u0012aa\u00149uS>t\u0007BBA\u0017!\u0001\u00071\u000f\u0003\u0004\u00022A\u0001\r!U\u0001$kB$\u0017\r^3D_:\u001cX/\u001c9uS>t\u0017I\u001c3SK\u000e|W\u000e];uKF+x\u000e^1t)EI\u0014\u0011JA*\u0003+\ny&!\u001b\u0002n\u0005]\u0014q\u0011\u0005\b\u0003\u0017\n\u0002\u0019AA'\u0003-\tXo\u001c;b\u0007>tg-[4\u0011\u00079\ny%C\u0002\u0002R]\u0011a#U;pi\u0006\u001cun\u001c:eS:\fGo\u001c:D_:4\u0017n\u001a\u0005\u0007\u0003[\t\u0002\u0019A:\t\u000f\u0005]\u0013\u00031\u0001\u0002Z\u0005Y1m\u001c8tk6\u0004H/[8o!\rq\u00131L\u0005\u0004\u0003;:\"\u0001E)v_R\f7i\u001c8tk6\u0004H/[8o\u0011\u001d\t\t'\u0005a\u0001\u0003G\nA\u0003\u001d:pIV\u001cW-U;pi\u0006\u001cf.\u00199tQ>$\bc\u0001\u0018\u0002f%\u0019\u0011qM\f\u0003\u001bE+x\u000e^1T]\u0006\u00048\u000f[8u\u0011\u001d\tY'\u0005a\u0001\u0003G\n!CZ3uG\"\fVo\u001c;b':\f\u0007o\u001d5pi\"9\u0011qN\tA\u0002\u0005E\u0014\u0001\u0006;pi\u0006dG\u000b\u001b:pk\u001eD\u0007/\u001e;Rk>$\u0018\rE\u0002!\u0003gJ1!!\u001e\"\u0005\u0019!u.\u001e2mK\"9\u0011\u0011P\tA\u0002\u0005m\u0014!\u00054mKb4\u0015M\\8vi6\u000bg.Y4feB!\u0011QPAB\u001b\t\tyHC\u0002\u0002\u0002n\taa]3sm\u0016\u0014\u0018\u0002BAC\u0003\u007f\u0012aC\u00127fq\u001a\u000bgn\\;u#V|G/Y'b]\u0006<WM\u001d\u0005\u0007\u0003\u0013\u000b\u0002\u0019\u0001\u001b\u0002\u001b\r,(O]3oiRKW.Z't\u0003E)\b\u000fZ1uK\u000e{gn];naRLwN\u001c\u000b\bs\u0005=\u0015\u0011SAJ\u0011\u0019\tiC\u0005a\u0001g\"9\u0011q\u000b\nA\u0002\u0005e\u0003BBAE%\u0001\u0007A'A\bsK\u000e|W\u000e];uKF+x\u000e^1t)=I\u0014\u0011TAN\u0003;\u000by*!)\u0002$\u0006\u0015\u0006bBA&'\u0001\u0007\u0011Q\n\u0005\u0007\u0003c\u0019\u0002\u0019A)\t\u000f\u0005\u00054\u00031\u0001\u0002d!9\u00111N\nA\u0002\u0005\r\u0004bBA8'\u0001\u0007\u0011\u0011\u000f\u0005\b\u0003s\u001a\u0002\u0019AA>\u0011\u0019\tIi\u0005a\u0001i\u0005!2m\\7qkR,G-U;pi\u0006\u001c8\u000b\u001e:j]\u001e$\u0012!U\u0001\ti>\u001cFO]5oO\"\u001a\u0001!a,\u0011\u0007\u0019\n\t,C\u0002\u00024\u001e\u0012QB\\8oi\"\u0014X-\u00193tC\u001a,\u0007")
public class QuotaEntry
implements Logging {
    private final QuotaEntity quotaEntity;
    private volatile long lastUpdatedTimestamp;
    private final ReentrantLock lock;
    private final Pool<Object, Map<String, QuotaValue>> computedQuotas;
    private final ConcurrentHashMap<String, Object> lastRecomputedTimeMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        QuotaEntry quotaEntry = this;
        synchronized (quotaEntry) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public QuotaEntity quotaEntity() {
        return this.quotaEntity;
    }

    public long lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public void lastUpdatedTimestamp_$eq(long x$1) {
        this.lastUpdatedTimestamp = x$1;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public Pool<Object, Map<String, QuotaValue>> computedQuotas() {
        return this.computedQuotas;
    }

    private ConcurrentHashMap<String, Object> lastRecomputedTimeMs() {
        return this.lastRecomputedTimeMs;
    }

    public <T> T inLock(Function0<T> fun) {
        return CoreUtils$.MODULE$.inLock(this.lock(), fun);
    }

    public void putQuotaValue(int brokerId, String quotaType, QuotaValue quotaValue) {
        ((scala.collection.mutable.MapOps)this.computedQuotas().getAndMaybePut(BoxesRunTime.boxToInteger(brokerId))).put(quotaType, quotaValue);
    }

    private Option<QuotaValue> getQuotaValue(int brokerId, String quotaType) {
        return ((MapOps)this.computedQuotas().getAndMaybePut(BoxesRunTime.boxToInteger(brokerId))).get(quotaType);
    }

    public void updateConsumptionAndRecomputeQuotas(QuotaCoordinatorConfig quotaConfig, int brokerId, QuotaConsumption consumption, QuotaSnapshot produceQuotaSnapshot, QuotaSnapshot fetchQuotaSnapshot, double totalThroughputQuota, FlexFanoutQuotaManager flexFanoutManager, long currentTimeMs) {
        this.lastUpdatedTimestamp_$eq(currentTimeMs);
        this.updateConsumption(brokerId, consumption, currentTimeMs);
        if (!this.lastRecomputedTimeMs().contains(consumption.quotaType()) || currentTimeMs - BoxesRunTime.unboxToLong(this.lastRecomputedTimeMs().get(consumption.quotaType())) > quotaConfig.quotasRecomputeIntervalMs()) {
            this.debug((Function0<String> & Serializable)() -> "Recomputing " + consumption.quotaType() + " quotas with produceQuotaSnapshot=" + produceQuotaSnapshot + ", fetchQuotaSnapshot=" + fetchQuotaSnapshot + ".");
            this.recomputeQuotas(quotaConfig, consumption.quotaType(), produceQuotaSnapshot, fetchQuotaSnapshot, totalThroughputQuota, flexFanoutManager, currentTimeMs);
            return;
        }
    }

    public void updateConsumption(int brokerId, QuotaConsumption consumption, long currentTimeMs) {
        Option<QuotaValue> option = this.getQuotaValue(brokerId, consumption.quotaType());
        if (option instanceof Some) {
            Some some = (Some)option;
            QuotaValue quotaValue = (QuotaValue)some.value();
            quotaValue.updateConsumption(consumption, currentTimeMs);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            ((scala.collection.mutable.MapOps)this.computedQuotas().get(BoxesRunTime.boxToInteger(brokerId))).update(consumption.quotaType(), QuotaValue$.MODULE$.valueFromConsumption(consumption, currentTimeMs));
            return;
        }
        throw new MatchError(option);
    }

    /*
     * Unable to fully structure code
     */
    private void recomputeQuotas(QuotaCoordinatorConfig quotaConfig, String quotaType, QuotaSnapshot produceQuotaSnapshot, QuotaSnapshot fetchQuotaSnapshot, double totalThroughputQuota, FlexFanoutQuotaManager flexFanoutManager, long currentTimeMs) {
        block7: {
            block6: {
                var13_8 = this.computeThrottleTimeAndUsage$1(ClientQuotaType.PRODUCE.toString(), currentTimeMs, quotaConfig);
                if (var13_8 == null) {
                    throw new MatchError(var13_8);
                }
                totalProduceThrottleTimeMs = var13_8._1$mcD$sp();
                totalProduceAdjustedUsage = var13_8._2$mcD$sp();
                var12_11 = new Tuple2$mcDD$sp(totalProduceThrottleTimeMs, totalProduceAdjustedUsage);
                totalProduceThrottleTimeMs = var12_11._1$mcD$sp();
                totalProduceAdjustedUsage = var12_11._2$mcD$sp();
                var23_14 = this.computeThrottleTimeAndUsage$1(ClientQuotaType.FETCH.toString(), currentTimeMs, quotaConfig);
                if (var23_14 == null) {
                    throw new MatchError(var23_14);
                }
                totalFetchThrottleTimeMs = var23_14._1$mcD$sp();
                totalFetchAdjustedUsage = var23_14._2$mcD$sp();
                var22_17 = new Tuple2$mcDD$sp(totalFetchThrottleTimeMs, totalFetchAdjustedUsage);
                totalFetchThrottleTimeMs = var22_17._1$mcD$sp();
                totalFetchAdjustedUsage = var22_17._2$mcD$sp();
                if (!quotaConfig.flexibleFanoutEnabled()) break block6;
                v0 = ffMode = FlexFanoutMode.forName(quotaConfig.flexibleFanoutMode());
                var33_21 = FlexFanoutMode.TENANT_QUOTA;
                if (v0 != null ? v0.equals((Object)var33_21) == false : var33_21 != null) ** GOTO lbl-1000
                if (QuotaEntry.isAboveFlexFanoutLazyEvaluationThreshold$1(totalProduceAdjustedUsage, quotaConfig, produceQuotaSnapshot, totalFetchAdjustedUsage, fetchQuotaSnapshot) && totalThroughputQuota > (double)false) {
                    totalThroughputAdjustedUsage = totalProduceAdjustedUsage + totalFetchAdjustedUsage;
                    produceUsageRatio = totalProduceAdjustedUsage / totalThroughputAdjustedUsage;
                    fetchUsageRatio = totalFetchAdjustedUsage / totalThroughputAdjustedUsage;
                    produceQuotaSnapshot.totalQuota_$eq(totalThroughputQuota * produceUsageRatio);
                    fetchQuotaSnapshot.totalQuota_$eq(totalThroughputQuota * fetchUsageRatio);
                    this.debug((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$recomputeQuotas$10(kafka.coordinator.quota.QuotaEntry java.lang.String kafka.coordinator.quota.QuotaSnapshot kafka.coordinator.quota.QuotaSnapshot ), ()Ljava/lang/String;)((QuotaEntry)this, (String)quotaType, (QuotaSnapshot)produceQuotaSnapshot, (QuotaSnapshot)fetchQuotaSnapshot));
                    this.recomputeDynamicQuota$1(produceQuotaSnapshot, totalProduceAdjustedUsage, totalProduceThrottleTimeMs, quotaConfig);
                    this.recomputeDynamicQuota$1(fetchQuotaSnapshot, totalFetchAdjustedUsage, totalFetchThrottleTimeMs, quotaConfig);
                } else if (flexFanoutManager.isDynamicQuotaComputedByFlexFanout(this.quotaEntity())) {
                    this.debug((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$recomputeQuotas$11(), ()Ljava/lang/String;)());
                } else {
                    this.runDynamicQuota$1(quotaType, produceQuotaSnapshot, totalProduceAdjustedUsage, totalProduceThrottleTimeMs, fetchQuotaSnapshot, totalFetchAdjustedUsage, totalFetchThrottleTimeMs, quotaConfig);
                }
                break block7;
            }
            this.runDynamicQuota$1(quotaType, produceQuotaSnapshot, totalProduceAdjustedUsage, totalProduceThrottleTimeMs, fetchQuotaSnapshot, totalFetchAdjustedUsage, totalFetchThrottleTimeMs, quotaConfig);
        }
        this.lastRecomputedTimeMs().put(quotaType, BoxesRunTime.boxToLong(currentTimeMs));
    }

    public String computedQuotasString() {
        if (this.computedQuotas().isEmpty()) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        this.computedQuotas().foreach((Function1<Tuple2, StringBuilder> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int broker = tuple2._1$mcI$sp();
                Map perBrokerQuotas = (Map)tuple2._2();
                return res.append("{broker=" + broker + ",perBrokerQuotas=" + perBrokerQuotas + "},");
            }
            throw new MatchError(tuple2);
        });
        res.deleteCharAt(res.length() - 1);
        return res.toString();
    }

    public String toString() {
        StringBuilder res = new StringBuilder("QuotaEntry(").append("quotaEntity=").append(this.quotaEntity().entityTypes().toString()).append(", computedQuotas=(").append(this.computedQuotasString()).append(")").append(", lastUpdatedTimestamp=").append(this.lastUpdatedTimestamp()).append(")");
        return res.toString();
    }

    public static final /* synthetic */ Map $anonfun$computedQuotas$1(int x$1) {
        return (Map)Map$.MODULE$.empty();
    }

    private static final double adjustedUsage$1(QuotaValue quotaValue, double totalThrottleTimeMs, QuotaCoordinatorConfig quotaConfig$1) {
        double adjustment = totalThrottleTimeMs > 0.0 && quotaValue.throttledTimeMs() > 0.0 ? Math.max(0.2, quotaConfig$1.quotaComputingUsageAdjustment() * quotaValue.throttledTimeMs() / totalThrottleTimeMs) : 0.0;
        return quotaValue.usage() * (1.0 + adjustment);
    }

    public static final /* synthetic */ double $anonfun$recomputeQuotas$1(String quotaType$1, long currentTimeMs$1, QuotaCoordinatorConfig quotaConfig$1, Map perBrokerQuota) {
        Option option = perBrokerQuota.get(quotaType$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            QuotaValue quotaValue = (QuotaValue)some.value();
            if (quotaValue.lastUsageReportTimestamp() >= currentTimeMs$1 - (long)quotaConfig$1.quotasConsumptionExpirationTimeMs()) {
                return quotaValue.throttledTimeMs();
            }
            perBrokerQuota.remove(quotaType$1);
            return 0.0;
        }
        if (None$.MODULE$.equals(option)) {
            return 0.0;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ double $anonfun$recomputeQuotas$2(String quotaType$1, double totalThrottleTimeMs$1, QuotaCoordinatorConfig quotaConfig$1, Map perBrokerQuota) {
        Option option = perBrokerQuota.get(quotaType$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            QuotaValue quotaValue = (QuotaValue)some.value();
            return QuotaEntry.adjustedUsage$1(quotaValue, totalThrottleTimeMs$1, quotaConfig$1);
        }
        if (None$.MODULE$.equals(option)) {
            return 0.0;
        }
        throw new MatchError(option);
    }

    private final Tuple2 computeThrottleTimeAndUsage$1(String quotaType, long currentTimeMs$1, QuotaCoordinatorConfig quotaConfig$1) {
        double totalThrottleTimeMs = BoxesRunTime.unboxToDouble(((IterableOnceOps)this.computedQuotas().values().map((Function1<Map, Object> & Serializable)perBrokerQuota -> BoxesRunTime.boxToDouble(QuotaEntry.$anonfun$recomputeQuotas$1(quotaType, currentTimeMs$1, quotaConfig$1, perBrokerQuota)))).sum(Numeric.DoubleIsFractional$.MODULE$));
        double totalAdjustedUsage = BoxesRunTime.unboxToDouble(((IterableOnceOps)this.computedQuotas().values().map((Function1<Map, Object> & Serializable)perBrokerQuota -> BoxesRunTime.boxToDouble(QuotaEntry.$anonfun$recomputeQuotas$2(quotaType, totalThrottleTimeMs, quotaConfig$1, perBrokerQuota)))).sum(Numeric.DoubleIsFractional$.MODULE$));
        return new Tuple2$mcDD$sp(totalThrottleTimeMs, totalAdjustedUsage);
    }

    public static final /* synthetic */ void $anonfun$recomputeQuotas$4(String quotaType$2, double maxBrokerQuota$1, Map perBrokerQuotas) {
        perBrokerQuotas.get(quotaType$2).foreach((Function1<QuotaValue, Object> & Serializable)quotaValue -> {
            quotaValue.quota_$eq(maxBrokerQuota$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ double $anonfun$recomputeQuotas$6(String quotaType$2, double totalThrottleTimeMs$2, QuotaCoordinatorConfig quotaConfig$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Map perBrokerQuotas = (Map)tuple2._2();
            Option option = perBrokerQuotas.get(quotaType$2);
            if (option instanceof Some) {
                Some some = (Some)option;
                QuotaValue quotaValue = (QuotaValue)some.value();
                return (double)-1 * QuotaEntry.adjustedUsage$1(quotaValue, totalThrottleTimeMs$2, quotaConfig$1);
            }
            if (None$.MODULE$.equals(option)) {
                return 0.0;
            }
            throw new MatchError(option);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$recomputeQuotas$8(QuotaEntry $this, QuotaCoordinatorConfig quotaConfig$1, double totalThrottleTimeMs$2, DoubleRef remainingUsage$1, DoubleRef remainingQuota$1, double maxBrokerQuota$1, String quotaType$2, int brokerId$1, QuotaValue quotaValue) {
        double currentUsage = 0.0;
        if (quotaConfig$1.enableBrokerReportMinUsageMode()) {
            currentUsage = QuotaEntry.adjustedUsage$1(quotaValue, totalThrottleTimeMs$2, quotaConfig$1);
        } else {
            double avgUsage = remainingUsage$1.elem / (double)$this.computedQuotas().size();
            double minUsageThreshold = package$.MODULE$.min((double)quotaConfig$1.quotaDynamicAdjustmentMinUsage(), avgUsage);
            currentUsage = package$.MODULE$.max(QuotaEntry.adjustedUsage$1(quotaValue, totalThrottleTimeMs$2, quotaConfig$1), minUsageThreshold);
        }
        quotaValue.quota_$eq(remainingUsage$1.elem > 0.0 ? remainingQuota$1.elem * (currentUsage / remainingUsage$1.elem) : 0.0);
        quotaValue.quota_$eq(package$.MODULE$.min(quotaValue.quota(), maxBrokerQuota$1));
        remainingQuota$1.elem -= quotaValue.quota();
        remainingUsage$1.elem -= currentUsage;
        $this.debug((Function0<String> & Serializable)() -> "Computed new " + quotaType$2 + " quota of " + quotaValue.quota() + " for " + $this.quotaEntity() + " with brokerId=" + brokerId$1 + ",remainingUsage=" + remainingUsage$1.elem + ",remainingQuota=" + remainingQuota$1.elem);
    }

    public static final /* synthetic */ void $anonfun$recomputeQuotas$7(QuotaEntry $this, String quotaType$2, QuotaCoordinatorConfig quotaConfig$1, double totalThrottleTimeMs$2, DoubleRef remainingUsage$1, DoubleRef remainingQuota$1, double maxBrokerQuota$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int brokerId = tuple2._1$mcI$sp();
            Map perBrokerQuota = (Map)tuple2._2();
            perBrokerQuota.get(quotaType$2).foreach((Function1<QuotaValue, Object> & Serializable)quotaValue -> {
                QuotaEntry.$anonfun$recomputeQuotas$8($this, quotaConfig$1, totalThrottleTimeMs$2, remainingUsage$1, remainingQuota$1, maxBrokerQuota$1, quotaType$2, brokerId, quotaValue);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    private final void recomputeDynamicQuota$1(QuotaSnapshot quotaSnapshot, double totalUsage, double totalThrottleTimeMs, QuotaCoordinatorConfig quotaConfig$1) {
        String quotaType = quotaSnapshot.quotaType();
        double maxBrokerQuota = quotaSnapshot.maxBrokerQuota();
        double totalQuota = quotaSnapshot.totalQuota();
        if (totalUsage <= quotaConfig$1.quotasLazyEvaluationThreshold() * totalQuota) {
            this.debug((Function0<String> & Serializable)() -> "Resetting " + quotaType + " quotas to " + maxBrokerQuota + " with totalUsage=" + totalUsage + ",lazyEvalThreshold=" + quotaConfig$1.quotasLazyEvaluationThreshold() + ",totalQuota=" + totalQuota);
            this.computedQuotas().values().foreach((Function1<Map, Object> & Serializable)perBrokerQuotas -> {
                QuotaEntry.$anonfun$recomputeQuotas$4(quotaType, maxBrokerQuota, perBrokerQuotas);
                return BoxedUnit.UNIT;
            });
            return;
        }
        DoubleRef remainingUsage = DoubleRef.create(totalUsage);
        DoubleRef remainingQuota = DoubleRef.create(totalQuota);
        Seq sortedQuotas = (Seq)this.computedQuotas().toSeq().sortBy((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToDouble(QuotaEntry.$anonfun$recomputeQuotas$6(quotaType, totalThrottleTimeMs, quotaConfig$1, x0$1)), Ordering.DeprecatedDoubleOrdering$.MODULE$);
        sortedQuotas.foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
            QuotaEntry.$anonfun$recomputeQuotas$7(this, quotaType, quotaConfig$1, totalThrottleTimeMs, remainingUsage, remainingQuota, maxBrokerQuota, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private static final boolean isAboveFlexFanoutLazyEvaluationThreshold$1(double totalProduceAdjustedUsage$1, QuotaCoordinatorConfig quotaConfig$1, QuotaSnapshot produceQuotaSnapshot$2, double totalFetchAdjustedUsage$1, QuotaSnapshot fetchQuotaSnapshot$2) {
        return totalProduceAdjustedUsage$1 > quotaConfig$1.flexibleFanoutLazyEvaluationThreshold() * produceQuotaSnapshot$2.totalQuota() || totalFetchAdjustedUsage$1 > quotaConfig$1.flexibleFanoutLazyEvaluationThreshold() * fetchQuotaSnapshot$2.totalQuota();
    }

    private final void runDynamicQuota$1(String quotaType$3, QuotaSnapshot produceQuotaSnapshot$2, double totalProduceAdjustedUsage$1, double totalProduceThrottleTimeMs$1, QuotaSnapshot fetchQuotaSnapshot$2, double totalFetchAdjustedUsage$1, double totalFetchThrottleTimeMs$1, QuotaCoordinatorConfig quotaConfig$1) {
        String string = quotaType$3;
        String string2 = ClientQuotaType.PRODUCE.toString();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.recomputeDynamicQuota$1(produceQuotaSnapshot$2, totalProduceAdjustedUsage$1, totalProduceThrottleTimeMs$1, quotaConfig$1);
            return;
        }
        this.recomputeDynamicQuota$1(fetchQuotaSnapshot$2, totalFetchAdjustedUsage$1, totalFetchThrottleTimeMs$1, quotaConfig$1);
    }

    public static final /* synthetic */ String $anonfun$recomputeQuotas$10(QuotaEntry $this, String quotaType$3, QuotaSnapshot produceQuotaSnapshot$2, QuotaSnapshot fetchQuotaSnapshot$2) {
        return "Computed new " + quotaType$3 + " cluster quota due to flex fanout for " + $this.quotaEntity() + " ofproduceQuota=" + produceQuotaSnapshot$2.totalQuota() + ", fetchQuota=" + fetchQuotaSnapshot$2.totalQuota();
    }

    public static final /* synthetic */ String $anonfun$recomputeQuotas$11() {
        return "Dynamic quota is not recomputed because flex fanout is running in " + FlexFanoutMode.BROKER_QUOTA + " mode.";
    }

    public QuotaEntry(QuotaEntity quotaEntity, long lastUpdatedTimestamp) {
        this.quotaEntity = quotaEntity;
        this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        Logging.$init$(this);
        this.logIdent_$eq("[QuotaEntry quotaEntity=" + quotaEntity + "]: ");
        this.lock = new ReentrantLock();
        this.computedQuotas = new Pool(new Some<Function1<Object, Map> & Serializable>((Function1<Object, Map> & Serializable)x$1 -> QuotaEntry.$anonfun$computedQuotas$1(BoxesRunTime.unboxToInt(x$1))));
        this.lastRecomputedTimeMs = new ConcurrentHashMap();
    }
}

