/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.ondemand;

import com.google.gson.Gson;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kafka.tier.common.RestServerRequest;
import org.apache.http.client.utils.URIBuilder;

public final class StartAuditJobRequest
implements RestServerRequest {
    private final String brokerUrl;
    private final Map<String, Set<Integer>> topicPartitionsMap;
    private final int jobId;
    private final boolean forceStart;
    private final boolean compactionCheckNeeded;

    public StartAuditJobRequest(String brokerUrl, Map<String, Set<Integer>> topicPartitionsMap, int jobId, boolean forceStart, boolean compactionCheckNeeded) {
        this.brokerUrl = brokerUrl;
        this.topicPartitionsMap = topicPartitionsMap;
        this.jobId = jobId;
        this.forceStart = forceStart;
        this.compactionCheckNeeded = compactionCheckNeeded;
    }

    public Map<String, Set<Integer>> topicPartitionsMap() {
        return this.topicPartitionsMap;
    }

    public int jobId() {
        return this.jobId;
    }

    public boolean forceStart() {
        return this.forceStart;
    }

    public boolean compactionCheckNeeded() {
        return this.compactionCheckNeeded;
    }

    @Override
    public RestServerRequest.RestRequestType requestType() {
        return RestServerRequest.RestRequestType.POST;
    }

    @Override
    public String requestBodyAsJson() {
        Gson gsonObj = new Gson();
        String jsonString = gsonObj.toJson(this.topicPartitionsMap);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("job_id", String.valueOf(this.jobId));
        attributes.put("topic_partitions_map", jsonString);
        attributes.put("compaction_check_needed", String.valueOf(this.compactionCheckNeeded));
        attributes.put("force_start", String.valueOf(this.forceStart));
        StringBuilder body = new StringBuilder();
        body.append("{");
        for (String key : attributes.keySet()) {
            body.append("\"").append(key).append("\"");
            if (key.equals("topic_partitions_map")) {
                body.append(": ").append((String)attributes.get(key)).append(",");
                continue;
            }
            body.append(": \"").append((String)attributes.get(key)).append("\",");
        }
        body.deleteCharAt(body.length() - 1);
        body.append("}");
        return body.toString();
    }

    @Override
    public String brokerUrl() {
        return this.brokerUrl;
    }

    @Override
    public String requestName() {
        return StartAuditJobRequest.class.getName();
    }

    @Override
    public URI uri() throws URISyntaxException {
        return new URIBuilder(this.brokerUrl + "/v1/audit/start-audit-job").build();
    }

    public int hashCode() {
        return Objects.hash(this.brokerUrl, this.topicPartitionsMap, this.jobId, this.forceStart, this.compactionCheckNeeded);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartAuditJobRequest that = (StartAuditJobRequest)o;
        return Objects.equals(this.brokerUrl, that.brokerUrl) && Objects.equals(this.topicPartitionsMap, that.topicPartitionsMap) && this.jobId == that.jobId && this.forceStart == that.forceStart && this.compactionCheckNeeded == that.compactionCheckNeeded;
    }
}

