/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import kafka.log.LogCleaner$;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.log.SegmentDeletionThrottlerConfig;
import kafka.log.SegmentDeletionThrottlerConfig$;
import kafka.log.TierLogComponents;
import kafka.server.KafkaBroker$;
import kafka.server.KafkaConfig;
import kafka.server.ProducerIdQuotaManager;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.ConfigRepository;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.common.CheckpointFileConfig;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class LogManager$ {
    public static final LogManager$ MODULE$ = new LogManager$();
    private static final String LockFileName = ".lock";
    private static final String RecoveryPointCheckpointFile = "recovery-point-offset-checkpoint";
    private static final String LogStartOffsetCheckpointFile = "log-start-offset-checkpoint";

    public CheckpointFileConfig $lessinit$greater$default$27() {
        return CheckpointFileConfig.DEFAULT;
    }

    public ServerLogConfigs.CleanupPolicyEmptyValidation $lessinit$greater$default$29() {
        return ServerLogConfigs.LOG_CLEANUP_POLICY_EMPTY_VALIDATION_DEFAULT;
    }

    public String LockFileName() {
        return LockFileName;
    }

    public boolean waitForAllToComplete(Seq<Future<?>> jobs, Function1<Throwable, BoxedUnit> callback) {
        return jobs.count((Function1<Future, Object> & Serializable)future -> BoxesRunTime.boxToBoolean(LogManager$.$anonfun$waitForAllToComplete$1(callback, future))) == 0;
    }

    public String RecoveryPointCheckpointFile() {
        return RecoveryPointCheckpointFile;
    }

    public String LogStartOffsetCheckpointFile() {
        return LogStartOffsetCheckpointFile;
    }

    public LogManager apply(KafkaConfig config, Seq<String> initialOfflineDirs, ConfigRepository configRepository, Scheduler kafkaScheduler, Time time, BrokerTopicStats brokerTopicStats, Metrics metrics, LogDirFailureChannel logDirFailureChannel, TierLogComponents tierLogComponents, boolean keepPartitionMetadataFile, Option<ProducerIdQuotaManager> producerIdQuotaManager, Optional<E2EChecksumStore> checksumStoreOpt, CheckpointFileConfig checkpointFileConfig) {
        Map<String, Object> defaultProps = config.extractLogConfigMap();
        KafkaBroker$.MODULE$.augmentWithKafkaConfig(defaultProps, config);
        LogConfig.validateBrokerLogConfigValues(defaultProps);
        LogConfig defaultLogConfig = new LogConfig(defaultProps);
        CleanerConfig cleanerConfig = LogCleaner$.MODULE$.cleanerConfig(config);
        Seq x$1 = (Seq)config.logDirs().map((Function1<String, File> & Serializable)x$37 -> new File((String)x$37).getAbsoluteFile());
        Seq x$2 = (Seq)initialOfflineDirs.map((Function1<String, File> & Serializable)x$38 -> new File((String)x$38).getAbsoluteFile());
        ConfigRepository x$3 = configRepository;
        LogConfig x$4 = defaultLogConfig;
        CleanerConfig x$5 = cleanerConfig;
        int x$6 = Predef$.MODULE$.Integer2int(config.numRecoveryThreadsPerDataDir());
        long x$7 = Predef$.MODULE$.Long2long(config.logFlushSchedulerIntervalMs());
        long x$8 = config.logFlushOffsetCheckpointIntervalMs();
        long x$9 = config.logFlushStartOffsetCheckpointIntervalMs();
        int x$10 = Predef$.MODULE$.Integer2int(config.confluentConfig().tierPartitionStateCommitIntervalMs());
        boolean x$11 = config.confluentConfig().eagerRollEnable();
        long x$12 = Predef$.MODULE$.Long2long(config.confluentConfig().rollCheckIntervalMs());
        long x$13 = Predef$.MODULE$.Long2long(config.logCleanupIntervalMs());
        SegmentDeletionThrottlerConfig x$14 = new SegmentDeletionThrottlerConfig(time, config, SegmentDeletionThrottlerConfig$.MODULE$.$lessinit$greater$default$3());
        int x$15 = config.transactionStateManagerConfig().transactionMaxTimeoutMs();
        ProducerStateManagerConfig x$16 = new ProducerStateManagerConfig(config.transactionLogConfig().producerIdExpirationMs(), config.transactionLogConfig().transactionPartitionVerificationEnable());
        int x$17 = config.transactionLogConfig().producerIdExpirationCheckIntervalMs();
        Option<ProducerIdQuotaManager> x$18 = producerIdQuotaManager;
        Scheduler x$19 = kafkaScheduler;
        BrokerTopicStats x$20 = brokerTopicStats;
        Metrics x$21 = metrics;
        LogDirFailureChannel x$22 = logDirFailureChannel;
        TierLogComponents x$23 = tierLogComponents;
        Time x$24 = time;
        boolean x$25 = keepPartitionMetadataFile;
        Optional<E2EChecksumStore> x$26 = checksumStoreOpt;
        CheckpointFileConfig x$27 = checkpointFileConfig;
        long x$28 = Predef$.MODULE$.Long2long(config.logInitialTaskDelayMs());
        ServerLogConfigs.CleanupPolicyEmptyValidation x$29 = config.logCleanupPolicyEmptyValidation();
        return new LogManager(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$13, x$12, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29);
    }

    public void createProducerStateSensors(Metrics metrics) {
        Sensor expiredProducersRestoredSensor = metrics.sensor("ExpiredProducersRestored");
        expiredProducersRestoredSensor.add(new Meter(metrics.metricName("expired-producers-restored-rate", "log-manager-metrics", "The number of non zero sequences (restoring an expired producer) per second found on new producer state."), metrics.metricName("expired-producers-restored-total", "log-manager-metrics", "The total number of non zero sequences (restoring an expired producer) found on new producer state")));
        Sensor duplicateSequenceTimeSensor = metrics.sensor("DuplicateSequenceTime");
        duplicateSequenceTimeSensor.add(metrics.metricName("duplicate-sequence-time-max", "log-manager-metrics", "The max time between duplicate batches"), new Max());
        duplicateSequenceTimeSensor.add(metrics.metricName("duplicate-sequence-time-avg", "log-manager-metrics", "The avg time between duplicate batches"), new Avg());
    }

    public boolean isStrayKraftReplica(int brokerId, TopicsImage newTopicsImage, MergedLog log) {
        int partitionId;
        if (log.topicId().isEmpty()) {
            BrokerMetadataPublisher$.MODULE$.info((Function0<String> & Serializable)() -> "The topicId does not exist in " + log + ", treat it as a stray log");
            return true;
        }
        Uuid topicId = log.topicId().get();
        Option<PartitionRegistration> option = Option$.MODULE$.apply(newTopicsImage.getPartition(topicId, partitionId = log.topicPartition().partition()));
        if (option instanceof Some) {
            Some some = (Some)option;
            PartitionRegistration partition = (PartitionRegistration)some.value();
            if (!ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.intArrayOps(partition.replicas), BoxesRunTime.boxToInteger(brokerId))) {
                BrokerMetadataPublisher$.MODULE$.info((Function0<String> & Serializable)() -> "Found stray log dir " + log + ": the current replica assignment " + Predef$.MODULE$.wrapIntArray(partition$1.replicas).mkString("[", ", ", "]") + " does not contain the local brokerId " + brokerId + ".");
                return true;
            }
            return false;
        }
        if (None$.MODULE$.equals(option)) {
            BrokerMetadataPublisher$.MODULE$.info((Function0<String> & Serializable)() -> "Found stray log dir " + log + ": the topicId " + topicId + " does not exist in the metadata image");
            return true;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$waitForAllToComplete$1(Function1 callback$1, Future future) {
        Try try_ = Try$.MODULE$.apply((Function0<Object> & Serializable)() -> future.get());
        if (try_ instanceof Success) {
            return false;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            callback$1.apply(e);
            return true;
        }
        throw new MatchError(try_);
    }

    private LogManager$() {
    }
}

