/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote;

import com.yammer.metrics.core.Timer;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.MergedLog;
import kafka.log.remote.RemoteLogOffsetReader;
import kafka.log.remote.RemoteLogReader;
import kafka.server.DelayedRemoteListOffsets;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.internals.SecurityManagerCompatibility;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RemoteLogInputStream;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ChildFirstClassLoader;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.CheckpointFile;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.common.StopPartition;
import org.apache.kafka.server.log.remote.metadata.storage.ClassLoaderAwareRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.quota.RLMQuotaManager;
import org.apache.kafka.server.log.remote.quota.RLMQuotaManagerConfig;
import org.apache.kafka.server.log.remote.quota.RLMQuotaMetrics;
import org.apache.kafka.server.log.remote.storage.ClassLoaderAwareRemoteStorageManager;
import org.apache.kafka.server.log.remote.storage.CustomMetadataSizeLimitExceededException;
import org.apache.kafka.server.log.remote.storage.LogSegmentData;
import org.apache.kafka.server.log.remote.storage.RemoteLogManagerConfig;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.apache.kafka.server.log.remote.storage.RemoteStorageException;
import org.apache.kafka.server.log.remote.storage.RemoteStorageManager;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.purgatory.DelayedOperationPurgatory;
import org.apache.kafka.server.purgatory.TopicPartitionOperationKey;
import org.apache.kafka.server.quota.QuotaType;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.AsyncOffsetReadFutureHolder;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchedTimestampAndOffset;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.storage.internals.log.OffsetResultHolder;
import org.apache.kafka.storage.internals.log.RemoteIndexCache;
import org.apache.kafka.storage.internals.log.RemoteLogReadResult;
import org.apache.kafka.storage.internals.log.RemoteStorageFetchInfo;
import org.apache.kafka.storage.internals.log.RemoteStorageThreadPool;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.storage.internals.log.TxnIndexSearchResult;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class RemoteLogManager
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteLogManager.class);
    private static final String REMOTE_LOG_READER_THREAD_NAME_PATTERN = "remote-log-reader-%d";
    private final RemoteLogManagerConfig rlmConfig;
    private final int brokerId;
    private final String logDir;
    private final Time time;
    private final Function<TopicPartition, Optional<MergedLog>> fetchLog;
    private final BiConsumer<TopicPartition, Long> updateRemoteLogStartOffset;
    private final BrokerTopicStats brokerTopicStats;
    private final Metrics metrics;
    private final RemoteStorageManager remoteLogStorageManager;
    private final RemoteLogMetadataManager remoteLogMetadataManager;
    private final ReentrantLock copyQuotaManagerLock = new ReentrantLock(true);
    private final Condition copyQuotaManagerLockCondition = this.copyQuotaManagerLock.newCondition();
    private final RLMQuotaManager rlmCopyQuotaManager;
    private final RLMQuotaManager rlmFetchQuotaManager;
    private final Sensor fetchThrottleTimeSensor;
    private final Sensor copyThrottleTimeSensor;
    private final RemoteIndexCache indexCache;
    private final RemoteStorageThreadPool remoteStorageReaderThreadPool;
    private final RLMScheduledThreadPool rlmCopyThreadPool;
    private final RLMScheduledThreadPool rlmExpirationThreadPool;
    private final RLMScheduledThreadPool followerThreadPool;
    private final long delayInMs;
    private final ConcurrentHashMap<TopicIdPartition, RLMTaskWithFuture> leaderCopyRLMTasks = new ConcurrentHashMap();
    private final ConcurrentHashMap<TopicIdPartition, RLMTaskWithFuture> leaderExpirationRLMTasks = new ConcurrentHashMap();
    private final ConcurrentHashMap<TopicIdPartition, RLMTaskWithFuture> followerRLMTasks = new ConcurrentHashMap();
    private final Set<RemoteLogSegmentId> segmentIdsBeingCopied = ConcurrentHashMap.newKeySet();
    private final ConcurrentMap<TopicPartition, Uuid> topicIdByPartitionMap = new ConcurrentHashMap<TopicPartition, Uuid>();
    private final String clusterId;
    private final KafkaMetricsGroup metricsGroup = new KafkaMetricsGroup(this.getClass());
    private Optional<Endpoint> endpoint = Optional.empty();
    private boolean closed = false;
    private volatile boolean remoteLogManagerConfigured = false;
    private final Timer remoteReadTimer;
    private volatile DelayedOperationPurgatory<DelayedRemoteListOffsets> delayedRemoteListOffsetsPurgatory;

    public RemoteLogManager(RemoteLogManagerConfig rlmConfig, int brokerId, String logDir, String clusterId, Time time, Function<TopicPartition, Optional<MergedLog>> fetchLog, BiConsumer<TopicPartition, Long> updateRemoteLogStartOffset, BrokerTopicStats brokerTopicStats, Metrics metrics) throws IOException {
        this.rlmConfig = rlmConfig;
        this.brokerId = brokerId;
        this.logDir = logDir;
        this.clusterId = clusterId;
        this.time = time;
        this.fetchLog = fetchLog;
        this.updateRemoteLogStartOffset = updateRemoteLogStartOffset;
        this.brokerTopicStats = brokerTopicStats;
        this.metrics = metrics;
        this.remoteLogStorageManager = this.createRemoteStorageManager();
        this.remoteLogMetadataManager = this.createRemoteLogMetadataManager();
        this.rlmCopyQuotaManager = this.createRLMCopyQuotaManager();
        this.rlmFetchQuotaManager = this.createRLMFetchQuotaManager();
        this.fetchThrottleTimeSensor = new RLMQuotaMetrics(metrics, "remote-fetch-throttle-time", RemoteLogManager.class.getSimpleName(), "The %s time in millis remote fetches was throttled by a broker", 3600L).sensor();
        this.copyThrottleTimeSensor = new RLMQuotaMetrics(metrics, "remote-copy-throttle-time", RemoteLogManager.class.getSimpleName(), "The %s time in millis remote copies was throttled by a broker", 3600L).sensor();
        this.indexCache = new RemoteIndexCache(rlmConfig.remoteLogIndexFileCacheTotalSizeBytes(), this.remoteLogStorageManager, logDir);
        this.delayInMs = rlmConfig.remoteLogManagerTaskIntervalMs();
        this.rlmCopyThreadPool = new RLMScheduledThreadPool(rlmConfig.remoteLogManagerCopierThreadPoolSize(), "RLMCopyThreadPool", "kafka-rlm-copy-thread-pool-%d");
        this.rlmExpirationThreadPool = new RLMScheduledThreadPool(rlmConfig.remoteLogManagerExpirationThreadPoolSize(), "RLMExpirationThreadPool", "kafka-rlm-expiration-thread-pool-%d");
        this.followerThreadPool = new RLMScheduledThreadPool(rlmConfig.remoteLogManagerThreadPoolSize(), "RLMFollowerScheduledThreadPool", "kafka-rlm-follower-thread-pool-%d");
        this.metricsGroup.newGauge(RemoteStorageMetrics.REMOTE_LOG_MANAGER_TASKS_AVG_IDLE_PERCENT_METRIC, this.rlmCopyThreadPool::getIdlePercent);
        this.remoteReadTimer = this.metricsGroup.newTimer(RemoteStorageMetrics.REMOTE_LOG_READER_FETCH_RATE_AND_TIME_METRIC, TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
        this.remoteStorageReaderThreadPool = new RemoteStorageThreadPool(REMOTE_LOG_READER_THREAD_NAME_PATTERN, rlmConfig.remoteLogReaderThreads(), rlmConfig.remoteLogReaderMaxPendingTasks());
    }

    public void setDelayedOperationPurgatory(DelayedOperationPurgatory<DelayedRemoteListOffsets> delayedRemoteListOffsetsPurgatory) {
        this.delayedRemoteListOffsetsPurgatory = delayedRemoteListOffsetsPurgatory;
    }

    public void resizeCacheSize(long remoteLogIndexFileCacheSize) {
        this.indexCache.resizeCacheSize(remoteLogIndexFileCacheSize);
    }

    public void updateCopyQuota(long quota) {
        LOGGER.info("Updating remote copy quota to {} bytes per second", (Object)quota);
        this.rlmCopyQuotaManager.updateQuota(new Quota(quota, true));
    }

    public void updateFetchQuota(long quota) {
        LOGGER.info("Updating remote fetch quota to {} bytes per second", (Object)quota);
        this.rlmFetchQuotaManager.updateQuota(new Quota(quota, true));
    }

    public void resizeCopierThreadPool(int newSize) {
        int currentSize = this.rlmCopyThreadPool.getCorePoolSize();
        LOGGER.info("Updating remote copy thread pool size from {} to {}", (Object)currentSize, (Object)newSize);
        this.rlmCopyThreadPool.setCorePoolSize(newSize);
    }

    public void resizeExpirationThreadPool(int newSize) {
        int currentSize = this.rlmExpirationThreadPool.getCorePoolSize();
        LOGGER.info("Updating remote expiration thread pool size from {} to {}", (Object)currentSize, (Object)newSize);
        this.rlmExpirationThreadPool.setCorePoolSize(newSize);
    }

    public void resizeReaderThreadPool(int newSize) {
        int currentSize = this.remoteStorageReaderThreadPool.getCorePoolSize();
        int currentMaximumSize = this.remoteStorageReaderThreadPool.getMaximumPoolSize();
        LOGGER.info("Updating remote reader thread pool size from {} to {}", (Object)currentSize, (Object)newSize);
        if (newSize > currentMaximumSize) {
            this.remoteStorageReaderThreadPool.setMaximumPoolSize(newSize);
            this.remoteStorageReaderThreadPool.setCorePoolSize(newSize);
        } else {
            this.remoteStorageReaderThreadPool.setCorePoolSize(newSize);
            this.remoteStorageReaderThreadPool.setMaximumPoolSize(newSize);
        }
    }

    private void removeMetrics() {
        this.metricsGroup.removeMetric(RemoteStorageMetrics.REMOTE_LOG_MANAGER_TASKS_AVG_IDLE_PERCENT_METRIC);
        this.metricsGroup.removeMetric(RemoteStorageMetrics.REMOTE_LOG_READER_FETCH_RATE_AND_TIME_METRIC);
        this.remoteStorageReaderThreadPool.removeMetrics();
    }

    int readerThreadPoolSize() {
        return this.remoteStorageReaderThreadPool.getCorePoolSize();
    }

    Duration quotaTimeout() {
        return Duration.ofSeconds(1L);
    }

    RLMQuotaManager createRLMCopyQuotaManager() {
        return new RLMQuotaManager(RemoteLogManager.copyQuotaManagerConfig(this.rlmConfig), this.metrics, QuotaType.RLM_COPY, "Tracking copy byte-rate for Remote Log Manager", this.time);
    }

    RLMQuotaManager createRLMFetchQuotaManager() {
        return new RLMQuotaManager(RemoteLogManager.fetchQuotaManagerConfig(this.rlmConfig), this.metrics, QuotaType.RLM_FETCH, "Tracking fetch byte-rate for Remote Log Manager", this.time);
    }

    public long getFetchThrottleTimeMs() {
        return this.rlmFetchQuotaManager.getThrottleTimeMs();
    }

    public Sensor fetchThrottleTimeSensor() {
        return this.fetchThrottleTimeSensor;
    }

    static RLMQuotaManagerConfig copyQuotaManagerConfig(RemoteLogManagerConfig rlmConfig) {
        return new RLMQuotaManagerConfig(rlmConfig.remoteLogManagerCopyMaxBytesPerSecond(), rlmConfig.remoteLogManagerCopyNumQuotaSamples(), rlmConfig.remoteLogManagerCopyQuotaWindowSizeSeconds());
    }

    static RLMQuotaManagerConfig fetchQuotaManagerConfig(RemoteLogManagerConfig rlmConfig) {
        return new RLMQuotaManagerConfig(rlmConfig.remoteLogManagerFetchMaxBytesPerSecond(), rlmConfig.remoteLogManagerFetchNumQuotaSamples(), rlmConfig.remoteLogManagerFetchQuotaWindowSizeSeconds());
    }

    private <T> T createDelegate(ClassLoader classLoader, String className) {
        try {
            return (T)classLoader.loadClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new KafkaException(e);
        }
    }

    RemoteStorageManager createRemoteStorageManager() {
        return SecurityManagerCompatibility.get().doPrivileged(() -> {
            String classPath = this.rlmConfig.remoteStorageManagerClassPath();
            if (classPath != null && !classPath.trim().isEmpty()) {
                ChildFirstClassLoader classLoader = new ChildFirstClassLoader(classPath, this.getClass().getClassLoader());
                RemoteStorageManager delegate = (RemoteStorageManager)this.createDelegate(classLoader, this.rlmConfig.remoteStorageManagerClassName());
                return new ClassLoaderAwareRemoteStorageManager(delegate, classLoader);
            }
            return (RemoteStorageManager)this.createDelegate(this.getClass().getClassLoader(), this.rlmConfig.remoteStorageManagerClassName());
        });
    }

    private void configureRSM() {
        HashMap<String, Object> rsmProps = new HashMap<String, Object>(this.rlmConfig.remoteStorageManagerProps());
        rsmProps.put("broker.id", this.brokerId);
        this.remoteLogStorageManager.configure(rsmProps);
    }

    RemoteLogMetadataManager createRemoteLogMetadataManager() {
        return SecurityManagerCompatibility.get().doPrivileged(() -> {
            String classPath = this.rlmConfig.remoteLogMetadataManagerClassPath();
            if (classPath != null && !classPath.trim().isEmpty()) {
                ChildFirstClassLoader classLoader = new ChildFirstClassLoader(classPath, this.getClass().getClassLoader());
                RemoteLogMetadataManager delegate = (RemoteLogMetadataManager)this.createDelegate(classLoader, this.rlmConfig.remoteLogMetadataManagerClassName());
                return new ClassLoaderAwareRemoteLogMetadataManager(delegate, classLoader);
            }
            return (RemoteLogMetadataManager)this.createDelegate(this.getClass().getClassLoader(), this.rlmConfig.remoteLogMetadataManagerClassName());
        });
    }

    public void onEndPointCreated(Endpoint endpoint) {
        this.endpoint = Optional.of(endpoint);
    }

    private void configureRLMM() {
        HashMap<String, Object> rlmmProps = new HashMap<String, Object>();
        this.endpoint.ifPresent(e -> {
            rlmmProps.put("remote.log.metadata.common.client.bootstrap.servers", e.host() + ":" + e.port());
            rlmmProps.put("remote.log.metadata.common.client.security.protocol", e.securityProtocol().name);
        });
        rlmmProps.putAll(this.rlmConfig.remoteLogMetadataManagerProps());
        rlmmProps.put("broker.id", this.brokerId);
        rlmmProps.put("log.dir", this.logDir);
        rlmmProps.put("cluster.id", this.clusterId);
        this.remoteLogMetadataManager.configure(rlmmProps);
    }

    public void startup() {
        this.configureRSM();
        this.configureRLMM();
        this.remoteLogManagerConfigured = true;
    }

    private boolean isRemoteLogManagerConfigured() {
        return this.remoteLogManagerConfigured;
    }

    public RemoteStorageManager storageManager() {
        return this.remoteLogStorageManager;
    }

    private Stream<Partition> filterPartitions(Set<Partition> partitions) {
        return partitions.stream().filter(partition -> partition.log().exists(AbstractLog::remoteLogEnabled));
    }

    private void cacheTopicPartitionIds(TopicIdPartition topicIdPartition) {
        Uuid previousTopicId = this.topicIdByPartitionMap.put(topicIdPartition.topicPartition(), topicIdPartition.topicId());
        if (previousTopicId != null && !previousTopicId.equals(topicIdPartition.topicId())) {
            LOGGER.info("Previous cached topic id {} for {} does not match updated topic id {}", previousTopicId, topicIdPartition.topicPartition(), topicIdPartition.topicId());
        }
    }

    public void onLeadershipChange(Set<Partition> partitionsBecomeLeader, Set<Partition> partitionsBecomeFollower, Map<String, Uuid> topicIds) {
        LOGGER.debug("Received leadership changes for leaders: {} and followers: {}", (Object)partitionsBecomeLeader, (Object)partitionsBecomeFollower);
        if (this.rlmConfig.isRemoteStorageSystemEnabled() && !this.isRemoteLogManagerConfigured()) {
            throw new KafkaException("RemoteLogManager is not configured when remote storage system is enabled");
        }
        Map<TopicIdPartition, Boolean> leaderPartitions = this.filterPartitions(partitionsBecomeLeader).collect(Collectors.toMap(p -> new TopicIdPartition((Uuid)topicIds.get(p.topic()), p.topicPartition()), p -> p.log().exists(log -> log.config().remoteLogCopyDisable())));
        Map<TopicIdPartition, Boolean> followerPartitions = this.filterPartitions(partitionsBecomeFollower).collect(Collectors.toMap(p -> new TopicIdPartition((Uuid)topicIds.get(p.topic()), p.topicPartition()), p -> p.log().exists(log -> log.config().remoteLogCopyDisable())));
        if (!leaderPartitions.isEmpty() || !followerPartitions.isEmpty()) {
            LOGGER.debug("Effective topic partitions after filtering compact and internal topics, leaders: {} and followers: {}", (Object)leaderPartitions, (Object)followerPartitions);
            leaderPartitions.forEach((tp, __) -> this.cacheTopicPartitionIds((TopicIdPartition)tp));
            followerPartitions.forEach((tp, __) -> this.cacheTopicPartitionIds((TopicIdPartition)tp));
            this.remoteLogMetadataManager.onPartitionLeadershipChanges(leaderPartitions.keySet(), followerPartitions.keySet());
            followerPartitions.forEach((tp, __) -> this.doHandleFollowerPartition((TopicIdPartition)tp));
            followerPartitions.forEach((tp, __) -> this.removeRemoteTopicPartitionMetrics((TopicIdPartition)tp));
            leaderPartitions.forEach(this::doHandleLeaderPartition);
        }
    }

    public void stopLeaderCopyRLMTasks(Set<Partition> partitions) {
        for (Partition partition : partitions) {
            TopicPartition tp = partition.topicPartition();
            if (!this.topicIdByPartitionMap.containsKey(tp)) continue;
            TopicIdPartition tpId = new TopicIdPartition((Uuid)this.topicIdByPartitionMap.get(tp), tp);
            this.leaderCopyRLMTasks.computeIfPresent(tpId, (topicIdPartition, task) -> {
                LOGGER.info("Cancelling the copy RLM task for partition: {}", (Object)tpId);
                task.cancel();
                LOGGER.info("Resetting remote copy lag metrics for partition: {}", (Object)tpId);
                ((RLMCopyTask)task.rlmTask).resetLagStats();
                return null;
            });
        }
    }

    public void stopPartitions(Set<StopPartition> stopPartitions, BiConsumer<TopicPartition, Throwable> errorHandler) {
        LOGGER.debug("Stop partitions: {}", (Object)stopPartitions);
        for (StopPartition stopPartition : stopPartitions) {
            TopicPartition tp = stopPartition.topicPartition;
            try {
                if (this.topicIdByPartitionMap.containsKey(tp)) {
                    TopicIdPartition tpId2 = new TopicIdPartition((Uuid)this.topicIdByPartitionMap.get(tp), tp);
                    this.leaderCopyRLMTasks.computeIfPresent(tpId2, (topicIdPartition, task) -> {
                        LOGGER.info("Cancelling the copy RLM task for partition: {}", (Object)tpId2);
                        task.cancel();
                        return null;
                    });
                    this.leaderExpirationRLMTasks.computeIfPresent(tpId2, (topicIdPartition, task) -> {
                        LOGGER.info("Cancelling the expiration RLM task for partition: {}", (Object)tpId2);
                        task.cancel();
                        return null;
                    });
                    this.followerRLMTasks.computeIfPresent(tpId2, (topicIdPartition, task) -> {
                        LOGGER.info("Cancelling the follower RLM task for partition: {}", (Object)tpId2);
                        task.cancel();
                        return null;
                    });
                    this.removeRemoteTopicPartitionMetrics(tpId2);
                    if (!stopPartition.deleteRemoteLog) continue;
                    LOGGER.info("Deleting the remote log segments task for partition: {}", (Object)tpId2);
                    this.deleteRemoteLogPartition(tpId2);
                    continue;
                }
                LOGGER.warn("StopPartition call is not expected for partition: {}", (Object)tp);
            }
            catch (Exception ex) {
                errorHandler.accept(tp, ex);
                LOGGER.error("Error while stopping the partition: {}", (Object)stopPartition, (Object)ex);
            }
        }
        Set<TopicIdPartition> pendingActionsPartitions = stopPartitions.stream().filter(sp2 -> (sp2.stopRemoteLogMetadataManager || sp2.deleteLocalLog) && this.topicIdByPartitionMap.containsKey(sp2.topicPartition)).map(sp2 -> new TopicIdPartition((Uuid)this.topicIdByPartitionMap.get(sp2.topicPartition), sp2.topicPartition)).collect(Collectors.toSet());
        if (!pendingActionsPartitions.isEmpty()) {
            pendingActionsPartitions.forEach(tpId -> this.topicIdByPartitionMap.remove(tpId.topicPartition()));
            this.remoteLogMetadataManager.onStopPartitions(pendingActionsPartitions);
        }
    }

    private void deleteRemoteLogPartition(TopicIdPartition partition) throws RemoteStorageException, ExecutionException, InterruptedException {
        ArrayList metadataList = new ArrayList();
        this.remoteLogMetadataManager.listRemoteLogSegments(partition).forEachRemaining(metadataList::add);
        List<RemoteLogSegmentMetadataUpdate> deleteSegmentStartedEvents = metadataList.stream().map(metadata -> new RemoteLogSegmentMetadataUpdate(metadata.remoteLogSegmentId(), this.time.milliseconds(), metadata.customMetadata(), RemoteLogSegmentState.DELETE_SEGMENT_STARTED, this.brokerId)).collect(Collectors.toList());
        this.publishEvents(deleteSegmentStartedEvents).get();
        ArrayList<Uuid> deletedSegmentIds = new ArrayList<Uuid>();
        for (RemoteLogSegmentMetadata metadata2 : metadataList) {
            deletedSegmentIds.add(metadata2.remoteLogSegmentId().id());
            this.remoteLogStorageManager.deleteLogSegmentData(metadata2);
        }
        this.indexCache.removeAll(deletedSegmentIds);
        List<RemoteLogSegmentMetadataUpdate> deleteSegmentFinishedEvents = metadataList.stream().map(metadata -> new RemoteLogSegmentMetadataUpdate(metadata.remoteLogSegmentId(), this.time.milliseconds(), metadata.customMetadata(), RemoteLogSegmentState.DELETE_SEGMENT_FINISHED, this.brokerId)).collect(Collectors.toList());
        this.publishEvents(deleteSegmentFinishedEvents).get();
    }

    private CompletableFuture<Void> publishEvents(List<RemoteLogSegmentMetadataUpdate> events) throws RemoteStorageException {
        ArrayList<CompletableFuture<Void>> result = new ArrayList<CompletableFuture<Void>>();
        for (RemoteLogSegmentMetadataUpdate event : events) {
            result.add(this.remoteLogMetadataManager.updateRemoteLogSegmentMetadata(event));
        }
        return CompletableFuture.allOf(result.toArray(new CompletableFuture[0]));
    }

    public Optional<RemoteLogSegmentMetadata> fetchRemoteLogSegmentMetadata(TopicPartition topicPartition, int epochForOffset, long offset) throws RemoteStorageException {
        Uuid topicId = (Uuid)this.topicIdByPartitionMap.get(topicPartition);
        if (topicId == null) {
            throw new KafkaException("No topic id registered for topic partition: " + String.valueOf(topicPartition));
        }
        return this.remoteLogMetadataManager.remoteLogSegmentMetadata(new TopicIdPartition(topicId, topicPartition), epochForOffset, offset);
    }

    public Optional<RemoteLogSegmentMetadata> fetchNextSegmentWithTxnIndex(TopicPartition topicPartition, int epochForOffset, long offset) throws RemoteStorageException {
        Uuid topicId = (Uuid)this.topicIdByPartitionMap.get(topicPartition);
        if (topicId == null) {
            throw new KafkaException("No topic id registered for topic partition: " + String.valueOf(topicPartition));
        }
        TopicIdPartition tpId = new TopicIdPartition(topicId, topicPartition);
        return this.remoteLogMetadataManager.nextSegmentWithTxnIndex(tpId, epochForOffset, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Optional<FileRecords.FileTimestampAndOffset> lookupTimestamp(RemoteLogSegmentMetadata rlsMetadata, long timestamp, long startingOffset) throws RemoteStorageException, IOException {
        int startPos = this.indexCache.lookupTimestamp(rlsMetadata, timestamp, startingOffset);
        InputStream remoteSegInputStream = null;
        try {
            CloseableIterator<Record> recordStreamingIterator;
            remoteSegInputStream = this.remoteLogStorageManager.fetchLogSegment(rlsMetadata, startPos);
            RemoteLogInputStream remoteLogInputStream = new RemoteLogInputStream(remoteSegInputStream);
            while (true) {
                RecordBatch batch;
                if ((batch = remoteLogInputStream.nextBatch()) != null) {
                    if (batch.maxTimestamp() < timestamp || batch.lastOffset() < startingOffset) continue;
                } else {
                    Optional<FileRecords.FileTimestampAndOffset> optional = Optional.empty();
                    Utils.closeQuietly(remoteSegInputStream, "RemoteLogSegmentInputStream");
                    return optional;
                }
                recordStreamingIterator = batch.streamingIterator(BufferSupplier.NO_CACHING);
                while (true) {
                    block12: {
                        Optional<FileRecords.FileTimestampAndOffset> optional;
                        block13: {
                            if (!recordStreamingIterator.hasNext()) break;
                            Record record = (Record)recordStreamingIterator.next();
                            if (record.timestamp() < timestamp || record.offset() < startingOffset) break block12;
                            optional = Optional.of(new FileRecords.FileTimestampAndOffset(record.timestamp(), record.offset(), this.maybeLeaderEpoch(batch.partitionLeaderEpoch())));
                            if (recordStreamingIterator == null) break block13;
                            recordStreamingIterator.close();
                        }
                        Utils.closeQuietly(remoteSegInputStream, "RemoteLogSegmentInputStream");
                        return optional;
                    }
                    continue;
                    break;
                }
                if (recordStreamingIterator == null) continue;
                recordStreamingIterator.close();
            }
            catch (Throwable throwable) {
                if (recordStreamingIterator == null) throw throwable;
                try {
                    recordStreamingIterator.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(remoteSegInputStream, "RemoteLogSegmentInputStream");
            throw throwable;
        }
    }

    private Optional<Integer> maybeLeaderEpoch(int leaderEpoch) {
        return leaderEpoch == -1 ? Optional.empty() : Optional.of(leaderEpoch);
    }

    public AsyncOffsetReadFutureHolder<OffsetResultHolder.FileRecordsOrError> asyncOffsetRead(TopicPartition topicPartition, Long timestamp, Long startingOffset, LeaderEpochFileCache leaderEpochCache, Supplier<Option<FileRecords.FileTimestampAndOffset>> searchLocalLog) {
        CompletableFuture taskFuture = new CompletableFuture();
        Future<Void> jobFuture = this.remoteStorageReaderThreadPool.submit(new RemoteLogOffsetReader(this, topicPartition, timestamp, startingOffset, leaderEpochCache, searchLocalLog, result -> {
            TopicPartitionOperationKey key = new TopicPartitionOperationKey(topicPartition.topic(), topicPartition.partition());
            taskFuture.complete(result);
            this.delayedRemoteListOffsetsPurgatory.checkAndComplete(key);
        }));
        return new AsyncOffsetReadFutureHolder<OffsetResultHolder.FileRecordsOrError>(jobFuture, taskFuture);
    }

    public Optional<FileRecords.FileTimestampAndOffset> findOffsetByTimestamp(TopicPartition tp, long timestamp, long startingOffset, LeaderEpochFileCache leaderEpochCache) throws RemoteStorageException, IOException {
        Uuid topicId = (Uuid)this.topicIdByPartitionMap.get(tp);
        if (topicId == null) {
            throw new KafkaException("Topic id does not exist for topic partition: " + String.valueOf(tp));
        }
        Optional<MergedLog> unifiedLogOptional = this.fetchLog.apply(tp);
        if (!unifiedLogOptional.isPresent()) {
            throw new KafkaException("UnifiedLog does not exist for topic partition: " + String.valueOf(tp));
        }
        MergedLog unifiedLog = unifiedLogOptional.get();
        OptionalInt maybeEpoch = leaderEpochCache.epochForOffset(startingOffset);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, tp);
        NavigableMap<Integer, Long> epochWithOffsets = RemoteLogManager.buildFilteredLeaderEpochMap(leaderEpochCache.epochWithOffsets());
        while (maybeEpoch.isPresent()) {
            int epoch = maybeEpoch.getAsInt();
            Iterator<RemoteLogSegmentMetadata> iterator = this.remoteLogMetadataManager.listRemoteLogSegments(topicIdPartition, epoch);
            while (iterator.hasNext()) {
                RemoteLogSegmentMetadata rlsMetadata = iterator.next();
                if (rlsMetadata.maxTimestampMs() < timestamp || rlsMetadata.endOffset() < startingOffset || !RemoteLogManager.isRemoteSegmentWithinLeaderEpochs(rlsMetadata, unifiedLog.logEndOffset(), epochWithOffsets) || !rlsMetadata.state().equals((Object)RemoteLogSegmentState.COPY_SEGMENT_FINISHED)) continue;
                ConcurrentNavigableMap logSegments = MergedLog.logSegments(new ConcurrentSkipListMap(), startingOffset, unifiedLog.logEndOffset());
                ArrayList segmentsList = new ArrayList(logSegments.values());
                if (segmentsList.isEmpty() || rlsMetadata.startOffset() < ((LogSegment)segmentsList.get(0)).baseOffset()) {
                    return this.lookupTimestamp(rlsMetadata, timestamp, startingOffset);
                }
                for (LogSegment segment : segmentsList) {
                    if (segment.largestTimestamp() < timestamp) continue;
                    Optional<FetchedTimestampAndOffset> fetchedTimestampAndOffset = segment.findOffsetByTimestamp(timestamp, startingOffset);
                    return Optional.of(new FileRecords.FileTimestampAndOffset(fetchedTimestampAndOffset.get().timestamp(), fetchedTimestampAndOffset.get().offset(), fetchedTimestampAndOffset.get().leaderEpoch()));
                }
            }
            maybeEpoch = leaderEpochCache.nextEpoch(epoch);
        }
        return Optional.empty();
    }

    List<EpochEntry> getLeaderEpochEntries(MergedLog log, long startOffset, long endOffset) {
        return log.leaderEpochCache().epochEntriesInRange(startOffset, endOffset);
    }

    RLMTask rlmCopyTask(TopicIdPartition topicIdPartition) {
        RLMTaskWithFuture task = this.leaderCopyRLMTasks.get(topicIdPartition);
        if (task != null) {
            return task.rlmTask;
        }
        return null;
    }

    private boolean deleteRemoteLogSegment(RemoteLogSegmentMetadata segmentMetadata, Predicate<RemoteLogSegmentMetadata> predicate) throws RemoteStorageException, ExecutionException, InterruptedException {
        if (predicate.test(segmentMetadata)) {
            LOGGER.debug("Deleting remote log segment {}", (Object)segmentMetadata.remoteLogSegmentId());
            String topic = segmentMetadata.topicIdPartition().topic();
            this.remoteLogMetadataManager.updateRemoteLogSegmentMetadata(new RemoteLogSegmentMetadataUpdate(segmentMetadata.remoteLogSegmentId(), this.time.milliseconds(), segmentMetadata.customMetadata(), RemoteLogSegmentState.DELETE_SEGMENT_STARTED, this.brokerId)).get();
            this.brokerTopicStats.topicStats(topic).remoteDeleteRequestRate().mark();
            this.brokerTopicStats.allTopicsStats().remoteDeleteRequestRate().mark();
            try {
                this.remoteLogStorageManager.deleteLogSegmentData(segmentMetadata);
            }
            catch (RemoteStorageException e) {
                this.brokerTopicStats.topicStats(topic).failedRemoteDeleteRequestRate().mark();
                this.brokerTopicStats.allTopicsStats().failedRemoteDeleteRequestRate().mark();
                throw e;
            }
            this.remoteLogMetadataManager.updateRemoteLogSegmentMetadata(new RemoteLogSegmentMetadataUpdate(segmentMetadata.remoteLogSegmentId(), this.time.milliseconds(), segmentMetadata.customMetadata(), RemoteLogSegmentState.DELETE_SEGMENT_FINISHED, this.brokerId)).get();
            LOGGER.debug("Deleted remote log segment {}", (Object)segmentMetadata.remoteLogSegmentId());
            return true;
        }
        return false;
    }

    static boolean isRemoteSegmentWithinLeaderEpochs(RemoteLogSegmentMetadata segmentMetadata, long logEndOffset, NavigableMap<Integer, Long> leaderEpochs) {
        long segmentEndOffset = segmentMetadata.endOffset();
        NavigableMap<Integer, Long> segmentLeaderEpochs = RemoteLogManager.buildFilteredLeaderEpochMap(segmentMetadata.segmentLeaderEpochs());
        Integer segmentLastEpoch = (Integer)segmentLeaderEpochs.lastKey();
        if (segmentLastEpoch < (Integer)leaderEpochs.firstKey() || segmentLastEpoch > (Integer)leaderEpochs.lastKey()) {
            LOGGER.debug("Segment {} is not within the partition leader epoch lineage. Remote segment epochs: {} and partition leader epochs: {}", segmentMetadata.remoteLogSegmentId(), segmentLeaderEpochs, leaderEpochs);
            return false;
        }
        Integer segmentFirstEpoch = segmentLeaderEpochs.ceilingKey((Integer)leaderEpochs.firstKey());
        if (segmentFirstEpoch == null) {
            LOGGER.debug("Segment {} is not within the partition leader epoch lineage. Remote segment epochs: {} and partition leader epochs: {}", segmentMetadata.remoteLogSegmentId(), segmentLeaderEpochs, leaderEpochs);
            return false;
        }
        for (Map.Entry entry : segmentLeaderEpochs.entrySet()) {
            Map.Entry<Integer, Long> nextEntry;
            int epoch = (Integer)entry.getKey();
            long offset = (Long)entry.getValue();
            if (epoch < segmentFirstEpoch) continue;
            if (!leaderEpochs.containsKey(epoch)) {
                LOGGER.debug("Segment {} epoch {} is not within the leader epoch lineage. Remote segment epochs: {} and partition leader epochs: {}", segmentMetadata.remoteLogSegmentId(), epoch, segmentLeaderEpochs, leaderEpochs);
                return false;
            }
            if (epoch == segmentFirstEpoch && leaderEpochs.lowerKey(epoch) != null && offset < (Long)leaderEpochs.get(epoch)) {
                LOGGER.debug("Segment {} first-valid epoch {} offset is less than first leader epoch offset {}.Remote segment epochs: {} and partition leader epochs: {}", segmentMetadata.remoteLogSegmentId(), epoch, leaderEpochs.get(epoch), segmentLeaderEpochs, leaderEpochs);
                return false;
            }
            if (epoch == segmentLastEpoch && (nextEntry = leaderEpochs.higherEntry(epoch)) != null && segmentEndOffset > nextEntry.getValue() - 1L) {
                LOGGER.debug("Segment {} end offset {} is more than leader epoch offset {}.Remote segment epochs: {} and partition leader epochs: {}", segmentMetadata.remoteLogSegmentId(), segmentEndOffset, nextEntry.getValue() - 1L, segmentLeaderEpochs, leaderEpochs);
                return false;
            }
            if (epoch == segmentLastEpoch || leaderEpochs.higherEntry(epoch).equals(segmentLeaderEpochs.higherEntry(epoch))) continue;
            LOGGER.debug("Segment {} epoch {} is not within the leader epoch lineage. Remote segment epochs: {} and partition leader epochs: {}", segmentMetadata.remoteLogSegmentId(), epoch, segmentLeaderEpochs, leaderEpochs);
            return false;
        }
        if (segmentEndOffset >= logEndOffset) {
            LOGGER.debug("Segment {} end offset {} is more than log end offset {}.", segmentMetadata.remoteLogSegmentId(), segmentEndOffset, logEndOffset);
            return false;
        }
        return true;
    }

    static NavigableMap<Integer, Long> buildFilteredLeaderEpochMap(NavigableMap<Integer, Long> leaderEpochs) {
        ArrayList<Integer> epochsWithNoMessages = new ArrayList<Integer>();
        Map.Entry previousEpochAndOffset = null;
        for (Map.Entry currentEpochAndOffset : leaderEpochs.entrySet()) {
            if (previousEpochAndOffset != null && ((Long)previousEpochAndOffset.getValue()).equals(currentEpochAndOffset.getValue())) {
                epochsWithNoMessages.add((Integer)previousEpochAndOffset.getKey());
            }
            previousEpochAndOffset = currentEpochAndOffset;
        }
        if (epochsWithNoMessages.isEmpty()) {
            return leaderEpochs;
        }
        TreeMap<Integer, Long> filteredLeaderEpochs = new TreeMap<Integer, Long>((SortedMap<Integer, Long>)leaderEpochs);
        for (Integer epochWithNoMessage : epochsWithNoMessages) {
            filteredLeaderEpochs.remove(epochWithNoMessage);
        }
        return filteredLeaderEpochs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FetchDataInfo read(RemoteStorageFetchInfo remoteStorageFetchInfo) throws RemoteStorageException, IOException {
        FetchDataInfo fetchDataInfo;
        block14: {
            int firstBatchSize;
            RecordBatch firstBatch;
            InputStream remoteSegInputStream;
            EnrichedRecordBatch enrichedRecordBatch;
            RemoteLogSegmentMetadata remoteLogSegmentMetadata;
            Optional<MergedLog> logOptional;
            int maxBytes;
            boolean includeAbortedTxns;
            block12: {
                FetchDataInfo fetchDataInfo2;
                block13: {
                    long offset;
                    block10: {
                        FetchDataInfo fetchDataInfo3;
                        block11: {
                            Optional<Object> rlsMetadataOptional;
                            int fetchMaxBytes = remoteStorageFetchInfo.fetchMaxBytes;
                            TopicPartition tp = remoteStorageFetchInfo.topicPartition;
                            FetchRequest.PartitionData fetchInfo = remoteStorageFetchInfo.fetchInfo;
                            includeAbortedTxns = remoteStorageFetchInfo.fetchIsolation == FetchIsolation.TXN_COMMITTED;
                            offset = fetchInfo.fetchOffset;
                            maxBytes = Math.min(fetchMaxBytes, fetchInfo.maxBytes);
                            logOptional = this.fetchLog.apply(tp);
                            OptionalInt epoch = OptionalInt.empty();
                            if (logOptional.isPresent()) {
                                LeaderEpochFileCache leaderEpochCache = logOptional.get().leaderEpochCache();
                                epoch = leaderEpochCache.epochForOffset(offset);
                            }
                            Optional<Object> optional = rlsMetadataOptional = epoch.isPresent() ? this.fetchRemoteLogSegmentMetadata(tp, epoch.getAsInt(), offset) : Optional.empty();
                            if (rlsMetadataOptional.isEmpty()) {
                                String epochStr = epoch.isPresent() ? Integer.toString(epoch.getAsInt()) : "NOT AVAILABLE";
                                throw new OffsetOutOfRangeException("Received request for offset " + offset + " for leader epoch " + epochStr + " and partition " + String.valueOf(tp) + " which does not exist in remote tier.");
                            }
                            remoteLogSegmentMetadata = (RemoteLogSegmentMetadata)rlsMetadataOptional.get();
                            enrichedRecordBatch = new EnrichedRecordBatch(null, 0);
                            remoteSegInputStream = null;
                            try {
                                int startPos = 0;
                                while (enrichedRecordBatch.batch == null && rlsMetadataOptional.isPresent()) {
                                    remoteLogSegmentMetadata = (RemoteLogSegmentMetadata)rlsMetadataOptional.get();
                                    startPos = this.lookupPositionForOffset(remoteLogSegmentMetadata, offset);
                                    remoteSegInputStream = this.remoteLogStorageManager.fetchLogSegment(remoteLogSegmentMetadata, startPos);
                                    RemoteLogInputStream remoteLogInputStream = this.getRemoteLogInputStream(remoteSegInputStream);
                                    enrichedRecordBatch = this.findFirstBatch(remoteLogInputStream, offset);
                                    if (enrichedRecordBatch.batch != null) continue;
                                    Utils.closeQuietly(remoteSegInputStream, "RemoteLogSegmentInputStream");
                                    rlsMetadataOptional = this.findNextSegmentMetadata((RemoteLogSegmentMetadata)rlsMetadataOptional.get(), logOptional.get().leaderEpochCache());
                                }
                                firstBatch = enrichedRecordBatch.batch;
                                if (firstBatch != null) break block10;
                                fetchDataInfo3 = new FetchDataInfo(new LogOffsetMetadata(offset), MemoryRecords.EMPTY, false, includeAbortedTxns ? Optional.of(Collections.emptyList()) : Optional.empty());
                                if (enrichedRecordBatch.batch == null) break block11;
                            }
                            catch (Throwable throwable) {
                                if (enrichedRecordBatch.batch != null) {
                                    Utils.closeQuietly(remoteSegInputStream, "RemoteLogSegmentInputStream");
                                }
                                throw throwable;
                            }
                            Utils.closeQuietly(remoteSegInputStream, "RemoteLogSegmentInputStream");
                        }
                        return fetchDataInfo3;
                    }
                    firstBatchSize = firstBatch.sizeInBytes();
                    if (remoteStorageFetchInfo.minOneMessage || remoteStorageFetchInfo.hardMaxBytesLimit || firstBatchSize <= maxBytes) break block12;
                    fetchDataInfo2 = new FetchDataInfo(new LogOffsetMetadata(offset), MemoryRecords.EMPTY);
                    if (enrichedRecordBatch.batch == null) break block13;
                    Utils.closeQuietly(remoteSegInputStream, "RemoteLogSegmentInputStream");
                }
                return fetchDataInfo2;
            }
            int updatedFetchSize = remoteStorageFetchInfo.minOneMessage && firstBatchSize > maxBytes ? firstBatchSize : maxBytes;
            ByteBuffer buffer = ByteBuffer.allocate(updatedFetchSize);
            int remainingBytes = updatedFetchSize;
            firstBatch.writeTo(buffer);
            if ((remainingBytes -= firstBatchSize) > 0) {
                Utils.readFully(remoteSegInputStream, buffer, false);
            }
            buffer.flip();
            FetchDataInfo fetchDataInfo4 = new FetchDataInfo(new LogOffsetMetadata(firstBatch.baseOffset(), remoteLogSegmentMetadata.startOffset(), startPos += enrichedRecordBatch.skippedBytes), MemoryRecords.readableRecords(buffer));
            if (includeAbortedTxns) {
                fetchDataInfo4 = this.addAbortedTransactions(firstBatch.baseOffset(), remoteLogSegmentMetadata, fetchDataInfo4, logOptional.get());
            }
            fetchDataInfo = fetchDataInfo4;
            if (enrichedRecordBatch.batch == null) break block14;
            Utils.closeQuietly(remoteSegInputStream, "RemoteLogSegmentInputStream");
        }
        return fetchDataInfo;
    }

    RemoteLogInputStream getRemoteLogInputStream(InputStream in) {
        return new RemoteLogInputStream(in);
    }

    int lookupPositionForOffset(RemoteLogSegmentMetadata remoteLogSegmentMetadata, long offset) {
        return this.indexCache.lookupOffset(remoteLogSegmentMetadata, offset);
    }

    private FetchDataInfo addAbortedTransactions(long startOffset, RemoteLogSegmentMetadata segmentMetadata, FetchDataInfo fetchInfo, MergedLog log) throws RemoteStorageException {
        int fetchSize = fetchInfo.records.sizeInBytes();
        OffsetPosition startOffsetPosition = new OffsetPosition(fetchInfo.fetchOffsetMetadata.messageOffset, fetchInfo.fetchOffsetMetadata.relativePositionInSegment);
        OffsetIndex offsetIndex = this.indexCache.getIndexEntry(segmentMetadata).offsetIndex();
        long upperBoundOffset = offsetIndex.fetchUpperBoundOffset(startOffsetPosition, fetchSize).map(position -> position.offset).orElse(segmentMetadata.endOffset() + 1L);
        HashSet abortedTransactions = new HashSet();
        Consumer<List<AbortedTxn>> accumulator = abortedTxns -> abortedTransactions.addAll(abortedTxns.stream().map(AbortedTxn::asAbortedTransaction).collect(Collectors.toList()));
        long startTimeNs = this.time.nanoseconds();
        this.collectAbortedTransactions(startOffset, upperBoundOffset, segmentMetadata, accumulator, log);
        LOGGER.debug("Time taken to collect: {} aborted transactions for {} in {} ns", abortedTransactions.size(), segmentMetadata, this.time.nanoseconds() - startTimeNs);
        return new FetchDataInfo(fetchInfo.fetchOffsetMetadata, fetchInfo.records, fetchInfo.firstEntryIncomplete, Optional.of(abortedTransactions.isEmpty() ? Collections.emptyList() : new ArrayList(abortedTransactions)));
    }

    private void collectAbortedTransactions(long startOffset, long upperBoundOffset, RemoteLogSegmentMetadata segmentMetadata, Consumer<List<AbortedTxn>> accumulator, MergedLog log) throws RemoteStorageException {
        TopicPartition tp = segmentMetadata.topicIdPartition().topicPartition();
        boolean isSearchComplete = false;
        LeaderEpochFileCache leaderEpochCache = log.leaderEpochCache();
        Optional<RemoteLogSegmentMetadata> currentMetadataOpt = Optional.of(segmentMetadata);
        while (!isSearchComplete && currentMetadataOpt.isPresent()) {
            RemoteLogSegmentMetadata currentMetadata = currentMetadataOpt.get();
            Optional<TransactionIndex> txnIndexOpt = this.getTransactionIndex(currentMetadata);
            if (txnIndexOpt.isPresent()) {
                TransactionIndex txnIndex = txnIndexOpt.get();
                TxnIndexSearchResult searchResult = txnIndex.collectAbortedTxns(startOffset, upperBoundOffset);
                accumulator.accept(searchResult.abortedTransactions);
                isSearchComplete = searchResult.isComplete;
            }
            if (isSearchComplete) continue;
            currentMetadataOpt = this.findNextSegmentWithTxnIndex(tp, currentMetadata.endOffset() + 1L, leaderEpochCache);
        }
        if (!isSearchComplete) {
            this.collectAbortedTransactionInLocalSegments(startOffset, upperBoundOffset, accumulator, log.localLogSegments().iterator());
        }
    }

    private Optional<TransactionIndex> getTransactionIndex(RemoteLogSegmentMetadata currentMetadata) {
        return !currentMetadata.isTxnIdxEmpty() ? Optional.ofNullable(this.indexCache.getIndexEntry(currentMetadata).txnIndex()) : Optional.empty();
    }

    private void collectAbortedTransactionInLocalSegments(long startOffset, long upperBoundOffset, Consumer<List<AbortedTxn>> accumulator, Iterator<LogSegment> localLogSegments) {
        while (localLogSegments.hasNext()) {
            TransactionIndex txnIndex = localLogSegments.next().txnIndex();
            if (txnIndex == null) continue;
            TxnIndexSearchResult searchResult = txnIndex.collectAbortedTxns(startOffset, upperBoundOffset);
            accumulator.accept(searchResult.abortedTransactions);
            if (!searchResult.isComplete) continue;
            return;
        }
    }

    Optional<RemoteLogSegmentMetadata> findNextSegmentMetadata(RemoteLogSegmentMetadata segmentMetadata, LeaderEpochFileCache leaderEpochFileCacheOption) throws RemoteStorageException {
        long nextSegmentBaseOffset = segmentMetadata.endOffset() + 1L;
        OptionalInt epoch = leaderEpochFileCacheOption.epochForOffset(nextSegmentBaseOffset);
        return epoch.isPresent() ? this.fetchRemoteLogSegmentMetadata(segmentMetadata.topicIdPartition().topicPartition(), epoch.getAsInt(), nextSegmentBaseOffset) : Optional.empty();
    }

    Optional<RemoteLogSegmentMetadata> findNextSegmentWithTxnIndex(TopicPartition tp, long offset, LeaderEpochFileCache leaderEpochCache) throws RemoteStorageException {
        OptionalInt initialEpochOpt = leaderEpochCache.epochForOffset(offset);
        if (initialEpochOpt.isEmpty()) {
            return Optional.empty();
        }
        int initialEpoch = initialEpochOpt.getAsInt();
        for (EpochEntry epochEntry : leaderEpochCache.epochEntries()) {
            long startOffset;
            Optional<RemoteLogSegmentMetadata> metadataOpt;
            if (epochEntry.epoch < initialEpoch || !(metadataOpt = this.fetchNextSegmentWithTxnIndex(tp, epochEntry.epoch, startOffset = Math.max(epochEntry.startOffset, offset))).isPresent()) continue;
            return metadataOpt;
        }
        return Optional.empty();
    }

    EnrichedRecordBatch findFirstBatch(RemoteLogInputStream remoteLogInputStream, long offset) throws IOException {
        int skippedBytes = 0;
        RecordBatch nextBatch = null;
        do {
            if (nextBatch == null) continue;
            skippedBytes += nextBatch.sizeInBytes();
        } while ((nextBatch = remoteLogInputStream.nextBatch()) != null && nextBatch.lastOffset() < offset);
        return new EnrichedRecordBatch(nextBatch, skippedBytes);
    }

    OffsetAndEpoch findHighestRemoteOffset(TopicIdPartition topicIdPartition, MergedLog log) throws RemoteStorageException {
        OffsetAndEpoch offsetAndEpoch = null;
        LeaderEpochFileCache leaderEpochCache = log.leaderEpochCache();
        Optional<EpochEntry> maybeEpochEntry = leaderEpochCache.latestEntry();
        while (offsetAndEpoch == null && maybeEpochEntry.isPresent()) {
            int epoch = maybeEpochEntry.get().epoch;
            Optional<Long> highestRemoteOffsetOpt = this.remoteLogMetadataManager.highestOffsetForEpoch(topicIdPartition, epoch);
            if (highestRemoteOffsetOpt.isPresent()) {
                long highestRemoteOffset;
                Map.Entry<Integer, Long> entry = leaderEpochCache.endOffsetFor(epoch, log.logEndOffset());
                int requestedEpoch = entry.getKey();
                long endOffset = entry.getValue();
                if (endOffset <= (highestRemoteOffset = highestRemoteOffsetOpt.get().longValue())) {
                    LOGGER.info("The end-offset for epoch {}: ({}, {}) is less than or equal to the highest-remote-offset: {} for partition: {}", epoch, requestedEpoch, endOffset, highestRemoteOffset, topicIdPartition);
                    offsetAndEpoch = new OffsetAndEpoch(endOffset - 1L, requestedEpoch);
                } else {
                    offsetAndEpoch = new OffsetAndEpoch(highestRemoteOffset, epoch);
                }
            }
            maybeEpochEntry = leaderEpochCache.previousEntry(epoch);
        }
        if (offsetAndEpoch == null) {
            offsetAndEpoch = new OffsetAndEpoch(-1L, -1);
        }
        return offsetAndEpoch;
    }

    long findLogStartOffset(TopicIdPartition topicIdPartition, MergedLog log) throws RemoteStorageException {
        Optional<Long> logStartOffset = Optional.empty();
        LeaderEpochFileCache leaderEpochCache = log.leaderEpochCache();
        OptionalInt earliestEpochOpt = leaderEpochCache.earliestEntry().map(epochEntry -> OptionalInt.of(epochEntry.epoch)).orElseGet(OptionalInt::empty);
        while (logStartOffset.isEmpty() && earliestEpochOpt.isPresent()) {
            Iterator<RemoteLogSegmentMetadata> iterator = this.remoteLogMetadataManager.listRemoteLogSegments(topicIdPartition, earliestEpochOpt.getAsInt());
            if (iterator.hasNext()) {
                logStartOffset = Optional.of(iterator.next().startOffset());
            }
            earliestEpochOpt = leaderEpochCache.nextEpoch(earliestEpochOpt.getAsInt());
        }
        return logStartOffset.orElseGet(log::localLogStartOffset);
    }

    public Future<Void> asyncRead(RemoteStorageFetchInfo fetchInfo, Consumer<RemoteLogReadResult> callback) {
        return this.remoteStorageReaderThreadPool.submit(new RemoteLogReader(fetchInfo, this, callback, this.brokerTopicStats, this.rlmFetchQuotaManager, this.remoteReadTimer));
    }

    void doHandleLeaderPartition(TopicIdPartition topicPartition, Boolean remoteLogCopyDisable) {
        RLMTaskWithFuture followerRLMTaskWithFuture = this.followerRLMTasks.remove(topicPartition);
        if (followerRLMTaskWithFuture != null) {
            LOGGER.info("Cancelling the follower task: {}", (Object)followerRLMTaskWithFuture.rlmTask);
            followerRLMTaskWithFuture.cancel();
        }
        if (!remoteLogCopyDisable.booleanValue()) {
            this.leaderCopyRLMTasks.computeIfAbsent(topicPartition, topicIdPartition -> {
                RLMCopyTask task = new RLMCopyTask((TopicIdPartition)topicIdPartition, this.rlmConfig.remoteLogMetadataCustomMetadataMaxBytes());
                LOGGER.info("Created a new copy task: {} and getting scheduled", (Object)task);
                ScheduledFuture<?> future = this.rlmCopyThreadPool.scheduleWithFixedDelay(task, 0L, this.delayInMs, TimeUnit.MILLISECONDS);
                return new RLMTaskWithFuture(task, future);
            });
        }
        this.leaderExpirationRLMTasks.computeIfAbsent(topicPartition, topicIdPartition -> {
            RLMExpirationTask task = new RLMExpirationTask((TopicIdPartition)topicIdPartition);
            LOGGER.info("Created a new expiration task: {} and getting scheduled", (Object)task);
            ScheduledFuture<?> future = this.rlmExpirationThreadPool.scheduleWithFixedDelay(task, 0L, this.delayInMs, TimeUnit.MILLISECONDS);
            return new RLMTaskWithFuture(task, future);
        });
    }

    void doHandleFollowerPartition(TopicIdPartition topicPartition) {
        RLMTaskWithFuture expirationRLMTaskWithFuture;
        RLMTaskWithFuture copyRLMTaskWithFuture = this.leaderCopyRLMTasks.remove(topicPartition);
        if (copyRLMTaskWithFuture != null) {
            LOGGER.info("Cancelling the copy task: {}", (Object)copyRLMTaskWithFuture.rlmTask);
            copyRLMTaskWithFuture.cancel();
        }
        if ((expirationRLMTaskWithFuture = this.leaderExpirationRLMTasks.remove(topicPartition)) != null) {
            LOGGER.info("Cancelling the expiration task: {}", (Object)expirationRLMTaskWithFuture.rlmTask);
            expirationRLMTaskWithFuture.cancel();
        }
        this.followerRLMTasks.computeIfAbsent(topicPartition, topicIdPartition -> {
            RLMFollowerTask task = new RLMFollowerTask((TopicIdPartition)topicIdPartition);
            LOGGER.info("Created a new follower task: {} and getting scheduled", (Object)task);
            ScheduledFuture<?> future = this.followerThreadPool.scheduleWithFixedDelay(task, 0L, this.delayInMs, TimeUnit.MILLISECONDS);
            return new RLMTaskWithFuture(task, future);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RemoteLogManager remoteLogManager = this;
        synchronized (remoteLogManager) {
            if (!this.closed) {
                this.leaderCopyRLMTasks.values().forEach(RLMTaskWithFuture::cancel);
                this.leaderExpirationRLMTasks.values().forEach(RLMTaskWithFuture::cancel);
                this.followerRLMTasks.values().forEach(RLMTaskWithFuture::cancel);
                Utils.closeQuietly(this.remoteLogStorageManager, "RemoteLogStorageManager");
                Utils.closeQuietly(this.remoteLogMetadataManager, "RemoteLogMetadataManager");
                Utils.closeQuietly(this.indexCache, "RemoteIndexCache");
                this.rlmCopyThreadPool.close();
                this.rlmExpirationThreadPool.close();
                this.followerThreadPool.close();
                try {
                    RemoteLogManager.shutdownAndAwaitTermination(this.remoteStorageReaderThreadPool, "RemoteStorageReaderThreadPool", 10L, TimeUnit.SECONDS);
                }
                finally {
                    this.removeMetrics();
                }
                this.leaderCopyRLMTasks.clear();
                this.leaderExpirationRLMTasks.clear();
                this.followerRLMTasks.clear();
                this.closed = true;
            }
        }
    }

    private static void shutdownAndAwaitTermination(ExecutorService executor, String poolName, long timeout, TimeUnit timeUnit) {
        LOGGER.info("Shutting down {} executor", (Object)poolName);
        ThreadUtils.shutdownExecutorServiceQuietly(executor, timeout, timeUnit);
        LOGGER.info("{} executor shutdown completed", (Object)poolName);
    }

    static ByteBuffer epochEntriesAsByteBuffer(List<EpochEntry> epochEntries) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));){
            CheckpointFile.CheckpointWriteBuffer<EpochEntry> writeBuffer = new CheckpointFile.CheckpointWriteBuffer<EpochEntry>(writer, 0, LeaderEpochCheckpointFile.FORMATTER);
            writeBuffer.write(epochEntries);
            writer.flush();
        }
        return ByteBuffer.wrap(stream.toByteArray());
    }

    private void removeRemoteTopicPartitionMetrics(TopicIdPartition topicIdPartition) {
        String topic = topicIdPartition.topic();
        if (!this.brokerTopicStats.isTopicStatsExisted(topicIdPartition.topic())) {
            this.brokerTopicStats.removeBrokerLevelRemoteCopyLagBytes(topic);
            this.brokerTopicStats.removeBrokerLevelRemoteCopyLagSegments(topic);
            this.brokerTopicStats.removeBrokerLevelRemoteDeleteLagBytes(topic);
            this.brokerTopicStats.removeBrokerLevelRemoteDeleteLagSegments(topic);
            this.brokerTopicStats.removeBrokerLevelRemoteLogMetadataCount(topic);
            this.brokerTopicStats.removeBrokerLevelRemoteLogSizeComputationTime(topic);
            this.brokerTopicStats.removeBrokerLevelRemoteLogSizeBytes(topic);
        } else {
            int partition = topicIdPartition.partition();
            this.brokerTopicStats.removeRemoteCopyLagBytes(topic, partition);
            this.brokerTopicStats.removeRemoteCopyLagSegments(topic, partition);
            this.brokerTopicStats.removeRemoteDeleteLagBytes(topic, partition);
            this.brokerTopicStats.removeRemoteDeleteLagSegments(topic, partition);
            this.brokerTopicStats.removeRemoteLogMetadataCount(topic, partition);
            this.brokerTopicStats.removeRemoteLogSizeComputationTime(topic, partition);
            this.brokerTopicStats.removeRemoteLogSizeBytes(topic, partition);
        }
    }

    RLMTaskWithFuture leaderCopyTask(TopicIdPartition partition) {
        return this.leaderCopyRLMTasks.get(partition);
    }

    RLMTaskWithFuture leaderExpirationTask(TopicIdPartition partition) {
        return this.leaderExpirationRLMTasks.get(partition);
    }

    RLMTaskWithFuture followerTask(TopicIdPartition partition) {
        return this.followerRLMTasks.get(partition);
    }

    static class RLMScheduledThreadPool {
        private static final Logger LOGGER = LoggerFactory.getLogger(RLMScheduledThreadPool.class);
        private final String threadPoolName;
        private final String threadNamePattern;
        private final ScheduledThreadPoolExecutor scheduledThreadPool;

        public RLMScheduledThreadPool(int poolSize, String threadPoolName, String threadNamePattern) {
            this.threadPoolName = threadPoolName;
            this.threadNamePattern = threadNamePattern;
            this.scheduledThreadPool = this.createPool(poolSize);
        }

        public void setCorePoolSize(int newSize) {
            this.scheduledThreadPool.setCorePoolSize(newSize);
        }

        public int getCorePoolSize() {
            return this.scheduledThreadPool.getCorePoolSize();
        }

        private ScheduledThreadPoolExecutor createPool(int poolSize) {
            ThreadFactory threadFactory = ThreadUtils.createThreadFactory(this.threadNamePattern, true, (t, e) -> LOGGER.error("Uncaught exception in thread '{}':", (Object)t.getName(), (Object)e));
            ScheduledThreadPoolExecutor threadPool = new ScheduledThreadPoolExecutor(poolSize);
            threadPool.setRemoveOnCancelPolicy(true);
            threadPool.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            threadPool.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            threadPool.setThreadFactory(threadFactory);
            return threadPool;
        }

        public Double getIdlePercent() {
            return 1.0 - (double)this.scheduledThreadPool.getActiveCount() / (double)this.scheduledThreadPool.getCorePoolSize();
        }

        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long initialDelay, long delay, TimeUnit timeUnit) {
            LOGGER.info("Scheduling runnable {} with initial delay: {}, fixed delay: {}", runnable, initialDelay, delay);
            return this.scheduledThreadPool.scheduleWithFixedDelay(runnable, initialDelay, delay, timeUnit);
        }

        public void close() {
            RemoteLogManager.shutdownAndAwaitTermination(this.scheduledThreadPool, this.threadPoolName, 10L, TimeUnit.SECONDS);
        }
    }

    static class RLMTaskWithFuture {
        private final RLMTask rlmTask;
        private final Future<?> future;

        RLMTaskWithFuture(RLMTask rlmTask, Future<?> future) {
            this.rlmTask = rlmTask;
            this.future = future;
        }

        public void cancel() {
            this.rlmTask.cancel();
            try {
                this.future.cancel(true);
            }
            catch (Exception ex) {
                LOGGER.error("Error occurred while canceling the task: {}", (Object)this.rlmTask, (Object)ex);
            }
        }
    }

    abstract class RLMTask
    extends CancellableRunnable {
        protected final TopicIdPartition topicIdPartition;
        private final Logger logger;

        public RLMTask(TopicIdPartition topicIdPartition) {
            this.topicIdPartition = topicIdPartition;
            this.logger = this.getLogContext().logger(RLMTask.class);
        }

        protected LogContext getLogContext() {
            return new LogContext("[RemoteLogManager=" + RemoteLogManager.this.brokerId + " partition=" + String.valueOf(this.topicIdPartition) + "] ");
        }

        @Override
        public void run() {
            block8: {
                if (this.isCancelled()) {
                    this.logger.debug("Skipping the current run for partition {} as it is cancelled", (Object)this.topicIdPartition);
                    return;
                }
                if (!RemoteLogManager.this.remoteLogMetadataManager.isReady(this.topicIdPartition)) {
                    this.logger.debug("Skipping the current run for partition {} as the remote-log metadata is not ready", (Object)this.topicIdPartition);
                    return;
                }
                try {
                    Optional<MergedLog> unifiedLogOptional = RemoteLogManager.this.fetchLog.apply(this.topicIdPartition.topicPartition());
                    if (unifiedLogOptional.isEmpty()) {
                        return;
                    }
                    this.execute(unifiedLogOptional.get());
                }
                catch (InterruptedException ex) {
                    if (!this.isCancelled()) {
                        this.logger.warn("Current thread for partition {} is interrupted", (Object)this.topicIdPartition, (Object)ex);
                    }
                }
                catch (RetriableException ex) {
                    this.logger.debug("Encountered a retryable error while executing current task for partition {}", (Object)this.topicIdPartition, (Object)ex);
                }
                catch (Exception ex) {
                    if (this.isCancelled()) break block8;
                    this.logger.warn("Current task for partition {} received error but it will be scheduled", (Object)this.topicIdPartition, (Object)ex);
                }
            }
        }

        protected abstract void execute(MergedLog var1) throws InterruptedException, RemoteStorageException, ExecutionException;

        public String toString() {
            return String.valueOf(this.getClass()) + "[" + String.valueOf(this.topicIdPartition) + "]";
        }
    }

    static class EnrichedRecordBatch {
        private final RecordBatch batch;
        private final int skippedBytes;

        public EnrichedRecordBatch(RecordBatch batch, int skippedBytes) {
            this.batch = batch;
            this.skippedBytes = skippedBytes;
        }
    }

    class RLMFollowerTask
    extends RLMTask {
        public RLMFollowerTask(TopicIdPartition topicIdPartition) {
            super(topicIdPartition);
        }

        @Override
        protected void execute(MergedLog log) throws InterruptedException, RemoteStorageException, ExecutionException {
            OffsetAndEpoch offsetAndEpoch = RemoteLogManager.this.findHighestRemoteOffset(this.topicIdPartition, log);
            log.updateHighestOffsetInRemoteStorage(offsetAndEpoch.offset());
        }
    }

    class RLMExpirationTask
    extends RLMTask {
        private final Logger logger;

        public RLMExpirationTask(TopicIdPartition topicIdPartition) {
            super(topicIdPartition);
            this.logger = this.getLogContext().logger(RLMExpirationTask.class);
        }

        @Override
        protected void execute(MergedLog log) throws InterruptedException, RemoteStorageException, ExecutionException {
            this.cleanupExpiredRemoteLogSegments();
        }

        public void handleLogStartOffsetUpdate(TopicPartition topicPartition, long remoteLogStartOffset) {
            this.logger.debug("Updating {} with remoteLogStartOffset: {}", (Object)topicPartition, (Object)remoteLogStartOffset);
            RemoteLogManager.this.updateRemoteLogStartOffset.accept(topicPartition, remoteLogStartOffset);
        }

        private void updateMetadataCountAndLogSizeWith(int metadataCount, long remoteLogSizeBytes) {
            int partition = this.topicIdPartition.partition();
            String topic = this.topicIdPartition.topic();
            RemoteLogManager.this.brokerTopicStats.recordRemoteLogMetadataCount(topic, partition, metadataCount);
            RemoteLogManager.this.brokerTopicStats.recordRemoteLogSizeBytes(topic, partition, remoteLogSizeBytes);
        }

        private void updateRemoteDeleteLagWith(int segmentsLeftToDelete, long sizeOfDeletableSegmentsBytes) {
            String topic = this.topicIdPartition.topic();
            int partition = this.topicIdPartition.partition();
            RemoteLogManager.this.brokerTopicStats.recordRemoteDeleteLagSegments(topic, partition, segmentsLeftToDelete);
            RemoteLogManager.this.brokerTopicStats.recordRemoteDeleteLagBytes(topic, partition, sizeOfDeletableSegmentsBytes);
        }

        void cleanupExpiredRemoteLogSegments() throws RemoteStorageException, ExecutionException, InterruptedException {
            Optional<EpochEntry> earliestEpochEntryOptional;
            if (this.isCancelled()) {
                this.logger.info("Returning from remote log segments cleanup as the task state is changed");
                return;
            }
            Optional<MergedLog> logOptional = RemoteLogManager.this.fetchLog.apply(this.topicIdPartition.topicPartition());
            if (logOptional.isEmpty()) {
                this.logger.debug("No UnifiedLog instance available for partition: {}", (Object)this.topicIdPartition);
                return;
            }
            MergedLog log = logOptional.get();
            Iterator<RemoteLogSegmentMetadata> segmentMetadataIter = RemoteLogManager.this.remoteLogMetadataManager.listRemoteLogSegments(this.topicIdPartition);
            if (!segmentMetadataIter.hasNext()) {
                this.updateMetadataCountAndLogSizeWith(0, 0L);
                this.logger.debug("No remote log segments available on remote storage for partition: {}", (Object)this.topicIdPartition);
                return;
            }
            HashSet epochsSet = new HashSet();
            int metadataCount = 0;
            long remoteLogSizeBytes = 0L;
            while (segmentMetadataIter.hasNext()) {
                RemoteLogSegmentMetadata segmentMetadata = segmentMetadataIter.next();
                epochsSet.addAll(segmentMetadata.segmentLeaderEpochs().keySet());
                ++metadataCount;
                remoteLogSizeBytes += (long)segmentMetadata.segmentSizeInBytes();
            }
            this.updateMetadataCountAndLogSizeWith(metadataCount, remoteLogSizeBytes);
            ArrayList remoteLeaderEpochs = new ArrayList(epochsSet);
            Collections.sort(remoteLeaderEpochs);
            LeaderEpochFileCache leaderEpochCache = log.leaderEpochCache();
            NavigableMap<Integer, Long> epochWithOffsets = RemoteLogManager.buildFilteredLeaderEpochMap(leaderEpochCache.epochWithOffsets());
            long logStartOffset = log.logStartOffset();
            long logEndOffset = log.logEndOffset();
            Optional<RetentionSizeData> retentionSizeData = this.buildRetentionSizeData(log.config().retentionSize, log.onlyLocalLogSegmentsSize(), logEndOffset, epochWithOffsets);
            Optional<RetentionTimeData> retentionTimeData = this.buildRetentionTimeData(log.config().retentionMs);
            RemoteLogRetentionHandler remoteLogRetentionHandler = new RemoteLogRetentionHandler(retentionSizeData, retentionTimeData);
            Iterator<Integer> epochIterator = epochWithOffsets.navigableKeySet().iterator();
            boolean canProcess = true;
            ArrayList<Object> segmentsToDelete = new ArrayList<Object>();
            long sizeOfDeletableSegmentsBytes = 0L;
            while (canProcess && epochIterator.hasNext()) {
                Integer epoch = epochIterator.next();
                Iterator<RemoteLogSegmentMetadata> segmentsIterator = RemoteLogManager.this.remoteLogMetadataManager.listRemoteLogSegments(this.topicIdPartition, epoch);
                while (canProcess && segmentsIterator.hasNext()) {
                    if (this.isCancelled()) {
                        this.logger.info("Returning from remote log segments cleanup for the remaining segments as the task state is changed.");
                        return;
                    }
                    RemoteLogSegmentMetadata metadata = segmentsIterator.next();
                    if (RemoteLogManager.this.segmentIdsBeingCopied.contains(metadata.remoteLogSegmentId())) {
                        this.logger.debug("Copy for the segment {} is currently in process. Skipping cleanup for it and the remaining segments", (Object)metadata.remoteLogSegmentId());
                        canProcess = false;
                        continue;
                    }
                    if (RemoteLogSegmentState.DELETE_SEGMENT_STARTED.equals((Object)metadata.state())) {
                        segmentsToDelete.add(metadata);
                        continue;
                    }
                    if (RemoteLogSegmentState.DELETE_SEGMENT_FINISHED.equals((Object)metadata.state()) || segmentsToDelete.contains(metadata)) continue;
                    boolean bl = remoteLogRetentionHandler.isSegmentBreachByLogStartOffset(metadata, logStartOffset, epochWithOffsets);
                    boolean isValidSegment = false;
                    if (!bl && (isValidSegment = RemoteLogManager.isRemoteSegmentWithinLeaderEpochs(metadata, logEndOffset, epochWithOffsets))) {
                        boolean bl2 = bl = remoteLogRetentionHandler.isSegmentBreachedByRetentionTime(metadata) || remoteLogRetentionHandler.isSegmentBreachedByRetentionSize(metadata);
                    }
                    if (bl) {
                        segmentsToDelete.add(metadata);
                        sizeOfDeletableSegmentsBytes += (long)metadata.segmentSizeInBytes();
                    }
                    canProcess = bl || !isValidSegment;
                }
            }
            remoteLogRetentionHandler.logStartOffset.ifPresent(offset -> this.handleLogStartOffsetUpdate(this.topicIdPartition.topicPartition(), offset));
            int segmentsLeftToDelete = segmentsToDelete.size();
            this.updateRemoteDeleteLagWith(segmentsLeftToDelete, sizeOfDeletableSegmentsBytes);
            ArrayList<String> undeletedSegments = new ArrayList<String>();
            for (RemoteLogSegmentMetadata remoteLogSegmentMetadata : segmentsToDelete) {
                if (!RemoteLogManager.this.deleteRemoteLogSegment(remoteLogSegmentMetadata, ignored -> !this.isCancelled())) {
                    undeletedSegments.add(remoteLogSegmentMetadata.remoteLogSegmentId().toString());
                    continue;
                }
                this.updateRemoteDeleteLagWith(--segmentsLeftToDelete, sizeOfDeletableSegmentsBytes -= (long)remoteLogSegmentMetadata.segmentSizeInBytes());
            }
            if (!undeletedSegments.isEmpty()) {
                this.logger.info("The following remote segments could not be deleted: {}", (Object)String.join((CharSequence)",", undeletedSegments));
            }
            if ((earliestEpochEntryOptional = leaderEpochCache.earliestEntry()).isPresent()) {
                EpochEntry epochEntry = earliestEpochEntryOptional.get();
                Iterator epochsToClean = remoteLeaderEpochs.stream().filter(remoteEpoch -> remoteEpoch < earliestEpochEntry.epoch).iterator();
                ArrayList<RemoteLogSegmentMetadata> listOfSegmentsToBeCleaned = new ArrayList<RemoteLogSegmentMetadata>();
                while (epochsToClean.hasNext()) {
                    int epoch = (Integer)epochsToClean.next();
                    Iterator<RemoteLogSegmentMetadata> segmentsToBeCleaned = RemoteLogManager.this.remoteLogMetadataManager.listRemoteLogSegments(this.topicIdPartition, epoch);
                    while (segmentsToBeCleaned.hasNext()) {
                        if (this.isCancelled()) continue;
                        RemoteLogSegmentMetadata nextSegmentMetadata = segmentsToBeCleaned.next();
                        sizeOfDeletableSegmentsBytes += (long)nextSegmentMetadata.segmentSizeInBytes();
                        listOfSegmentsToBeCleaned.add(nextSegmentMetadata);
                    }
                }
                this.updateRemoteDeleteLagWith(segmentsLeftToDelete += listOfSegmentsToBeCleaned.size(), sizeOfDeletableSegmentsBytes);
                for (RemoteLogSegmentMetadata segmentMetadata : listOfSegmentsToBeCleaned) {
                    if (this.isCancelled() || !remoteLogRetentionHandler.deleteLogSegmentsDueToLeaderEpochCacheTruncation(epochEntry, segmentMetadata)) continue;
                    this.updateRemoteDeleteLagWith(--segmentsLeftToDelete, sizeOfDeletableSegmentsBytes -= (long)segmentMetadata.segmentSizeInBytes());
                }
            }
        }

        private Optional<RetentionTimeData> buildRetentionTimeData(long retentionMs) {
            long cleanupUntilMs = RemoteLogManager.this.time.milliseconds() - retentionMs;
            return retentionMs > -1L && cleanupUntilMs >= 0L ? Optional.of(new RetentionTimeData(retentionMs, cleanupUntilMs)) : Optional.empty();
        }

        private Optional<RetentionSizeData> buildRetentionSizeData(long retentionSize, long onlyLocalLogSegmentsSize, long logEndOffset, NavigableMap<Integer, Long> epochEntries) throws RemoteStorageException {
            if (retentionSize > -1L) {
                long startTimeMs = RemoteLogManager.this.time.milliseconds();
                long remoteLogSizeBytes = 0L;
                HashSet<RemoteLogSegmentId> visitedSegmentIds = new HashSet<RemoteLogSegmentId>();
                for (Integer epoch : epochEntries.navigableKeySet()) {
                    Iterator<RemoteLogSegmentMetadata> segmentsIterator = RemoteLogManager.this.remoteLogMetadataManager.listRemoteLogSegments(this.topicIdPartition, epoch);
                    while (segmentsIterator.hasNext()) {
                        RemoteLogSegmentId segmentId;
                        RemoteLogSegmentMetadata segmentMetadata = segmentsIterator.next();
                        if (!segmentMetadata.state().equals((Object)RemoteLogSegmentState.COPY_SEGMENT_FINISHED) || visitedSegmentIds.contains(segmentId = segmentMetadata.remoteLogSegmentId()) || !RemoteLogManager.isRemoteSegmentWithinLeaderEpochs(segmentMetadata, logEndOffset, epochEntries)) continue;
                        remoteLogSizeBytes += (long)segmentMetadata.segmentSizeInBytes();
                        visitedSegmentIds.add(segmentId);
                    }
                }
                RemoteLogManager.this.brokerTopicStats.recordRemoteLogSizeComputationTime(this.topicIdPartition.topic(), this.topicIdPartition.partition(), RemoteLogManager.this.time.milliseconds() - startTimeMs);
                long totalSize = onlyLocalLogSegmentsSize + remoteLogSizeBytes;
                if (totalSize > retentionSize) {
                    long remainingBreachedSize = totalSize - retentionSize;
                    RetentionSizeData retentionSizeData = new RetentionSizeData(retentionSize, remainingBreachedSize);
                    return Optional.of(retentionSizeData);
                }
            }
            return Optional.empty();
        }

        class RemoteLogRetentionHandler {
            private final Optional<RetentionSizeData> retentionSizeData;
            private final Optional<RetentionTimeData> retentionTimeData;
            private long remainingBreachedSize;
            private OptionalLong logStartOffset = OptionalLong.empty();

            public RemoteLogRetentionHandler(Optional<RetentionSizeData> retentionSizeData, Optional<RetentionTimeData> retentionTimeData) {
                this.retentionSizeData = retentionSizeData;
                this.retentionTimeData = retentionTimeData;
                this.remainingBreachedSize = retentionSizeData.map(sizeData -> sizeData.remainingBreachedSize).orElse(0L);
            }

            private boolean isSegmentBreachedByRetentionSize(RemoteLogSegmentMetadata metadata) {
                long remainingBytes;
                boolean shouldDeleteSegment = false;
                if (this.retentionSizeData.isEmpty()) {
                    return shouldDeleteSegment;
                }
                if (this.remainingBreachedSize > 0L && (remainingBytes = this.remainingBreachedSize - (long)metadata.segmentSizeInBytes()) >= 0L) {
                    this.remainingBreachedSize = remainingBytes;
                    shouldDeleteSegment = true;
                }
                if (shouldDeleteSegment) {
                    if (this.logStartOffset.isEmpty() || this.logStartOffset.getAsLong() < metadata.endOffset() + 1L) {
                        this.logStartOffset = OptionalLong.of(metadata.endOffset() + 1L);
                    }
                    RLMExpirationTask.this.logger.info("About to delete remote log segment {} due to retention size {} breach. Log size after deletion will be {}.", metadata.remoteLogSegmentId(), this.retentionSizeData.get().retentionSize, this.remainingBreachedSize + this.retentionSizeData.get().retentionSize);
                }
                return shouldDeleteSegment;
            }

            public boolean isSegmentBreachedByRetentionTime(RemoteLogSegmentMetadata metadata) {
                boolean shouldDeleteSegment = false;
                if (this.retentionTimeData.isEmpty()) {
                    return shouldDeleteSegment;
                }
                boolean bl = shouldDeleteSegment = metadata.maxTimestampMs() <= this.retentionTimeData.get().cleanupUntilMs;
                if (shouldDeleteSegment) {
                    this.remainingBreachedSize = Math.max(0L, this.remainingBreachedSize - (long)metadata.segmentSizeInBytes());
                    if (this.logStartOffset.isEmpty() || this.logStartOffset.getAsLong() < metadata.endOffset() + 1L) {
                        this.logStartOffset = OptionalLong.of(metadata.endOffset() + 1L);
                    }
                    RLMExpirationTask.this.logger.info("About to delete remote log segment {} due to retention time {}ms breach based on the largest record timestamp in the segment", (Object)metadata.remoteLogSegmentId(), (Object)this.retentionTimeData.get().retentionMs);
                }
                return shouldDeleteSegment;
            }

            private boolean isSegmentBreachByLogStartOffset(RemoteLogSegmentMetadata metadata, long logStartOffset, NavigableMap<Integer, Long> leaderEpochEntries) {
                boolean shouldDeleteSegment = false;
                if (!leaderEpochEntries.isEmpty()) {
                    Integer firstEpoch = (Integer)leaderEpochEntries.firstKey();
                    boolean bl = shouldDeleteSegment = metadata.segmentLeaderEpochs().keySet().stream().allMatch(epoch -> epoch <= firstEpoch) && metadata.endOffset() < logStartOffset;
                }
                if (shouldDeleteSegment) {
                    RLMExpirationTask.this.logger.info("About to delete remote log segment {} due to log-start-offset {} breach. Current earliest-epoch-entry: {}, segment-end-offset: {} and segment-epochs: {}", metadata.remoteLogSegmentId(), logStartOffset, leaderEpochEntries.firstEntry(), metadata.endOffset(), metadata.segmentLeaderEpochs());
                }
                return shouldDeleteSegment;
            }

            private boolean deleteLogSegmentsDueToLeaderEpochCacheTruncation(EpochEntry earliestEpochEntry, RemoteLogSegmentMetadata metadata) throws RemoteStorageException, ExecutionException, InterruptedException {
                boolean isSegmentDeleted = RemoteLogManager.this.deleteRemoteLogSegment(metadata, ignored -> metadata.segmentLeaderEpochs().keySet().stream().allMatch(epoch -> epoch < earliestEpochEntry.epoch));
                if (isSegmentDeleted) {
                    RLMExpirationTask.this.logger.info("Deleted remote log segment {} due to leader-epoch-cache truncation. Current earliest-epoch-entry: {}, segment-end-offset: {} and segment-epochs: {}", metadata.remoteLogSegmentId(), earliestEpochEntry, metadata.endOffset(), metadata.segmentLeaderEpochs().keySet());
                }
                return isSegmentDeleted;
            }
        }
    }

    class RLMCopyTask
    extends RLMTask {
        private final int customMetadataSizeLimit;
        private final Logger logger;
        private volatile Optional<OffsetAndEpoch> copiedOffsetOption;
        private volatile boolean isLogStartOffsetUpdated;
        private volatile Optional<String> logDirectory;

        public RLMCopyTask(TopicIdPartition topicIdPartition, int customMetadataSizeLimit) {
            super(topicIdPartition);
            this.copiedOffsetOption = Optional.empty();
            this.isLogStartOffsetUpdated = false;
            this.logDirectory = Optional.empty();
            this.customMetadataSizeLimit = customMetadataSizeLimit;
            this.logger = this.getLogContext().logger(RLMCopyTask.class);
        }

        @Override
        protected void execute(MergedLog log) throws InterruptedException {
            if (!log.parentDir().equals(this.logDirectory.orElse(null))) {
                this.copiedOffsetOption = Optional.empty();
                this.isLogStartOffsetUpdated = false;
                this.logDirectory = Optional.of(log.parentDir());
            }
            this.copyLogSegmentsToRemote(log);
        }

        private void maybeUpdateLogStartOffsetOnBecomingLeader(MergedLog log) throws RemoteStorageException {
            if (!this.isLogStartOffsetUpdated) {
                long logStartOffset = RemoteLogManager.this.findLogStartOffset(this.topicIdPartition, log);
                RemoteLogManager.this.updateRemoteLogStartOffset.accept(this.topicIdPartition.topicPartition(), logStartOffset);
                this.isLogStartOffsetUpdated = true;
                this.logger.info("Found the logStartOffset: {} for partition: {} after becoming leader", (Object)logStartOffset, (Object)this.topicIdPartition);
            }
        }

        private void maybeUpdateCopiedOffset(MergedLog log) throws RemoteStorageException {
            if (this.copiedOffsetOption.isEmpty()) {
                this.copiedOffsetOption = Optional.of(RemoteLogManager.this.findHighestRemoteOffset(this.topicIdPartition, log));
                this.logger.info("Found the highest copiedRemoteOffset: {} for partition: {} after becoming leader", (Object)this.copiedOffsetOption, (Object)this.topicIdPartition);
                this.copiedOffsetOption.ifPresent(offsetAndEpoch -> log.updateHighestOffsetInRemoteStorage(offsetAndEpoch.offset()));
            }
        }

        List<EnrichedLogSegment> candidateLogSegments(MergedLog log, Long fromOffset, Long lastStableOffset) {
            ArrayList<EnrichedLogSegment> candidateLogSegments = new ArrayList<EnrichedLogSegment>();
            ArrayList<LogSegment> segments = new ArrayList<LogSegment>(log.localLogSegments(fromOffset, Long.MAX_VALUE));
            if (!segments.isEmpty()) {
                for (int idx = 1; idx < segments.size(); ++idx) {
                    LogSegment previousSeg = (LogSegment)segments.get(idx - 1);
                    LogSegment currentSeg = (LogSegment)segments.get(idx);
                    if (currentSeg.baseOffset() > lastStableOffset) continue;
                    candidateLogSegments.add(new EnrichedLogSegment(previousSeg, currentSeg.baseOffset()));
                }
            }
            return candidateLogSegments;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyLogSegmentsToRemote(MergedLog log) throws InterruptedException {
            block17: {
                if (this.isCancelled()) {
                    return;
                }
                try {
                    this.maybeUpdateLogStartOffsetOnBecomingLeader(log);
                    this.maybeUpdateCopiedOffset(log);
                    long copiedOffset = this.copiedOffsetOption.get().offset();
                    long lso = log.lastStableOffset();
                    if (lso < 0L) {
                        this.logger.warn("lastStableOffset for partition {} is {}, which should not be negative.", (Object)this.topicIdPartition, (Object)lso);
                        break block17;
                    }
                    if (lso > 0L && copiedOffset < lso) {
                        long fromOffset = Math.max(copiedOffset + 1L, log.logStartOffset());
                        List<EnrichedLogSegment> candidateLogSegments = this.candidateLogSegments(log, fromOffset, lso);
                        this.logger.debug("Candidate log segments, logStartOffset: {}, copiedOffset: {}, fromOffset: {}, lso: {} and candidateLogSegments: {}", log.logStartOffset(), copiedOffset, fromOffset, lso, candidateLogSegments);
                        if (candidateLogSegments.isEmpty()) {
                            this.logger.debug("No segments found to be copied for partition {} with copiedOffset: {} and active segment's base-offset: {}", this.topicIdPartition, copiedOffset, log.activeSegment().baseOffset());
                            break block17;
                        }
                        for (EnrichedLogSegment candidateLogSegment : candidateLogSegments) {
                            if (this.isCancelled()) {
                                this.logger.info("Skipping copying log segments as the current task state is changed, cancelled: {}", (Object)this.isCancelled());
                                return;
                            }
                            RemoteLogManager.this.copyQuotaManagerLock.lock();
                            try {
                                long throttleTimeMs = RemoteLogManager.this.rlmCopyQuotaManager.getThrottleTimeMs();
                                while (throttleTimeMs > 0L) {
                                    RemoteLogManager.this.copyThrottleTimeSensor.record((double)throttleTimeMs, RemoteLogManager.this.time.milliseconds());
                                    this.logger.debug("Quota exceeded for copying log segments, waiting for the quota to be available.");
                                    boolean ignored = RemoteLogManager.this.copyQuotaManagerLockCondition.await(RemoteLogManager.this.quotaTimeout().toMillis(), TimeUnit.MILLISECONDS);
                                    throttleTimeMs = RemoteLogManager.this.rlmCopyQuotaManager.getThrottleTimeMs();
                                }
                                RemoteLogManager.this.rlmCopyQuotaManager.record(candidateLogSegment.logSegment.log().sizeInBytes());
                                RemoteLogManager.this.copyQuotaManagerLockCondition.signalAll();
                            }
                            finally {
                                RemoteLogManager.this.copyQuotaManagerLock.unlock();
                            }
                            RemoteLogSegmentId segmentId = RemoteLogSegmentId.generateNew(this.topicIdPartition);
                            RemoteLogManager.this.segmentIdsBeingCopied.add(segmentId);
                            try {
                                this.copyLogSegment(log, candidateLogSegment.logSegment, segmentId, candidateLogSegment.nextSegmentOffset);
                            }
                            finally {
                                RemoteLogManager.this.segmentIdsBeingCopied.remove(segmentId);
                            }
                        }
                        break block17;
                    }
                    this.logger.debug("Skipping copying segments, current read-offset:{}, and LSO:{}", (Object)copiedOffset, (Object)lso);
                }
                catch (CustomMetadataSizeLimitExceededException e) {
                    RemoteLogManager.this.brokerTopicStats.topicStats(log.topicPartition().topic()).failedRemoteCopyRequestRate().mark();
                    RemoteLogManager.this.brokerTopicStats.allTopicsStats().failedRemoteCopyRequestRate().mark();
                    this.cancel();
                }
                catch (InterruptedException | RetriableException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    if (this.isCancelled()) break block17;
                    RemoteLogManager.this.brokerTopicStats.topicStats(log.topicPartition().topic()).failedRemoteCopyRequestRate().mark();
                    RemoteLogManager.this.brokerTopicStats.allTopicsStats().failedRemoteCopyRequestRate().mark();
                    this.logger.error("Error occurred while copying log segments of partition: {}", (Object)this.topicIdPartition, (Object)ex);
                }
            }
        }

        private void copyLogSegment(MergedLog log, LogSegment segment, RemoteLogSegmentId segmentId, long nextSegmentBaseOffset) throws InterruptedException, ExecutionException, RemoteStorageException, IOException, CustomMetadataSizeLimitExceededException {
            long customMetadataSize;
            Optional<RemoteLogSegmentMetadata.CustomMetadata> customMetadata;
            File logFile = segment.log().file();
            String logFileName = logFile.getName();
            this.logger.info("Copying {} to remote storage.", (Object)logFileName);
            long endOffset = nextSegmentBaseOffset - 1L;
            File producerStateSnapshotFile = log.producerStateManager().fetchSnapshot(nextSegmentBaseOffset).orElse(null);
            List<EpochEntry> epochEntries = RemoteLogManager.this.getLeaderEpochEntries(log, segment.baseOffset(), nextSegmentBaseOffset);
            HashMap<Integer, Long> segmentLeaderEpochs = new HashMap<Integer, Long>(epochEntries.size());
            epochEntries.forEach(entry -> segmentLeaderEpochs.put(entry.epoch, entry.startOffset));
            boolean isTxnIdxEmpty = segment.txnIndex().isEmpty();
            RemoteLogSegmentMetadata copySegmentStartedRlsm = new RemoteLogSegmentMetadata(segmentId, segment.baseOffset(), endOffset, segment.largestTimestamp(), RemoteLogManager.this.brokerId, RemoteLogManager.this.time.milliseconds(), segment.log().sizeInBytes(), segmentLeaderEpochs, isTxnIdxEmpty);
            RemoteLogManager.this.remoteLogMetadataManager.addRemoteLogSegmentMetadata(copySegmentStartedRlsm).get();
            ByteBuffer leaderEpochsIndex = RemoteLogManager.epochEntriesAsByteBuffer(RemoteLogManager.this.getLeaderEpochEntries(log, -1L, nextSegmentBaseOffset));
            LogSegmentData segmentData = new LogSegmentData(logFile.toPath(), this.toPathIfExists(segment.offsetIndex().file()), this.toPathIfExists(segment.timeIndex().file()), Optional.ofNullable(this.toPathIfExists(segment.txnIndex().file())), producerStateSnapshotFile.toPath(), leaderEpochsIndex);
            RemoteLogManager.this.brokerTopicStats.topicStats(log.topicPartition().topic()).remoteCopyRequestRate().mark();
            RemoteLogManager.this.brokerTopicStats.allTopicsStats().remoteCopyRequestRate().mark();
            try {
                customMetadata = RemoteLogManager.this.remoteLogStorageManager.copyLogSegmentData(copySegmentStartedRlsm, segmentData);
            }
            catch (RemoteStorageException e) {
                this.logger.info("Copy failed, cleaning segment {}", (Object)copySegmentStartedRlsm.remoteLogSegmentId());
                try {
                    RemoteLogManager.this.deleteRemoteLogSegment(copySegmentStartedRlsm, ignored -> !this.isCancelled());
                    LOGGER.info("Cleanup completed for segment {}", (Object)copySegmentStartedRlsm.remoteLogSegmentId());
                }
                catch (RemoteStorageException e1) {
                    LOGGER.info("Cleanup failed, will retry later with segment {}: {}", (Object)copySegmentStartedRlsm.remoteLogSegmentId(), (Object)e1.getMessage());
                }
                throw e;
            }
            RemoteLogSegmentMetadataUpdate copySegmentFinishedRlsm = new RemoteLogSegmentMetadataUpdate(segmentId, RemoteLogManager.this.time.milliseconds(), customMetadata, RemoteLogSegmentState.COPY_SEGMENT_FINISHED, RemoteLogManager.this.brokerId);
            if (customMetadata.isPresent() && (customMetadataSize = (long)customMetadata.get().value().length) > (long)this.customMetadataSizeLimit) {
                CustomMetadataSizeLimitExceededException e = new CustomMetadataSizeLimitExceededException();
                this.logger.info("Custom metadata size {} exceeds configured limit {}. Copying will be stopped and copied segment will be attempted to clean. Original metadata: {}", customMetadataSize, this.customMetadataSizeLimit, copySegmentStartedRlsm, e);
                RemoteLogSegmentMetadata newMetadata = copySegmentStartedRlsm.createWithUpdates(copySegmentFinishedRlsm);
                try {
                    RemoteLogManager.this.deleteRemoteLogSegment(newMetadata, ignored -> !this.isCancelled());
                    LOGGER.info("Cleanup completed for segment {}", (Object)newMetadata.remoteLogSegmentId());
                }
                catch (RemoteStorageException e1) {
                    LOGGER.info("Cleanup failed, will retry later with segment {}: {}", (Object)newMetadata.remoteLogSegmentId(), (Object)e1.getMessage());
                }
                throw e;
            }
            RemoteLogManager.this.remoteLogMetadataManager.updateRemoteLogSegmentMetadata(copySegmentFinishedRlsm).get();
            RemoteLogManager.this.brokerTopicStats.topicStats(log.topicPartition().topic()).remoteCopyBytesRate().mark(copySegmentStartedRlsm.segmentSizeInBytes());
            RemoteLogManager.this.brokerTopicStats.allTopicsStats().remoteCopyBytesRate().mark(copySegmentStartedRlsm.segmentSizeInBytes());
            int lastEpochInSegment = epochEntries.get((int)(epochEntries.size() - 1)).epoch;
            this.copiedOffsetOption = Optional.of(new OffsetAndEpoch(endOffset, lastEpochInSegment));
            log.updateHighestOffsetInRemoteStorage(endOffset);
            this.logger.info("Copied {} to remote storage with segment-id: {}", (Object)logFileName, (Object)copySegmentFinishedRlsm.remoteLogSegmentId());
            long bytesLag = log.onlyLocalLogSegmentsSize() - (long)log.activeSegment().size();
            long segmentsLag = -1L;
            this.recordLagStats(bytesLag, segmentsLag);
        }

        void recordLagStats(long bytesLag, long segmentsLag) {
            if (!this.isCancelled()) {
                String topic = this.topicIdPartition.topic();
                int partition = this.topicIdPartition.partition();
                RemoteLogManager.this.brokerTopicStats.recordRemoteCopyLagBytes(topic, partition, bytesLag);
                RemoteLogManager.this.brokerTopicStats.recordRemoteCopyLagSegments(topic, partition, segmentsLag);
            }
        }

        void resetLagStats() {
            String topic = this.topicIdPartition.topic();
            int partition = this.topicIdPartition.partition();
            RemoteLogManager.this.brokerTopicStats.recordRemoteCopyLagBytes(topic, partition, 0L);
            RemoteLogManager.this.brokerTopicStats.recordRemoteCopyLagSegments(topic, partition, 0L);
        }

        private Path toPathIfExists(File file) {
            return file.exists() ? file.toPath() : null;
        }
    }

    static class EnrichedLogSegment {
        private final LogSegment logSegment;
        private final long nextSegmentOffset;

        public EnrichedLogSegment(LogSegment logSegment, long nextSegmentOffset) {
            this.logSegment = logSegment;
            this.nextSegmentOffset = nextSegmentOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnrichedLogSegment that = (EnrichedLogSegment)o;
            return this.nextSegmentOffset == that.nextSegmentOffset && Objects.equals(this.logSegment, that.logSegment);
        }

        public int hashCode() {
            return Objects.hash(this.logSegment, this.nextSegmentOffset);
        }

        public String toString() {
            return "EnrichedLogSegment{logSegment=" + String.valueOf(this.logSegment) + ", nextSegmentOffset=" + this.nextSegmentOffset + "}";
        }
    }

    public static class RetentionTimeData {
        private final long retentionMs;
        private final long cleanupUntilMs;

        public RetentionTimeData(long retentionMs, long cleanupUntilMs) {
            if (retentionMs < 0L) {
                throw new IllegalArgumentException("retentionMs should be non negative, but it is " + retentionMs);
            }
            if (cleanupUntilMs < 0L) {
                throw new IllegalArgumentException("cleanupUntilMs should be non negative, but it is " + cleanupUntilMs);
            }
            this.retentionMs = retentionMs;
            this.cleanupUntilMs = cleanupUntilMs;
        }
    }

    public static class RetentionSizeData {
        private final long retentionSize;
        private final long remainingBreachedSize;

        public RetentionSizeData(long retentionSize, long remainingBreachedSize) {
            if (retentionSize < 0L) {
                throw new IllegalArgumentException("retentionSize should be non negative, but it is " + retentionSize);
            }
            if (remainingBreachedSize <= 0L) {
                throw new IllegalArgumentException("remainingBreachedSize should be more than zero, but it is " + remainingBreachedSize);
            }
            this.retentionSize = retentionSize;
            this.remainingBreachedSize = remainingBreachedSize;
        }
    }

    private static abstract class CancellableRunnable
    implements Runnable {
        private volatile boolean cancelled = false;

        private CancellableRunnable() {
        }

        public void cancel() {
            this.cancelled = true;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }
}

