/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.common.TenantHelpers;
import kafka.metrics.ConsumerLagEmitter$;
import kafka.metrics.ConsumerLagEmitterSummary;
import kafka.metrics.DescribedGroup;
import kafka.metrics.DescribedMember;
import kafka.metrics.MemberTopicPartition;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotCoordinatorException;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.GaugeSuite;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.View;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0011mq!B3g\u0011\u0003Yg!B7g\u0011\u0003q\u0007\"B;\u0002\t\u00031\b\"B<\u0002\t\u0003A\b\"CBJ\u0003E\u0005I\u0011ABK\u0011%\u0019Y+\u0001b\u0001\n\u0003\u0019i\u000b\u0003\u0005\u00044\u0006\u0001\u000b\u0011BBX\u0011%\u0019),\u0001b\u0001\n\u0003\u0019i\u000b\u0003\u0005\u00048\u0006\u0001\u000b\u0011BBX\u0011%\u0019I,\u0001b\u0001\n\u0003\u0019i\u000b\u0003\u0005\u0004<\u0006\u0001\u000b\u0011BBX\u0011%\u0019i,\u0001b\u0001\n\u0003\u0019i\u000b\u0003\u0005\u0004@\u0006\u0001\u000b\u0011BBX\u0011%\u0019\t-\u0001b\u0001\n\u0003\u0019i\u000b\u0003\u0005\u0004D\u0006\u0001\u000b\u0011BBX\u0011%\u0019)-\u0001b\u0001\n\u0003\u0019i\u000b\u0003\u0005\u0004H\u0006\u0001\u000b\u0011BBX\u0011%\u0019I-\u0001b\u0001\n\u0003\u0019i\u000b\u0003\u0005\u0004L\u0006\u0001\u000b\u0011BBX\u0011%\u0019i-\u0001b\u0001\n\u0003\u0019i\u000b\u0003\u0005\u0004P\u0006\u0001\u000b\u0011BBX\u0011%\u0019\t.\u0001b\u0001\n\u0003\u0019i\u000b\u0003\u0005\u0004T\u0006\u0001\u000b\u0011BBX\u0011%\u0019).\u0001b\u0001\n\u0003\u0019i\u000b\u0003\u0005\u0004X\u0006\u0001\u000b\u0011BBX\u0011%\u0019I.\u0001b\u0001\n\u0003\tI\r\u0003\u0005\u0004\\\u0006\u0001\u000b\u0011BAf\u0011%\u0019i.\u0001b\u0001\n\u0003\tI\r\u0003\u0005\u0004`\u0006\u0001\u000b\u0011BAf\u0011)\u0019\t/\u0001b\u0001\n\u0003171\u001d\u0005\t\u0007_\f\u0001\u0015!\u0003\u0004f\"I1\u0011_\u0001C\u0002\u0013%11\u001f\u0005\t\u0007s\f\u0001\u0015!\u0003\u0004v\"I11`\u0001C\u0002\u0013%1Q \u0005\t\t\u0003\t\u0001\u0015!\u0003\u0004\u0000\"IA1A\u0001C\u0002\u0013%AQ\u0001\u0005\t\t'\t\u0001\u0015!\u0003\u0005\b!IAQC\u0001C\u0002\u0013%AQ\u0001\u0005\t\t/\t\u0001\u0015!\u0003\u0005\b!IA\u0011D\u0001\u0012\u0002\u0013\u00051Q\u0013\u0004\u0005[\u001a\u0004!\u0010\u0003\u0005hQ\t\u0015\r\u0011\"\u0001|\u0011%\t\t\u0002\u000bB\u0001B\u0003%A\u0010\u0003\u0006\u0002\u0014!\u0012)\u0019!C\u0001\u0003+A!\"!\f)\u0005\u0003\u0005\u000b\u0011BA\f\u0011)\ty\u0003\u000bBC\u0002\u0013\u0005\u0011\u0011\u0007\u0005\u000b\u0003\u0007B#\u0011!Q\u0001\n\u0005M\u0002BCA#Q\t\u0015\r\u0011\"\u0001\u0002H!Q\u0011\u0011\f\u0015\u0003\u0002\u0003\u0006I!!\u0013\t\u0015\u0005m\u0003F!b\u0001\n\u0003\ti\u0006\u0003\u0006\u0002f!\u0012\t\u0011)A\u0005\u0003?B!\"a\u001a)\u0005\u000b\u0007I\u0011AA5\u0011)\tI\b\u000bB\u0001B\u0003%\u00111\u000e\u0005\u0007k\"\"\t!a\u001f\t\u0015\u0005%\u0005F1A\u0005\u0002\u0019\fY\t\u0003\u0005\u0002F\"\u0002\u000b\u0011BAG\u0011%\t9\r\u000ba\u0001\n\u0013\tI\rC\u0005\u0002R\"\u0002\r\u0011\"\u0003\u0002T\"A\u0011q\u001c\u0015!B\u0013\tY\rC\u0005\u0002j\"\u0002\r\u0011\"\u0003\u0002J\"I\u00111\u001e\u0015A\u0002\u0013%\u0011Q\u001e\u0005\t\u0003cD\u0003\u0015)\u0003\u0002L\"I\u0011Q\u001f\u0015A\u0002\u0013%\u0011\u0011\u001a\u0005\n\u0003oD\u0003\u0019!C\u0005\u0003sD\u0001\"!@)A\u0003&\u00111\u001a\u0005\n\u0005\u0003A\u0003\u0019!C\u0005\u0003\u0013D\u0011Ba\u0001)\u0001\u0004%IA!\u0002\t\u0011\t%\u0001\u0006)Q\u0005\u0003\u0017D\u0011B!\u0004)\u0001\u0004%I!!\u0018\t\u0013\t=\u0001\u00061A\u0005\n\tE\u0001\u0002\u0003B\u000bQ\u0001\u0006K!a\u0018\t\u0013\te\u0001\u00061A\u0005\n\u0005u\u0003\"\u0003B\u000eQ\u0001\u0007I\u0011\u0002B\u000f\u0011!\u0011\t\u0003\u000bQ!\n\u0005}\u0003\"\u0003B\u0013Q\u0001\u0007I\u0011BA/\u0011%\u00119\u0003\u000ba\u0001\n\u0013\u0011I\u0003\u0003\u0005\u0003.!\u0002\u000b\u0015BA0\u0011%\u0011\t\u0004\u000bb\u0001\n\u0013\u0011\u0019\u0004\u0003\u0005\u0003<!\u0002\u000b\u0011\u0002B\u001b\u0011%\u0011i\u0004\u000bb\u0001\n\u0013\u0011y\u0004\u0003\u0005\u0003H!\u0002\u000b\u0011\u0002B!\u0011%\u0011I\u0005\u000bb\u0001\n\u0003\u0011Y\u0005\u0003\u0005\u0003Z!\u0002\u000b\u0011\u0002B'\u0011\u001d\u0011Y\u0006\u000bC\u0001\u0005;BqAa\u0018)\t\u0003\u0011i\u0006C\u0004\u0003b!\"\tA!\u0018\t\u0011\t\r\u0004\u0006\"\u0001g\u0005KBqA!\u001c)\t\u0013\u0011y\u0007C\u0004\u0003\u001c\"\"IA!(\t\u000f\tE\u0006\u0006\"\u0003\u00034\"9!\u0011\u001b\u0015\u0005\n\tM\u0007b\u0002B{Q\u0011%!q\u001f\u0005\b\u0007\u001bAC\u0011BB\b\u0011\u001d\u00199\u0002\u000bC\u0005\u00073Aqa!\t)\t\u0013\u0019\u0019\u0003C\u0004\u00040!\"Ia!\r\t\u000f\rm\u0002\u0006\"\u0003\u0004>!91\u0011\u000b\u0015\u0005\n\rM\u0003bBB,Q\u0011%1\u0011\f\u0005\t\u00077BC\u0011\u00014\u0004^!91q\r\u0015\u0005\n\r%\u0014AE\"p]N,X.\u001a:MC\u001e,U.\u001b;uKJT!a\u001a5\u0002\u000f5,GO]5dg*\t\u0011.A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u00051\fQ\"\u00014\u0003%\r{gn];nKJd\u0015mZ#nSR$XM]\n\u0003\u0003=\u0004\"\u0001]:\u000e\u0003ET\u0011A]\u0001\u0006g\u000e\fG.Y\u0005\u0003iF\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001l\u0003\u0015\t\u0007\u000f\u001d7z)-I8qNB9\u0007g\u001a)ha\u001e\u0011\u00051D3C\u0001\u0015p+\u0005a\bcA?\u0002\u000e5\taP\u0003\u0002h\u007f*!\u0011\u0011AA\u0002\u0003\u0019\u0019w.\\7p]*\u0019\u0011.!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0007CB\f7\r[3\u000b\u0005\u0005-\u0011aA8sO&\u0019\u0011q\u0002@\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0005sK\u001eL7\u000f\u001e:z+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005%RBAA\u000e\u0015\u0011\ti\"a\b\u0002\t\r|'/\u001a\u0006\u0004O\u0006\u0005\"\u0002BA\u0012\u0003K\ta!_1n[\u0016\u0014(BAA\u0014\u0003\r\u0019w.\\\u0005\u0005\u0003W\tYBA\bNKR\u0014\u0018nY:SK\u001eL7\u000f\u001e:z\u0003%\u0011XmZ5tiJL\b%A\u0005tG\",G-\u001e7feV\u0011\u00111\u0007\t\u0005\u0003k\ty$\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003\u0011)H/\u001b7\u000b\t\u0005u\u00121A\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005\u0005\u0013q\u0007\u0002\n'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003A9'o\\;q\u0007>|'\u000fZ5oCR|'/\u0006\u0002\u0002JA!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013!B4s_V\u0004(\u0002BA*\u0003\u0007\t1bY8pe\u0012Lg.\u0019;pe&!\u0011qKA'\u0005A9%o\\;q\u0007>|'\u000fZ5oCR|'/A\the>,\boQ8pe\u0012Lg.\u0019;pe\u0002\na\"Z7ji&sG/\u001a:wC2l5/\u0006\u0002\u0002`A\u0019\u0001/!\u0019\n\u0007\u0005\r\u0014O\u0001\u0003M_:<\u0017aD3nSRLe\u000e^3sm\u0006dWj\u001d\u0011\u0002\u000b\u0005$W.\u001b8\u0016\u0005\u0005-\u0004\u0003BA7\u0003kj!!a\u001c\u000b\t\u0005\u001d\u0014\u0011\u000f\u0006\u0005\u0003g\n\u0019!A\u0004dY&,g\u000e^:\n\t\u0005]\u0014q\u000e\u0002\u0006\u0003\u0012l\u0017N\\\u0001\u0007C\u0012l\u0017N\u001c\u0011\u0015\u001be\fi(a \u0002\u0002\u0006\r\u0015QQAD\u0011\u00159W\u00071\u0001}\u0011\u001d\t\u0019\"\u000ea\u0001\u0003/Aq!a\f6\u0001\u0004\t\u0019\u0004C\u0004\u0002FU\u0002\r!!\u0013\t\u0013\u0005mS\u0007%AA\u0002\u0005}\u0003bBA4k\u0001\u0007\u00111N\u0001\u0013G>t7/^7fe2\u000bw-T3ue&\u001c7/\u0006\u0002\u0002\u000eBA\u0011qRAM\u0003;\u000b\u0019,\u0004\u0002\u0002\u0012*!\u00111SAK\u0003\u001diW\u000f^1cY\u0016T1!a&r\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\u000b\tJA\u0002NCB\u0004B!a(\u0002.:!\u0011\u0011UAU!\r\t\u0019+]\u0007\u0003\u0003KS1!a*k\u0003\u0019a$o\\8u}%\u0019\u00111V9\u0002\rA\u0013X\rZ3g\u0013\u0011\ty+!-\u0003\rM#(/\u001b8h\u0015\r\tY+\u001d\t\t\u0003k\u000bY,a0\u0002`5\u0011\u0011q\u0017\u0006\u0004\u0003ss\u0018!C5oi\u0016\u0014h.\u00197t\u0013\u0011\ti,a.\u0003\u0015\u001d\u000bWoZ3Tk&$X\rE\u0002m\u0003\u0003L1!a1g\u0005QiU-\u001c2feR{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u00192m\u001c8tk6,'\u000fT1h\u001b\u0016$(/[2tA\u0005\u0001R\u000f\u001d3bi\u0016$wI]8vaNK'0Z\u000b\u0003\u0003\u0017\u00042\u0001]Ag\u0013\r\ty-\u001d\u0002\u0004\u0013:$\u0018\u0001F;qI\u0006$X\rZ$s_V\u00048+\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u0002V\u0006m\u0007c\u00019\u0002X&\u0019\u0011\u0011\\9\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003;L\u0014\u0011!a\u0001\u0003\u0017\f1\u0001\u001f\u00132\u0003E)\b\u000fZ1uK\u0012<%o\\;q'&TX\r\t\u0015\u0004u\u0005\r\bc\u00019\u0002f&\u0019\u0011q]9\u0003\u0011Y|G.\u0019;jY\u0016\fAC]3cC2\fgnY5oO\u001e\u0013x.\u001e9TSj,\u0017\u0001\u0007:fE\u0006d\u0017M\\2j]\u001e<%o\\;q'&TXm\u0018\u0013fcR!\u0011Q[Ax\u0011%\ti\u000ePA\u0001\u0002\u0004\tY-A\u000bsK\n\fG.\u00198dS:<wI]8vaNK'0\u001a\u0011)\u0007u\n\u0019/A\bgC&dW\rZ$s_V\u00048+\u001b>f\u0003M1\u0017-\u001b7fI\u001e\u0013x.\u001e9TSj,w\fJ3r)\u0011\t).a?\t\u0013\u0005uw(!AA\u0002\u0005-\u0017\u0001\u00054bS2,Gm\u0012:pkB\u001c\u0016N_3!Q\r\u0001\u00151]\u0001\u0011Kb\u0004\u0018N]3e\u000fJ|W\u000f]*ju\u0016\fA#\u001a=qSJ,Gm\u0012:pkB\u001c\u0016N_3`I\u0015\fH\u0003BAk\u0005\u000fA\u0011\"!8C\u0003\u0003\u0005\r!a3\u0002#\u0015D\b/\u001b:fI\u001e\u0013x.\u001e9TSj,\u0007\u0005K\u0002D\u0003G\f1\"\\3ue&\u001c7oU5{K\u0006yQ.\u001a;sS\u000e\u001c8+\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u0002V\nM\u0001\"CAo\u000b\u0006\u0005\t\u0019AA0\u00031iW\r\u001e:jGN\u001c\u0016N_3!Q\r1\u00151]\u0001\u000eKb,7-\u001e;j_:$\u0016.\\3\u0002#\u0015DXmY;uS>tG+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002V\n}\u0001\"CAo\u0011\u0006\u0005\t\u0019AA0\u00039)\u00070Z2vi&|g\u000eV5nK\u0002B3!SAr\u0003Ma\u0017m\u001d;Tk\u000e\u001cWm]:gk2\u0014VO\\'t\u0003]a\u0017m\u001d;Tk\u000e\u001cWm]:gk2\u0014VO\\'t?\u0012*\u0017\u000f\u0006\u0003\u0002V\n-\u0002\"CAo\u0017\u0006\u0005\t\u0019AA0\u0003Qa\u0017m\u001d;Tk\u000e\u001cWm]:gk2\u0014VO\\'tA!\u001aA*a9\u0002\u00155,WNY3s'&TX-\u0006\u0002\u00036A!\u0011\u0011\u0004B\u001c\u0013\u0011\u0011I$a\u0007\u0003\u00155+GO]5d\u001d\u0006lW-A\u0006nK6\u0014WM]*ju\u0016\u0004\u0013aE7f[\n,'oU5{K\"K7\u000f^8he\u0006lWC\u0001B!!\u0011\tIBa\u0011\n\t\t\u0015\u00131\u0004\u0002\n\u0011&\u001cHo\\4sC6\fA#\\3nE\u0016\u00148+\u001b>f\u0011&\u001cHo\\4sC6\u0004\u0013A\u00057be\u001e,7\u000f^$s_V\u00048/U;fk\u0016,\"A!\u0014\u0011\r\u0005=%q\nB*\u0013\u0011\u0011\t&!%\u0003\u001bA\u0013\u0018n\u001c:jif\fV/Z;f!\u001d\u0001(QKAO\u0003\u0017L1Aa\u0016r\u0005\u0019!V\u000f\u001d7fe\u0005\u0019B.\u0019:hKN$xI]8vaN\fV/Z;fA\u0005)1\u000f^1siR\u0011\u0011Q[\u0001\tg\",H\u000fZ8x]\u0006yQ-\\5u\u0007>t7/^7fe2\u000bw-\u0001\rgKR\u001c\u0007n\u00144gg\u0016$8/\u00118e%\u0016\u001cwN\u001d3MC\u001e$\"Aa\u001a\u0011\u00071\u0014I'C\u0002\u0003l\u0019\u0014\u0011dQ8ogVlWM\u001d'bO\u0016k\u0017\u000e\u001e;feN+X.\\1ss\u0006)B-Z:fe&\fG.\u001b>f\u0003N\u001c\u0018n\u001a8nK:$HC\u0002B9\u0005\u007f\u0012\u0019\t\u0005\u0004\u0002\u0010\nM$qO\u0005\u0005\u0005k\n\tJ\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0005s\u0012Y(D\u0001\u0000\u0013\r\u0011ih \u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\u0011\ti\u0016a\u0001\u0003;\u000bqa\u001a:pkBLE\rC\u0004\u0003\u0006^\u0003\rAa\"\u0002\r5,WNY3s!\u0011\u0011II!&\u000f\t\t-%\u0011S\u0007\u0003\u0005\u001bS1Aa$\u0000\u0003\u001diWm]:bO\u0016LAAa%\u0003\u000e\u0006QB)Z:de&\u0014Wm\u0012:pkB\u001c(+Z:q_:\u001cX\rR1uC&!!q\u0013BM\u0005Q!Um]2sS\n,Gm\u0012:pkBlU-\u001c2fe*!!1\u0013BG\u0003E\u0019wN\u001c<feR\f5o]5h]6,g\u000e\u001e\u000b\u0005\u0005c\u0012y\nC\u0004\u0003\"b\u0003\rAa)\u0002\u0015\u0005\u001c8/[4o[\u0016tG\u000f\u0005\u0003\u0003&\n-f\u0002\u0002BF\u0005OKAA!+\u0003\u000e\u0006\t3i\u001c8tk6,'o\u0012:pkB$Um]2sS\n,'+Z:q_:\u001cX\rR1uC&!!Q\u0016BX\u0005)\t5o]5h]6,g\u000e\u001e\u0006\u0005\u0005S\u0013i)\u0001\nnC.,'+Z9vKN$8i\u001c8uKb$H\u0003\u0002B[\u0005\u0003\u0004BAa.\u0003>6\u0011!\u0011\u0018\u0006\u0004\u0005w{\u0018\u0001\u0003:fcV,7\u000f^:\n\t\t}&\u0011\u0018\u0002\u000f%\u0016\fX/Z:u\u0007>tG/\u001a=u\u0011\u001d\u0011\u0019-\u0017a\u0001\u0005\u000b\fa!\u00199j\u0017\u0016L\b\u0003\u0002Bd\u0005\u001bl!A!3\u000b\u0007\t-w0\u0001\u0005qe>$xnY8m\u0013\u0011\u0011yM!3\u0003\u000f\u0005\u0003\u0018nS3zg\u0006qA-Z:de&\u0014Wm\u0012:pkB\u001cHC\u0002Bk\u0005G\u0014i\u000f\u0005\u0004\u0003X\ne'Q\\\u0007\u0003\u0003+KAAa7\u0002\u0016\n!a+[3x!\ra'q\\\u0005\u0004\u0005C4'A\u0004#fg\u000e\u0014\u0018NY3e\u000fJ|W\u000f\u001d\u0005\b\u0005KT\u0006\u0019\u0001Bt\u0003\u0019\u0019H/\u0019;fgB1\u0011q\u0014Bu\u0003;KAAa;\u00022\n\u00191+\u001a;\t\u000f\t=(\f1\u0001\u0003r\u0006aa-Y5mK\u0012<%o\\;qgB1\u0011q\u0012Bz\u0003;KAAa;\u0002\u0012\u0006!b-\u001b7uKJ$Um]2sS\n,Gm\u0012:pkB$\u0002B!?\u0003\u0000\u000e\u000511\u0002\t\u0004a\nm\u0018b\u0001B\u007fc\n9!i\\8mK\u0006t\u0007b\u0002BA7\u0002\u0007\u0011Q\u0014\u0005\b\u0007\u0007Y\u0006\u0019AB\u0003\u0003%)'O]8s\u0007>$W\rE\u0002q\u0007\u000fI1a!\u0003r\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\u0011yo\u0017a\u0001\u0005c\f1cY8om\u0016\u0014Ho\u00117bgNL7m\u0012:pkB$BA!8\u0004\u0012!9\u0011q\n/A\u0002\rM\u0001\u0003\u0002BE\u0007+IAA!9\u0003\u001a\u0006!2m\u001c8wKJ$8i\u001c8tk6,'o\u0012:pkB$BA!8\u0004\u001c!9\u0011qJ/A\u0002\ru\u0001\u0003\u0002BS\u0007?IAA!9\u00030\u0006I2m\u001c8wKJ$8\t\\1tg&\u001cwI]8va6+WNY3s)\u0019\u0019)ca\u000b\u0004.A\u0019Ana\n\n\u0007\r%bMA\bEKN\u001c'/\u001b2fI6+WNY3s\u0011\u001d\u0011\tI\u0018a\u0001\u0003;CqA!\"_\u0001\u0004\u00119)\u0001\u000ed_:4XM\u001d;D_:\u001cX/\\3s\u000fJ|W\u000f]'f[\n,'\u000f\u0006\u0003\u0004&\rM\u0002b\u0002BC?\u0002\u00071Q\u0007\t\u0005\u0005K\u001b9$\u0003\u0003\u0004:\t=&AB'f[\n,'/A\bgKR\u001c\u0007.\u00117m\u001f\u001a47/\u001a;t)\u0011\u0019yda\u0014\u0011\u0011\u0005=\u0015\u0011\u0014B<\u0007\u0003\u0002Baa\u0011\u0004J9!!1RB#\u0013\u0011\u00199E!$\u0002/=3gm]3u\r\u0016$8\r\u001b*fgB|gn]3ECR\f\u0017\u0002BB&\u0007\u001b\u0012Qd\u00144gg\u0016$h)\u001a;dQJ+7\u000f]8og\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0006\u0005\u0007\u000f\u0012i\tC\u0004\u0003\u0002\u0002\u0004\r!!(\u0002!\r\u0014X-\u0019;f\u000f\u0006,x-Z*vSR,G\u0003BAZ\u0007+BqA!!b\u0001\u0004\ti*\u0001\ndkJ\u0014XM\u001c;NKR\u0014\u0018nY:TSj,GCAA0\u00031j\u0017-\u001f2f!J,g-\u001b=U_BL7\rU1si&$\u0018n\u001c8t/&$\b\u000eV3oC:$h)\u001e8di&|g\u000e\u0006\u0003\u0004`\r\u0015\u0004c\u00029\u0004b\tE$\u0011O\u0005\u0004\u0007G\n(!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\u0011\ti\u0019a\u0001\u0003;\u000b\u0001$\u001e9eCR,G*\u0019:hKN$xI]8vaN\fV/Z;f)\u0019\t)na\u001b\u0004n!9!\u0011\u00113A\u0002\u0005u\u0005b\u0002B\u0019I\u0002\u0007\u00111\u001a\u0005\u0006O\u000e\u0001\r\u0001 \u0005\b\u0003'\u0019\u0001\u0019AA\f\u0011\u001d\t)e\u0001a\u0001\u0003\u0013B\u0011\"a\u0017\u0004!\u0003\u0005\r!a\u0018\t\u000f\re4\u00011\u0001\u0004|\u0005Q\u0011\rZ7j]B\u0013x\u000e]:\u0011\u0011\ru4QQAO\u0007\u000fk!aa \u000b\t\u0005e2\u0011\u0011\u0006\u0003\u0007\u0007\u000bAA[1wC&!\u00111TB@!\u0011\u0019Iia$\u000e\u0005\r-%\u0002BBG\u0007\u0003\u000bA\u0001\\1oO&!1\u0011SBF\u0005\u0019y%M[3di\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'\u0006\u0002\u0004\u0018*\"\u0011qLBMW\t\u0019Y\n\u0005\u0003\u0004\u001e\u000e\u001dVBABP\u0015\u0011\u0019\tka)\u0002\u0013Ut7\r[3dW\u0016$'bABSc\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r%6q\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!F\"p]N,X.\u001a:MC\u001elU\r\u001e:jG:\u000bW.Z\u000b\u0003\u0007_\u0003Ba!#\u00042&!\u0011qVBF\u0003Y\u0019uN\\:v[\u0016\u0014H*Y4NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013aD'fiJL7m\u0012:pkBt\u0015-\\3\u0002!5+GO]5d\u000fJ|W\u000f\u001d(b[\u0016\u0004\u0013AG+qI\u0006$X\rZ$s_V\u00048+\u001b>f\u001b\u0016$(/[2OC6,\u0017aG+qI\u0006$X\rZ$s_V\u00048+\u001b>f\u001b\u0016$(/[2OC6,\u0007%\u0001\u0010SK\n\fG.\u00198dS:<wI]8vaNK'0Z'fiJL7MT1nK\u0006y\"+\u001a2bY\u0006t7-\u001b8h\u000fJ|W\u000f]*ju\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u00023\u0019\u000b\u0017\u000e\\3e\u000fJ|W\u000f]*ju\u0016lU\r\u001e:jG:\u000bW.Z\u0001\u001b\r\u0006LG.\u001a3He>,\boU5{K6+GO]5d\u001d\u0006lW\rI\u0001\u001b\u000bb\u0004\u0018N]3e\u000fJ|W\u000f]*ju\u0016lU\r\u001e:jG:\u000bW.Z\u0001\u001c\u000bb\u0004\u0018N]3e\u000fJ|W\u000f]*ju\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002+5+GO]5dgNK'0Z'fiJL7MT1nK\u00061R*\u001a;sS\u000e\u001c8+\u001b>f\u001b\u0016$(/[2OC6,\u0007%A\fFq\u0016\u001cW\u000f^5p]RKW.Z'fiJL7MT1nK\u0006AR\t_3dkRLwN\u001c+j[\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002MQKW.Z*j]\u000e,G*Y:u'V\u001c7-Z:tMVd'+\u001e8Ng6+GO]5d\u001d\u0006lW-A\u0014US6,7+\u001b8dK2\u000b7\u000f^*vG\u000e,7o\u001d4vYJ+h.T:NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013\u0001F'f[\n,'oU5{K6+GO]5d\u001d\u0006lW-A\u000bNK6\u0014WM]*ju\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002-1\u000b'oZ3ti\u001e\u0013x.\u001e9t#V,W/Z*ju\u0016\fq\u0003T1sO\u0016\u001cHo\u0012:pkB\u001c\u0018+^3vKNK'0\u001a\u0011\u000271\u000b'oZ3ti\u001e\u0013x.\u001e9t#V,W/\u001a+ie\u0016\u001c\bn\u001c7e\u0003qa\u0015M]4fgR<%o\\;qgF+X-^3UQJ,7\u000f[8mI\u0002\n\u0001CV1mS\u0012<%o\\;q'R\fG/Z:\u0016\u0005\r\u0015\bCBBt\u0007[\u001cy+\u0004\u0002\u0004j*!11^AK\u0003%IW.\\;uC\ndW-\u0003\u0003\u0003l\u000e%\u0018!\u0005,bY&$wI]8vaN#\u0018\r^3tA\u0005\t\"+\u001a2bY\u0006t7-\u001b8h'R\fG/Z:\u0016\u0005\rU\b\u0003CBt\u0007o\u001cyk!:\n\t\u0005m5\u0011^\u0001\u0013%\u0016\u0014\u0017\r\\1oG&twm\u0015;bi\u0016\u001c\b%A\u0007NK6\u0014WM\u001d+za\u0016l\u0015\r]\u000b\u0003\u0007\u007f\u0004\u0002ba:\u0004x\u0006-7qV\u0001\u000f\u001b\u0016l'-\u001a:UsB,W*\u00199!\u0003\rawnZ\u000b\u0003\t\u000f\u0001B\u0001\"\u0003\u0005\u00105\u0011A1\u0002\u0006\u0005\t\u001b\tI!A\u0003tY\u001a$$.\u0003\u0003\u0005\u0012\u0011-!A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013!D4bk\u001e,7+^5uK2{w-\u0001\bhCV<WmU;ji\u0016dun\u001a\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0001")
public class ConsumerLagEmitter {
    private final Metrics metrics;
    private final MetricsRegistry registry;
    private final Scheduler scheduler;
    private final GroupCoordinator groupCoordinator;
    private final long emitIntervalMs;
    private final Admin admin;
    private final scala.collection.mutable.Map<String, GaugeSuite<MemberTopicPartition, Object>> consumerLagMetrics;
    private volatile int kafka$metrics$ConsumerLagEmitter$$updatedGroupSize;
    private volatile int kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize;
    private volatile int kafka$metrics$ConsumerLagEmitter$$failedGroupSize;
    private volatile int kafka$metrics$ConsumerLagEmitter$$expiredGroupSize;
    private volatile long kafka$metrics$ConsumerLagEmitter$$metricsSize;
    private volatile long kafka$metrics$ConsumerLagEmitter$$executionTime;
    private volatile long kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs;
    private final MetricName memberSize;
    private final Histogram memberSizeHistogram;
    private final PriorityQueue<Tuple2<String, Object>> largestGroupsQueue;

    public static long $lessinit$greater$default$5() {
        return ConsumerLagEmitter$.MODULE$.$lessinit$greater$default$5();
    }

    public static int LargestGroupsQueueThreshold() {
        return ConsumerLagEmitter$.MODULE$.LargestGroupsQueueThreshold();
    }

    public static int LargestGroupsQueueSize() {
        return ConsumerLagEmitter$.MODULE$.LargestGroupsQueueSize();
    }

    public static String MemberSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.MemberSizeMetricName();
    }

    public static String TimeSinceLastSuccessfulRunMsMetricName() {
        return ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName();
    }

    public static String ExecutionTimeMetricName() {
        return ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName();
    }

    public static String MetricsSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName();
    }

    public static String ExpiredGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName();
    }

    public static String FailedGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName();
    }

    public static String RebalancingGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName();
    }

    public static String UpdatedGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName();
    }

    public static String MetricGroupName() {
        return ConsumerLagEmitter$.MODULE$.MetricGroupName();
    }

    public static String ConsumerLagMetricName() {
        return ConsumerLagEmitter$.MODULE$.ConsumerLagMetricName();
    }

    public static long apply$default$4() {
        return ConsumerLagEmitter$.MODULE$.apply$default$4();
    }

    public static ConsumerLagEmitter apply(Metrics metrics, MetricsRegistry registry, GroupCoordinator groupCoordinator, long emitIntervalMs, Map<String, Object> adminProps) {
        return ConsumerLagEmitter$.MODULE$.apply(metrics, registry, groupCoordinator, emitIntervalMs, adminProps);
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetricsRegistry registry() {
        return this.registry;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    public long emitIntervalMs() {
        return this.emitIntervalMs;
    }

    public Admin admin() {
        return this.admin;
    }

    public scala.collection.mutable.Map<String, GaugeSuite<MemberTopicPartition, Object>> consumerLagMetrics() {
        return this.consumerLagMetrics;
    }

    public int kafka$metrics$ConsumerLagEmitter$$updatedGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize;
    }

    private void updatedGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize = x$1;
    }

    public int kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize;
    }

    private void rebalancingGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize = x$1;
    }

    public int kafka$metrics$ConsumerLagEmitter$$failedGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize;
    }

    private void failedGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize = x$1;
    }

    public int kafka$metrics$ConsumerLagEmitter$$expiredGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize;
    }

    private void expiredGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize = x$1;
    }

    public long kafka$metrics$ConsumerLagEmitter$$metricsSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$metricsSize;
    }

    private void metricsSize_$eq(long x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$metricsSize = x$1;
    }

    public long kafka$metrics$ConsumerLagEmitter$$executionTime() {
        return this.kafka$metrics$ConsumerLagEmitter$$executionTime;
    }

    private void executionTime_$eq(long x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$executionTime = x$1;
    }

    public long kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs() {
        return this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs;
    }

    private void lastSuccessfulRunMs_$eq(long x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs = x$1;
    }

    private MetricName memberSize() {
        return this.memberSize;
    }

    private Histogram memberSizeHistogram() {
        return this.memberSizeHistogram;
    }

    public PriorityQueue<Tuple2<String, Object>> largestGroupsQueue() {
        return this.largestGroupsQueue;
    }

    public void start() {
        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Consumer lag emitter starting up.");
        this.scheduler().startup();
        this.scheduler().schedule("emit-consumer-lag-", () -> this.emitConsumerLag(), this.emitIntervalMs(), this.emitIntervalMs());
    }

    public void shutdown() {
        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Consumer lag emitter shutting down.");
        this.consumerLagMetrics().foreachEntry((Function2<String, GaugeSuite, Object> & Serializable)(x$2, gaugeSuite) -> {
            gaugeSuite.close();
            return BoxedUnit.UNIT;
        });
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.registry().removeMetric(this.memberSize());
        this.scheduler().shutdown();
        if (this.admin() != null) {
            this.admin().close();
        }
        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Consumer lag emitter shutdown complete.");
    }

    public void emitConsumerLag() {
        try {
            ConsumerLagEmitterSummary result = this.fetchOffsetsAndRecordLag();
            this.updatedGroupSize_$eq(result.updatedGroupSize());
            this.rebalancingGroupSize_$eq(result.rebalancingGroupSize());
            this.failedGroupSize_$eq(result.failedGroupSize());
            this.expiredGroupSize_$eq(result.expiredGroupSize());
            this.metricsSize_$eq(result.metricsSize());
            this.executionTime_$eq(result.executionTime());
            this.lastSuccessfulRunMs_$eq(System.currentTimeMillis());
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Updated lag of " + this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize() + " groups, ignored " + this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize() + " rebalancing groups, failed to update " + this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize() + " groups due to errors, and expired " + this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize() + " groups.");
        }
        catch (Throwable t) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().error("Could not update consumer lag metrics.", t);
        }
    }

    public ConsumerLagEmitterSummary fetchOffsetsAndRecordLag() {
        long startTime = System.currentTimeMillis();
        scala.collection.mutable.Map groupsToCurrentOffsets = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        scala.collection.mutable.Set rebalancingGroups = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        scala.collection.mutable.Set failedGroups = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        View<DescribedGroup> describedGroups = this.describeGroups(ConsumerLagEmitter$.MODULE$.ValidGroupStates(), failedGroups);
        this.memberSizeHistogram().clear();
        this.largestGroupsQueue().clear();
        describedGroups.foreach((Function1<DescribedGroup, Object> & Serializable)describedGroup -> {
            String groupId = describedGroup.groupId();
            int memberSize = describedGroup.members().size();
            this.memberSizeHistogram().update(memberSize);
            this.updateLargestGroupsQueue(groupId, memberSize);
            String string = describedGroup.protocolType();
            String string2 = "consumer";
            if (string == null ? string2 != null : !string.equals(string2)) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug("Group " + groupId + " is not a classic group using the 'consumer' protocol. Ignoring it.");
                return BoxedUnit.UNIT;
            }
            if (((SetOps)ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$RebalancingStates().apply(describedGroup.groupType())).contains(describedGroup.groupState())) {
                return rebalancingGroups.$plus$eq(groupId);
            }
            String string3 = describedGroup.groupState();
            String string4 = GroupState.STABLE.toString();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                Object object;
                try {
                    scala.collection.mutable.Map<TopicPartition, OffsetFetchResponseData.OffsetFetchResponsePartitions> currentOffsets = this.fetchAllOffsets(groupId);
                    scala.collection.mutable.Map memberTopicPartitions = (scala.collection.mutable.Map)groupsToCurrentOffsets.getOrElse(groupId, (Function0<scala.collection.mutable.Map> & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.empty());
                    Function1<Buffer<TopicPartition>, Buffer<TopicPartition>> maybePrefixTopicPartitions = this.maybePrefixTopicPartitionsWithTenantFunction(groupId);
                    describedGroup.members().foreach((Function1<DescribedMember, Object> & Serializable)member -> {
                        ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$3(maybePrefixTopicPartitions, currentOffsets, groupId, memberTopicPartitions, member);
                        return BoxedUnit.UNIT;
                    });
                    object = memberTopicPartitions.nonEmpty() ? groupsToCurrentOffsets.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(groupId), memberTopicPartitions)) : BoxedUnit.UNIT;
                }
                catch (NotCoordinatorException notCoordinatorException) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug("Ignoring group " + groupId + " because it is not hosted on this coordinator anymore.");
                    object = BoxedUnit.UNIT;
                }
                catch (Throwable t) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug("Could not fetch offsets of group " + groupId + " due to " + t.getMessage() + ". Will retry in the next run.");
                    object = failedGroups.$plus$eq(groupId);
                }
                return object;
            }
            return BoxedUnit.UNIT;
        });
        if (this.largestGroupsQueue().nonEmpty()) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Top " + ConsumerLagEmitter$.MODULE$.LargestGroupsQueueSize() + " largest groups with more than " + ConsumerLagEmitter$.MODULE$.LargestGroupsQueueThreshold() + " members:\n" + this.largestGroupsQueue().reverseIterator().map((Function1<Tuple2, String> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String groupId = (String)tuple2._1();
                    int memberSize = tuple2._2$mcI$sp();
                    return "Group " + groupId + " has " + memberSize + " members.";
                }
                throw new MatchError(tuple2);
            }).mkString("\n"));
        }
        if (groupsToCurrentOffsets.nonEmpty()) {
            Map<TopicPartition, OffsetSpec> latestOffsetSpec = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)groupsToCurrentOffsets.flatMap((Function1<Tuple2, scala.collection.mutable.Map> & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    scala.collection.mutable.Map memberTopicPartitions = (scala.collection.mutable.Map)tuple2._2();
                    return (scala.collection.mutable.Map)memberTopicPartitions.map((Function1<Tuple2, Tuple2> & Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 != null) {
                            MemberTopicPartition memberTopicPartition = (MemberTopicPartition)tuple2._1();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(memberTopicPartition.topicPartition()), OffsetSpec.latest());
                        }
                        throw new MatchError(tuple2);
                    });
                }
                throw new MatchError(tuple2);
            })).asJava();
            ListOffsetsResult result = this.admin().listOffsets(latestOffsetSpec);
            groupsToCurrentOffsets.foreachEntry((Function2<String, scala.collection.mutable.Map, scala.collection.mutable.Map> & Serializable)(groupId, memberTopicPartitions) -> {
                GaugeSuite groupGaugeSuite = (GaugeSuite)this.consumerLagMetrics().getOrElse((String)groupId, (Function0<GaugeSuite> & Serializable)() -> this.createGaugeSuite((String)groupId));
                memberTopicPartitions.foreachEntry((Function2<MemberTopicPartition, Object, Object> & Serializable)(memberTopicPartition, currentOffset) -> {
                    ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$11(result, groupGaugeSuite, memberTopicPartition, BoxesRunTime.unboxToLong(currentOffset));
                    return BoxedUnit.UNIT;
                });
                return (scala.collection.mutable.Map)this.consumerLagMetrics().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(groupId), groupGaugeSuite));
            });
        }
        scala.collection.immutable.Set expiredGroups = ((MapOps)this.consumerLagMetrics().filterNot((Function1<Tuple2, Object> & Serializable)x0$4 -> BoxesRunTime.boxToBoolean(ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$12(groupsToCurrentOffsets, rebalancingGroups, failedGroups, x0$4)))).keys().toSet();
        expiredGroups.foreach((Function1<String, Object> & Serializable)groupId -> {
            ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$14(this, groupId);
            return BoxedUnit.UNIT;
        });
        long executionTime = System.currentTimeMillis() - startTime;
        return new ConsumerLagEmitterSummary(groupsToCurrentOffsets.keySet().size(), rebalancingGroups.size(), failedGroups.size(), expiredGroups.size(), this.currentMetricsSize(), executionTime);
    }

    private Buffer<TopicPartition> deserializeAssignment(String groupId, DescribeGroupsResponseData.DescribedGroupMember member) {
        ConsumerPartitionAssignor.Assignment assignment = new ConsumerPartitionAssignor.Assignment(CollectionConverters$.MODULE$.SeqHasAsJava(package$.MODULE$.List().empty()).asJava());
        try {
            assignment = ConsumerProtocol.deserializeAssignment(ByteBuffer.wrap(member.memberAssignment()));
        }
        catch (SchemaException e) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug("Failed to deserialize assignment(length=" + member.memberAssignment().length + ") for group " + groupId + " and member " + member.memberId() + ": " + e.getMessage());
        }
        return CollectionConverters$.MODULE$.ListHasAsScala(assignment.partitions()).asScala();
    }

    private Buffer<TopicPartition> convertAssignment(ConsumerGroupDescribeResponseData.Assignment assignment) {
        Buffer topicPartitions = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(assignment.topicPartitions()).asScala().flatMap((Function1<ConsumerGroupDescribeResponseData.TopicPartitions, Buffer> & Serializable)topicPartition -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicPartition.partitions()).asScala().map((Function1<Integer, TopicPartition> & Serializable)partition -> new TopicPartition(topicPartition.topicName(), Predef$.MODULE$.Integer2int((Integer)partition))));
        return topicPartitions;
    }

    private RequestContext makeRequestContext(ApiKeys apiKey) {
        return new RequestContext(new RequestHeader(apiKey, apiKey.latestVersion(), ConsumerLagEmitter$.MODULE$.MetricGroupName(), 0), "-1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol(SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
    }

    private View<DescribedGroup> describeGroups(scala.collection.immutable.Set<String> states, scala.collection.mutable.Set<String> failedGroups) {
        View view;
        CompletionStage future = this.groupCoordinator().listGroups(this.makeRequestContext(ApiKeys.LIST_GROUPS), new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava(states.toList()).asJava()).setTypesFilter(CollectionConverters$.MODULE$.SeqHasAsJava(new $colon$colon<Nothing$>((Nothing$)((Object)Group.GroupType.CLASSIC.toString()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Group.GroupType.CONSUMER.toString()), Nil$.MODULE$))).asJava())).thenCompose(listGroupsResult -> {
            if (listGroupsResult.errorCode() != Errors.NONE.code()) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(Errors.forCode(listGroupsResult.errorCode()).exception());
                return future;
            }
            scala.collection.immutable.Map groupedGroups = CollectionConverters$.MODULE$.ListHasAsScala(listGroupsResult.groups()).asScala().groupBy((Function1<ListGroupsResponseData.ListedGroup, Object> & Serializable)group -> BoxesRunTime.boxToBoolean(ConsumerLagEmitter.$anonfun$describeGroups$2(group)));
            Seq classicGroups = (Seq)groupedGroups.getOrElse(BoxesRunTime.boxToBoolean(true), (Function0<List> & Serializable)() -> package$.MODULE$.List().empty());
            Seq consumerGroups = (Seq)groupedGroups.getOrElse(BoxesRunTime.boxToBoolean(false), (Function0<List> & Serializable)() -> package$.MODULE$.List().empty());
            ObjectRef<CompletableFuture<Object>> describedClassicGroupsFuture = ObjectRef.create(CompletableFuture.completedFuture(Buffer$.MODULE$.empty()));
            ObjectRef<CompletableFuture<Object>> describedConsumerGroupsFuture = ObjectRef.create(CompletableFuture.completedFuture(Buffer$.MODULE$.empty()));
            if (classicGroups.nonEmpty()) {
                describedClassicGroupsFuture.elem = this.groupCoordinator().describeGroups(this.makeRequestContext(ApiKeys.DESCRIBE_GROUPS), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)classicGroups.map((Function1<ListGroupsResponseData.ListedGroup, String> & Serializable)x$4 -> x$4.groupId())).asJava()).thenApply(x$5 -> CollectionConverters$.MODULE$.ListHasAsScala(x$5).asScala());
            }
            if (consumerGroups.nonEmpty()) {
                describedConsumerGroupsFuture.elem = this.groupCoordinator().consumerGroupDescribe(this.makeRequestContext(ApiKeys.CONSUMER_GROUP_DESCRIBE), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)consumerGroups.map((Function1<ListGroupsResponseData.ListedGroup, String> & Serializable)x$6 -> x$6.groupId())).asJava()).thenApply(x$7 -> CollectionConverters$.MODULE$.ListHasAsScala(x$7).asScala());
            }
            return CompletableFuture.allOf((CompletableFuture)describedClassicGroupsFuture.elem, (CompletableFuture)describedConsumerGroupsFuture.elem).thenApply(x$8 -> (View)((IterableOps)((IterableOps)((SeqOps)((CompletableFuture)describedClassicGroupsFuture$1.elem).get()).view().filter((Function1<DescribeGroupsResponseData.DescribedGroup, Object> & Serializable)group -> BoxesRunTime.boxToBoolean(this.filterDescribedGroup(group.groupId(), group.errorCode(), failedGroups)))).map((Function1<DescribeGroupsResponseData.DescribedGroup, DescribedGroup> & Serializable)group -> this.convertClassicGroup((DescribeGroupsResponseData.DescribedGroup)group))).$plus$plus((IterableOnce)((IterableOps)((SeqOps)((CompletableFuture)describedConsumerGroupsFuture$1.elem).get()).view().filter((Function1<ConsumerGroupDescribeResponseData.DescribedGroup, Object> & Serializable)group -> BoxesRunTime.boxToBoolean(this.filterDescribedGroup(group.groupId(), group.errorCode(), failedGroups)))).map((Function1<ConsumerGroupDescribeResponseData.DescribedGroup, DescribedGroup> & Serializable)group -> this.convertConsumerGroup((ConsumerGroupDescribeResponseData.DescribedGroup)group))));
        });
        try {
            view = (View)((CompletableFuture)future).get(30L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ExecutionException && (executionException = (ExecutionException)throwable2).getCause() != null) {
                throw executionException.getCause();
            }
            throw throwable;
        }
        return view;
    }

    private boolean filterDescribedGroup(String groupId, short errorCode, scala.collection.mutable.Set<String> failedGroups) {
        if (errorCode == Errors.NOT_COORDINATOR.code()) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug("Ignoring group " + groupId + " because it is not hosted on this coordinator anymore.");
            v0 = BoxedUnit.UNIT;
        } else if (errorCode != Errors.NONE.code()) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug("Could not describe group " + groupId + " due to " + Errors.forCode(errorCode) + ". Will retry in the next run.");
            v0 = failedGroups.$plus$eq(groupId);
        } else {
            return true;
        }
        return false;
    }

    private DescribedGroup convertClassicGroup(DescribeGroupsResponseData.DescribedGroup group) {
        return new DescribedGroup(Group.GroupType.CLASSIC.toString(), group.groupId(), group.groupState(), group.protocolType(), CollectionConverters$.MODULE$.ListHasAsScala(group.members()).asScala().view().map((Function1<DescribeGroupsResponseData.DescribedGroupMember, DescribedMember> & Serializable)member -> this.convertClassicGroupMember(group.groupId(), (DescribeGroupsResponseData.DescribedGroupMember)member)));
    }

    private DescribedGroup convertConsumerGroup(ConsumerGroupDescribeResponseData.DescribedGroup group) {
        return new DescribedGroup(Group.GroupType.CONSUMER.toString(), group.groupId(), group.groupState(), "consumer", CollectionConverters$.MODULE$.ListHasAsScala(group.members()).asScala().view().map((Function1<ConsumerGroupDescribeResponseData.Member, DescribedMember> & Serializable)member -> this.convertConsumerGroupMember((ConsumerGroupDescribeResponseData.Member)member)));
    }

    private DescribedMember convertClassicGroupMember(String groupId, DescribeGroupsResponseData.DescribedGroupMember member) {
        return new DescribedMember(member.memberId(), member.groupInstanceId(), member.clientId(), 0, this.deserializeAssignment(groupId, member));
    }

    private DescribedMember convertConsumerGroupMember(ConsumerGroupDescribeResponseData.Member member) {
        return new DescribedMember(member.memberId(), member.instanceId(), member.clientId(), member.memberType(), this.convertAssignment(member.assignment()));
    }

    private scala.collection.mutable.Map<TopicPartition, OffsetFetchResponseData.OffsetFetchResponsePartitions> fetchAllOffsets(String groupId) {
        scala.collection.mutable.Map map;
        CompletionStage future = this.groupCoordinator().fetchAllOffsets(this.makeRequestContext(ApiKeys.OFFSET_FETCH), new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupId), false).thenApply(response -> {
            HashMap byTopicPartitions = new HashMap();
            response.topics().forEach(topic -> topic.partitions().forEach(partition -> {
                TopicPartition tp = new TopicPartition(topic.name(), partition.partitionIndex());
                byTopicPartitions.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), partition));
            }));
            return byTopicPartitions;
        });
        try {
            map = (scala.collection.mutable.Map)((CompletableFuture)future).get(30L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ExecutionException && (executionException = (ExecutionException)throwable2).getCause() != null) {
                throw executionException.getCause();
            }
            throw throwable;
        }
        return map;
    }

    private GaugeSuite<MemberTopicPartition, Object> createGaugeSuite(String groupId) {
        return new GaugeSuite<MemberTopicPartition, Object>(ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$gaugeSuiteLog(), "consumer-lag-emitter-" + groupId, this.metrics(), memberTopicPartition -> this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ConsumerLagMetricName(), "tenant-metrics", "The group member's consumer lag in offsets.", CollectionConverters$.MODULE$.MutableMapHasAsJava(memberTopicPartition.tags()).asJava()));
    }

    private long currentMetricsSize() {
        return BoxesRunTime.unboxToInt(((IterableOnceOps)this.consumerLagMetrics().map((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToInteger(ConsumerLagEmitter.$anonfun$currentMetricsSize$1(x0$1)))).sum(Numeric.IntIsIntegral$.MODULE$));
    }

    public Function1<Buffer<TopicPartition>, Buffer<TopicPartition>> maybePrefixTopicPartitionsWithTenantFunction(String groupId) {
        if (TenantHelpers.isTenantPrefixed(groupId)) {
            String prefix = TenantHelpers.extractTenantPrefix(groupId);
            return (Function1<Buffer, Buffer> & Serializable)topicPartitions -> (Buffer)topicPartitions.map((Function1<TopicPartition, TopicPartition> & Serializable)x$9 -> TenantHelpers.prefixWithTenant(prefix, x$9));
        }
        return (Function1<Buffer, Buffer> & Serializable)topicPartitions -> topicPartitions;
    }

    private void updateLargestGroupsQueue(String groupId, int memberSize) {
        if (memberSize > ConsumerLagEmitter$.MODULE$.LargestGroupsQueueThreshold()) {
            this.largestGroupsQueue().enqueue(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<String, Integer>(groupId, BoxesRunTime.boxToInteger(memberSize))}));
        }
        if (this.largestGroupsQueue().size() > ConsumerLagEmitter$.MODULE$.LargestGroupsQueueSize()) {
            this.largestGroupsQueue().dequeue();
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$largestGroupsQueue$1(Tuple2 x$1) {
        return -x$1._2$mcI$sp();
    }

    public static final /* synthetic */ void $anonfun$fetchOffsetsAndRecordLag$3(Function1 maybePrefixTopicPartitions$1, scala.collection.mutable.Map currentOffsets$1, String groupId$1, scala.collection.mutable.Map memberTopicPartitions$1, DescribedMember member) {
        ((IterableOnceOps)maybePrefixTopicPartitions$1.apply(member.assignment())).foreach((Function1<TopicPartition, Object> & Serializable)topicPartition -> {
            Option option = currentOffsets$1.get(topicPartition);
            if (option instanceof Some) {
                Errors error;
                Some some = (Some)option;
                OffsetFetchResponseData.OffsetFetchResponsePartitions currentOffset = (OffsetFetchResponseData.OffsetFetchResponsePartitions)some.value();
                Errors errors = error = Errors.forCode(currentOffset.errorCode());
                Errors errors2 = Errors.NONE;
                if (errors == null ? errors2 != null : !((Object)((Object)errors)).equals((Object)errors2)) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug("Could not get committed offset for group " + groupId$1 + " and partition " + topicPartition + " due to " + error + ". Will retry in the next run.");
                    return BoxedUnit.UNIT;
                }
                MemberTopicPartition memberTopicPartition = new MemberTopicPartition(groupId$1, Option$.MODULE$.apply(member.groupInstanceId()), member.memberId(), member.clientId(), (String)ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$MemberTypeMap().getOrElse(BoxesRunTime.boxToInteger(member.memberType()), (Function0<String> & Serializable)() -> "UNKNOWN"), (TopicPartition)topicPartition);
                return memberTopicPartitions$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(memberTopicPartition), BoxesRunTime.boxToLong(currentOffset.committedOffset())));
            }
            if (None$.MODULE$.equals(option)) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug("Group coordinator does not have offsets for group " + groupId$1 + " and topic partition " + topicPartition + ".");
                return BoxedUnit.UNIT;
            }
            throw new MatchError(option);
        });
    }

    public static final /* synthetic */ void $anonfun$fetchOffsetsAndRecordLag$11(ListOffsetsResult result$1, GaugeSuite groupGaugeSuite$1, MemberTopicPartition memberTopicPartition, long currentOffset) {
        block4: {
            try {
                long latestOffset = result$1.partitionResult(memberTopicPartition.topicPartition()).get().offset();
                long consumerLag = latestOffset - currentOffset;
                if (consumerLag < 0L) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().warn("Consumer lag of member " + memberTopicPartition + " is negative. Latest offset is " + latestOffset + " and committed offset is " + currentOffset + ". The topic may have been recreated.");
                    groupGaugeSuite$1.update(memberTopicPartition, BoxesRunTime.boxToLong(0L));
                    break block4;
                }
                groupGaugeSuite$1.update(memberTopicPartition, BoxesRunTime.boxToLong(consumerLag));
            }
            catch (ExecutionException e) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug("Could not list offsets for partition " + memberTopicPartition.topicPartition() + " due to " + e.getCause().getMessage());
            }
            catch (InterruptedException e) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug("Unable to list offsets for partition " + memberTopicPartition.topicPartition() + " due to " + e.getCause());
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffsetsAndRecordLag$12(scala.collection.mutable.Map groupsToCurrentOffsets$1, scala.collection.mutable.Set rebalancingGroups$1, scala.collection.mutable.Set failedGroups$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            String groupId = (String)tuple2._1();
            GaugeSuite groupGaugeSuite = (GaugeSuite)tuple2._2();
            if (groupsToCurrentOffsets$1.contains(groupId)) {
                Set currentMemberTopicPartitions = ((MapOps)groupsToCurrentOffsets$1.apply(groupId)).keySet();
                scala.collection.mutable.Set expiredMembers = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(groupGaugeSuite.keySet()).asScala().diff(currentMemberTopicPartitions);
                expiredMembers.foreach((Function1<MemberTopicPartition, Object> & Serializable)key -> {
                    groupGaugeSuite.remove(key);
                    return BoxedUnit.UNIT;
                });
                groupGaugeSuite.flush();
                return groupGaugeSuite.keySet().size() != 0;
            }
            return rebalancingGroups$1.contains(groupId) || failedGroups$1.contains(groupId);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$fetchOffsetsAndRecordLag$14(ConsumerLagEmitter $this, String groupId) {
        $this.consumerLagMetrics().remove(groupId).foreach((Function1<GaugeSuite, Object> & Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$describeGroups$2(ListGroupsResponseData.ListedGroup group) {
        String string = group.groupType();
        String string2 = Group.GroupType.CLASSIC.toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$currentMetricsSize$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            GaugeSuite groupGaugeSuite = (GaugeSuite)tuple2._2();
            return groupGaugeSuite.keySet().size();
        }
        throw new MatchError(tuple2);
    }

    public ConsumerLagEmitter(Metrics metrics, MetricsRegistry registry, Scheduler scheduler, GroupCoordinator groupCoordinator, long emitIntervalMs, Admin admin) {
        this.metrics = metrics;
        this.registry = registry;
        this.scheduler = scheduler;
        this.groupCoordinator = groupCoordinator;
        this.emitIntervalMs = emitIntervalMs;
        this.admin = admin;
        this.consumerLagMetrics = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$failedGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$metricsSize = 0L;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public long value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$metricsSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$executionTime = 0L;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public long value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$executionTime();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs = System.currentTimeMillis();
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public long value(MetricConfig config, long now) {
                return System.currentTimeMillis() - this.$outer.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.memberSize = KafkaYammerMetrics.getMetricName("kafka.coordinator.group", ConsumerLagEmitter$.MODULE$.MetricGroupName(), ConsumerLagEmitter$.MODULE$.MemberSizeMetricName());
        this.memberSizeHistogram = registry.newHistogram(this.memberSize(), false);
        this.largestGroupsQueue = PriorityQueue$.MODULE$.empty(package$.MODULE$.Ordering().by((Function1<Tuple2, Object> & Serializable)x$1 -> BoxesRunTime.boxToInteger(ConsumerLagEmitter.$anonfun$largestGroupsQueue$1(x$1)), Ordering.Int$.MODULE$));
    }
}

