/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Histogram;
import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import kafka.log.AbstractLog;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.MetadataLogConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.CheckpointFileConfig;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerIdQuotaRecorder;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KafkaMetadataLog$
implements Logging {
    public static final KafkaMetadataLog$ MODULE$ = new KafkaMetadataLog$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        KafkaMetadataLog$ kafkaMetadataLog$ = this;
        synchronized (kafkaMetadataLog$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public KafkaMetadataLog apply(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Metrics metrics, Scheduler scheduler, MetadataLogConfig config, Consumer<Long> logStartOffsetChangeCallback, Consumer<OffsetAndEpoch> logSnapshotGeneratedCallback) {
        Properties props = new Properties();
        props.setProperty("max.message.bytes", Integer.toString(config.maxBatchSizeInBytes()));
        props.setProperty("segment.bytes", Integer.toString(config.logSegmentBytes()));
        props.setProperty("segment.ms", Long.toString(config.logSegmentMillis()));
        props.setProperty("file.delete.delay.ms", Long.toString(60000L));
        props.setProperty("retention.ms", "-1");
        props.setProperty("retention.bytes", "-1");
        LogConfig.validate(props);
        LogConfig defaultLogConfig = new LogConfig(props);
        if (config.logSegmentBytes() < config.logSegmentMinBytes()) {
            throw new InvalidConfigurationException("Cannot set metadata.log.segment.bytes below " + config.logSegmentMinBytes() + ": " + config.logSegmentBytes());
        }
        if (defaultLogConfig.retentionMs >= 0L) {
            throw new InvalidConfigurationException("Cannot set retention.ms above -1: " + defaultLogConfig.retentionMs + ".");
        }
        if (defaultLogConfig.retentionSize >= 0L) {
            throw new InvalidConfigurationException("Cannot set retention.bytes above -1: " + defaultLogConfig.retentionSize + ".");
        }
        File x$1 = dataDir;
        LogConfig x$2 = defaultLogConfig;
        long x$3 = 0L;
        long x$4 = 0L;
        Scheduler x$5 = scheduler;
        BrokerTopicStats x$6 = new BrokerTopicStats();
        Metrics x$7 = metrics;
        Time x$8 = time;
        int x$9 = Integer.MAX_VALUE;
        ProducerStateManagerConfig x$10 = new ProducerStateManagerConfig(Integer.MAX_VALUE, false);
        int x$11 = Integer.MAX_VALUE;
        LogDirFailureChannel x$12 = new LogDirFailureChannel(5);
        TierLogComponents x$13 = TierLogComponents$.MODULE$.EMPTY();
        boolean x$14 = false;
        Some<Uuid> x$15 = new Some<Uuid>(topicId);
        boolean x$16 = true;
        None$ x$17 = None$.MODULE$;
        ChecksumParams x$18 = ChecksumParams.EMPTY;
        Option<ProducerIdQuotaRecorder> x$19 = MergedLog$.MODULE$.apply$default$12();
        LogOffsetsListener x$20 = MergedLog$.MODULE$.apply$default$18();
        ConcurrentMap<String, Integer> x$21 = MergedLog$.MODULE$.apply$default$20();
        CheckpointFileConfig x$22 = MergedLog$.MODULE$.apply$default$22();
        ServerLogConfigs.CleanupPolicyEmptyValidation x$23 = MergedLog$.MODULE$.apply$default$23();
        MergedLog log = MergedLog$.MODULE$.apply(x$1, x$2, 0L, 0L, x$5, x$6, x$7, x$8, Integer.MAX_VALUE, x$10, Integer.MAX_VALUE, x$19, x$12, x$13, false, x$15, true, x$20, x$17, x$21, x$18, x$22, x$23);
        KafkaMetadataLog metadataLog = new KafkaMetadataLog(log, time, scheduler, this.recoverSnapshots(log, this.recoverSnapshots$default$2()), topicPartition, config, logStartOffsetChangeCallback, logSnapshotGeneratedCallback);
        if (config.logSegmentMinBytes() != 0x800000) {
            metadataLog.error((Function0<String> & Serializable)() -> "Overriding metadata.log.segment.min.bytes is only supported for testing. Setting this value too low may lead to an inability to write batches of metadata records.");
        }
        metadataLog.truncateToLatestSnapshot();
        return metadataLog;
    }

    public Consumer<Long> apply$default$8() {
        return x$4 -> {};
    }

    public Consumer<OffsetAndEpoch> apply$default$9() {
        return x$5 -> {};
    }

    public KafkaMetadataLog createWithoutRecovery(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Metrics metrics, Scheduler scheduler, MetadataLogConfig config, Consumer<Long> logStartOffsetChangeCallback, Consumer<OffsetAndEpoch> logSnapshotGeneratedCallback) {
        KafkaMetadataLog metadataLog;
        block3: {
            Properties props = new Properties();
            props.setProperty("max.message.bytes", Integer.toString(config.maxBatchSizeInBytes()));
            props.setProperty("segment.bytes", Integer.toString(config.logSegmentBytes()));
            props.setProperty("segment.ms", Long.toString(config.logSegmentMillis()));
            props.setProperty("file.delete.delay.ms", Long.toString(60000L));
            props.setProperty("retention.ms", "-1");
            props.setProperty("retention.bytes", "-1");
            LogConfig.validate(props);
            LogConfig defaultLogConfig = new LogConfig(props);
            if (config.logSegmentBytes() < config.logSegmentMinBytes()) {
                throw new InvalidConfigurationException("Cannot set metadata.log.segment.bytes below " + config.logSegmentMinBytes() + ": " + config.logSegmentBytes());
            }
            if (defaultLogConfig.retentionMs >= 0L) {
                throw new InvalidConfigurationException("Cannot set retention.ms above -1: " + defaultLogConfig.retentionMs + ".");
            }
            if (defaultLogConfig.retentionSize >= 0L) {
                throw new InvalidConfigurationException("Cannot set retention.bytes above -1: " + defaultLogConfig.retentionSize + ".");
            }
            File x$1 = dataDir;
            LogConfig x$2 = defaultLogConfig;
            long x$3 = 0L;
            long x$4 = 0L;
            Scheduler x$5 = scheduler;
            BrokerTopicStats x$6 = new BrokerTopicStats();
            Metrics x$7 = metrics;
            Time x$8 = time;
            int x$9 = Integer.MAX_VALUE;
            ProducerStateManagerConfig x$10 = new ProducerStateManagerConfig(Integer.MAX_VALUE, false);
            int x$11 = Integer.MAX_VALUE;
            LogDirFailureChannel x$12 = new LogDirFailureChannel(5);
            TierLogComponents x$13 = TierLogComponents$.MODULE$.EMPTY();
            boolean x$14 = false;
            Some<Uuid> x$15 = new Some<Uuid>(topicId);
            boolean x$16 = true;
            ChecksumParams x$17 = ChecksumParams.EMPTY;
            Option<ProducerIdQuotaRecorder> x$18 = MergedLog$.MODULE$.apply$default$12();
            LogOffsetsListener x$19 = MergedLog$.MODULE$.apply$default$18();
            Option<Histogram> x$20 = MergedLog$.MODULE$.apply$default$19();
            ConcurrentMap<String, Integer> x$21 = MergedLog$.MODULE$.apply$default$20();
            CheckpointFileConfig x$22 = MergedLog$.MODULE$.apply$default$22();
            ServerLogConfigs.CleanupPolicyEmptyValidation x$23 = MergedLog$.MODULE$.apply$default$23();
            MergedLog log = MergedLog$.MODULE$.apply(x$1, x$2, 0L, 0L, x$5, x$6, x$7, x$8, Integer.MAX_VALUE, x$10, Integer.MAX_VALUE, x$18, x$12, x$13, false, x$15, true, x$19, x$20, x$21, x$17, x$22, x$23);
            metadataLog = new KafkaMetadataLog(log, time, scheduler, this.recoverSnapshots(log, false), topicPartition, config, logStartOffsetChangeCallback, logSnapshotGeneratedCallback);
            if (config.logSegmentMinBytes() == 0x800000) break block3;
            metadataLog.error((Function0<String> & Serializable)() -> "Overriding metadata.log.segment.min.bytes is only supported for testing. Setting this value too low may lead to an inability to write batches of metadata records.");
        }
        return metadataLog;
    }

    public Consumer<Long> createWithoutRecovery$default$8() {
        return x$6 -> {};
    }

    public Consumer<OffsetAndEpoch> createWithoutRecovery$default$9() {
        return x$7 -> {};
    }

    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> recoverSnapshots(AbstractLog log, boolean allowDelete) {
        Object snapshotsToRetain = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        Buffer snapshotsToDelete = (Buffer)Buffer$.MODULE$.empty();
        try (DirectoryStream<Path> filesInDir = FilesWrapper.newDirectoryStream(log.dir().toPath());){
            Option latestSnapshotId;
            filesInDir.forEach(arg_0 -> KafkaMetadataLog$.$anonfun$recoverSnapshots$1(log, snapshotsToDelete, (TreeMap)snapshotsToRetain, arg_0));
            if (log.logStartOffset() > 0L && !(latestSnapshotId = ((AbstractIterable)snapshotsToRetain).lastOption().map((Function1<Tuple2, OffsetAndEpoch> & Serializable)x$8 -> (OffsetAndEpoch)x$8._1())).exists((Function1<OffsetAndEpoch, Object> & Serializable)snapshotId -> BoxesRunTime.boxToBoolean(KafkaMetadataLog$.$anonfun$recoverSnapshots$4(log, snapshotId)))) {
                throw new IllegalStateException("Inconsistent snapshot state: there must be a snapshot at an offset larger then the current log start offset " + log.logStartOffset() + ", but the latest snapshot is " + latestSnapshotId);
            }
            if (allowDelete) {
                snapshotsToDelete.foreach((Function1<SnapshotPath, Object> & Serializable)snapshotPath -> {
                    KafkaMetadataLog$.$anonfun$recoverSnapshots$5(snapshotPath);
                    return BoxedUnit.UNIT;
                });
            } else if (snapshotsToDelete.nonEmpty()) {
                this.info((Function0<String> & Serializable)() -> "Skipping deletion of eligible snapshots found during recovery: " + snapshotsToDelete);
            }
        }
        this.info(() -> KafkaMetadataLog$.$anonfun$recoverSnapshots$8((TreeMap)snapshotsToRetain, log));
        return snapshotsToRetain;
    }

    private boolean recoverSnapshots$default$2() {
        return true;
    }

    public void kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(Path logDir, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots, Logging logging) {
        expiredSnapshots.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(KafkaMetadataLog$.$anonfun$deleteSnapshotFiles$1(logDir, x0$1)));
    }

    public static final /* synthetic */ void $anonfun$recoverSnapshots$1(AbstractLog log$1, Buffer snapshotsToDelete$1, TreeMap snapshotsToRetain$1, Path path) {
        Snapshots.parse(path).ifPresent(snapshotPath -> {
            if (snapshotPath.partial || snapshotPath.deleted || snapshotPath.snapshotId.offset() < log$1.logStartOffset()) {
                snapshotsToDelete$1.append(snapshotPath);
                return;
            }
            snapshotsToRetain$1.put(snapshotPath.snapshotId, None$.MODULE$);
        });
    }

    public static final /* synthetic */ boolean $anonfun$recoverSnapshots$4(AbstractLog log$1, OffsetAndEpoch snapshotId) {
        return snapshotId.offset() >= log$1.logStartOffset();
    }

    public static final /* synthetic */ void $anonfun$recoverSnapshots$5(SnapshotPath snapshotPath) {
        Files.deleteIfExists(snapshotPath.path);
        MODULE$.info((Function0<String> & Serializable)() -> "Deleted unneeded snapshot file with path " + snapshotPath);
    }

    public static final /* synthetic */ String $anonfun$recoverSnapshots$8(TreeMap snapshotsToRetain$1, AbstractLog log$1) {
        return "Initialized snapshots with IDs " + snapshotsToRetain$1.keys() + " from " + log$1.dir();
    }

    public static final /* synthetic */ void $anonfun$deleteSnapshotFiles$2(FileRawSnapshotReader reader) {
        Utils.closeQuietly(reader, "reader");
    }

    public static final /* synthetic */ boolean $anonfun$deleteSnapshotFiles$1(Path logDir$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            OffsetAndEpoch snapshotId = (OffsetAndEpoch)tuple2._1();
            Option snapshotReader = (Option)tuple2._2();
            snapshotReader.foreach((Function1<FileRawSnapshotReader, Object> & Serializable)reader -> {
                KafkaMetadataLog$.$anonfun$deleteSnapshotFiles$2(reader);
                return BoxedUnit.UNIT;
            });
            return Snapshots.deleteIfExists(logDir$1, snapshotId);
        }
        throw new MatchError(tuple2);
    }

    private KafkaMetadataLog$() {
    }
}

