/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.server.ConfigAdminManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkDisabled$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.logger.RuntimeLoggerManager;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.ResourceType;
import org.slf4j.Logger;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015f\u0001B\u000f\u001f\u0001\rB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005A\u0001\t\u0015\r\u0011\"\u0001B\u0011!a\u0005A!A!\u0002\u0013\u0011\u0005\"B'\u0001\t\u0003q\u0005b\u0002+\u0001\u0005\u0004%\t!\u0016\u0005\u00079\u0002\u0001\u000b\u0011\u0002,\t\u000bu\u0003A\u0011\u00010\t\u0013\u0005]\u0003!%A\u0005\u0002\u0005e\u0003bBA8\u0001\u0011%\u0011\u0011\u000f\u0005\b\u0003_\u0002A\u0011BAF\u0011\u0019i\u0006\u0001\"\u0001\u0002\u001a\"9\u0011q\u000e\u0001\u0005\n\u0005E\u0006bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003\u007f\u0003A\u0011AAa\u0011!\t)\u000e\u0001C\u0001=\u0005]\u0007bBAo\u0001\u0011\u0005\u0011q\\\u0004\b\u0003gt\u0002\u0012AA{\r\u0019ib\u0004#\u0001\u0002x\"1Q\n\u0006C\u0001\u0003sD\u0011\"a?\u0015\u0005\u0004%\t!!@\t\u0011\t-A\u0003)A\u0005\u0003\u007fDqA!\u0004\u0015\t\u0003\u0011y\u0001C\u0004\u0003\u0016Q!\tAa\u0006\t\u000f\t\u0015B\u0003\"\u0001\u0003(!9!q\u000b\u000b\u0005\u0002\te\u0003b\u0002B7)\u0011\u0005!q\u000e\u0002\u0013\u0007>tg-[4BI6Lg.T1oC\u001e,'O\u0003\u0002 A\u000511/\u001a:wKJT\u0011!I\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-rS\"\u0001\u0017\u000b\u00055\u0002\u0013!B;uS2\u001c\u0018BA\u0018-\u0005\u001daunZ4j]\u001e\faA\\8eK&#\u0007CA\u00133\u0013\t\u0019dEA\u0002J]R\fAaY8oMB\u0011agN\u0007\u0002=%\u0011\u0001H\b\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\td_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ssB\u00111HP\u0007\u0002y)\u0011QHH\u0001\t[\u0016$\u0018\rZ1uC&\u0011q\b\u0010\u0002\u0011\u0007>tg-[4SKB|7/\u001b;pef\f!c\u00197vgR,'\u000fT5oW6\u000bg.Y4feV\t!\t\u0005\u0002D\u0013:\u0011AiR\u0007\u0002\u000b*\u0011aIH\u0001\u0005Y&t7.\u0003\u0002I\u000b\u0006\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\tQ5JA\u0006MS:\\W*\u00198bO\u0016\u0014(B\u0001%F\u0003M\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:!\u0003\u0019a\u0014N\\5u}Q)q\nU)S'B\u0011a\u0007\u0001\u0005\u0006a\u0019\u0001\r!\r\u0005\u0006i\u0019\u0001\r!\u000e\u0005\u0006s\u0019\u0001\rA\u000f\u0005\u0006\u0001\u001a\u0001\rAQ\u0001\u0015eVtG/[7f\u0019><w-\u001a:NC:\fw-\u001a:\u0016\u0003Y\u0003\"a\u0016.\u000e\u0003aS!!\u0017\u0010\u0002\r1|wmZ3s\u0013\tY\u0006L\u0001\u000bSk:$\u0018.\\3M_\u001e<WM]'b]\u0006<WM]\u0001\u0016eVtG/[7f\u0019><w-\u001a:NC:\fw-\u001a:!\u0003)\u0001(/\u001a9s_\u000e,7o\u001d\u000b\b?\u0006U\u0011\u0011EA'!\u0015\u0001WmZA\u0005\u001b\u0005\t'B\u00012d\u0003\u0011)H/\u001b7\u000b\u0003\u0011\fAA[1wC&\u0011a-\u0019\u0002\u0010\u0013\u0012,g\u000e^5us\"\u000b7\u000f['baB\u0019\u0001.a\u0001\u000f\u0005%thB\u00016|\u001d\tY\u0007P\u0004\u0002mm:\u0011Qn\u001d\b\u0003]Fl\u0011a\u001c\u0006\u0003a\n\na\u0001\u0010:p_Rt\u0014\"\u0001:\u0002\u0007=\u0014x-\u0003\u0002uk\u00061\u0011\r]1dQ\u0016T\u0011A]\u0005\u0003C]T!\u0001^;\n\u0005eT\u0018AB2p[6|gN\u0003\u0002\"o&\u0011A0`\u0001\b[\u0016\u001c8/Y4f\u0015\tI(0C\u0002\u0000\u0003\u0003\t!%\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:SKF,Xm\u001d;ECR\f'B\u0001?~\u0013\u0011\t)!a\u0002\u0003)\u0005cG/\u001a:D_:4\u0017nZ:SKN|WO]2f\u0015\ry\u0018\u0011\u0001\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB?\u0002\u0011I,\u0017/^3tiNLA!a\u0005\u0002\u000e\tA\u0011\t]5FeJ|'\u000fC\u0004\u0002\u0018%\u0001\r!!\u0007\u0002\u000fI,\u0017/^3tiB!\u00111DA\u000f\u001b\t\t\t!\u0003\u0003\u0002 \u0005\u0005!AI%oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4t%\u0016\fX/Z:u\t\u0006$\u0018\rC\u0004\u0002$%\u0001\r!!\n\u0002\u0013\u0005,H\u000f[8sSj,\u0007#C\u0013\u0002(\u0005-\u0012qGA$\u0013\r\tIC\n\u0002\n\rVt7\r^5p]J\u0002B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003ci\u0018\u0001\u0003:fg>,(oY3\n\t\u0005U\u0012q\u0006\u0002\r%\u0016\u001cx.\u001e:dKRK\b/\u001a\t\u0005\u0003s\t\tE\u0004\u0003\u0002<\u0005u\u0002C\u00018'\u0013\r\tyDJ\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0013Q\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}b\u0005E\u0002&\u0003\u0013J1!a\u0013'\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0014\n!\u0003\u0005\r!!\u0015\u0002I\u0005,H\u000f[8sSj,W*\u001b:s_J$v\u000e]5d\u0007>tg-[4WC2LG-\u0019;j_:\u0004R!JA*\u0003\u000fJ1!!\u0016'\u0005%1UO\\2uS>t\u0007'\u0001\u000bqe\u0016\u0004(o\\2fgN$C-\u001a4bk2$HeM\u000b\u0003\u00037RC!!\u0015\u0002^-\u0012\u0011q\f\t\u0005\u0003C\nY'\u0004\u0002\u0002d)!\u0011QMA4\u0003%)hn\u00195fG.,GMC\u0002\u0002j\u0019\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti'a\u0019\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000ewC2LG-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ\"iC:<W\r\u0006\u0004\u0002t\u0005e\u00141\u0010\t\u0004K\u0005U\u0014bAA<M\t!QK\\5u\u0011\u0019\t\td\u0003a\u0001O\"9\u0011QP\u0006A\u0002\u0005}\u0014AD2p]\u001aLwMU3t_V\u00148-\u001a\t\u0005\u0003\u0003\u000b9)\u0004\u0002\u0002\u0004*\u0019\u0011QQ?\u0002\r\r|gNZ5h\u0013\u0011\tI)a!\u0003\u001d\r{gNZ5h%\u0016\u001cx.\u001e:dKR1\u00111OAG\u0003/Cq!a$\r\u0001\u0004\t\t*A\u0003qe>\u00048\u000fE\u0002a\u0003'K1!!&b\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0003{b\u0001\u0019AA@)\u0011\tY*!+\u0011\r\u0001,\u0017QTA\u0005!\u0011\ty*!*\u000f\u0007%\f\t+\u0003\u0003\u0002$\u0006\u0005\u0011aF!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z9vKN$H)\u0019;b\u0013\u0011\t)!a*\u000b\t\u0005\r\u0016\u0011\u0001\u0005\b\u0003/i\u0001\u0019AAV!\u0011\tY\"!,\n\t\u0005=\u0016\u0011\u0001\u0002\u0018\u00032$XM]\"p]\u001aLwm\u001d*fcV,7\u000f\u001e#bi\u0006$b!a\u001d\u00024\u0006U\u0006bBA\u0019\u001d\u0001\u0007\u0011Q\u0014\u0005\b\u0003{r\u0001\u0019AA@\u0003\r2\u0018\r\\5eCR,'+Z:pkJ\u001cWMT1nK&\u001b8)\u001e:sK:$hj\u001c3f\u0013\u0012$B!a\u001d\u0002<\"9\u0011QX\bA\u0002\u0005]\u0012\u0001\u00028b[\u0016\f\u0001&\\1zE\u0016lu\u000eZ5gs&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u0014V-];fgR$b!a1\u0002P\u0006E\u0007CBAc\u0003\u0017\fI\"\u0004\u0002\u0002H*\u0019\u0011\u0011Z1\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002N\u0006\u001d'!E\"p[BdW\r^1cY\u00164U\u000f^;sK\"9\u0011q\u0003\tA\u0002\u0005e\u0001BBAj!\u0001\u0007q,A\u0005qe>\u001cWm]:fI\u0006\u0011s-\u001a;J]R\u0014\u0018M\\3u\u0005>|Go\u001d;sCB4uN]!mi\u0016\u00148i\u001c8gS\u001e$B!!7\u0002\\B1\u0011QYAf\u0003oAa!!\r\u0012\u0001\u00049\u0017!\b:fCN\u001cX-\u001c2mK&s7M]3nK:$\u0018\r\u001c*fgB|gn]3\u0015\u0011\u0005\u0005\u0018q]Av\u0003_\u0004B!a\u0007\u0002d&!\u0011Q]A\u0001\u0005\rJen\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7OU3ta>t7/\u001a#bi\u0006Dq!!;\u0013\u0001\u0004\tI\"\u0001\u0005pe&<\u0017N\\1m\u0011\u0019\tiO\u0005a\u0001?\u00061\u0002O]3qe>\u001cWm]:j]\u001e\u0014Vm\u001d9p]N,7\u000fC\u0004\u0002rJ\u0001\r!!9\u0002'A,'o]5ti\u0016tGOU3ta>t7/Z:\u0002%\r{gNZ5h\u0003\u0012l\u0017N\\'b]\u0006<WM\u001d\t\u0003mQ\u0019\"\u0001\u0006\u0013\u0015\u0005\u0005U\u0018a\u00017pOV\u0011\u0011q \t\u0005\u0005\u0003\u00119!\u0004\u0002\u0003\u0004)\u0019!QA;\u0002\u000bMdg\r\u000e6\n\t\t%!1\u0001\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\u0001\u0018G>\u0004\u0018pV5uQ>,H\u000f\u0015:faJ|7-Z:tK\u0012$b!a+\u0003\u0012\tM\u0001bBA\f1\u0001\u0007\u00111\u0016\u0005\b\u0003'D\u0002\u0019AAN\u0003a\u0011X-Y:tK6\u0014G.\u001a'fO\u0006\u001c\u0017PU3ta>t7/\u001a\u000b\t\u00053\u0011yB!\t\u0003$A!\u00111\u0004B\u000e\u0013\u0011\u0011i\"!\u0001\u00031\u0005cG/\u001a:D_:4\u0017nZ:SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0004\u0002jf\u0001\r!a+\t\u000f\u00055\u0018\u00041\u0001\u0002\u001c\"9\u0011\u0011_\rA\u0002\te\u0011AE2p]R\f\u0017N\\:EkBd\u0017nY1uKN,BA!\u000b\u0003FQ!\u0011q\tB\u0016\u0011\u001d\u0011iC\u0007a\u0001\u0005_\t\u0001\"\u001b;fe\u0006\u0014G.\u001a\t\u0007\u0005c\u0011YD!\u0011\u000f\t\tM\"q\u0007\b\u0004]\nU\u0012\"A\u0014\n\u0007\teb%A\u0004qC\u000e\\\u0017mZ3\n\t\tu\"q\b\u0002\t\u0013R,'/\u00192mK*\u0019!\u0011\b\u0014\u0011\t\t\r#Q\t\u0007\u0001\t\u001d\u00119E\u0007b\u0001\u0005\u0013\u0012\u0011\u0001V\t\u0005\u0005\u0017\u0012\t\u0006E\u0002&\u0005\u001bJ1Aa\u0014'\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!\nB*\u0013\r\u0011)F\n\u0002\u0004\u0003:L\u0018a\u0004;p\u0019><w-\u00192mKB\u0013x\u000e]:\u0015\r\tm#q\rB5!!\u0011iFa\u0019\u00028\u0005]RB\u0001B0\u0015\r\u0011\tGJ\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B3\u0005?\u00121!T1q\u0011\u001d\t\td\u0007a\u0001\u0003\u007fBqAa\u001b\u001c\u0001\u0004\t\t*A\u0006d_:4\u0017n\u001a)s_B\u001c\u0018!\u00079sKB\f'/Z%oGJ,W.\u001a8uC2\u001cuN\u001c4jON$\u0002\"a\u001d\u0003r\t-%Q\u0012\u0005\b\u0005gb\u0002\u0019\u0001B;\u00039\tG\u000e^3s\u0007>tg-[4PaN\u0004bA!\u0018\u0003x\tm\u0014\u0002\u0002B=\u0005?\u00121aU3r!\u0011\u0011iHa\"\u000e\u0005\t}$\u0002\u0002BA\u0005\u0007\u000bQ!\u00193nS:T1A!\"{\u0003\u001d\u0019G.[3oiNLAA!#\u0003\u0000\ti\u0011\t\u001c;fe\u000e{gNZ5h\u001fBDqAa\u001b\u001d\u0001\u0004\t\t\nC\u0004\u0003\u0010r\u0001\rA!%\u0002\u0015\r|gNZ5h\u0017\u0016L8\u000f\u0005\u0005\u0003^\t\r\u0014q\u0007BJ!\u0011\u0011)Ja(\u000f\t\t]%1\u0014\b\u0004U\ne\u0015bAAC{&!!QTAB\u0003%\u0019uN\u001c4jO\u0012+g-\u0003\u0003\u0003\"\n\r&!C\"p]\u001aLwmS3z\u0015\u0011\u0011i*a!")
public class ConfigAdminManager
implements Logging {
    private final int nodeId;
    private final KafkaConfig conf;
    private final ConfigRepository configRepository;
    private final ClusterLinkFactory.LinkManager clusterLinkManager;
    private final RuntimeLoggerManager runtimeLoggerManager;
    private com.typesafe.scalalogging.Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void prepareIncrementalConfigs(Seq<AlterConfigOp> alterConfigOps, Properties configProps, Map<String, ConfigDef.ConfigKey> configKeys) {
        ConfigAdminManager$.MODULE$.prepareIncrementalConfigs(alterConfigOps, configProps, configKeys);
    }

    public static Map<String, String> toLoggableProps(ConfigResource resource, Properties configProps) {
        return ConfigAdminManager$.MODULE$.toLoggableProps(resource, configProps);
    }

    public static <T> boolean containsDuplicates(Iterable<T> iterable) {
        return ConfigAdminManager$.MODULE$.containsDuplicates(iterable);
    }

    public static AlterConfigsResponseData reassembleLegacyResponse(AlterConfigsRequestData original, IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessingResponses, AlterConfigsResponseData persistentResponses) {
        return ConfigAdminManager$.MODULE$.reassembleLegacyResponse(original, preprocessingResponses, persistentResponses);
    }

    public static AlterConfigsRequestData copyWithoutPreprocessed(AlterConfigsRequestData request, IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> processed) {
        return ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed);
    }

    public static Logger log() {
        return ConfigAdminManager$.MODULE$.log();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        ConfigAdminManager configAdminManager = this;
        synchronized (configAdminManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public RuntimeLoggerManager runtimeLoggerManager() {
        return this.runtimeLoggerManager;
    }

    public IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> preprocess(IncrementalAlterConfigsRequestData request, Function2<ResourceType, String, Object> authorize, Function0<Object> authorizeMirrorTopicConfigValidation) {
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> results = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        HashMap resourceIds = new HashMap();
        request.resources().forEach(resource -> {
            IncrementalAlterConfigsRequestData.AlterConfigsResource preexisting = resourceIds.put(new Tuple2<Byte, String>(BoxesRunTime.boxToByte(resource.resourceType()), resource.resourceName()), resource);
            if (preexisting != null) {
                new $colon$colon<Nothing$>((Nothing$)((Object)preexisting), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)resource), Nil$.MODULE$)).foreach((Function1<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> & Serializable)r -> results.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)r, new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once.")));
                return;
            }
        });
        request.resources().forEach(resource -> {
            if (!results.containsKey(resource)) {
                block21: {
                    ConfigResource.Type resourceType = ConfigResource.Type.forId(resource.resourceType());
                    ConfigResource configResource = new ConfigResource(resourceType, resource.resourceName());
                    try {
                        if (ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(resource.configs()).asScala().map((Function1<IncrementalAlterConfigsRequestData.AlterableConfig, String> & Serializable)x$1 -> x$1.name()))) {
                            throw new InvalidRequestException("Error due to duplicate config keys");
                        }
                        ArrayList nullUpdates = new ArrayList();
                        resource.configs().forEach(config -> {
                            if (config.configOperation() != AlterConfigOp.OpType.DELETE.id() && config.value() == null) {
                                nullUpdates.add(config.name());
                                return;
                            }
                        });
                        if (!nullUpdates.isEmpty()) {
                            throw new InvalidRequestException("Null value not supported for : " + String.join((CharSequence)", ", nullUpdates));
                        }
                        ConfigResource.Type type = resourceType;
                        if (((Object)((Object)ConfigResource.Type.BROKER_LOGGER)).equals((Object)type)) {
                            this.runtimeLoggerManager().applyChangesForResource(BoxesRunTime.unboxToBoolean(authorize.apply(ResourceType.CLUSTER, "kafka-cluster")), request.validateOnly(), (IncrementalAlterConfigsRequestData.AlterConfigsResource)resource);
                            results.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, ApiError.NONE);
                            break block21;
                        }
                        if (((Object)((Object)ConfigResource.Type.BROKER)).equals((Object)type)) {
                            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(configResource.name()))) {
                                this.validateResourceNameIsCurrentNodeId(resource.resourceName());
                            }
                            this.validateBrokerConfigChange((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, configResource);
                            break block21;
                        }
                        if (((Object)((Object)ConfigResource.Type.TOPIC)).equals((Object)type)) {
                            if (!request.skipMirrorTopicConfigValidation()) {
                                ClusterLinkUtils$.MODULE$.validateMirrorTopicConfig(resource.resourceName(), ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(resource.configs()).asScala().map((Function1<IncrementalAlterConfigsRequestData.AlterableConfig, String> & Serializable)cfg -> cfg.name())).toSet(), this.clusterLinkManager(), true);
                            } else if (request.skipMirrorTopicConfigValidation() && !authorizeMirrorTopicConfigValidation.apply$mcZ$sp()) {
                                throw new ClusterAuthorizationException(Errors.CLUSTER_AUTHORIZATION_FAILED.message());
                            }
                            break block21;
                        }
                        if (((Object)((Object)ConfigResource.Type.CLUSTER_LINK)).equals((Object)type)) {
                            Option<ClusterLinkMetadataManager> option = this.clusterLinkManager().clusterLinkMetadataManager();
                            if (option instanceof Some) {
                                String linkName;
                                Some some = (Some)option;
                                ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)some.value();
                                Option<ClusterLinkData> linkData = metadataManager.getClusterLinkData(linkName = resource.resourceName());
                                Option<ClusterLinkData> option2 = linkData;
                                if (option2 instanceof Some) {
                                    Some some2 = (Some)option2;
                                    ClusterLinkData cld = (ClusterLinkData)some2.value();
                                    Properties configProps = metadataManager.getClusterLinkConfigProps(cld.linkId());
                                    Option<ClusterLinkConfig> currentConfig = this.clusterLinkManager().linkConfigFromPersistentProps(linkName, configProps, this.clusterLinkManager().linkConfigFromPersistentProps$default$3());
                                    scala.collection.immutable.Seq<AlterConfigOp> alterConfigOps = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(resource.configs()).asScala().map((Function1<IncrementalAlterConfigsRequestData.AlterableConfig, AlterConfigOp> & Serializable)config -> {
                                        AlterConfigOp.OpType opType = AlterConfigOp.OpType.forId(config.configOperation());
                                        if (opType == null) {
                                            throw new InvalidRequestException("Unknown operations type " + config.configOperation());
                                        }
                                        return new AlterConfigOp(new ConfigEntry(config.name(), config.value()), opType);
                                    })).toSeq();
                                    ConfigAdminManager$.MODULE$.prepareIncrementalConfigs(alterConfigOps, configProps, ClusterLinkConfig$.MODULE$.configKeys());
                                    ClusterLinkConfig newConfig = ClusterLinkConfig$.MODULE$.create(configProps, new Some<KafkaConfig>($this.conf), ClusterLinkConfig$.MODULE$.create$default$3());
                                    currentConfig.foreach((Function1<ClusterLinkConfig, Object> & Serializable)x$2 -> {
                                        x$2.validateReconfiguration(newConfig);
                                        return BoxedUnit.UNIT;
                                    });
                                    if (newConfig.autoMirroringEnable()) {
                                        this.clusterLinkManager().maybeCheckForOverlappingTopicFilters(newConfig, cld.linkName(), cld.tenantPrefix());
                                    }
                                    break block21;
                                }
                                if (None$.MODULE$.equals(option2)) {
                                    throw new ClusterLinkNotFoundException("Cluster link with name " + linkName + " wasn't found.");
                                }
                                throw new MatchError(option2);
                            }
                            if (None$.MODULE$.equals(option)) {
                                throw ClusterLinkDisabled$.MODULE$.exception(ClusterLinkDisabled$.MODULE$.exception$default$1());
                            }
                            throw new MatchError(option);
                        }
                        if (((Object)((Object)ConfigResource.Type.CLIENT_METRICS)).equals((Object)type) ? true : ((Object)((Object)ConfigResource.Type.GROUP)).equals((Object)type)) {
                            break block21;
                        }
                        throw new InvalidRequestException("Unknown resource type " + resource.resourceType());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof ConfigException ? true : throwable2 instanceof IllegalArgumentException) {
                            String message = "Invalid config value for resource " + resource + ": " + throwable2.getMessage();
                            this.info((Function0<String> & Serializable)() -> message);
                            ApiError err = ApiError.fromThrowable(new InvalidConfigurationException(message, throwable2));
                            results.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, err);
                        }
                        if (throwable2 != null) {
                            Throwable throwable3 = throwable2;
                            ApiError err = ApiError.fromThrowable(throwable3);
                            this.info((Function0<String> & Serializable)() -> "Error preprocessing incrementalAlterConfigs request on " + configResource, (Function0<Throwable> & Serializable)() -> throwable3);
                            results.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, err);
                        }
                        throw throwable;
                    }
                }
                return;
            }
        });
        return results;
    }

    private void validateBrokerConfigChange(IncrementalAlterConfigsRequestData.AlterConfigsResource resource, ConfigResource configResource) {
        boolean perBrokerConfig = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(configResource.name()));
        Properties persistentProps = this.configRepository.config(configResource);
        Properties configProps = this.conf.dynamicConfig().fromPersistentProps(persistentProps, perBrokerConfig);
        scala.collection.immutable.Seq<AlterConfigOp> alterConfigOps = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(resource.configs()).asScala().map((Function1<IncrementalAlterConfigsRequestData.AlterableConfig, AlterConfigOp> & Serializable)config -> {
            AlterConfigOp.OpType opType = AlterConfigOp.OpType.forId(config.configOperation());
            if (opType == null) {
                throw new InvalidRequestException("Unknown operations type " + config.configOperation());
            }
            return new AlterConfigOp(new ConfigEntry(config.name(), config.value()), opType);
        })).toSeq();
        ConfigAdminManager$.MODULE$.prepareIncrementalConfigs(alterConfigOps, configProps, KafkaConfig$.MODULE$.configKeys());
        try {
            this.validateBrokerConfigChange(configProps, configResource);
        }
        catch (Throwable t) {
            this.error((Function0<String> & Serializable)() -> "validation of configProps " + configProps + " for " + configResource + " failed with exception", (Function0<Throwable> & Serializable)() -> t);
            throw t;
        }
    }

    private void validateBrokerConfigChange(Properties props, ConfigResource configResource) {
        try {
            this.conf.dynamicConfig().validate(props, StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(configResource.name())));
        }
        catch (ApiException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> preprocess(AlterConfigsRequestData request) {
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> results = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        HashMap resourceIds = new HashMap();
        request.resources().forEach(resource -> {
            AlterConfigsRequestData.AlterConfigsResource preexisting = resourceIds.put(new Tuple2<Byte, String>(BoxesRunTime.boxToByte(resource.resourceType()), resource.resourceName()), resource);
            if (preexisting != null) {
                new $colon$colon<Nothing$>((Nothing$)((Object)preexisting), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)resource), Nil$.MODULE$)).foreach((Function1<AlterConfigsRequestData.AlterConfigsResource, ApiError> & Serializable)r -> results.put((AlterConfigsRequestData.AlterConfigsResource)r, new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once.")));
                return;
            }
        });
        request.resources().forEach(resource -> {
            if (!results.containsKey(resource)) {
                block9: {
                    ConfigResource.Type resourceType = ConfigResource.Type.forId(resource.resourceType());
                    ConfigResource configResource = new ConfigResource(resourceType, resource.resourceName());
                    try {
                        if (ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(resource.configs()).asScala().map((Function1<AlterConfigsRequestData.AlterableConfig, String> & Serializable)x$3 -> x$3.name()))) {
                            throw new InvalidRequestException("Error due to duplicate config keys");
                        }
                        ArrayList nullUpdates = new ArrayList();
                        resource.configs().forEach(config -> {
                            if (config.value() == null) {
                                nullUpdates.add(config.name());
                                return;
                            }
                        });
                        if (!nullUpdates.isEmpty()) {
                            throw new InvalidRequestException("Null value not supported for : " + String.join((CharSequence)", ", nullUpdates));
                        }
                        ConfigResource.Type type = resourceType;
                        if (((Object)((Object)ConfigResource.Type.BROKER)).equals((Object)type)) {
                            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(configResource.name()))) {
                                this.validateResourceNameIsCurrentNodeId(resource.resourceName());
                            }
                            this.validateBrokerConfigChange((AlterConfigsRequestData.AlterConfigsResource)resource, configResource);
                            break block9;
                        }
                        if (((Object)((Object)ConfigResource.Type.TOPIC)).equals((Object)type)) {
                            ClusterLinkUtils$.MODULE$.validateMirrorTopicConfig(resource.resourceName(), ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(resource.configs()).asScala().map((Function1<AlterConfigsRequestData.AlterableConfig, String> & Serializable)cfg -> cfg.name())).toSet(), this.clusterLinkManager(), false);
                            break block9;
                        }
                        if (((Object)((Object)ConfigResource.Type.CLIENT_METRICS)).equals((Object)type) ? true : ((Object)((Object)ConfigResource.Type.GROUP)).equals((Object)type)) {
                            break block9;
                        }
                        throw new InvalidRequestException("Unknown resource type " + resource.resourceType());
                    }
                    catch (Throwable t) {
                        ApiError err = ApiError.fromThrowable(t);
                        this.info((Function0<String> & Serializable)() -> "Error preprocessing alterConfigs request on " + configResource + ": " + err);
                        results.put((AlterConfigsRequestData.AlterConfigsResource)resource, err);
                    }
                }
                return;
            }
        });
        return results;
    }

    public Function0<Object> preprocess$default$3() {
        return () -> false;
    }

    private void validateBrokerConfigChange(AlterConfigsRequestData.AlterConfigsResource resource, ConfigResource configResource) {
        Properties props = new Properties();
        resource.configs().forEach(config -> props.setProperty(config.name(), config.value()));
        this.validateBrokerConfigChange(props, configResource);
    }

    public void validateResourceNameIsCurrentNodeId(String name) {
        int n;
        try {
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(name));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException("Node id must be an integer, but it is: " + name);
        }
        int id = n;
        if (id != this.nodeId) {
            throw new InvalidRequestException("Unexpected broker id, expected " + this.nodeId + ", but received " + name);
        }
    }

    public CompletableFuture<IncrementalAlterConfigsRequestData> maybeModifyIncrementalAlterConfigRequest(IncrementalAlterConfigsRequestData request, IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed) {
        CompletableFuture<IncrementalAlterConfigsRequestData> result = new CompletableFuture<IncrementalAlterConfigsRequestData>();
        IncrementalAlterConfigsRequestData copy = new IncrementalAlterConfigsRequestData().setValidateOnly(request.validateOnly()).setSkipMirrorTopicConfigValidation(request.skipMirrorTopicConfigValidation());
        HashMap bootstrapFutures = new HashMap();
        request.resources().forEach(resource -> {
            ConfigResource.Type type = ConfigResource.Type.forId(resource.resourceType());
            if (((Object)((Object)ConfigResource.Type.CLUSTER_LINK)).equals((Object)type)) {
                if (!processed.containsKey(resource)) {
                    BoxedUnit boxedUnit;
                    CompletableFuture<Object> bootstrapResult = new CompletableFuture<Object>();
                    try {
                        CompletableFuture<String> intranetBootstrapFuture = this.getIntranetBootstrapForAlterConfig((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource);
                        bootstrapFutures.put(resource, bootstrapResult);
                        ArrayList newConfigs = new ArrayList();
                        intranetBootstrapFuture.whenComplete((intranetBootstrap, exception) -> {
                            if (exception != null) {
                                ConfigAdminManager$.MODULE$.log().error("Failed to get intranet bootstrap for cluster link " + resource.resourceName() + ", will continue to update rest of the configs", (Throwable)exception);
                                v0 = processed.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, ApiError.fromThrowable(exception));
                            } else {
                                try {
                                    if (intranetBootstrap != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(intranetBootstrap.trim()))) {
                                        this.debug((Function0<String> & Serializable)() -> "Setting bootstrap override for cluster link " + resource.resourceName() + " to " + intranetBootstrap);
                                        v1 = BoxesRunTime.boxToBoolean(newConfigs.add(new IncrementalAlterConfigsRequestData.AlterableConfig().setName(ClusterLinkConfig$.MODULE$.BootstrapServersOverrideProp()).setValue((String)intranetBootstrap).setConfigOperation(AlterConfigOp.OpType.SET.id())));
                                    } else {
                                        v1 = BoxedUnit.UNIT;
                                    }
                                    CollectionConverters$.MODULE$.CollectionHasAsScala(resource.configs()).asScala().foreach((Function1<IncrementalAlterConfigsRequestData.AlterableConfig, Object> & Serializable)cfg -> BoxesRunTime.boxToBoolean(newConfigs.add(new IncrementalAlterConfigsRequestData.AlterableConfig().setName(cfg.name()).setValue(cfg.value()).setConfigOperation(cfg.configOperation()))));
                                    Tuple2<String, Object> tuple2 = new Tuple2<String, Object>(this.linkIdAsString$1((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource), null);
                                    if (tuple2 == null) {
                                        throw new MatchError(tuple2);
                                    }
                                    String resourceName = tuple2._1();
                                    Null$ resourceId = tuple2._2();
                                    Tuple2<String, Object> tuple22 = new Tuple2<String, Object>(resourceName, null);
                                    String resourceName2 = tuple22._1();
                                    Null$ resourceId2 = tuple22._2();
                                    copy.resources().mustAdd(new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName(resourceName2).setClusterLinkResourceId(null).setResourceType(resource.resourceType()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(newConfigs.iterator())));
                                    v0 = BoxedUnit.UNIT;
                                }
                                catch (Throwable ex) {
                                    ConfigAdminManager$.MODULE$.log().debug("Encountered an error when processing cluster link resource " + resource + " in IncrementalAlterConfigs request. " + ex.getMessage());
                                    v0 = processed.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, ApiError.fromThrowable(ex));
                                }
                            }
                            bootstrapResult.complete(null);
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable ex) {
                        ConfigAdminManager$.MODULE$.log().warn("Encountered an error when processing cluster link resource " + resource + " in IncrementalAlterConfigs request. " + ex.getMessage());
                        processed.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, ApiError.fromThrowable(ex));
                        bootstrapResult.complete(null);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                return;
            }
            if (!processed.containsKey(resource)) {
                copy.resources().mustAdd(resource.duplicate());
                return;
            }
        });
        Object object = bootstrapFutures.isEmpty() ? BoxesRunTime.boxToBoolean(result.complete(copy)) : CompletableFuture.allOf((CompletableFuture[])CollectionConverters$.MODULE$.CollectionHasAsScala(bootstrapFutures.values()).asScala().toSeq().toArray(ClassTag$.MODULE$.apply(CompletableFuture.class))).whenComplete((x$6, ex) -> {
            if (ex != null) {
                bootstrapFutures.keySet().forEach(resource -> processed.putIfAbsent((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, ApiError.fromThrowable(ex)));
            }
            result.complete(copy);
        });
        return result;
    }

    public CompletableFuture<String> getIntranetBootstrapForAlterConfig(IncrementalAlterConfigsRequestData.AlterConfigsResource resource) {
        Option newBootstrap = CollectionConverters$.MODULE$.CollectionHasAsScala(resource.configs()).asScala().find((Function1<IncrementalAlterConfigsRequestData.AlterableConfig, Object> & Serializable)cfg -> BoxesRunTime.boxToBoolean(ConfigAdminManager.$anonfun$getIntranetBootstrapForAlterConfig$1(cfg)));
        Option<ClusterLinkData> existingLink = this.clusterLinkManager().linkData(resource.resourceName());
        if (existingLink.nonEmpty() && newBootstrap.nonEmpty() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((IncrementalAlterConfigsRequestData.AlterableConfig)newBootstrap.get()).value().trim())) && ((IncrementalAlterConfigsRequestData.AlterableConfig)newBootstrap.get()).configOperation() == AlterConfigOp.OpType.SET.id()) {
            return this.clusterLinkManager().getIntranetBootstrapForAlterConfig(existingLink.get(), ((IncrementalAlterConfigsRequestData.AlterableConfig)newBootstrap.get()).value().trim());
        }
        return CompletableFuture.completedFuture("");
    }

    public IncrementalAlterConfigsResponseData reassembleIncrementalResponse(IncrementalAlterConfigsRequestData original, IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessingResponses, IncrementalAlterConfigsResponseData persistentResponses) {
        IncrementalAlterConfigsResponseData response = new IncrementalAlterConfigsResponseData();
        scala.collection.immutable.Map responsesByResource = CollectionConverters$.MODULE$.IteratorHasAsScala(persistentResponses.responses().iterator()).asScala().map((Function1<IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse, Tuple2> & Serializable)x0$1 -> {
            IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse alterConfigsResourceResponse = x0$1;
            ConfigResource.Type type = ConfigResource.Type.forId(alterConfigsResourceResponse.resourceType());
            ConfigResource.Type type2 = ConfigResource.Type.CLUSTER_LINK;
            if (!(type != null ? !((Object)((Object)type)).equals((Object)type2) : type2 != null)) {
                String string;
                ConfigRepository configRepository = $this.configRepository;
                if (configRepository instanceof KRaftMetadataCache) {
                    KRaftMetadataCache kRaftMetadataCache = (KRaftMetadataCache)configRepository;
                    String linkId = alterConfigsResourceResponse.resourceName();
                    try {
                        string = kRaftMetadataCache.currentImage().clusterLinks().linksById().get(Uuid.fromString(linkId)).linkName();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new IllegalStateException("Found non Kafka link id in KRaft mode.");
                    }
                } else {
                    throw new IllegalStateException("Unsupported config repository type");
                }
                String resourceName = string;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new Tuple2<String, Byte>(resourceName, BoxesRunTime.boxToByte(alterConfigsResourceResponse.resourceType()))), new ApiError(alterConfigsResourceResponse.errorCode(), alterConfigsResourceResponse.errorMessage()));
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new Tuple2<String, Byte>(alterConfigsResourceResponse.resourceName(), BoxesRunTime.boxToByte(alterConfigsResourceResponse.resourceType()))), new ApiError(alterConfigsResourceResponse.errorCode(), alterConfigsResourceResponse.errorMessage()));
        }).toMap($less$colon$less$.MODULE$.refl());
        original.resources().forEach(r -> {
            ApiError apiError;
            Option option = Option$.MODULE$.apply(preprocessingResponses.get(r));
            if (None$.MODULE$.equals(option)) {
                Option option2 = responsesByResource.get(new Tuple2<String, Byte>(r.resourceName(), BoxesRunTime.boxToByte(r.resourceType())));
                if (None$.MODULE$.equals(option2)) {
                    ConfigAdminManager$.MODULE$.log().error("The controller returned fewer results than we expected. No response found for " + r + ".");
                    apiError = new ApiError(Errors.UNKNOWN_SERVER_ERROR);
                } else {
                    ApiError err;
                    if (!(option2 instanceof Some)) throw new MatchError(option2);
                    Some some = (Some)option2;
                    apiError = err = (ApiError)some.value();
                }
            } else {
                ApiError err;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                apiError = err = (ApiError)some.value();
            }
            ApiError err = apiError;
            response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName(r.resourceName()).setResourceType(r.resourceType()).setErrorCode(err.error().code()).setErrorMessage(err.message()));
        });
        return response;
    }

    private final String linkIdAsString$1(IncrementalAlterConfigsRequestData.AlterConfigsResource resource$1) {
        return ((Uuid)this.clusterLinkManager().linkData(resource$1.resourceName()).map((Function1<ClusterLinkData, Uuid> & Serializable)x$4 -> x$4.linkId()).getOrElse((Function0<Nothing$> & Serializable)() -> {
            throw new InvalidRequestException("Unable to find cluster link resource " + resource$1.resourceName());
        })).toString();
    }

    public static final /* synthetic */ boolean $anonfun$getIntranetBootstrapForAlterConfig$1(IncrementalAlterConfigsRequestData.AlterableConfig cfg) {
        String string = cfg.name();
        String string2 = "bootstrap.servers";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ConfigAdminManager(int nodeId, KafkaConfig conf, ConfigRepository configRepository, ClusterLinkFactory.LinkManager clusterLinkManager) {
        this.nodeId = nodeId;
        this.conf = conf;
        this.configRepository = configRepository;
        this.clusterLinkManager = clusterLinkManager;
        Logging.$init$(this);
        this.logIdent_$eq("[ConfigAdminManager[nodeId=" + nodeId + "]: ");
        this.runtimeLoggerManager = new RuntimeLoggerManager(nodeId, this.logger().underlying());
    }
}

