/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.server.AbstractLogReadResult;
import kafka.server.DelayedFetch$;
import kafka.server.DelayedFetchMetrics$;
import kafka.server.FetchLag$;
import kafka.server.LogReadResult;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierLogReadResult;
import kafka.tier.fetcher.PendingFetch;
import kafka.tier.fetcher.TierFetchResult;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.purgatory.DelayedOperation;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetSnapshot;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcZ$sp;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001\u0002\f\u0018\u0001qA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011!9\u0006A!A!\u0002\u0013A\u0006\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u00111\u0004!\u0011!Q\u0001\n5D\u0001\u0002\u001f\u0001\u0003\u0002\u0003\u0006I!\u001f\u0005\ty\u0002\u0011\t\u0011)A\u0005{\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\b\u0003\u007f\u0001A\u0011BA!\u0011\u001d\t)\u0007\u0001C!\u0003OBq!!\u001b\u0001\t\u0013\t9\u0007C\u0004\u0002l\u0001!\t%!\u001c\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u0011Q\u0010\u0001\u0005B\u00055t!CA@/\u0005\u0005\t\u0012AAA\r!1r#!A\t\u0002\u0005\r\u0005bBA\u0007'\u0011\u0005\u00111\u0012\u0005\n\u0003\u001b\u001b\u0012\u0013!C\u0001\u0003\u001f\u0013A\u0002R3mCf,GMR3uG\"T!\u0001G\r\u0002\rM,'O^3s\u0015\u0005Q\u0012!B6bM.\f7\u0001A\n\u0004\u0001uI\u0003C\u0001\u0010(\u001b\u0005y\"B\u0001\u0011\"\u0003%\u0001XO]4bi>\u0014\u0018P\u0003\u0002\u0019E)\u0011!d\t\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014x-\u0003\u0002)?\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\u001c\t\u0003U5j\u0011a\u000b\u0006\u0003Ye\tQ!\u001e;jYNL!AL\u0016\u0003\u000f1{wmZ5oO\u00061\u0001/\u0019:b[N\u0004\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\u00071|wM\u0003\u00026C\u000591\u000f^8sC\u001e,\u0017BA\u001c3\u0005-1U\r^2i!\u0006\u0014\u0018-\\:\u0002\u001f\u0019,Go\u00195QCJ$\u0018\u000e^5p]N\u00042AO B\u001b\u0005Y$B\u0001\u001f>\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002}\u0005)1oY1mC&\u0011\u0001i\u000f\u0002\u0004'\u0016\f\b\u0003\u0002\"D\u000b.k\u0011!P\u0005\u0003\tv\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001$J\u001b\u00059%B\u0001%#\u0003\u0019\u0019w.\\7p]&\u0011!j\u0012\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004\"\u0001T'\u000e\u0003]I!AT\f\u0003-A\u000b'\u000f^5uS>tg)\u001a;dQ6+G/\u00193bi\u0006\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002M#&\u0011!k\u0006\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0015\tXo\u001c;b!\taU+\u0003\u0002W/\ta!+\u001a9mS\u000e\f\u0017+^8uC\u0006aA/[3s\r\u0016$8\r[(qiB\u0019!)W.\n\u0005ik$AB(qi&|g\u000e\u0005\u0002]C6\tQL\u0003\u0002_?\u00069a-\u001a;dQ\u0016\u0014(B\u00011\u001a\u0003\u0011!\u0018.\u001a:\n\u0005\tl&\u0001\u0004)f]\u0012Lgn\u001a$fi\u000eD\u0017\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t!\t)'.D\u0001g\u0015\t9\u0007.A\u0004nKR\u0014\u0018nY:\u000b\u0005MJ'BA\u001b#\u0013\tYgM\u0001\tCe>\\WM\u001d+pa&\u001c7\u000b^1ug\u0006\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\u0005\u0005:\u0004X/\u0003\u0002p{\tIa)\u001e8di&|g.\r\t\u0004u}\n\b\u0003\u0002\"D\u000bJ\u0004\"!M:\n\u0005Q\u0014$A\u0005$fi\u000eD\u0007+\u0019:uSRLwN\u001c#bi\u0006\u0004\"A\u0011<\n\u0005]l$\u0001B+oSR\fADZ3uG\"\u0004\u0016M\u001d;ji&|g\u000e\u0015:v]&tw-\u00128bE2,G\r\u0005\u0002Cu&\u001110\u0010\u0002\b\u0005>|G.Z1o\u0003i\t7mY;nk2\fG/\u001a3GKR\u001c\u0007\u000eT1uK:\u001c\u00170T1q!\u0019q\u00181A#\u0002\b5\tqPC\u0002\u0002\u0002m\nq!\\;uC\ndW-C\u0002\u0002\u0006}\u0014q\u0001S1tQ6\u000b\u0007\u000fE\u0002C\u0003\u0013I1!a\u0003>\u0005\u0011auN\\4\u0002\rqJg.\u001b;?)Q\t\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0003;\ty\"!\t\u0002$A\u0011A\n\u0001\u0005\u0006_)\u0001\r\u0001\r\u0005\u0006q)\u0001\r!\u000f\u0005\u0006\u001f*\u0001\r\u0001\u0015\u0005\u0006'*\u0001\r\u0001\u0016\u0005\u0006/*\u0001\r\u0001\u0017\u0005\u0006G*\u0001\r\u0001\u001a\u0005\u0006Y*\u0001\r!\u001c\u0005\u0006q*\u0001\r!\u001f\u0005\by*\u0001\n\u00111\u0001~\u0003!!xn\u0015;sS:<GCAA\u0015!\u0011\tY#!\u000f\u000f\t\u00055\u0012Q\u0007\t\u0004\u0003_iTBAA\u0019\u0015\r\t\u0019dG\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005]R(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003w\tiD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003oi\u0014a\u00054fi\u000eDwJ\u001a4tKRlU\r^1eCR\fGCBA\"\u0003#\n)\u0006\u0005\u0003\u0002F\u00055SBAA$\u0015\r\u0019\u0014\u0011\n\u0006\u0004\u0003\u0017J\u0017!C5oi\u0016\u0014h.\u00197t\u0013\u0011\ty%a\u0012\u0003#1{wm\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\r\u0003\u0004\u0002T1\u0001\raS\u0001\u000eM\u0016$8\r['fi\u0006$\u0017\r^1\t\u000f\u0005]C\u00021\u0001\u0002Z\u0005I\u0001/\u0019:uSRLwN\u001c\t\u0005\u00037\n\t'\u0004\u0002\u0002^)\u0019\u0011qL\r\u0002\u000f\rdWo\u001d;fe&!\u00111MA/\u0005%\u0001\u0016M\u001d;ji&|g.A\u0006uef\u001cu.\u001c9mKR,G#A=\u00023%\u001chj\u001c8US\u0016\u0014h)\u001a;dQ\u000e{W\u000e\u001d7fi\u0006\u0014G.Z\u0001\r_:,\u0005\u0010]5sCRLwN\u001c\u000b\u0002k\u0006)2m\u001c7mK\u000e$Hj\\4SK\u0006$'+Z:vYR\u001cHCAA:!\u0011Qt(!\u001e\u0011\u000b\t\u001bU)a\u001e\u0011\u00071\u000bI(C\u0002\u0002|]\u0011Q#\u00112tiJ\f7\r\u001e'pOJ+\u0017\r\u001a*fgVdG/\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016\fA\u0002R3mCf,GMR3uG\"\u0004\"\u0001T\n\u0014\u0007M\t)\tE\u0002C\u0003\u000fK1!!#>\u0005\u0019\te.\u001f*fMR\u0011\u0011\u0011Q\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\u0005E%fA?\u0002\u0014.\u0012\u0011Q\u0013\t\u0005\u0003/\u000b\t+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003%)hn\u00195fG.,GMC\u0002\u0002 v\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019+!'\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class DelayedFetch
extends DelayedOperation
implements Logging {
    private final FetchParams params;
    private final Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>> fetchPartitions;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Option<PendingFetch> tierFetchOpt;
    private final BrokerTopicStats brokerTopicStats;
    private final Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback;
    private final boolean fetchPartitionPruningEnabled;
    private final HashMap<TopicIdPartition, Object> accumulatedFetchLatencyMap;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static HashMap<TopicIdPartition, Object> $lessinit$greater$default$9() {
        return DelayedFetch$.MODULE$.$lessinit$greater$default$9();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DelayedFetch delayedFetch = this;
        synchronized (delayedFetch) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String toString() {
        return "DelayedFetch(params=" + this.params + ", numPartitions=" + this.fetchPartitions.size() + ")";
    }

    private LogOffsetMetadata fetchOffsetMetadata(PartitionFetchMetadata fetchMetadata, Partition partition) {
        LogOffsetMetadata fetchOffsetMetadata;
        block0: {
            LogOffsetMetadata logOffsetMetadata = fetchOffsetMetadata = fetchMetadata.fetchOffsetMetadata();
            LogOffsetMetadata logOffsetMetadata2 = LogOffsetMetadata.UNKNOWN_OFFSET_METADATA;
            if (!(logOffsetMetadata == null ? logOffsetMetadata2 != null : !((Object)logOffsetMetadata).equals(logOffsetMetadata2)) || !fetchOffsetMetadata.messageOffsetOnly()) break block0;
            long fetchOffset = fetchMetadata.fetchOffset();
            fetchOffsetMetadata = (LogOffsetMetadata)partition.convertToLocalOffsetMetadata(fetchOffset).getOrElse((Function0<LogOffsetMetadata> & Serializable)() -> LogOffsetMetadata.UNKNOWN_OFFSET_METADATA);
            fetchMetadata.setFetchOffsetMetadata(fetchOffsetMetadata);
        }
        return fetchOffsetMetadata;
    }

    @Override
    public boolean tryComplete() {
        Option<PendingFetch> option = this.tierFetchOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            PendingFetch tierFetch = (PendingFetch)some.value();
            if (tierFetch.isComplete()) {
                return this.forceComplete();
            }
            return false;
        }
        if (None$.MODULE$.equals(option)) {
            if (this.isNonTierFetchCompletable()) {
                return this.forceComplete();
            }
            return false;
        }
        throw new MatchError(option);
    }

    private boolean isNonTierFetchCompletable() {
        boolean bl;
        Object object = new Object();
        try {
            IntRef accumulatedSize = IntRef.create(0);
            this.fetchPartitions.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
                DelayedFetch.$anonfun$isNonTierFetchCompletable$1(this, object, accumulatedSize, x0$1);
                return BoxedUnit.UNIT;
            });
            bl = accumulatedSize.elem >= this.params.minBytes;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    @Override
    public void onExpiration() {
        this.tierFetchOpt.foreach((Function1<PendingFetch, Object> & Serializable)x$1 -> {
            x$1.markFetchExpired();
            return BoxedUnit.UNIT;
        });
        if (this.params.isFromFollower()) {
            DelayedFetchMetrics$.MODULE$.followerExpiredRequestMeter().mark();
            return;
        }
        DelayedFetchMetrics$.MODULE$.consumerExpiredRequestMeter().mark();
    }

    private Seq<Tuple2<TopicIdPartition, AbstractLogReadResult>> collectLogReadResults() {
        return this.replicaManager.readFromLog(this.params, this.fetchPartitions, this.quota, true, this.fetchPartitionPruningEnabled);
    }

    @Override
    public void onComplete() {
        Option tierFetcherReadResults = this.tierFetchOpt.map((Function1<PendingFetch, Map> & Serializable)x$2 -> CollectionConverters$.MODULE$.MapHasAsScala(x$2.finish()).asScala());
        Seq<Tuple2<TopicIdPartition, AbstractLogReadResult>> logReadResults = this.collectLogReadResults();
        Seq fetchPartitionData = (Seq)logReadResults.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LogReadResult logReadResult;
                TopicIdPartition tp = (TopicIdPartition)tuple2._1();
                AbstractLogReadResult logReadResult2 = (AbstractLogReadResult)tuple2._2();
                long tierFetchTime = 0L;
                AbstractLogReadResult abstractLogReadResult = logReadResult2;
                if (abstractLogReadResult instanceof TierLogReadResult) {
                    TierLogReadResult tierLogReadResult = (TierLogReadResult)abstractLogReadResult;
                    TierFetchResult tierFetchResult = (TierFetchResult)tierFetcherReadResults.flatMap((Function1<Map, Option> & Serializable)x$3 -> x$3.get(tp.topicPartition())).getOrElse((Function0<TierFetchResult> & Serializable)() -> TierFetchResult.emptyFetchResult());
                    tierFetchTime = tierFetchResult.fetchTotalTimeNanos;
                    logReadResult = tierLogReadResult.intoLogReadResult(tierFetchResult, !tierFetchResult.isEmpty());
                } else if (abstractLogReadResult instanceof LogReadResult) {
                    LogReadResult logReadResult3;
                    logReadResult = logReadResult3 = (LogReadResult)abstractLogReadResult;
                } else {
                    throw new MatchError(abstractLogReadResult);
                }
                LogReadResult result = logReadResult;
                FetchLag$.MODULE$.maybeRecordConsumerFetchTimeLag(!$this.params.isFromFollower(), result, $this.brokerTopicStats);
                boolean isReassignmentFetch = $this.params.isFromFollower() && $this.replicaManager.isAddingReplica(tp.topicPartition(), $this.params.replicaId);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), result.toFetchPartitionData(isReassignmentFetch, BoxesRunTime.unboxToLong($this.accumulatedFetchLatencyMap.getOrElse(tp, () -> 0L)), tierFetchTime));
            }
            throw new MatchError(tuple2);
        });
        this.responseCallback.apply(fetchPartitionData);
    }

    public static final /* synthetic */ void $anonfun$isNonTierFetchCompletable$1(DelayedFetch $this, Object nonLocalReturnKey1$1, IntRef accumulatedSize$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicIdPartition topicIdPartition = (TopicIdPartition)tuple2._1();
            PartitionFetchMetadata fetchPartition = (PartitionFetchMetadata)tuple2._2();
            if (!$this.fetchPartitionPruningEnabled || !fetchPartition.isCaughtUp($this.params.isolation)) {
                Optional<Integer> fetchLeaderEpoch = fetchPartition.currentLeaderEpoch();
                try {
                    LogOffsetMetadata fetchOffset;
                    Partition partition = $this.replicaManager.getPartitionOrException(topicIdPartition.topicPartition());
                    LogOffsetMetadata logOffsetMetadata = fetchOffset = $this.fetchOffsetMetadata(fetchPartition, partition);
                    LogOffsetMetadata logOffsetMetadata2 = LogOffsetMetadata.UNKNOWN_OFFSET_METADATA;
                    if (logOffsetMetadata == null ? logOffsetMetadata2 != null : !((Object)logOffsetMetadata).equals(logOffsetMetadata2)) {
                        LogOffsetMetadata logOffsetMetadata3;
                        LogOffsetSnapshot offsetSnapshot = partition.fetchOffsetSnapshot(fetchLeaderEpoch, $this.params.fetchOnlyLeader(fetchLeaderEpoch));
                        FetchIsolation fetchIsolation = $this.params.isolation;
                        if (((Object)((Object)FetchIsolation.LOG_END)).equals((Object)fetchIsolation)) {
                            logOffsetMetadata3 = offsetSnapshot.logEndOffset;
                        } else if (((Object)((Object)FetchIsolation.HIGH_WATERMARK)).equals((Object)fetchIsolation)) {
                            logOffsetMetadata3 = offsetSnapshot.highWatermark;
                        } else if (((Object)((Object)FetchIsolation.TXN_COMMITTED)).equals((Object)fetchIsolation)) {
                            logOffsetMetadata3 = offsetSnapshot.lastStableOffset;
                        } else {
                            throw new MatchError((Object)fetchIsolation);
                        }
                        LogOffsetMetadata endOffset = logOffsetMetadata3;
                        if (fetchOffset.messageOffset > endOffset.messageOffset) {
                            $this.debug((Function0<String> & Serializable)() -> "Satisfying fetch " + $this + " since it is fetching later segments of partition " + topicIdPartition + ".");
                            throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, true);
                        }
                        if (fetchOffset.messageOffset < endOffset.messageOffset) {
                            if (fetchOffset.onOlderSegment(endOffset)) {
                                $this.debug((Function0<String> & Serializable)() -> "Satisfying fetch " + $this + " immediately since it is fetching older segments of partition " + topicIdPartition + ".");
                                if (!$this.params.isFromFollower() || !$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.params.replicaId)) {
                                    throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, true);
                                }
                            } else if (fetchOffset.onSameSegment(endOffset)) {
                                int bytesAvailable = package$.MODULE$.min(endOffset.positionDiff(fetchOffset), fetchPartition.maxBytes());
                                if (!$this.params.isFromFollower() || !$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.params.replicaId)) {
                                    accumulatedSize$1.elem += bytesAvailable;
                                    if (accumulatedSize$1.elem >= $this.params.minBytes) {
                                        throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, true);
                                    }
                                }
                            }
                        }
                        fetchPartition.lastFetchedEpoch().ifPresent(fetchEpoch -> {
                            OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(fetchLeaderEpoch, Predef$.MODULE$.Integer2int((Integer)fetchEpoch), false);
                            if (epochEndOffset.errorCode() != Errors.NONE.code() || epochEndOffset.endOffset() == -1L || epochEndOffset.leaderEpoch() == -1) {
                                $this.debug((Function0<String> & Serializable)() -> "Could not obtain last offset for leader epoch for partition " + topicIdPartition + ", epochEndOffset=" + epochEndOffset + ".");
                                throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, true);
                            }
                            if (epochEndOffset.leaderEpoch() < Predef$.MODULE$.Integer2int((Integer)fetchEpoch) || epochEndOffset.endOffset() < fetchPartition.fetchOffset()) {
                                $this.debug((Function0<String> & Serializable)() -> "Satisfying fetch " + $this + " since it has diverging epoch requiring truncation for partition " + topicIdPartition + " epochEndOffset=" + epochEndOffset + " fetchEpoch=" + fetchEpoch + " fetchOffset=" + fetchPartition.fetchOffset() + ".");
                                throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, true);
                            }
                        });
                        v2 = BoxedUnit.UNIT;
                    } else {
                        v2 = BoxedUnit.UNIT;
                    }
                }
                catch (NotLeaderOrFollowerException notLeaderOrFollowerException) {
                    $this.debug((Function0<String> & Serializable)() -> "Broker is no longer the leader or follower of " + topicIdPartition + ", satisfy " + $this + " immediately");
                    throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, true);
                }
                catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                    $this.debug((Function0<String> & Serializable)() -> "Broker no longer knows of partition " + topicIdPartition + ", satisfy " + $this + " immediately");
                    throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, true);
                }
                catch (KafkaStorageException kafkaStorageException) {
                    $this.debug((Function0<String> & Serializable)() -> "Partition " + topicIdPartition + " is in an offline log directory, satisfy " + $this + " immediately");
                    throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, true);
                }
                catch (FencedLeaderEpochException fencedLeaderEpochException) {
                    $this.debug((Function0<String> & Serializable)() -> "Broker is the leader of partition " + topicIdPartition + ", but the requested epoch " + fetchLeaderEpoch + " is fenced by the latest leader epoch, satisfy " + $this + " immediately");
                    throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, true);
                }
                return;
            }
        }
        if (tuple2 != null) {
            TopicIdPartition topicPartition = (TopicIdPartition)tuple2._1();
            PartitionFetchMetadata fetchInfo = (PartitionFetchMetadata)tuple2._2();
            $this.trace((Function0<String> & Serializable)() -> "Ignored caught-up partition " + topicPartition + " with " + fetchInfo + " for replica " + $this.params.replicaId + ".");
            return;
        }
    }

    public DelayedFetch(FetchParams params, Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>> fetchPartitions, ReplicaManager replicaManager, ReplicaQuota quota, Option<PendingFetch> tierFetchOpt, BrokerTopicStats brokerTopicStats, Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback, boolean fetchPartitionPruningEnabled, HashMap<TopicIdPartition, Object> accumulatedFetchLatencyMap) {
        this.params = params;
        this.fetchPartitions = fetchPartitions;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.tierFetchOpt = tierFetchOpt;
        this.brokerTopicStats = brokerTopicStats;
        this.responseCallback = responseCallback;
        this.fetchPartitionPruningEnabled = fetchPartitionPruningEnabled;
        this.accumulatedFetchLatencyMap = accumulatedFetchLatencyMap;
        super(params.maxWaitMs);
        Logging.$init$(this);
    }
}

