/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.LinkedHashMap;
import java.util.Map;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.PartitionFetchMetadata;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.requests.RequestUtils;

public final class FetchContext$ {
    public static final FetchContext$ MODULE$ = new FetchContext$();

    public Map<TopicIdPartition, PartitionFetchMetadata> createFetchPartitions(boolean fetchRequestUsesTopicIds, FetchRequestData fetchRequest, Map<Uuid, String> topicNames) {
        LinkedHashMap<TopicIdPartition, PartitionFetchMetadata> results = new LinkedHashMap<TopicIdPartition, PartitionFetchMetadata>();
        fetchRequest.topics().forEach(topic -> {
            String name = !fetchRequestUsesTopicIds ? topic.topic() : (String)topicNames.get(topic.topicId());
            topic.partitions().forEach(partition -> results.put(new TopicIdPartition(topic.topicId(), partition.partition(), name), new FullPartitionFetchMetadata(topic.topicId(), partition.fetchOffset(), partition.logStartOffset(), partition.partitionMaxBytes(), RequestUtils.getLeaderEpoch(partition.currentLeaderEpoch()), RequestUtils.getLeaderEpoch(partition.lastFetchedEpoch()), partition.replicationSessionId())));
        });
        return results;
    }

    private FetchContext$() {
    }
}

