/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import kafka.server.AbstractFetcherThread;
import kafka.server.AbstractFetcherThread$;
import kafka.server.BlockingSend;
import kafka.server.FollowerThrottler;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.RequestBuilder;
import kafka.server.TierMaterializationRequirements;
import kafka.server.TierOffsetInfo;
import kafka.server.TierOffsetInfo$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.network.BrokerEndPoint;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t\rd\u0001B\u0011#\u0001\u001dB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"I\u0001\n\u0001BC\u0002\u0013\u0005!%\u0013\u0005\t+\u0002\u0011\t\u0011)A\u0005\u0015\"Ia\u000b\u0001BC\u0002\u0013\u0005!e\u0016\u0005\t7\u0002\u0011\t\u0011)A\u00051\"AA\f\u0001B\u0001B\u0003%Q\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011!!\u0007A!A!\u0002\u0013)\u0007\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u000b1\u0004A\u0011A7\t\u000f]\u0004\u0001\u0019!C\tq\"I\u00111\u0001\u0001A\u0002\u0013E\u0011Q\u0001\u0005\b\u0003#\u0001\u0001\u0015)\u0003z\u0011\u001d\t\u0019\u0002\u0001C!\u0003+Aq!!\b\u0001\t\u0003\ny\u0002C\u0004\u0002\"\u0001!\t%a\b\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&!9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBA9\u0001\u0011E\u00111\u000f\u0005\b\u0003\u0017\u0003A\u0011CAG\u0011\u001d\tI\n\u0001C!\u00037Cq!!.\u0001\t\u0003\n9\fC\u0004\u0002>\u0002!\t%a0\t\u000f\u0005-\u0007\u0001\"\u0011\u0002N\"9\u00111\u001b\u0001\u0005\n\u0005U\u0007bBAv\u0001\u0011\u0005\u0013Q\u001e\u0005\b\u0005#\u0001A\u0011\u0003B\n\u0011\u001d\u0011\u0019\u0003\u0001C\t\u0005KAqAa\u000b\u0001\t#\u0011i\u0003C\u0004\u00034\u0001!\tE!\u000e\t\u000f\tm\u0003\u0001\"\u0011\u0003^\t!\"+Z7pi\u0016dU-\u00193fe\u0016sG\rU8j]RT!a\t\u0013\u0002\rM,'O^3s\u0015\u0005)\u0013!B6bM.\f7\u0001A\n\u0005\u0001!r#\u0007\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VM\u001a\t\u0003_Aj\u0011AI\u0005\u0003c\t\u0012a\u0002T3bI\u0016\u0014XI\u001c3Q_&tG\u000f\u0005\u00024m5\tAG\u0003\u00026I\u0005)Q\u000f^5mg&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0003%awn\u001a)sK\u001aL\u0007\u0010\u0005\u0002;\u0003:\u00111h\u0010\t\u0003y)j\u0011!\u0010\u0006\u0003}\u0019\na\u0001\u0010:p_Rt\u0014B\u0001!+\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001S\u0013A\u00042m_\u000e\\\u0017N\\4TK:$WM\u001d\t\u0003_\u0019K!a\u0012\u0012\u0003\u0019\tcwnY6j]\u001e\u001cVM\u001c3\u0002'\u0019,Go\u00195TKN\u001c\u0018n\u001c8IC:$G.\u001a:\u0016\u0003)\u0003\"aS*\u000e\u00031S!!\u0014(\u0002\u000f\rd\u0017.\u001a8ug*\u0011Qe\u0014\u0006\u0003!F\u000ba!\u00199bG\",'\"\u0001*\u0002\u0007=\u0014x-\u0003\u0002U\u0019\n\u0019b)\u001a;dQN+7o]5p]\"\u000bg\u000e\u001a7fe\u0006!b-\u001a;dQN+7o]5p]\"\u000bg\u000e\u001a7fe\u0002\naB]3rk\u0016\u001cHOQ;jY\u0012,'/F\u0001Y!\ty\u0013,\u0003\u0002[E\tq!+Z9vKN$()^5mI\u0016\u0014\u0018a\u0004:fcV,7\u000f\u001e\"vS2$WM\u001d\u0011\u0002\u0013QD'o\u001c;uY\u0016\u0014\bCA\u0018_\u0013\ty&EA\tG_2dwn^3s)\"\u0014x\u000e\u001e;mKJ\fAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"a\f2\n\u0005\r\u0014#aC&bM.\f7i\u001c8gS\u001e\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u00020M&\u0011qM\t\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0015\tXo\u001c;b!\ty#.\u0003\u0002lE\ta!+\u001a9mS\u000e\f\u0017+^8uC\u00061A(\u001b8jiz\"\u0012B\\8qcJ\u001cH/\u001e<\u0011\u0005=\u0002\u0001\"\u0002\u001d\f\u0001\u0004I\u0004\"\u0002#\f\u0001\u0004)\u0005\"\u0002%\f\u0001\u0004Q\u0005\"\u0002,\f\u0001\u0004A\u0006\"\u0002/\f\u0001\u0004i\u0006\"\u00021\f\u0001\u0004\t\u0007\"\u00023\f\u0001\u0004)\u0007\"\u00025\f\u0001\u0004I\u0017!\u00034fi\u000eD7+\u001b>f+\u0005I\bC\u0001>\u0000\u001b\u0005Y(B\u0001?~\u0003\u0011a\u0017M\\4\u000b\u0003y\fAA[1wC&\u0019\u0011\u0011A>\u0003\u000f%sG/Z4fe\u0006ia-\u001a;dQNK'0Z0%KF$B!a\u0002\u0002\u000eA\u0019\u0011&!\u0003\n\u0007\u0005-!F\u0001\u0003V]&$\b\u0002CA\b\u001b\u0005\u0005\t\u0019A=\u0002\u0007a$\u0013'\u0001\u0006gKR\u001c\u0007nU5{K\u0002\nA$[:UeVt7-\u0019;j_:|eNR3uG\"\u001cV\u000f\u001d9peR,G-\u0006\u0002\u0002\u0018A\u0019\u0011&!\u0007\n\u0007\u0005m!FA\u0004C_>dW-\u00198\u0002\u001b%t\u0017\u000e^5bi\u0016\u001cEn\\:f)\t\t9!A\u0003dY>\u001cX-\u0001\bce>\\WM]#oIB{\u0017N\u001c;\u0015\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003ci!!a\u000b\u000b\t\u00055\u0012qF\u0001\b]\u0016$xo\u001c:l\u0015\t\u0019c*\u0003\u0003\u00024\u0005-\"A\u0004\"s_.,'/\u00128e!>Lg\u000e^\u0001\u0006M\u0016$8\r\u001b\u000b\u0005\u0003s\tI\u0006\u0005\u0005\u0002<\u0005\u0005\u0013QIA)\u001b\t\tiDC\u0002\u0002@)\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019%!\u0010\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tYET\u0001\u0007G>lWn\u001c8\n\t\u0005=\u0013\u0011\n\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\u0011\t\u0019&!\u0016\u000e\u0003\u0001I1!a\u00161\u0005%1U\r^2i\t\u0006$\u0018\rC\u0004\u0002\\M\u0001\r!!\u0018\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\u0011\t\u0005}\u00131\u000e\b\u0005\u0003C\n9'\u0004\u0002\u0002d)!\u0011QMA%\u0003!\u0011X-];fgR\u001c\u0018\u0002BA5\u0003G\nABR3uG\"\u0014V-];fgRLA!!\u001c\u0002p\t9!)^5mI\u0016\u0014(\u0002BA5\u0003G\nQ\u0003\u001d:pG\u0016\u001c8OR3uG\",\u0005pY3qi&|g\u000e\u0006\u0003\u0002\b\u0005U\u0004bBA<)\u0001\u0007\u0011\u0011P\u0001\u0002iB!\u00111PAC\u001d\u0011\ti(!!\u000f\u0007q\ny(C\u0001,\u0013\r\t\u0019IK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9)!#\u0003\u0013QC'o\\<bE2,'bAABU\u0005!\u0002O]8dKN\u001ch)\u001a;dQJ+7\u000f]8og\u0016$B!!\u000f\u0002\u0010\"9\u0011\u0011S\u000bA\u0002\u0005M\u0015AD2mS\u0016tGOU3ta>t7/\u001a\t\u0004\u0017\u0006U\u0015bAAL\u0019\nq1\t\\5f]R\u0014Vm\u001d9p]N,\u0017a\u00054fi\u000eDW)\u0019:mS\u0016\u001cHo\u00144gg\u0016$HCBAO\u0003O\u000bY\u000b\u0005\u0003\u0002 \u0006\rVBAAQ\u0015\u0011\tY%a\f\n\t\u0005\u0015\u0016\u0011\u0015\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0011\u001d\tIK\u0006a\u0001\u0003\u000b\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002.Z\u0001\r!a,\u0002%\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r\u001b\t\u0004S\u0005E\u0016bAAZU\t\u0019\u0011J\u001c;\u0002#\u0019,Go\u00195MCR,7\u000f^(gMN,G\u000f\u0006\u0004\u0002\u001e\u0006e\u00161\u0018\u0005\b\u0003S;\u0002\u0019AA#\u0011\u001d\tik\u0006a\u0001\u0003_\u000baDZ3uG\"$\u0016.\u001a:NCR,'/[1mSj\fG/[8o)\u0006\u0014x-\u001a;\u0015\r\u0005\u0005\u0017qYAe!\ry\u00131Y\u0005\u0004\u0003\u000b\u0014#A\u0004+jKJ|eMZ:fi&sgm\u001c\u0005\b\u0003SC\u0002\u0019AA#\u0011\u001d\ti\u000b\u0007a\u0001\u0003_\u000b\u0001DZ3uG\",\u0015M\u001d7jKN$Hj\\2bY>3gm]3u)\u0019\ti*a4\u0002R\"9\u0011\u0011V\rA\u0002\u0005\u0015\u0003bBAW3\u0001\u0007\u0011qV\u0001\fM\u0016$8\r[(gMN,G\u000f\u0006\u0005\u0002X\u0006u\u0017q\\Aq!\u001dI\u0013\u0011\\AX\u0003\u0003L1!a7+\u0005\u0019!V\u000f\u001d7fe!9\u0011\u0011\u0016\u000eA\u0002\u0005\u0015\u0003bBAW5\u0001\u0007\u0011q\u0016\u0005\b\u0003GT\u0002\u0019AAs\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002*\u0003OL1!!;+\u0005\u0011auN\\4\u0002)\u0019,Go\u00195Fa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;t)\u0011\tyO!\u0002\u0011\u0011\u0005m\u0012\u0011IA#\u0003c\u0004B!a=\u0002\u0000:!\u0011Q_A~\u001b\t\t9P\u0003\u0003\u0002z\u0006%\u0013aB7fgN\fw-Z\u0005\u0005\u0003{\f90\u0001\u0011PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fgB|gn]3ECR\f\u0017\u0002\u0002B\u0001\u0005\u0007\u0011a\"\u00129pG\",e\u000eZ(gMN,GO\u0003\u0003\u0002~\u0006]\bb\u0002B\u00047\u0001\u0007!\u0011B\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b\u0003CA\u001e\u0003\u0003\n)Ea\u0003\u0011\t\u0005M#QB\u0005\u0004\u0005\u001f\u0001$!C#q_\u000eDG)\u0019;b\u0003q\u0019'/Z1uK\u0016\u0003xn\u00195F]\u0012|eMZ:fiN\u0014V-];fgR$BA!\u0006\u0003\"A!!q\u0003B\u000f\u001d\u0011\t\tG!\u0007\n\t\tm\u00111M\u0001\u001d\u001f\u001a47/\u001a;t\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:u\u0013\u0011\tiGa\b\u000b\t\tm\u00111\r\u0005\b\u0005\u000fa\u0002\u0019\u0001B\u0005\u0003y\u0001(o\\2fgN,\u0005o\\2i\u000b:$wJ\u001a4tKR\u001c(+Z:q_:\u001cX\r\u0006\u0003\u0002p\n\u001d\u0002b\u0002B\u0015;\u0001\u0007\u00111S\u0001\te\u0016\u001c\bo\u001c8tK\u0006i\u0002O]8dKN\u001cX\t]8dQ\u0016sGm\u00144gg\u0016$8OR1jYV\u0014X\r\u0006\u0004\u0002p\n=\"\u0011\u0007\u0005\b\u0005\u000fq\u0002\u0019\u0001B\u0005\u0011\u001d\t9H\ba\u0001\u0003s\n!BY;jY\u00124U\r^2i)\u0011\u00119D!\u0015\u0011\r\te\"q\bB#\u001d\ry#1H\u0005\u0004\u0005{\u0011\u0013!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0005\u0005\u0005\u0003\u0012\u0019E\u0001\u000bSKN,H\u000e^,ji\"\u0004\u0016M\u001d;ji&|gn\u001d\u0006\u0004\u0005{\u0011\u0003#B\u0015\u0003H\t-\u0013b\u0001B%U\t1q\n\u001d;j_:\u0004BA!\u000f\u0003N%!!q\nB\"\u00051\u0011V\r\u001d7jG\u00064U\r^2i\u0011\u001d\u00119a\ba\u0001\u0005'\u0002\u0002\"a\u000f\u0002B\u0005\u0015#Q\u000b\t\u0004_\t]\u0013b\u0001B-E\t\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\u0006y\u0011n\u001d*fC\u0012Lhi\u001c:GKR\u001c\u0007\u000e\u0006\u0003\u0002\u0018\t}\u0003b\u0002B1A\u0001\u0007\u0011QI\u0001\u0003iB\u0004")
public class RemoteLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BlockingSend blockingSender;
    private final FetchSessionHandler fetchSessionHandler;
    private final RequestBuilder requestBuilder;
    private final FollowerThrottler throttler;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private Integer fetchSize;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        RemoteLeaderEndPoint remoteLeaderEndPoint = this;
        synchronized (remoteLeaderEndPoint) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    public RequestBuilder requestBuilder() {
        return this.requestBuilder;
    }

    public Integer fetchSize() {
        return this.fetchSize;
    }

    public void fetchSize_$eq(Integer x$1) {
        this.fetchSize = x$1;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return true;
    }

    @Override
    public void initiateClose() {
        this.blockingSender.initiateClose();
    }

    @Override
    public void close() {
        this.blockingSender.close();
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.blockingSender.brokerEndPoint();
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ClientResponse clientResponse;
        try {
            clientResponse = this.blockingSender.sendRequest(fetchRequest);
        }
        catch (Throwable t) {
            this.processFetchException(t);
            throw t;
        }
        ClientResponse clientResponse2 = clientResponse;
        return this.processFetchResponse(clientResponse2);
    }

    public void processFetchException(Throwable t) {
        this.fetchSessionHandler().handleError(t);
    }

    public Map<TopicPartition, FetchResponseData.PartitionData> processFetchResponse(ClientResponse clientResponse) {
        FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
        if (!this.fetchSessionHandler().handleResponse(fetchResponse, clientResponse.requestHeader().apiVersion())) {
            Errors errors = fetchResponse.error();
            Errors errors2 = Errors.FETCH_SESSION_TOPIC_ID_ERROR;
            if (!(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null)) {
                throw Errors.forCode(fetchResponse.error().code()).exception();
            }
            return (Map)scala.collection.Map$.MODULE$.empty();
        }
        return CollectionConverters$.MODULE$.MapHasAsScala(fetchResponse.responseData(this.fetchSessionHandler().sessionTopicNames(), clientResponse.requestHeader().apiVersion())).asScala();
    }

    @Override
    public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        TierOffsetInfo tierOffsetInfo;
        int epoch;
        block5: {
            Tuple2<Object, TierOffsetInfo> tuple2;
            block4: {
                tuple2 = this.fetchOffset(topicPartition, currentLeaderEpoch, -2L);
                if (tuple2 == null) break block4;
                epoch = tuple2._1$mcI$sp();
                tierOffsetInfo = tuple2._2();
                if (tierOffsetInfo != null) break block5;
            }
            throw new MatchError(tuple2);
        }
        long localLogStartOffset = tierOffsetInfo.localLogStartOffset();
        Option<TierMaterializationRequirements> tierRestorePoint = tierOffsetInfo.tierRestorePoint();
        Tuple3<Integer, Long, Option<TierMaterializationRequirements>> tuple3 = new Tuple3<Integer, Long, Option<TierMaterializationRequirements>>(BoxesRunTime.boxToInteger(epoch), BoxesRunTime.boxToLong(localLogStartOffset), tierRestorePoint);
        int epoch2 = BoxesRunTime.unboxToInt(tuple3._1());
        long localLogStartOffset2 = BoxesRunTime.unboxToLong(tuple3._2());
        Option<TierMaterializationRequirements> tierRestorePoint2 = tuple3._3();
        if (tierRestorePoint2.isDefined()) {
            throw new IllegalStateException("Tier restore point returned for earliest timestamp fetch");
        }
        return new OffsetAndEpoch(localLogStartOffset2, epoch2);
    }

    @Override
    public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        TierOffsetInfo tierOffsetInfo;
        int epoch;
        block5: {
            Tuple2<Object, TierOffsetInfo> tuple2;
            block4: {
                tuple2 = this.fetchOffset(topicPartition, currentLeaderEpoch, -1L);
                if (tuple2 == null) break block4;
                epoch = tuple2._1$mcI$sp();
                tierOffsetInfo = tuple2._2();
                if (tierOffsetInfo != null) break block5;
            }
            throw new MatchError(tuple2);
        }
        long localLogStartOffset = tierOffsetInfo.localLogStartOffset();
        Option<TierMaterializationRequirements> tierRestorePoint = tierOffsetInfo.tierRestorePoint();
        Tuple3<Integer, Long, Option<TierMaterializationRequirements>> tuple3 = new Tuple3<Integer, Long, Option<TierMaterializationRequirements>>(BoxesRunTime.boxToInteger(epoch), BoxesRunTime.boxToLong(localLogStartOffset), tierRestorePoint);
        int epoch2 = BoxesRunTime.unboxToInt(tuple3._1());
        long localLogStartOffset2 = BoxesRunTime.unboxToLong(tuple3._2());
        Option<TierMaterializationRequirements> tierRestorePoint2 = tuple3._3();
        if (tierRestorePoint2.isDefined()) {
            throw new IllegalStateException("Tier restore point returned for latest timestamp fetch");
        }
        return new OffsetAndEpoch(localLogStartOffset2, epoch2);
    }

    @Override
    public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int currentLeaderEpoch) {
        if (Predef$.MODULE$.Boolean2boolean(this.brokerConfig.confluentConfig().tierFeature())) {
            Tuple2<Object, TierOffsetInfo> tuple2 = this.fetchOffset(topicPartition, currentLeaderEpoch, -10000L);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TierOffsetInfo tierOffsetInfo = tuple2._2();
            TierOffsetInfo tierOffsetInfo2 = tierOffsetInfo;
            return tierOffsetInfo2;
        }
        throw new IllegalStateException("Incompatible configuration for tiered storage");
    }

    @Override
    public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        throw new UnsupportedOperationException("Fetching earliest local offset is not supported in Remote Leader Endpoint.");
    }

    private Tuple2<Object, TierOffsetInfo> fetchOffset(TopicPartition topicPartition, int currentLeaderEpoch, long timestamp) {
        ListOffsetsRequestData.ListOffsetsTopic topic = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(topicPartition.partition()).setCurrentLeaderEpoch(currentLeaderEpoch).setTimestamp(timestamp)));
        ListOffsetsRequest.Builder listOffsetRequest = this.requestBuilder().buildListOffsetRequest(topic);
        ClientResponse clientResponse = this.blockingSender.sendRequest(listOffsetRequest);
        ListOffsetsResponse response = (ListOffsetsResponse)clientResponse.responseBody();
        ListOffsetsResponseData.ListOffsetsPartitionResponse responsePartition = (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala().find((Function1<ListOffsetsResponseData.ListOffsetsTopicResponse, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(RemoteLeaderEndPoint.$anonfun$fetchOffset$1(topicPartition, x$3))).get()).partitions()).asScala().find((Function1<ListOffsetsResponseData.ListOffsetsPartitionResponse, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(RemoteLeaderEndPoint.$anonfun$fetchOffset$2(topicPartition, x$4))).get();
        Errors errors = Errors.forCode(responsePartition.errorCode());
        if (((Object)((Object)Errors.NONE)).equals((Object)errors)) {
            if (responsePartition.followerRestorePointObjectId() != null && !responsePartition.followerRestorePointObjectId().equals(Uuid.ZERO_UUID)) {
                return new Tuple2<Object, TierOffsetInfo>(BoxesRunTime.boxToInteger(responsePartition.leaderEpoch()), TierOffsetInfo$.MODULE$.apply(responsePartition.offset(), CoreUtils$.MODULE$.toJavaUUID(responsePartition.followerRestorePointObjectId()), responsePartition.followerRestorePointEpoch()));
            }
            return new Tuple2<Object, TierOffsetInfo>(BoxesRunTime.boxToInteger(responsePartition.leaderEpoch()), TierOffsetInfo$.MODULE$.apply(responsePartition.offset()));
        }
        throw errors.exception();
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> map;
        if (partitions.isEmpty()) {
            this.debug((Function0<String> & Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
            return (Map)scala.collection.Map$.MODULE$.empty();
        }
        OffsetsForLeaderEpochRequest.Builder epochRequest = this.createEpochEndOffsetsRequest(partitions);
        this.debug((Function0<String> & Serializable)() -> "Sending offset for leader epoch request " + epochRequest);
        try {
            ClientResponse response = this.blockingSender.sendRequest(epochRequest);
            map = this.processEpochEndOffsetsResponse(response);
        }
        catch (Throwable t) {
            map = this.processEpochEndOffsetsFailure(partitions, t);
        }
        return map;
    }

    public OffsetsForLeaderEpochRequest.Builder createEpochEndOffsetsRequest(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(partitions.size());
        partitions.foreachEntry((Function2<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition, Object> & Serializable)(topicPartition, epochData) -> BoxesRunTime.boxToBoolean(RemoteLeaderEndPoint.$anonfun$createEpochEndOffsetsRequest$1(topics, topicPartition, epochData)));
        return this.requestBuilder().buildOffsetsForLeaderEpochRequest(topics);
    }

    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> processEpochEndOffsetsResponse(ClientResponse response) {
        OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
        this.debug((Function0<String> & Serializable)() -> "Received leaderEpoch response " + response);
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(responseBody.data().topics()).asScala().flatMap((Function1<OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult, Buffer> & Serializable)offsetForLeaderTopicResult -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(offsetForLeaderTopicResult.partitions()).asScala().map((Function1<OffsetForLeaderEpochResponseData.EpochEndOffset, Tuple2> & Serializable)offsetForLeaderPartitionResult -> {
            TopicPartition tp = new TopicPartition(offsetForLeaderTopicResult.topic(), offsetForLeaderPartitionResult.partition());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), offsetForLeaderPartitionResult);
        }))).toMap($less$colon$less$.MODULE$.refl());
    }

    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> processEpochEndOffsetsFailure(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions, Throwable t) {
        this.warn((Function0<String> & Serializable)() -> "Error when sending leader epoch request for " + partitions, (Function0<Throwable> & Serializable)() -> t);
        Errors error = AbstractFetcherThread$.MODULE$.exceptionToError(t);
        return (Map)partitions.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()));
            }
            throw new MatchError(tuple2);
        });
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        scala.collection.mutable.Map partitionsWithError = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder(partitions.size(), false);
        boolean lowDiskThrottle = this.throttler.shouldThrottleDueToLowDisk(this.quota);
        boolean isQuotaExceeded = this.quota.isQuotaExceeded();
        partitions.foreachEntry((Function2<TopicPartition, PartitionFetchState, Object> & Serializable)(topicPartition, fetchState) -> {
            if (fetchState.isReadyForFetch() && this.isReadyForFetch((TopicPartition)topicPartition)) {
                Object object;
                if (lowDiskThrottle || $this.throttler.shouldThrottle(isQuotaExceeded, $this.quota, (PartitionFetchState)fetchState, (TopicPartition)topicPartition)) {
                    $this.throttler.markReplicaThrottle($this.replicaManager, $this.quota);
                    return BoxedUnit.UNIT;
                }
                try {
                    long logStartOffset = $this.replicaManager.localLogOrException((TopicPartition)topicPartition).logStartOffset();
                    Optional<Integer> lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(fetchState.lastFetchedEpoch().map((Function1<Object, Integer> & Serializable)x$5 -> RemoteLeaderEndPoint.$anonfun$buildFetch$2(BoxesRunTime.unboxToInt(x$5))))) : Optional.empty();
                    builder.add((TopicPartition)topicPartition, new FetchRequest.PartitionData((Uuid)fetchState.topicId().getOrElse((Function0<Uuid> & Serializable)() -> Uuid.ZERO_UUID), fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(fetchState.replicationSessionId().map((Function1<Object, Long> & Serializable)x$6 -> RemoteLeaderEndPoint.$anonfun$buildFetch$4(BoxesRunTime.unboxToLong(x$6))))), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
                    object = BoxedUnit.UNIT;
                }
                catch (KafkaStorageException kafkaStorageException) {
                    object = partitionsWithError.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), Errors.KAFKA_STORAGE_ERROR));
                }
                return object;
            }
            return BoxedUnit.UNIT;
        });
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        Option fetchRequestOpt = fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty() ? None$.MODULE$ : new Some<AbstractFetcherThread.ReplicaFetch>(new AbstractFetcherThread.ReplicaFetch(fetchData.sessionPartitions(), this.requestBuilder().buildFetchRequest(fetchData)));
        return new AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>>(fetchRequestOpt, partitionsWithError);
    }

    @Override
    public boolean isReadyForFetch(TopicPartition tp) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$1(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$3) {
        String string = x$3.name();
        String string2 = topicPartition$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$2(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$4) {
        return x$4.partitionIndex() == topicPartition$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$createEpochEndOffsetsRequest$1(OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics$1, TopicPartition topicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopic topic = topics$1.find(topicPartition.topic());
        if (topic == null) {
            topic = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic());
            v0 = BoxesRunTime.boxToBoolean(topics$1.add(topic));
        } else {
            v0 = BoxedUnit.UNIT;
        }
        return topic.partitions().add(epochData);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetch$2(int x$5) {
        return BoxesRunTime.boxToInteger(x$5);
    }

    public static final /* synthetic */ Long $anonfun$buildFetch$4(long x$6) {
        return BoxesRunTime.boxToLong(x$6);
    }

    public RemoteLeaderEndPoint(String logPrefix, BlockingSend blockingSender, FetchSessionHandler fetchSessionHandler, RequestBuilder requestBuilder, FollowerThrottler throttler, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota) {
        this.blockingSender = blockingSender;
        this.fetchSessionHandler = fetchSessionHandler;
        this.requestBuilder = requestBuilder;
        this.throttler = throttler;
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.quota = quota;
        Logging.$init$(this);
        this.logIdent_$eq(logPrefix);
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
    }
}

