/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.Optional;
import kafka.tier.fetcher.MemoryTracker;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.record.ConvertedRecords;
import org.apache.kafka.common.record.DefaultRecordsSend;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;

public class ReclaimableMemoryRecords
extends MemoryRecords {
    private State state;
    public static final ReclaimableMemoryRecords EMPTY = new ReclaimableMemoryRecords(ByteBuffer.allocate(0), Optional.empty());
    private final MemoryTracker.MemoryLease lease;

    public ReclaimableMemoryRecords(ByteBuffer buffer, Optional<MemoryTracker.MemoryLease> lease) {
        super(buffer);
        if (lease.isPresent()) {
            this.state = State.ACTIVE;
            this.lease = lease.get();
        } else {
            this.state = State.EMPTY;
            this.lease = null;
        }
    }

    private void throwIfReleased() {
        if (this.state == State.RELEASED) {
            throw new RuntimeException("ReclaimableMemoryRecords used after released");
        }
    }

    @Override
    public int sizeInBytes() {
        this.throwIfReleased();
        return super.sizeInBytes();
    }

    @Override
    public int writeTo(TransferableChannel channel, int position, int length) throws IOException {
        this.throwIfReleased();
        return super.writeTo(channel, position, length);
    }

    @Override
    public int writeFullyTo(GatheringByteChannel channel) throws IOException {
        this.throwIfReleased();
        return super.writeFullyTo(channel);
    }

    @Override
    public int validBytes() {
        this.throwIfReleased();
        return super.validBytes();
    }

    @Override
    public ConvertedRecords<MemoryRecords> downConvert(byte toMagic, long firstOffset, Time time) {
        this.throwIfReleased();
        return super.downConvert(toMagic, firstOffset, time);
    }

    @Override
    public AbstractIterator<MutableRecordBatch> batchIterator() {
        this.throwIfReleased();
        return super.batchIterator();
    }

    @Override
    public Integer firstBatchSize() {
        this.throwIfReleased();
        return super.firstBatchSize();
    }

    @Override
    public MemoryRecords.FilterResult filterTo(MemoryRecords.RecordFilter filter, ByteBuffer destinationBuffer, BufferSupplier decompressionBufferSupplier, boolean validateTimestamps) {
        this.throwIfReleased();
        return super.filterTo(filter, destinationBuffer, decompressionBufferSupplier, validateTimestamps);
    }

    @Override
    public ByteBuffer buffer() {
        this.throwIfReleased();
        return super.buffer();
    }

    @Override
    public Iterable<MutableRecordBatch> batches() {
        this.throwIfReleased();
        return super.batches();
    }

    @Override
    public boolean hasMatchingMagic(byte magic) {
        this.throwIfReleased();
        return super.hasMatchingMagic(magic);
    }

    @Override
    public RecordBatch firstBatch() {
        this.throwIfReleased();
        return super.firstBatch();
    }

    @Override
    public Iterable<Record> records() {
        this.throwIfReleased();
        return super.records();
    }

    @Override
    public DefaultRecordsSend<Records> toSend() {
        this.throwIfReleased();
        return super.toSend();
    }

    @Override
    public void release() {
        if (this.state == State.ACTIVE) {
            this.lease.release();
            this.state = State.RELEASED;
        }
    }

    @Override
    public String toString() {
        return "ReclaimableMemoryRecords(records=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReclaimableMemoryRecords self = this;
        MemoryRecords that = (MemoryRecords)o;
        return ((MemoryRecords)self).equals(that);
    }

    @Override
    public int hashCode() {
        ReclaimableMemoryRecords self = this;
        return ((MemoryRecords)self).hashCode();
    }

    private static enum State {
        EMPTY,
        ACTIVE,
        RELEASED;

    }
}

