/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import io.confluent.kafka.storage.checksum.CheckedFileIO;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import kafka.log.TierLogSegment;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.FileTierPartitionStateUtils;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionState;
import org.apache.kafka.common.errors.KafkaStorageException;

public class TierUtils {
    public static final int ENTRY_LENGTH_SIZE = 2;

    private static Optional<MetadataWithOffset> metadataForOffset(TierPartitionState partitionState, long offset) throws KafkaStorageException {
        try {
            return partitionState.metadata(offset).map(tierLogSegment -> new MetadataWithOffset(offset, (TierLogSegment)tierLogSegment));
        }
        catch (IOException e) {
            throw new KafkaStorageException(e);
        }
    }

    public static Optional<TierLogSegment> tierLogSegmentForOffset(TierPartitionState partitionState, long offset) {
        return TierUtils.metadataForOffset(partitionState, offset).map(v -> v.tierLogSegment);
    }

    public static TierObjectMetadata updateSegmentState(TopicIdPartition topicIdPartition, SegmentState currentState, TierObjectMetadata.State newState, CheckedFileIO stateFileChannel, long timestamp) throws IOException {
        return TierUtils.updateSegmentState(topicIdPartition, currentState, newState, stateFileChannel, true, timestamp);
    }

    public static TierObjectMetadata updateSegmentState(TopicIdPartition topicIdPartition, SegmentState currentState, TierObjectMetadata.State newState, CheckedFileIO stateFileChannel, boolean transitionCheck, long timestamp) throws IOException {
        int newSize;
        TierObjectMetadata metadata;
        UUID objectId = currentState.objectId();
        if (!objectId.equals((metadata = FileTierPartitionStateUtils.read(topicIdPartition, stateFileChannel, currentState.filePosition())).objectId())) {
            throw new IllegalStateException("ObjectId mismatch. Expected: " + String.valueOf(objectId) + " Got: " + String.valueOf(metadata.objectId()));
        }
        int oldSize = metadata.payloadSize();
        TierObjectMetadata.State oldState = currentState.state();
        if (transitionCheck) {
            metadata.mutateState(newState);
        } else {
            metadata.forceMutateState(newState);
        }
        metadata.mutateStateChangeTimestamp(timestamp);
        if (newState.equals((Object)TierObjectMetadata.State.SEGMENT_DELETE_INITIATE)) {
            metadata.mutateStateBeforeDeletion(oldState);
        }
        if (oldSize != (newSize = metadata.payloadSize())) {
            throw new IllegalStateException(String.format("Size mismatch for objectId %s, expected: %d, got: %d, topicIdPartition: %s.", metadata.objectId(), oldSize, newSize, topicIdPartition));
        }
        stateFileChannel.write(metadata.payloadBuffer(), currentState.filePosition() + 2);
        return metadata;
    }

    private static class MetadataWithOffset {
        long startOffset;
        TierLogSegment tierLogSegment;

        MetadataWithOffset(long startOffset, TierLogSegment tierLogSegment) {
            this.startOffset = startOffset;
            this.tierLogSegment = tierLogSegment;
        }
    }
}

