/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.serdes.FragmentDescription;
import io.confluent.kafka.storage.tier.serdes.SegmentUploadInitiate;
import io.confluent.kafka.storage.tier.serdes.TierPartitionStateEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kafka.tier.TopicIdPartition;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.TierSegmentUpload;
import org.apache.kafka.server.config.SegmentMetadataLayoutPutMode;

public class FragmentDescriptionWrapper {
    static final int INITIAL_BUFFER_SIZE = 48;
    private final FragmentDescription fragmentDescription;

    public FragmentDescriptionWrapper(FragmentType fragmentType, ObjectType objectType, long filePosition, int size) {
        FlatBufferBuilder builder = new FlatBufferBuilder(48).forceDefaults(true);
        int entryId = FragmentDescription.createFragmentDescription(builder, fragmentType.getByte(), objectType.getByte(), filePosition, size);
        builder.finish(entryId);
        this.fragmentDescription = FragmentDescription.getRootAsFragmentDescription(builder.dataBuffer());
    }

    @JsonCreator
    public FragmentDescriptionWrapper(@JsonProperty(value="fragmentTypeByte") byte fragmentTypeByte, @JsonProperty(value="objectTypeByte") byte objectTypeByte, @JsonProperty(value="filePosition") long filePosition, @JsonProperty(value="size") int size) {
        this(FragmentType.byteToFragmentType(fragmentTypeByte), ObjectType.byteToObjectType(objectTypeByte), filePosition, size);
    }

    public FragmentDescriptionWrapper(FragmentDescription fragmentDescription) {
        this.fragmentDescription = fragmentDescription;
    }

    public static List<FragmentDescriptionWrapper> createFragmentDescriptionsList(TopicIdPartition tpid, SegmentMetadataLayoutPutMode putMode, int segmentSize, long offsetIndexSize, long timestampIndexSize, int transactionIndexSize, int epochStateSize, long producerStateSize) {
        if (offsetIndexSize > Integer.MAX_VALUE || timestampIndexSize > Integer.MAX_VALUE || producerStateSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("At least one per-segment file for topicIdPartition %s exceeds the maximum size of INT_MAX, so we cannot represent its layout in the format required by the tier topic.\noffsetIndexSize: %d, timestampIndexSize: %d, producerStateSize: %d", tpid, offsetIndexSize, timestampIndexSize, producerStateSize));
        }
        if (segmentSize < 0 || offsetIndexSize < 0L || timestampIndexSize < 0L || transactionIndexSize < 0 || epochStateSize < 0 || producerStateSize < 0L) {
            throw new IllegalArgumentException(String.format("At least one per-segment file for topicIdPartition %s has a negative size.\nsegmentSize: %d, offsetIndexSize: %d, timestampIndexSize: %d, transactionIndexSize: %d, epochStateSize: %d, producerStateSize: %d", tpid, segmentSize, offsetIndexSize, timestampIndexSize, transactionIndexSize, epochStateSize, producerStateSize));
        }
        switch (putMode) {
            case LegacyMultiObject: {
                return FragmentDescriptionWrapper.multiObjectSegmentFragmentDescriptions(segmentSize, offsetIndexSize, timestampIndexSize, transactionIndexSize, epochStateSize, producerStateSize);
            }
            case CombinedObject: {
                return FragmentDescriptionWrapper.combinedObjectSegmentFragmentDescriptions(segmentSize, offsetIndexSize, timestampIndexSize, transactionIndexSize, epochStateSize, producerStateSize);
            }
        }
        throw new IllegalArgumentException("Unhandled SegmentMetadataLayoutPutMode: " + String.valueOf((Object)putMode));
    }

    private static FragmentDescriptionWrapper singletonFragmentDescription(FragmentType fragmentType, int size) {
        return ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).map(objectType -> new FragmentDescriptionWrapper(fragmentType, (ObjectType)((Object)objectType), 0L, size)).orElseThrow(() -> new IllegalArgumentException("No default ObjectType for FragmentType " + String.valueOf((Object)fragmentType)));
    }

    private static List<FragmentDescriptionWrapper> multiObjectSegmentFragmentDescriptions(int segmentSize, long offsetIndexSize, long timestampIndexSize, int transactionIndexSize, int epochStateSize, long producerStateSize) {
        return Arrays.asList(FragmentDescriptionWrapper.singletonFragmentDescription(FragmentType.SEGMENT, segmentSize), FragmentDescriptionWrapper.singletonFragmentDescription(FragmentType.OFFSET_INDEX, (int)offsetIndexSize), FragmentDescriptionWrapper.singletonFragmentDescription(FragmentType.TIMESTAMP_INDEX, (int)timestampIndexSize), FragmentDescriptionWrapper.singletonFragmentDescription(FragmentType.TRANSACTION_INDEX, transactionIndexSize), FragmentDescriptionWrapper.singletonFragmentDescription(FragmentType.PRODUCER_STATE, (int)producerStateSize), FragmentDescriptionWrapper.singletonFragmentDescription(FragmentType.EPOCH_STATE, epochStateSize));
    }

    private static List<FragmentDescriptionWrapper> combinedObjectSegmentFragmentDescriptions(int segmentSize, long offsetIndexSize, long timestampIndexSize, int transactionIndexSize, int epochStateSize, long producerStateSize) {
        HashMap<FragmentType, Integer> fragmentSizes = new HashMap<FragmentType, Integer>();
        fragmentSizes.put(FragmentType.SEGMENT, segmentSize);
        fragmentSizes.put(FragmentType.OFFSET_INDEX, (int)offsetIndexSize);
        fragmentSizes.put(FragmentType.TIMESTAMP_INDEX, (int)timestampIndexSize);
        fragmentSizes.put(FragmentType.PRODUCER_STATE, (int)producerStateSize);
        fragmentSizes.put(FragmentType.TRANSACTION_INDEX, transactionIndexSize);
        fragmentSizes.put(FragmentType.EPOCH_STATE, epochStateSize);
        int filePosition = 0;
        ArrayList<FragmentDescriptionWrapper> fragmentDescriptions = new ArrayList<FragmentDescriptionWrapper>();
        for (FragmentType ft : TierSegmentUpload.canonicalOrderForCombinedObject()) {
            Integer fileSize = (Integer)fragmentSizes.get((Object)ft);
            if (fileSize == null) {
                throw new IllegalArgumentException("Unhandled segment-associated FragmentType " + String.valueOf((Object)ft));
            }
            fragmentDescriptions.add(new FragmentDescriptionWrapper(ft, ObjectType.SEGMENT_WITH_METADATA, (long)filePosition, (int)fileSize));
            filePosition += fileSize.intValue();
        }
        return fragmentDescriptions;
    }

    public static int serializeFragmentDescriptionsIntoSegmentUploadInitiate(FlatBufferBuilder builder, List<FragmentDescriptionWrapper> fragmentDescriptionsList) {
        int[] segmentAndMetadataLayoutOffsets = FragmentDescriptionWrapper.createSegmentAndMetadataLayoutOffsetsArray(builder, fragmentDescriptionsList);
        return SegmentUploadInitiate.createSegmentAndMetadataLayoutVector(builder, segmentAndMetadataLayoutOffsets);
    }

    public static int serializeFragmentDescriptionsIntoTierPartitionStateEntry(FlatBufferBuilder builder, List<FragmentDescriptionWrapper> fragmentDescriptionsList) {
        int[] segmentAndMetadataLayoutOffsets = FragmentDescriptionWrapper.createSegmentAndMetadataLayoutOffsetsArray(builder, fragmentDescriptionsList);
        return TierPartitionStateEntry.createSegmentAndMetadataLayoutVector(builder, segmentAndMetadataLayoutOffsets);
    }

    private static int[] createSegmentAndMetadataLayoutOffsetsArray(FlatBufferBuilder builder, List<FragmentDescriptionWrapper> fragmentDescriptionsList) {
        int[] segmentAndMetadataLayoutOffsets = new int[fragmentDescriptionsList.size()];
        for (int i = 0; i < fragmentDescriptionsList.size(); ++i) {
            FragmentDescriptionWrapper fragmentDescription = fragmentDescriptionsList.get(i);
            segmentAndMetadataLayoutOffsets[i] = FragmentDescription.createFragmentDescription(builder, fragmentDescription.fragmentType().getByte(), fragmentDescription.objectType().getByte(), fragmentDescription.filePosition(), fragmentDescription.size());
        }
        return segmentAndMetadataLayoutOffsets;
    }

    public FragmentType fragmentType() {
        return FragmentType.byteToFragmentType(this.fragmentDescription.fragmentType());
    }

    @JsonProperty(value="fragmentTypeByte", required=true)
    public byte fragmentTypeByte() {
        return this.fragmentType().getByte();
    }

    public ObjectType objectType() {
        return ObjectType.byteToObjectType(this.fragmentDescription.objectType());
    }

    @JsonProperty(value="objectTypeByte", required=true)
    public byte objectTypeByte() {
        return this.objectType().getByte();
    }

    @JsonProperty(value="filePosition", required=true)
    public long filePosition() {
        return this.fragmentDescription.filePosition();
    }

    @JsonProperty(value="size", required=true)
    public int size() {
        return this.fragmentDescription.size();
    }

    int underlyingBufferSize() {
        return this.fragmentDescription.getByteBuffer().capacity();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentDescriptionWrapper that = (FragmentDescriptionWrapper)o;
        return Objects.equals(this.fragmentDescription.getByteBuffer(), that.fragmentDescription.getByteBuffer());
    }

    public int hashCode() {
        return Objects.hash(this.fragmentDescription.getByteBuffer());
    }

    public String toString() {
        return String.format("FragmentDescriptionWrapper(fragmentType=%s, ObjectType=%s, filePosition=%d, size=%d)", new Object[]{this.fragmentType(), this.objectType(), this.filePosition(), this.size()});
    }
}

