/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kafka.tier.raft.KRaftSnapshotObject;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;

public class KRaftSnapshotMetadata
implements ObjectStoreMetadata {
    private static final int CURRENT_KEY_PATH_VERSION = 0;
    private final int version = 0;
    private final KRaftSnapshotObject snapshotObject;

    public KRaftSnapshotMetadata(KRaftSnapshotObject snapshotObject) {
        this.snapshotObject = snapshotObject;
    }

    @Override
    public Optional<FragmentLocation> toFragmentLocation(String keyPrefix, FragmentType fragmentType) {
        if (fragmentType != FragmentType.KRAFT_SNAPSHOT) {
            throw new UnsupportedOperationException(String.format("KRaftSnapshotMetadata cannot get FragmentLocation for fragment type of type %s", fragmentType.name()));
        }
        ObjectType defaultObjectType = ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get();
        return Optional.of(new FragmentLocation(this.toPath(keyPrefix, defaultObjectType), defaultObjectType));
    }

    private String toPath(String keyPrefix, ObjectType objectType) {
        return this.snapshotObject.encodePath(keyPrefix, 0);
    }

    public static KRaftSnapshotMetadata fromPath(String keyPrefix, String filePath) {
        return new KRaftSnapshotMetadata(KRaftSnapshotObject.decodePath(keyPrefix, filePath));
    }

    public KRaftSnapshotObject snapshotObject() {
        return this.snapshotObject;
    }

    @Override
    public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        clusterIdOpt.ifPresent(clusterId -> metadata.put("clusterId", (String)clusterId));
        brokerIdOpt.ifPresent(brokerId -> metadata.put("nodeId", Integer.toString(brokerId)));
        return metadata;
    }

    @Override
    public OpaqueData opaqueData() {
        return OpaqueData.ZEROED;
    }

    public String toString() {
        return "KRaftSnapshotMetadata(version=0, snapshotObject=" + String.valueOf(this.snapshotObject) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KRaftSnapshotMetadata that = (KRaftSnapshotMetadata)o;
        return 0 == that.version && this.snapshotObject.equals(that.snapshotObject);
    }

    public int hashCode() {
        return Objects.hash(0, this.snapshotObject);
    }
}

