/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.util.Properties;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import kafka.server.KafkaConfig;
import kafka.tier.store.TierObjectStore;

class TierCloudBackendUtils {
    TierCloudBackendUtils() {
    }

    static OptionParser augmentParserWithValidatorOpts(OptionParser maybeExistingParser) {
        if (maybeExistingParser == null) {
            maybeExistingParser = new OptionParser();
        }
        maybeExistingParser.accepts("validate-tier-storage", "verifies the object presence in the tier object store in terms of the object ID in the metadata").withRequiredArg().describedAs("verifies the object presence in the tier object store in terms of the object ID in the metadata").ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]);
        maybeExistingParser.accepts("validate-tier-storage-offset", "verifies that the offsets mentioned in the metadata is present in the segment file in object store").withRequiredArg().describedAs("verifies that the offsets mentioned in the metadata is present in the segment file in object store").ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]);
        maybeExistingParser.accepts("cluster-id", "The zk cluster ID for which the tool will connect").withRequiredArg().describedAs("The zk cluster ID for which the tool will connect").ofType(String.class).defaultsTo("kafka", (String[])new String[0]);
        maybeExistingParser.accepts("broker.id", "The broker id for this server.").withRequiredArg().describedAs("The broker id for this server.").ofType(Integer.class);
        return maybeExistingParser;
    }

    static OptionParser augmentParserWithTierBackendOpts(OptionParser maybeExistingParser) {
        if (maybeExistingParser == null) {
            maybeExistingParser = new OptionParser();
        }
        maybeExistingParser.accepts(KafkaConfig.TierBackendProp(), KafkaConfig.TierBackendDoc()).withRequiredArg().describedAs(KafkaConfig.TierBackendDoc()).ofType(TierObjectStore.Backend.class).defaultsTo(TierObjectStore.Backend.S3, (TierObjectStore.Backend[])new TierObjectStore.Backend[0]);
        maybeExistingParser.accepts(KafkaConfig.TierS3BucketProp(), KafkaConfig.TierS3BucketDoc()).withRequiredArg().describedAs(KafkaConfig.TierS3BucketDoc()).ofType(String.class);
        maybeExistingParser.accepts(KafkaConfig.TierS3RegionProp(), KafkaConfig.TierS3RegionDoc()).withRequiredArg().describedAs(KafkaConfig.TierS3RegionDoc()).ofType(String.class).defaultsTo("us-west-2", (String[])new String[0]);
        maybeExistingParser.accepts(KafkaConfig.TierS3CredFilePathProp(), KafkaConfig.TierS3CredFilePathDoc()).withRequiredArg().describedAs(KafkaConfig.TierS3CredFilePathDoc()).ofType(String.class);
        maybeExistingParser.accepts(KafkaConfig.TierS3EndpointOverrideProp(), KafkaConfig.TierS3EndpointOverrideDoc()).withRequiredArg().describedAs(KafkaConfig.TierS3EndpointOverrideDoc()).ofType(String.class);
        maybeExistingParser.accepts(KafkaConfig.TierS3SignerOverrideProp(), KafkaConfig.TierS3SignerOverrideDoc()).withRequiredArg().describedAs(KafkaConfig.TierS3SignerOverrideDoc()).ofType(String.class);
        maybeExistingParser.accepts(KafkaConfig.TierS3SseAlgorithmProp(), KafkaConfig.TierS3SseAlgorithmDoc()).withRequiredArg().describedAs(KafkaConfig.TierS3SseAlgorithmDoc()).ofType(String.class).defaultsTo("AES256", (String[])new String[0]);
        maybeExistingParser.accepts(KafkaConfig.TierS3AutoAbortThresholdBytesProp(), KafkaConfig.TierS3AutoAbortThresholdBytesDoc()).withRequiredArg().describedAs(KafkaConfig.TierS3AutoAbortThresholdBytesDoc()).ofType(Integer.class).defaultsTo(500000, (Integer[])new Integer[0]);
        maybeExistingParser.accepts(KafkaConfig.TierS3PrefixProp(), KafkaConfig.TierS3PrefixDoc()).withRequiredArg().describedAs(KafkaConfig.TierS3PrefixDoc()).ofType(String.class).defaultsTo("", (String[])new String[0]);
        return maybeExistingParser;
    }

    static Properties addValidatorProps(OptionSet options, Properties maybeExistingProps) {
        if (options == null) {
            throw new IllegalArgumentException("Options need to be instantiated. See TierCloudBackendUtils.augmentParserValidatorOpts.");
        }
        if (maybeExistingProps == null) {
            maybeExistingProps = new Properties();
        }
        maybeExistingProps.put("validate-tier-storage", options.valueOf("validate-tier-storage"));
        maybeExistingProps.put("validate-tier-storage-offset", options.valueOf("validate-tier-storage-offset"));
        maybeExistingProps.put("cluster-id", options.valueOf("cluster-id"));
        if (options.has("broker.id")) {
            maybeExistingProps.put("broker.id", options.valueOf("broker.id"));
        }
        return maybeExistingProps;
    }

    static Properties addTierBackendProps(OptionSet options, Properties maybeExistingProps) {
        if (options == null) {
            throw new IllegalArgumentException("Options need to be instantiated. See TierCloudBackendUtils.augmentParserWithTierBackendOpts!");
        }
        if (maybeExistingProps == null) {
            maybeExistingProps = new Properties();
        }
        maybeExistingProps.put(KafkaConfig.TierBackendProp(), options.valueOf(KafkaConfig.TierBackendProp()));
        if (options.has(KafkaConfig.TierS3BucketProp())) {
            maybeExistingProps.put(KafkaConfig.TierS3BucketProp(), options.valueOf(KafkaConfig.TierS3BucketProp()));
        }
        maybeExistingProps.put(KafkaConfig.TierS3RegionProp(), options.valueOf(KafkaConfig.TierS3RegionProp()));
        if (options.has(KafkaConfig.TierS3CredFilePathProp())) {
            maybeExistingProps.put(KafkaConfig.TierS3CredFilePathProp(), options.valueOf(KafkaConfig.TierS3CredFilePathProp()));
        }
        if (options.has(KafkaConfig.TierS3EndpointOverrideProp())) {
            maybeExistingProps.put(KafkaConfig.TierS3EndpointOverrideProp(), options.valueOf(KafkaConfig.TierS3EndpointOverrideProp()));
        }
        if (options.has(KafkaConfig.TierS3SignerOverrideProp())) {
            maybeExistingProps.put(KafkaConfig.TierS3SignerOverrideProp(), options.valueOf(KafkaConfig.TierS3SignerOverrideProp()));
        }
        maybeExistingProps.put(KafkaConfig.TierS3SseAlgorithmProp(), options.valueOf(KafkaConfig.TierS3SseAlgorithmProp()));
        maybeExistingProps.put(KafkaConfig.TierS3AutoAbortThresholdBytesProp(), options.valueOf(KafkaConfig.TierS3AutoAbortThresholdBytesProp()));
        maybeExistingProps.put(KafkaConfig.TierS3PrefixProp(), options.valueOf(KafkaConfig.TierS3PrefixProp()));
        return maybeExistingProps;
    }
}

