/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.util.Properties;
import java.util.UUID;
import kafka.utils.CoreUtils;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class TierTopicMaterializationToolConfig
extends AbstractConfig {
    private static final ConfigDef CONFIG;
    public static final String SRC_TOPIC_ID = "source-topic-id";
    public static final String SRC_TOPIC_DOC = "source topic id. If selected all the processing will be limited for this id";
    public static final String SRC_PARTITION = "source-partition";
    public static final String SRC_PARTIITON_DOC = "source partition id. If selected, all the processing will be limited for this partition.";
    public static final String TIER_STATE_TOPIC_PARTITION = "tier-state-topic-partition";
    public static final String TIER_STATE_TOPIC_PARTITION_DOC = "tier topic partition. If selected all the processing will be limited from this partition.";
    public static final String START_OFFSET = "start-offset";
    public static final String START_OFFSET_DOC = "start offset from where the events will be processed.This will be ignored if tier-topic-partition is not set.";
    public static final String END_OFFSET = "end-offset";
    public static final String END_OFFSET_DOC = "end offset from where the events will be processed. This will be ignored if tier-topic-partition is not set.";
    public static final String BOOTSTRAP_SERVER_CONFIG = "bootstrap-server";
    public static final String BOOTSTRAP_SERVER_DOC = "The broker server and port string in form host:port";
    public static final String DUMP_METADATA = "dump-metadata";
    public static final String DUMP_METADATA_DOC = "dump-metadata will dump entire metadata of tier topic partitions on the std output.";
    public static final String DUMP_METADATA_HEADER = "dump-metadata-header";
    public static final String DUMP_METADATA_HEADER_DOC = "dump-metadata-header will dump only header of the tier topic partition's state.";
    public static final String WORKING_DIR = "working-dir";
    public static final String WORKING_DIR_DOC = "working-dir is the directory path where the tool will generate its data";
    public static final String METADATA_STATES_DIR = "metadata-states-dir";
    public static final String METADATA_STATES_DIR_DOC = "data directory of kafka, to pull tier topic state files.";
    public static final String EMPTY_UUID_STR = "00000000-0000-0000-0000-000000000000";
    public static final UUID EMPTY_UUID;
    public static final String DUMP_EVENTS = "dump-events";
    public static final String DUMP_EVENTS_DOC = "dumps the tier state topic's events on std out. By default its turned to be true. If chosen false it will still dump everty 1000th events for trackinglong runs.";
    public static final String SNAPSHOT_STATES_FILES = "snapshot-states-files";
    public static final String SNAPSHOT_STATES_FILES_DOC = "If not set then it's expected that the state files are already saved in the snapshot folder.";
    public static final String MATERIALIZE = "materialize";
    public static final String MATERIALIZE_DOC = "if set, then only materialize the events to generate state file.";
    public static final String CHECKSUM_ENABLED = "checksum-enabled";
    public static final String CHECKSUM_ENABLED_DOC = "should be set to true if checksum is enabled for the tier state file false otherwise.";
    public static final String TIER_COMPACT_ENABLED = "tier-compact-feature-flag";
    public static final String TIER_COMPACT_ENABLED_DOC = "should be set to true if tier compaction is enabled for this cluster.";
    public static final String TIER_PARTITION_STATE_CLEANUP_ENABLED = "tier-partition-state-cleanup-feature-flag";
    public static final String TIER_PARTITION_STATE_CLEANUP_ENABLED_DOC = "should be set to true if tier state file cleanup is enabled.";
    public static final String TIER_PARTITION_STATE_CLEANUP_DELAY = "tier-partition-state-cleanup-delay";
    public static final String TIER_PARTITION_STATE_CLEANUP_DELAY_DOC = "FTPS cleanup only removes deleted segment entries which are deleted this amount of time ago. It is in millisecond time unit.";
    public static final String TIER_PARTITION_STATE_CLEANUP_INTERVAL = "tier-partition-state-cleanup-interval";
    public static final String TIER_PARTITION_STATE_CLEANUP_INTERVAL_DOC = "FTPS cleanup is triggered periodically during flush. This config is the interval in millisecond time unit.";
    public static final String TIER_PARTITION_STATE_METADATA_SNAPSHOTS_ENABLED = "tier-partition-state-metadata-snapshots-feature-flag";
    public static final String TIER_PARTITION_STATE_METADATA_SNAPSHOTS_ENABLED_DOC = "should be set to true if tier metadata snapshots are enabled.";
    public static final String TIER_STORAGE_VALIDATION = "validate-tier-storage";
    public static final String TIER_STORAGE_VALIDATION_DOC = "verifies the object presence in the tier object store in terms of the object ID in the metadata";
    public static final String TIER_STORAGE_OFFSET_VALIDATION = "validate-tier-storage-offset";
    public static final String TIER_STORAGE_OFFSET_VALIDATION_DOC = "verifies that the offsets mentioned in the metadata is present in the segment file in object store";
    public static final String BROKER_ID = "broker-id";
    public static final String BROKER_ID_DOC = "The zk broker ID for which the tool will connect";
    public static final String CLUSTER_ID = "cluster-id";
    public static final String CLUSTER_ID_DOC = "The zk cluster ID for which the tool will connect";
    public static final String CONSUMER_CONFIG = "consumer-config";
    public static final String CONSUMER_CONFIG_DOC = "Additional KafkaConsumer configuration properties file.";
    public static final long UNKNOWN_OFFSET = -2L;
    public final Integer userPartition;
    public final Integer partition;
    public final Integer startOffset;
    public final Integer endOffset;
    public final String server;
    public final Boolean dumpRecords;
    public final UUID userTopicId;
    public final String materializationPath;
    public final Boolean dumpHeader;
    public final String metadataStatesDir;
    public final Boolean dumpEvents;
    public final Boolean materialize;

    public TierTopicMaterializationToolConfig(Properties props) {
        super(CONFIG, props);
        System.out.println("Configs: " + String.valueOf(props));
        this.userPartition = this.getInt(SRC_PARTITION);
        this.partition = this.getInt(TIER_STATE_TOPIC_PARTITION);
        this.server = this.getString(BOOTSTRAP_SERVER_CONFIG);
        this.dumpHeader = this.getBoolean(DUMP_METADATA_HEADER);
        this.dumpRecords = this.getBoolean(DUMP_METADATA);
        this.userTopicId = CoreUtils.uuidFromBase64(this.getString(SRC_TOPIC_ID));
        this.materializationPath = this.getString(WORKING_DIR);
        this.metadataStatesDir = this.getString(METADATA_STATES_DIR);
        this.dumpEvents = this.getBoolean(DUMP_EVENTS);
        this.materialize = this.getBoolean(MATERIALIZE);
        if (this.partition.equals(-1)) {
            this.startOffset = 0;
            this.endOffset = -1;
        } else {
            this.startOffset = this.getInt(START_OFFSET);
            this.endOffset = this.getInt(END_OFFSET);
        }
    }

    static {
        EMPTY_UUID = CoreUtils.uuidFromBase64(EMPTY_UUID_STR);
        CONFIG = new ConfigDef().define(BOOTSTRAP_SERVER_CONFIG, ConfigDef.Type.STRING, "localhost:9071", ConfigDef.Importance.HIGH, BOOTSTRAP_SERVER_DOC).define(SRC_TOPIC_ID, ConfigDef.Type.STRING, EMPTY_UUID_STR, ConfigDef.Importance.MEDIUM, SRC_TOPIC_DOC).define(SRC_PARTITION, ConfigDef.Type.INT, -1, ConfigDef.Importance.LOW, SRC_PARTIITON_DOC).define(TIER_STATE_TOPIC_PARTITION, ConfigDef.Type.INT, -1, ConfigDef.Importance.LOW, TIER_STATE_TOPIC_PARTITION_DOC).define(START_OFFSET, ConfigDef.Type.INT, 0, ConfigDef.Importance.MEDIUM, START_OFFSET_DOC).define(END_OFFSET, ConfigDef.Type.INT, -1, ConfigDef.Importance.LOW, END_OFFSET_DOC).define(DUMP_METADATA, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.MEDIUM, DUMP_METADATA_DOC).define(DUMP_METADATA_HEADER, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.MEDIUM, DUMP_METADATA_HEADER_DOC).define(WORKING_DIR, ConfigDef.Type.STRING, "/tmp/workDir", ConfigDef.Importance.HIGH, WORKING_DIR_DOC).define(METADATA_STATES_DIR, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, METADATA_STATES_DIR_DOC).define(DUMP_EVENTS, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.MEDIUM, DUMP_EVENTS_DOC).define(MATERIALIZE, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.MEDIUM, MATERIALIZE_DOC).define(CHECKSUM_ENABLED, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.MEDIUM, CHECKSUM_ENABLED_DOC).define(TIER_COMPACT_ENABLED, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.MEDIUM, TIER_COMPACT_ENABLED_DOC).define(TIER_PARTITION_STATE_CLEANUP_ENABLED, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.MEDIUM, TIER_PARTITION_STATE_CLEANUP_ENABLED_DOC).define(TIER_PARTITION_STATE_CLEANUP_DELAY, ConfigDef.Type.LONG, 2592000000L, ConfigDef.Importance.MEDIUM, TIER_PARTITION_STATE_CLEANUP_DELAY_DOC).define(TIER_PARTITION_STATE_CLEANUP_INTERVAL, ConfigDef.Type.LONG, 86400000L, ConfigDef.Importance.MEDIUM, TIER_PARTITION_STATE_CLEANUP_INTERVAL_DOC).define(TIER_PARTITION_STATE_METADATA_SNAPSHOTS_ENABLED, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.MEDIUM, TIER_PARTITION_STATE_METADATA_SNAPSHOTS_ENABLED_DOC).define(BROKER_ID, ConfigDef.Type.INT, -1, ConfigDef.Importance.MEDIUM, BROKER_ID_DOC).define(SNAPSHOT_STATES_FILES, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.MEDIUM, SNAPSHOT_STATES_FILES_DOC);
    }
}

