/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.node.MetadataLeafNode;
import org.apache.kafka.image.node.MetadataNode;

public class BrokerReplicaExclusionsImageNode
implements MetadataNode {
    public static final String NAME = "replicaExclusions";
    private final BrokerReplicaExclusionsImage image;

    public BrokerReplicaExclusionsImageNode(BrokerReplicaExclusionsImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        ArrayList<String> ids = new ArrayList<String>();
        for (Integer id : this.image.activeBrokerReplicaExclusions().keySet()) {
            ids.add(Integer.toString(id));
        }
        return ids;
    }

    @Override
    public MetadataNode child(String name) {
        Integer val;
        try {
            val = Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            return null;
        }
        String exclusion = this.image.activeBrokerReplicaExclusions().get(val);
        if (exclusion == null) {
            return null;
        }
        return new MetadataLeafNode(exclusion);
    }
}

