/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.kafka.metadata.migration.MigrationTrigger;

public class FileMigrationTrigger
implements MigrationTrigger {
    private final Path triggerFilePath;

    FileMigrationTrigger(Path triggerFilePath) {
        this.triggerFilePath = triggerFilePath;
    }

    public static FileMigrationTrigger newFileTrigger(String triggerFilePath) {
        if (triggerFilePath == null || triggerFilePath.isEmpty()) {
            throw new IllegalArgumentException("Cannot create FileMigrationTrigger for empty path");
        }
        Path triggerFile = FileSystems.getDefault().getPath(triggerFilePath, new String[0]);
        Path triggerDir = triggerFile.getParent();
        if (!Files.exists(triggerDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Cannot create FileMigrationTrigger for " + triggerFilePath + ", the parent directory does not exist.");
        }
        if (!Files.isDirectory(triggerDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Cannot create FileMigrationTrigger for " + triggerFilePath + ", the parent path is not a directory.");
        }
        if (Files.exists(triggerFile, new LinkOption[0]) && !Files.isRegularFile(triggerFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Cannot create FileMigrationTrigger for " + triggerFilePath + ", the file exists, but is not a regular file.");
        }
        return new FileMigrationTrigger(triggerFile);
    }

    @Override
    public void checkTrigger(MigrationTrigger.MigrationTriggerCheckResult result) {
        if (Files.exists(this.triggerFilePath, new LinkOption[0])) {
            result.accept(true, "Migration trigger file " + String.valueOf(this.triggerFilePath) + " was found, migration will continue.");
        } else {
            result.accept(false, "Migration trigger file " + String.valueOf(this.triggerFilePath) + " not yet found, migration will not yet continue");
        }
    }
}

