/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.security.KsqlAuthTokenProvider;
import io.confluent.ksql.security.KsqlAuthTokenProviderImpl;
import io.confluent.ksql.security.KsqlAuthorizationProvider;
import io.confluent.ksql.security.KsqlSecurityExtension;
import io.confluent.ksql.security.KsqlSecurityExtensionConfig;
import io.confluent.ksql.security.KsqlUserContextProvider;
import io.confluent.ksql.security.KsqlUserContextProviderImpl;
import io.confluent.ksql.security.authorizer.AuthorizationDecisionMaker;
import io.confluent.ksql.security.authorizer.KsqlAuthorizationProviderImpl;
import io.confluent.ksql.security.authorizer.KsqlSchemaRegistryPermissionsValidator;
import io.confluent.ksql.security.authorizer.MdsRestAuthorizationDecisionMaker;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlConfluentSecurityExtension
implements KsqlSecurityExtension {
    private static final Logger LOG = LoggerFactory.getLogger(KsqlConfluentSecurityExtension.class);
    private KsqlSecurityExtensionConfig securityConfig;
    private AuthorizationDecisionMaker authorizationDecisionMaker;
    private KsqlAuthorizationProvider authorizationProvider;
    private Optional<KsqlUserContextProvider> userContextProvider;
    private Optional<KsqlSchemaRegistryPermissionsValidator> srPermissionsValidator;
    private KsqlAuthTokenProviderImpl ksqlAuthTokenProvider;
    private final Supplier<AuthorizationDecisionMaker> authorizationDecisionMakerSupplier;
    private final Predicate<KsqlConfig> isSchemaRegistryPermissionsEnabled;

    public KsqlConfluentSecurityExtension() {
        this(MdsRestAuthorizationDecisionMaker::new);
    }

    protected KsqlConfluentSecurityExtension(Supplier<AuthorizationDecisionMaker> authorizationDecisionMakerSupplier) {
        this(authorizationDecisionMakerSupplier, KsqlSchemaRegistryPermissionsValidator::isSchemaRegistryPermissionsEnabled);
    }

    @VisibleForTesting
    KsqlConfluentSecurityExtension(Supplier<AuthorizationDecisionMaker> authorizationDecisionMakerSupplier, Predicate<KsqlConfig> isSchemaRegistryPermissionsEnabled) {
        this.authorizationDecisionMakerSupplier = Objects.requireNonNull(authorizationDecisionMakerSupplier, "authorizationDecisionMakerSupplier");
        this.isSchemaRegistryPermissionsEnabled = Objects.requireNonNull(isSchemaRegistryPermissionsEnabled, "isSchemaRegistryPermissionsEnabled");
    }

    public void initialize(KsqlConfig ksqlConfig) {
        this.checkInvalidConfiguration(ksqlConfig);
        this.securityConfig = new KsqlSecurityExtensionConfig(ksqlConfig.originals());
        this.authorizationDecisionMaker = this.authorizationDecisionMakerSupplier.get();
        this.authorizationDecisionMaker.initialize(ksqlConfig);
        LOG.info("Authorization decision maker '{}' initialized.", (Object)this.authorizationDecisionMaker.getClass().getSimpleName());
        this.srPermissionsValidator = this.securityConfig.getBoolean("ksql.security.extension.sr-permissions.validator.enabled") != false ? this.getSchemaRegistryValidator(ksqlConfig) : Optional.empty();
        this.userContextProvider = this.securityConfig.getBoolean("ksql.security.extension.user.impersonation.enabled") != false ? Optional.of(new KsqlUserContextProviderImpl(ksqlConfig)) : Optional.empty();
        this.authorizationProvider = new KsqlAuthorizationProviderImpl(this.authorizationDecisionMaker, this.srPermissionsValidator);
        this.ksqlAuthTokenProvider = new KsqlAuthTokenProviderImpl();
        LOG.info("KSQL security extension registered.");
    }

    private Optional<KsqlSchemaRegistryPermissionsValidator> getSchemaRegistryValidator(KsqlConfig ksqlConfig) {
        if (this.isSchemaRegistryPermissionsEnabled.test(ksqlConfig)) {
            LOG.info("Schema Registry permissions checks is enabled");
            return Optional.of(new KsqlSchemaRegistryPermissionsValidator(ksqlConfig));
        }
        return Optional.empty();
    }

    private void checkInvalidConfiguration(KsqlConfig ksqlConfig) {
        String protocolConfig = ksqlConfig.getKsqlAdminClientConfigProps().getOrDefault("security.protocol", "");
        SecurityProtocol securityProtocol = SecurityProtocol.forName((String)protocolConfig);
        if (securityProtocol != SecurityProtocol.SASL_PLAINTEXT && securityProtocol != SecurityProtocol.SASL_SSL && securityProtocol != SecurityProtocol.SSL) {
            this.throwInitializationException(String.format("Unsupported '%s' value (%s). Only SASL_PLAINTEXT, SASL_SSL and SSL are allowed.", "security.protocol", protocolConfig));
        }
    }

    private void throwInitializationException(String cause) {
        throw new KsqlException(String.format("Failed to initialize Confluent RBAC: %s", cause));
    }

    @VisibleForTesting
    Optional<KsqlSchemaRegistryPermissionsValidator> getSchemaRegistryPermissionsValidator() {
        return this.srPermissionsValidator;
    }

    public Optional<KsqlAuthorizationProvider> getAuthorizationProvider() {
        return Optional.of(this.authorizationProvider);
    }

    public Optional<KsqlUserContextProvider> getUserContextProvider() {
        return this.userContextProvider;
    }

    public Optional<KsqlAuthTokenProvider> getAuthTokenProvider() {
        return Optional.of(this.ksqlAuthTokenProvider);
    }

    public void close() {
        if (this.authorizationDecisionMaker != null) {
            try {
                this.authorizationDecisionMaker.close();
            }
            catch (Exception e) {
                throw new KsqlException("Failed to close the authorization decision maker", (Throwable)e);
            }
            this.authorizationDecisionMaker = null;
        }
        LOG.info("KSQL security extension deregistered.");
    }
}

