/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.schema.registry.KsqlSchemaRegistryClientFactory;
import io.confluent.ksql.security.KsqlUserContextProvider;
import io.confluent.ksql.security.utils.KsqlSecurityUtils;
import io.confluent.ksql.services.ConfiguredKafkaClientSupplier;
import io.confluent.ksql.util.KsqlConfig;
import java.security.Principal;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;

public class KsqlUserContextProviderImpl
implements KsqlUserContextProvider {
    private final KsqlConfig ksqlConfig;
    private final BiFunction<KsqlConfig, Map<String, String>, KsqlSchemaRegistryClientFactory> srFactory;

    public KsqlUserContextProviderImpl(KsqlConfig ksqlConfig) {
        this(ksqlConfig, KsqlSchemaRegistryClientFactory::new);
    }

    @VisibleForTesting
    KsqlUserContextProviderImpl(KsqlConfig ksqlConfig, BiFunction<KsqlConfig, Map<String, String>, KsqlSchemaRegistryClientFactory> srFactory) {
        this.ksqlConfig = ksqlConfig;
        this.srFactory = srFactory;
    }

    public ConfiguredKafkaClientSupplier getKafkaClientSupplier(Principal principal) {
        JwtPrincipal jwtPrincipal = KsqlSecurityUtils.toPrincipalType(principal, JwtPrincipal.class);
        return new ConfiguredKafkaClientSupplier((KafkaClientSupplier)new DefaultKafkaClientSupplier(), KsqlSecurityUtils.getKafkaClientSupplierOAuthProperties(this.getMetadataServerUrl(), jwtPrincipal, this.ksqlConfig));
    }

    public Supplier<SchemaRegistryClient> getSchemaRegistryClientFactory(Principal principal) {
        JwtPrincipal jwtPrincipal = KsqlSecurityUtils.toPrincipalType(principal, JwtPrincipal.class);
        return () -> ((KsqlSchemaRegistryClientFactory)this.srFactory.apply(this.ksqlConfig, KsqlSecurityUtils.getSchemaRegistryClientHttpHeaders(jwtPrincipal))).get();
    }

    private String getMetadataServerUrl() {
        return this.ksqlConfig.originals().getOrDefault("confluent.metadata.bootstrap.server.urls", "");
    }
}

