/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import io.confluent.common.security.auth.CertificatePrincipal;
import io.confluent.common.security.auth.ImpersonationTokenProvider;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.common.security.jetty.initializer.AuthenticationHandler;
import io.confluent.common.security.metrics.MetricsContainer;
import io.confluent.common.security.util.AuthUtils;
import io.confluent.ksql.security.VertxAuthenticationPlugin;
import io.confluent.rest.RestConfig;
import io.confluent.security.auth.client.rest.RestClient;
import io.confluent.security.auth.common.JwtBearerToken;
import io.vertx.ext.web.RoutingContext;
import java.security.Principal;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxAuthenticationHandlerPlugin
extends VertxAuthenticationPlugin {
    private static final Logger log = LoggerFactory.getLogger(VertxAuthenticationHandlerPlugin.class);
    private MetricsContainer metricsContainer;
    private String realm;
    private Authenticator authenticator;
    private LoginService loginService;
    private AuthenticationHandler.SecurityHandlerConfig config;
    private RestClient restClient;
    private ImpersonationTokenProvider impersonationTokenProvider;

    @Override
    public void configure(Map<String, ?> originals) {
        this.config = new AuthenticationHandler.SecurityHandlerConfig(originals);
        this.realm = this.config.getString("authentication.realm");
        if (this.config.getBoolean("rest.auth.jmx.enabled").booleanValue()) {
            this.metricsContainer = new MetricsContainer((RestConfig)this.config);
        }
        BasicAuthenticator basicAuthenticator = AuthUtils.getBasicAuthenticatorForNonJettyUsage();
        this.authenticator = AuthUtils.createCompositeAuthenticator((AuthenticationHandler.SecurityHandlerConfig)this.config, (BasicAuthenticator)basicAuthenticator);
        this.loginService = AuthUtils.getCompositeLoginService((AuthenticationHandler.SecurityHandlerConfig)this.config, (MetricsContainer)this.metricsContainer, (Logger)log);
        this.restClient = this.createRestClient(originals);
        if (this.restClient != null) {
            this.impersonationTokenProvider = new ImpersonationTokenProvider(this.restClient);
        }
        this.configure(this.realm, this.authenticator, this.loginService);
    }

    @Override
    protected boolean validateUser(UserIdentity userIdentity) {
        return true;
    }

    @Override
    protected Principal getPrincipalFromUserIdentity(UserIdentity userIdentity, RoutingContext routingContext) {
        if (userIdentity.getUserPrincipal() instanceof CertificatePrincipal) {
            if (this.restClient != null) {
                String impersonationToken = this.getImpersonationToken(userIdentity);
                routingContext.put("impersonate-token", (Object)impersonationToken);
                return new JwtPrincipal((OAuthBearerToken)new JwtBearerToken(impersonationToken));
            }
            log.warn("RestClient is not configured in VertxAuthenticationHandlerPlugin");
            return userIdentity.getUserPrincipal();
        }
        return userIdentity.getUserPrincipal();
    }

    String getImpersonationToken(UserIdentity userIdentity) {
        return this.impersonationTokenProvider.get(userIdentity.getUserPrincipal().getName());
    }

    public String getRealm() {
        return this.realm;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public LoginService getLoginService() {
        return this.loginService;
    }

    public AuthenticationHandler.SecurityHandlerConfig getConfig() {
        return this.config;
    }

    protected RestClient createRestClient(Map<String, ?> configs) {
        try {
            return new RestClient(configs);
        }
        catch (ConfigException e) {
            log.debug("Not configuring RestClient", (Throwable)e);
            return null;
        }
    }
}

